# -*- coding: utf-8 -*-
#   WillowNG - Content Filtering Web Proxy 
#   Copyright (C) 2006  Travis Watkins
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Library General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Library General Public License for more details.
#
#   You should have received a copy of the GNU Library General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

class DomainFilter:
    def __init__(self, db_list):
        self.db_list = db_list

    def normalize(self, domain):
        if domain.startswith('http'):
            domain = domain.split('//', 1)[1]
        domain = domain.split('/')[0]
        if domain.startswith('www.'):
            domain = domain[4:]
        return domain

    def isBad(self, domain):
        #user DB always overrides builtin, check it first
        cur = self.db_list[1].cursor()
        cur.execute('SELECT pool FROM __domains WHERE domain = ?', (self.normalize(domain),))
        row = cur.fetchone()
        if row == None:
            cur = self.db_list[1].cursor()
            cur.execute('SELECT pool FROM __domains WHERE domain = ?', (self.normalize(domain),))
            row = cur.fetchone()
            if row == None or row[0] == 'good':
                return False
        elif row[0] == 'good':
            return False
        return True

    def isGood(self, domain):
        #user DB always overrides builtin, check it first
        cur = self.db_list[1].cursor()
        cur.execute('SELECT pool FROM __domains WHERE domain = ?', (self.normalize(domain),))
        row = cur.fetchone()
        if row == None:
            cur = self.db_list[1].cursor()
            cur.execute('SELECT pool FROM __domains WHERE domain = ?', (self.normalize(domain),))
            row = cur.fetchone()
            if row == None or row[0] == 'bad':
                return False
        elif row[0] == 'bad':
            return False
        return True

    def add(self, pool, domain):
        cur = self.db_list[1].cursor()
        cur.execute('SELECT pool FROM __domains WHERE domain = ?', (self.normalize(domain),))
        row = cur.fetchone()
        if row == None:
            cur.execute('INSERT INTO __domains (pool, domain) VALUES(?, ?)', (pool, self.normalize(domain)))
        else:
            cur.execute('UPDATE __domains SET pool = ? WHERE domain = ?', (pool, self.normalize(domain)))
        self.db_list[1].commit()

    def remove(self, domain):
        cur = self.db_list[1].cursor()
        cur.execute('DELETE FROM __domains WHERE domain = ?', (self.normalize(domain),))
        self.db_list[1].commit()

    def get(self):
        all = {}
        #the user DB values will override any existing builtin values
        for db in self.db_list:
            cur = db.cursor()
            cur.execute('SELECT pool, domain FROM __domains')
            rows = cur.fetchall()
            for value, key in rows:
                all[key] = value
        if len(all.items()):
            return all.items()
        return None
