/* gsd-async-operation.c generated by valac 0.12.0, the Vala compiler
 * generated from gsd-async-operation.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <signal.h>
#include <unistd.h>
#include <float.h>
#include <math.h>


#define GSD_TYPE_ASYNC_OPERATION (gsd_async_operation_get_type ())
#define GSD_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation))
#define GSD_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))
#define GSD_IS_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ASYNC_OPERATION))
#define GSD_IS_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ASYNC_OPERATION))
#define GSD_ASYNC_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))

typedef struct _GsdAsyncOperation GsdAsyncOperation;
typedef struct _GsdAsyncOperationClass GsdAsyncOperationClass;
typedef struct _GsdAsyncOperationPrivate GsdAsyncOperationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

/**
   * Error domain for the AsyncOperation class.
   */
typedef enum  {
	GSD_ASYNC_OPERATION_ERROR_CHILD_FAILED,
	GSD_ASYNC_OPERATION_ERROR_SUBCLASS_ERROR
} GsdAsyncOperationError;
#define GSD_ASYNC_OPERATION_ERROR gsd_async_operation_error_quark ()
struct _GsdAsyncOperation {
	GObject parent_instance;
	GsdAsyncOperationPrivate * priv;
	guint n_passes;
	guint passes;
	GPid pid;
	gint fd_in;
	gint fd_out;
	gint fd_err;
};

struct _GsdAsyncOperationClass {
	GObjectClass parent_class;
	GList* (*build_args) (GsdAsyncOperation* self, GError** error);
	gchar** (*build_env) (GsdAsyncOperation* self, int* result_length1);
	void (*cleanup) (GsdAsyncOperation* self);
	guint (*get_max_progress) (GsdAsyncOperation* self);
	guint (*get_progress) (GsdAsyncOperation* self);
	gchar* (*get_subprocess_error_msg) (GsdAsyncOperation* self);
};

struct _GsdAsyncOperationPrivate {
	gboolean _busy;
	GStaticRecMutex __lock__busy;
	gchar* _path;
	gchar* _path_default;
};

typedef enum  {
	GSD_FD_ERROR_KILL_ERROR,
	GSD_FD_ERROR_READ_ERROR,
	GSD_FD_ERROR_SELECT_ERROR,
	GSD_FD_ERROR_WAITPID_ERROR
} GsdFDError;
#define GSD_FD_ERROR gsd_fd_error_quark ()

static gpointer gsd_async_operation_parent_class = NULL;

#define WATCH_INTERVAL ((guint) 100)
GQuark gsd_async_operation_error_quark (void);
GType gsd_async_operation_get_type (void) G_GNUC_CONST;
#define GSD_ASYNC_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationPrivate))
enum  {
	GSD_ASYNC_OPERATION_DUMMY_PROPERTY,
	GSD_ASYNC_OPERATION_PATH,
	GSD_ASYNC_OPERATION_BUSY
};
GList* gsd_async_operation_build_args (GsdAsyncOperation* self, GError** error);
static GList* gsd_async_operation_real_build_args (GsdAsyncOperation* self, GError** error);
static gchar** gsd_async_operation_do_build_args (GsdAsyncOperation* self, int* result_length1, GError** error);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
const gchar* gsd_async_operation_get_path (GsdAsyncOperation* self);
gchar** gsd_async_operation_build_env (GsdAsyncOperation* self, int* result_length1);
static gchar** gsd_async_operation_real_build_env (GsdAsyncOperation* self, int* result_length1);
void gsd_async_operation_cleanup (GsdAsyncOperation* self);
static void gsd_async_operation_real_cleanup (GsdAsyncOperation* self);
guint gsd_async_operation_get_max_progress (GsdAsyncOperation* self);
static guint gsd_async_operation_real_get_max_progress (GsdAsyncOperation* self);
guint gsd_async_operation_get_progress (GsdAsyncOperation* self);
static guint gsd_async_operation_real_get_progress (GsdAsyncOperation* self);
static void gsd_async_operation_update_progress (GsdAsyncOperation* self);
gchar* gsd_async_operation_get_subprocess_error_msg (GsdAsyncOperation* self);
static gchar* gsd_async_operation_real_get_subprocess_error_msg (GsdAsyncOperation* self);
GQuark gsd_fd_error_quark (void);
gchar* gsd_fd_read_string (gint fd, gssize n_bytes, GError** error);
static gboolean gsd_async_operation_do_wait_child (GsdAsyncOperation* self);
gboolean gsd_async_operation_cancel (GsdAsyncOperation* self);
gboolean gsd_async_operation_get_busy (GsdAsyncOperation* self);
gboolean gsd_async_operation_run (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, GError** error);
static gboolean _gsd_async_operation_do_wait_child_gsource_func (gpointer self);
gboolean gsd_async_operation_run_sync (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, gchar** standard_output, GError** error);
GsdAsyncOperation* gsd_async_operation_construct (GType object_type);
void gsd_async_operation_set_path (GsdAsyncOperation* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gsd_async_operation_finalize (GObject* obj);
static void _vala_gsd_async_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gsd_async_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark gsd_async_operation_error_quark (void) {
	return g_quark_from_static_string ("gsd_async_operation_error-quark");
}


static GList* gsd_async_operation_real_build_args (GsdAsyncOperation* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gsd_async_operation_build_args'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GList* gsd_async_operation_build_args (GsdAsyncOperation* self, GError** error) {
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->build_args (self, error);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gchar** gsd_async_operation_do_build_args (GsdAsyncOperation* self, int* result_length1, GError** error) {
	gchar** result = NULL;
	GList* args = NULL;
	gchar** array_args = NULL;
	gint array_args_length1 = 0;
	gint _array_args_size_ = 0;
	gsize i = 0UL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_;
	guint _tmp2_;
	gchar** _tmp3_ = NULL;
	gsize _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gsd_async_operation_build_args (self, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			array_args = (_vala_array_free (array_args, array_args_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free__g_free0_0 (args);
			return NULL;
		} else {
			array_args = (_vala_array_free (array_args, array_args_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free__g_free0_0 (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	__g_list_free__g_free0_0 (args);
	args = _tmp1_;
	_tmp2_ = g_list_length (args);
	_tmp3_ = g_new0 (gchar*, (_tmp2_ + 2) + 1);
	array_args = (_vala_array_free (array_args, array_args_length1, (GDestroyNotify) g_free), NULL);
	array_args = _tmp3_;
	array_args_length1 = _tmp2_ + 2;
	_array_args_size_ = _tmp2_ + 2;
	i = (gsize) 0;
	_tmp4_ = i;
	i = _tmp4_ + 1;
	_tmp5_ = gsd_async_operation_get_path (self);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (array_args[_tmp4_]);
	array_args[_tmp4_] = _tmp7_;
	{
		GList* arg_collection;
		GList* arg_it;
		arg_collection = args;
		for (arg_it = arg_collection; arg_it != NULL; arg_it = arg_it->next) {
			const gchar* arg;
			arg = (const gchar*) arg_it->data;
			{
				gsize _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = i;
				i = _tmp8_ + 1;
				_tmp9_ = g_strdup (arg);
				_tmp10_ = _tmp9_;
				_g_free0 (array_args[_tmp8_]);
				array_args[_tmp8_] = _tmp10_;
			}
		}
	}
	_tmp11_ = NULL;
	_g_free0 (array_args[i]);
	array_args[i] = _tmp11_;
	_tmp12_ = array_args;
	*result_length1 = array_args_length1;
	result = _tmp12_;
	__g_list_free__g_free0_0 (args);
	return result;
}


static gchar** gsd_async_operation_real_build_env (GsdAsyncOperation* self, int* result_length1) {
	gchar** result = NULL;
	gpointer _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	*result_length1 = 0;
	result = _tmp0_;
	return result;
}


gchar** gsd_async_operation_build_env (GsdAsyncOperation* self, int* result_length1) {
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->build_env (self, result_length1);
}


static void gsd_async_operation_real_cleanup (GsdAsyncOperation* self) {
	g_return_if_fail (self != NULL);
}


void gsd_async_operation_cleanup (GsdAsyncOperation* self) {
	GSD_ASYNC_OPERATION_GET_CLASS (self)->cleanup (self);
}


static guint gsd_async_operation_real_get_max_progress (GsdAsyncOperation* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) 0;
	return result;
}


guint gsd_async_operation_get_max_progress (GsdAsyncOperation* self) {
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->get_max_progress (self);
}


static guint gsd_async_operation_real_get_progress (GsdAsyncOperation* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) 0;
	return result;
}


guint gsd_async_operation_get_progress (GsdAsyncOperation* self) {
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->get_progress (self);
}


static void gsd_async_operation_update_progress (GsdAsyncOperation* self) {
	guint _tmp0_;
	guint progress;
	g_return_if_fail (self != NULL);
	_tmp0_ = gsd_async_operation_get_progress (self);
	progress = _tmp0_;
	if (progress > 0) {
		self->passes = self->passes + progress;
		g_signal_emit_by_name (self, "progress", self->passes / (self->n_passes * 1.0));
	}
}


static gchar* gsd_async_operation_real_get_subprocess_error_msg (GsdAsyncOperation* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gsd_fd_read_string (self->fd_err, (gssize) (-1), &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_FD_ERROR) {
			goto __catch0_gsd_fd_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
	goto __finally0;
	__catch0_gsd_fd_error:
	{
		GError * e;
		gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("gsd-async-operation.vala:264: Subprocess error output read failed: %s", e->message);
		_tmp2_ = g_strdup ("???");
		result = _tmp2_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


gchar* gsd_async_operation_get_subprocess_error_msg (GsdAsyncOperation* self) {
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->get_subprocess_error_msg (self);
}


static gboolean gsd_async_operation_do_wait_child (GsdAsyncOperation* self) {
	gboolean result = FALSE;
	gboolean finished;
	gboolean success;
	gint exit_status = 0;
	pid_t wait_rv = 0;
	gchar* message;
	gint _tmp0_;
	pid_t _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	finished = TRUE;
	success = FALSE;
	message = NULL;
	_tmp1_ = waitpid ((pid_t) self->pid, &_tmp0_, WNOHANG);
	exit_status = _tmp0_;
	wait_rv = _tmp1_;
	if (((gint) wait_rv) < 0) {
		const gchar* _tmp2_ = NULL;
		gint _tmp3_;
		_tmp2_ = g_strerror (errno);
		g_critical ("gsd-async-operation.vala:284: waitpid() failed: %s", _tmp2_);
		_tmp3_ = kill ((pid_t) self->pid, (gint) SIGTERM);
		if (_tmp3_ < 0) {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = g_strerror (errno);
			g_critical ("gsd-async-operation.vala:287: kill() failed: %s", _tmp4_);
		}
	} else {
		if (((gint) wait_rv) == 0) {
			gsd_async_operation_update_progress (self);
			finished = FALSE;
		} else {
			gboolean _tmp5_;
			_tmp5_ = WIFEXITED (exit_status);
			if (!_tmp5_) {
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = gsd_async_operation_get_subprocess_error_msg (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat ("Subprocess crashed.\n", _tmp7_, NULL);
				_g_free0 (message);
				message = _tmp8_;
				_g_free0 (_tmp7_);
			} else {
				gint _tmp9_;
				_tmp9_ = WEXITSTATUS (exit_status);
				if (_tmp9_ != 0) {
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp10_ = gsd_async_operation_get_subprocess_error_msg (self);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat ("Subprocess failed.\n", _tmp11_, NULL);
					_g_free0 (message);
					message = _tmp12_;
					_g_free0 (_tmp11_);
				} else {
					success = TRUE;
				}
			}
		}
	}
	if (finished) {
		g_signal_emit_by_name (self, "finished", success, message);
		gsd_async_operation_cleanup (self);
		g_spawn_close_pid (self->pid);
		close (self->fd_err);
		close (self->fd_out);
		close (self->fd_in);
		{
			g_static_rec_mutex_lock (&self->priv->__lock__busy);
			self->priv->_busy = FALSE;
			__finally1:
			g_static_rec_mutex_unlock (&self->priv->__lock__busy);
			if (_inner_error_ != NULL) {
				_g_free0 (message);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = !finished;
	_g_free0 (message);
	return result;
}


/**
     * Tries to cancel the operation.
     * 
     * @return true if successfully canceled, false otherwise.
     */
gboolean gsd_async_operation_cancel (GsdAsyncOperation* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gint kill_status = 0;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gsd_async_operation_get_busy (self);
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp1_ = kill ((pid_t) self->pid, (gint) SIGTERM);
	kill_status = _tmp1_;
	if (kill_status < 0) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = g_strerror (errno);
		g_critical ("gsd-async-operation.vala:333: kill() failed: %s", _tmp2_);
	}
	result = !(kill_status < 0);
	return result;
}


/**
     * Launches an operation asynchronously.
     * 
     * @param working_directory the working directory of the child process, or
     *    null to use the parent's one.
     * @param spawn_flags SpawnFlags. You may only use the SEARCH_PATH and
     *    CHILD_INHERITS_STDIN flags, others may conflict.
     * 
     * @return whether asynchronous operation was successfully started.
     */
static gboolean _gsd_async_operation_do_wait_child_gsource_func (gpointer self) {
	gboolean result;
	result = gsd_async_operation_do_wait_child (self);
	return result;
}


gboolean gsd_async_operation_run (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, GError** error) {
	gboolean result = FALSE;
	gboolean success;
	gboolean busy;
	guint _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint __tmp3__size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GPid _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	success = FALSE;
	busy = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock__busy);
		busy = self->priv->_busy;
		self->priv->_busy = TRUE;
		__finally2:
		g_static_rec_mutex_unlock (&self->priv->__lock__busy);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	g_return_val_if_fail (!busy, FALSE);
	self->fd_err = -1;
	self->fd_out = -1;
	_tmp0_ = gsd_async_operation_get_max_progress (self);
	self->n_passes = _tmp0_;
	self->passes = (guint) 0;
	_tmp2_ = gsd_async_operation_do_build_args (self, &_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	__tmp3__size_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __finally3;
	}
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp6_ = gsd_async_operation_build_env (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp12_ = g_spawn_async_with_pipes (working_directory, _tmp4_, _tmp7_, spawn_flags | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error_);
	self->pid = _tmp8_;
	self->fd_in = _tmp9_;
	self->fd_out = _tmp10_;
	self->fd_err = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		goto __finally3;
	}
	success = _tmp14_;
	if (success) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, WATCH_INTERVAL, _gsd_async_operation_do_wait_child_gsource_func, g_object_ref (self), g_object_unref);
	}
	__finally3:
	if (!success) {
		{
			g_static_rec_mutex_lock (&self->priv->__lock__busy);
			self->priv->_busy = FALSE;
			__finally4:
			g_static_rec_mutex_unlock (&self->priv->__lock__busy);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return FALSE;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
		}
	}
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	return result;
}


/**
     * Launches an operation synchronously.
     * 
     * @param working_directory the working directory of the child process, or
     *    null to use the parent's one.
     * @param spawn_flags SpawnFlags. You may only use the SEARCH_PATH and
     *    CHILD_INHERITS_STDIN flags, others may conflict.
     * @param standard_output return location for the subprocess' standard
     *    output, or null to ignore it.
     * 
     * @return true if all worked properly, and false if something failed.
     *         An error is thrown if something fails. It can be the subprocess
     *         spawning (SpawnError) or the child that failed
     *         (AsyncOperationError.CHILD_FAILED).
     */
gboolean gsd_async_operation_run_sync (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, gchar** standard_output, GError** error) {
	gchar* _standard_output = NULL;
	gboolean result = FALSE;
	gboolean success;
	gboolean busy;
	gchar* error_output = NULL;
	gint exit_status = 0;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	success = TRUE;
	busy = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock__busy);
		busy = self->priv->_busy;
		self->priv->_busy = TRUE;
		__finally5:
		g_static_rec_mutex_unlock (&self->priv->__lock__busy);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_output);
				return FALSE;
			} else {
				_g_free0 (error_output);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	g_return_val_if_fail (!busy, FALSE);
	_tmp1_ = gsd_async_operation_do_build_args (self, &_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	__tmp2__size_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __finally6;
	}
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	_tmp5_ = gsd_async_operation_build_env (self, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp10_ = g_spawn_sync (working_directory, _tmp3_, _tmp6_, spawn_flags, NULL, NULL, &_tmp7_, &_tmp8_, &_tmp9_, &_inner_error_);
	_g_free0 (_standard_output);
	_standard_output = _tmp7_;
	_g_free0 (error_output);
	error_output = _tmp8_;
	exit_status = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		goto __finally6;
	}
	success = _tmp12_;
	if (success) {
		gchar* message;
		gboolean _tmp13_;
		message = NULL;
		success = FALSE;
		_tmp13_ = WIFEXITED (exit_status);
		if (!_tmp13_) {
			gchar* _tmp14_;
			_tmp14_ = g_strconcat ("Subprocess crashed.\n", error_output, NULL);
			_g_free0 (message);
			message = _tmp14_;
		} else {
			gint _tmp15_;
			_tmp15_ = WEXITSTATUS (exit_status);
			if (_tmp15_ != 0) {
				gchar* _tmp16_;
				_tmp16_ = g_strconcat ("Subprocess failed.\n", error_output, NULL);
				_g_free0 (message);
				message = _tmp16_;
			} else {
				success = TRUE;
			}
		}
		g_signal_emit_by_name (self, "finished", success, message);
		gsd_async_operation_cleanup (self);
		if (message != NULL) {
			GError* _tmp17_ = NULL;
			_tmp17_ = g_error_new (GSD_ASYNC_OPERATION_ERROR, GSD_ASYNC_OPERATION_ERROR_CHILD_FAILED, "%s", message);
			_inner_error_ = _tmp17_;
			_g_free0 (message);
			goto __finally6;
		}
		_g_free0 (message);
	}
	__finally6:
	{
		g_static_rec_mutex_lock (&self->priv->__lock__busy);
		self->priv->_busy = FALSE;
		__finally7:
		g_static_rec_mutex_unlock (&self->priv->__lock__busy);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_output);
				return FALSE;
			} else {
				_g_free0 (error_output);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (error_output);
			return FALSE;
		} else {
			_g_free0 (error_output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_free0 (error_output);
	if (standard_output) {
		*standard_output = _standard_output;
	} else {
		_g_free0 (_standard_output);
	}
	return result;
}


GsdAsyncOperation* gsd_async_operation_construct (GType object_type) {
	GsdAsyncOperation * self = NULL;
	self = (GsdAsyncOperation*) g_object_new (object_type, NULL);
	return self;
}


const gchar* gsd_async_operation_get_path (GsdAsyncOperation* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_path == NULL) {
		g_critical ("gsd-async-operation.vala:151: Property AsyncOperation::path not set");
	}
	result = self->priv->_path;
	return result;
}


void gsd_async_operation_set_path (GsdAsyncOperation* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		gchar* _tmp1_;
		if (self->priv->_path_default == NULL) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (value);
			_g_free0 (self->priv->_path_default);
			self->priv->_path_default = _tmp0_;
		}
		_tmp1_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self->priv->_path_default);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp2_;
	}
	g_object_notify ((GObject *) self, "path");
}


gboolean gsd_async_operation_get_busy (GsdAsyncOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_busy;
	return result;
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_STRING) (gpointer data1, gboolean arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void gsd_async_operation_class_init (GsdAsyncOperationClass * klass) {
	gsd_async_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GsdAsyncOperationPrivate));
	GSD_ASYNC_OPERATION_CLASS (klass)->build_args = gsd_async_operation_real_build_args;
	GSD_ASYNC_OPERATION_CLASS (klass)->build_env = gsd_async_operation_real_build_env;
	GSD_ASYNC_OPERATION_CLASS (klass)->cleanup = gsd_async_operation_real_cleanup;
	GSD_ASYNC_OPERATION_CLASS (klass)->get_max_progress = gsd_async_operation_real_get_max_progress;
	GSD_ASYNC_OPERATION_CLASS (klass)->get_progress = gsd_async_operation_real_get_progress;
	GSD_ASYNC_OPERATION_CLASS (klass)->get_subprocess_error_msg = gsd_async_operation_real_get_subprocess_error_msg;
	G_OBJECT_CLASS (klass)->get_property = _vala_gsd_async_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gsd_async_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = gsd_async_operation_finalize;
	/**
	     * The path to the command to spawn.
	     * 
	     * Setting it to null resets it to its default value.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_ASYNC_OPERATION_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether the operation object is busy.
	     * 
	     * A busy operation cannot be reused until it gets ready again.
	     * An operation is busy when it is currently doing a job.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_ASYNC_OPERATION_BUSY, g_param_spec_boolean ("busy", "busy", "busy", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * This signal is emitted when the operation just terminated.
	     * 
	     * @param success whether the operation succeed.
	     * @param message if the operation failed, contains the error message.
	     */
	g_signal_new ("finished", GSD_TYPE_ASYNC_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_STRING, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_STRING);
	/**
	     * This signal is emitted when the progress status of the operation changes.
	     * 
	     * @param fraction the current progress, from 0.0 to 1.0.
	     */
	g_signal_new ("progress", GSD_TYPE_ASYNC_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}


static void gsd_async_operation_instance_init (GsdAsyncOperation * self) {
	self->priv = GSD_ASYNC_OPERATION_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__busy);
	self->priv->_busy = FALSE;
	self->priv->_path = NULL;
	self->priv->_path_default = NULL;
}


static void gsd_async_operation_finalize (GObject* obj) {
	GsdAsyncOperation * self;
	self = GSD_ASYNC_OPERATION (obj);
	g_static_rec_mutex_free (&self->priv->__lock__busy);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_path_default);
	G_OBJECT_CLASS (gsd_async_operation_parent_class)->finalize (obj);
}


/**
   * An asynchronous process spawner, with support for progression and success
   * report.
   * 
   * This is a base class designed to be subclassed by actual spawners, with
   * as less efforts as possible.
   * 
   * To subclass this class, the only thing you need to implement is the
   * argument builder, that gives the arguments of the spawned command; and you
   * need to set the AsyncOperation::path property to the command to spawn in
   * your constructor too (hence it is not required, it is slightly better to
   * set it since it must be set before calling run() or run_sync() - or getting
   * it).
   * This said, you may want to override get_max_progress() and get_progress()
   * to add actual progress support; and build_env() to provide a specific
   * environment to your command.
   * 
   * =Important note=
   * 
   * As this class uses a timeout function to watch the child, you need a GLib
   * MainLoop for the watching process to work for the asynchronous method.
   * 
   * =Simple usage of an hypothetical FooOperation subclass=
   * 
   * {{{
   * var foo = new FooOperation();
   * 
   * // Connect the finish callback
   * foo.finished.connect ((success, error) => {
   *                         if (success) {
   *                           stdout.printf ("success!\n");
   *                         } else {
   *                           stderr.printf ("failure: %s\n", error);
   *                         }
   *                       });
   * // and the progress callback
   * foo.progress.connect ((progress) => {
   *                         stdout.printf ("\r%.0f%%", progress * 100);
   *                       });
   * foo.run ();
   * 
   * var loop = GLib.MainLoop (null, false);
   * loop.run ();
   * }}}
   */
GType gsd_async_operation_get_type (void) {
	static volatile gsize gsd_async_operation_type_id__volatile = 0;
	if (g_once_init_enter (&gsd_async_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GsdAsyncOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsd_async_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GsdAsyncOperation), 0, (GInstanceInitFunc) gsd_async_operation_instance_init, NULL };
		GType gsd_async_operation_type_id;
		gsd_async_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "GsdAsyncOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gsd_async_operation_type_id__volatile, gsd_async_operation_type_id);
	}
	return gsd_async_operation_type_id__volatile;
}


static void _vala_gsd_async_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GsdAsyncOperation * self;
	self = GSD_ASYNC_OPERATION (object);
	switch (property_id) {
		case GSD_ASYNC_OPERATION_PATH:
		g_value_set_string (value, gsd_async_operation_get_path (self));
		break;
		case GSD_ASYNC_OPERATION_BUSY:
		g_value_set_boolean (value, gsd_async_operation_get_busy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gsd_async_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GsdAsyncOperation * self;
	self = GSD_ASYNC_OPERATION (object);
	switch (property_id) {
		case GSD_ASYNC_OPERATION_PATH:
		gsd_async_operation_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



