/*
 *  @(#)AbstractStateMachineType.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.ant;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.taskdefs.Definer;

import java.util.Vector;

import net.sourceforge.groboutils.mbtf.v1.IValidate;
import net.sourceforge.groboutils.mbtf.v1.ISystem;

import net.sourceforge.groboutils.mbtf.v1.assembler.AsmblState;

import org.apache.log4j.Logger;


/**
 * An ant datatype encapsulating the IState instance.  This includes an
 * <tt>execute()</tt> method to allow for this to be defined in a
 * &lt;typedef&gt; declaration, rather than inside a target as a
 * &lt;datatype&gt; declaration.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 13, 2002
 */
public abstract class AbstractStateMachineType extends DataType
{
    private static final Logger LOG = Logger.getLogger(
        AbstractStateMachineType.class );
    
    public void execute()
            throws BuildException
    {
        // do nothing
    }

    protected Location location = Location.UNKNOWN_LOCATION;
    /**
     * Sets the file location where this task was defined.
     */
    public void setLocation(Location location) {
        this.location = location;
    }
    
    
    private Vector validates = new Vector();
    private String name;
    
    
    public void setName( String name )
    {
        this.name = name;
    }
    
    
    public String getName()
    {
        if (isReference())
        {
            return ((AbstractStateMachineType)getCheckedRef(
                AbstractStateMachineType.class, "state machine type" )).
                getName();
        }
        return this.name;
    }
    
    
    public IValidate[] getValidates()
    {
        if (isReference())
        {
            return ((AbstractStateMachineType)getCheckedRef(
                AbstractStateMachineType.class, "state machine type" )).
                getValidates();
        }
        IValidate[] v = new IValidate[ this.validates.size() ];
        this.validates.copyInto( v );
        if (getProject() != null)
        {
            for (int i = 0; i < v.length; ++i)
            {
                IValidate vv = v[i];
                if (vv instanceof ProjectComponent)
                {
                    LOG.debug("Setting project of "+vv);
                    ((ProjectComponent)vv).setProject( getProject() );
                }
                else
                {
                    LOG.debug("Validator "+vv+" not a ProjectComponent, but "+
                        vv.getClass().getName());
                }
            }
        }
        else
        {
            LOG.debug("Ant type "+this+" never had project set");
        }
        return v;
    }
    
    
    public void addConfiguredValidateJava( ValidateJavaType type )
    {
        if (type != null)
        {
            LOG.debug("Adding ValidateJavaType "+type);
            this.validates.addElement( type );
        }
    }
    
    
    public void addConfiguredValidateAnt( ValidateTaskType type )
    {
        if (type != null)
        {
            this.validates.addElement( type );
        }
    }
    
    
    protected void verifySettings()
            throws BuildException
    {
        if (isReference())
        {
            ((AbstractStateMachineType)getCheckedRef(
                AbstractStateMachineType.class, "state machine type" )).
                verifySettings();
            return;
        }
        if (this.name == null)
        {
            throw new BuildException( "name not set", location );
        }
        if (this.validates.size() <= 0)
        {
            throw new BuildException( "no validation types registered",
                location );
        }
    }
}

