!    This file is part of ELPA.
!
!    The ELPA library was originally created by the ELPA consortium,
!    consisting of the following organizations:
!
!    - Rechenzentrum Garching der Max-Planck-Gesellschaft (RZG),
!    - Bergische Universität Wuppertal, Lehrstuhl für angewandte
!      Informatik,
!    - Technische Universität München, Lehrstuhl für Informatik mit
!      Schwerpunkt Wissenschaftliches Rechnen ,
!    - Fritz-Haber-Institut, Berlin, Abt. Theorie,
!    - Max-Plack-Institut für Mathematik in den Naturwissenschaften,
!      Leipzig, Abt. Komplexe Strukutren in Biologie und Kognition,
!      and
!    - IBM Deutschland GmbH
!
!
!    More information can be found here:
!    http://elpa.rzg.mpg.de/
!
!    ELPA is free software: you can redistribute it and/or modify
!    it under the terms of the version 3 of the license of the
!    GNU Lesser General Public License as published by the Free
!    Software Foundation.
!
!    ELPA is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU Lesser General Public License for more details.
!
!    You should have received a copy of the GNU Lesser General Public License
!    along with ELPA.  If not, see <http://www.gnu.org/licenses/>
!
!    ELPA reflects a substantial effort on the part of the original
!    ELPA consortium, and we ask you to respect the spirit of the
!    license that we chose: i.e., please contribute any changes you
!    may have back to the original ELPA library distribution, and keep
!    any derivatives of ELPA under the same license that we chose for
!    the original distribution, the GNU Lesser General Public License.
!
! This file was written by A. Marek, MPCDF

#include "config-f90.h"
!> \brief Fortran module which defines the datatypes used in ELPA
module precision
  use iso_c_binding, only : C_FLOAT, C_DOUBLE, C_FLOAT_COMPLEX, C_DOUBLE_COMPLEX, C_INT32_T, C_INT64_T, C_INT

  implicit none
  integer, parameter :: rk8  = C_DOUBLE
  integer, parameter :: rk4  = C_FLOAT
  integer, parameter :: ck8  = C_DOUBLE_COMPLEX
  integer, parameter :: ck4  = C_FLOAT_COMPLEX
  integer, parameter :: ik  = C_INT32_T
  integer, parameter :: lik = C_INT64_T

#ifdef HAVE_64BIT_INTEGER_MATH_SUPPORT
  integer, parameter :: BLAS_KIND = C_INT64_T
#else
  integer, parameter :: BLAS_KIND = C_INT32_T
#endif
#ifdef HAVE_64BIT_INTEGER_MPI_SUPPORT
  integer, parameter :: MPI_KIND  = C_INT64_T
#else
  integer, parameter :: MPI_KIND  = C_INT32_T
#endif

end module precision
