DBIx/Connection version 0.55
============================

DBIx::Connector provides a simple interface for fast and safe DBI connection
and transaction management. Connecting to a database can be expensive; you
don't want your application to re-connect every time you need to run a query.
The efficient thing to do is to hang on to a database handle to maintain a
connection to the database in order to minimize that overhead. DBIx::Connector
lets you do that without having to worry about dropped or corrupted
connections.

You might be familiar with Apache::DBI and with the DBI's `connect_cached()`
constructor. DBIx::Connector serves a similar need, but does a much better
job. How is it different? I'm glad you asked!

* Fork Safety

  Like Apache::DBI, but unlike `connect_cached()`, DBIx::Connector will return
  a new database handle if a new process has been `fork`ed. This happens all
  the time under mod_perl, in POE applications, and elsewhere.

* Thread Safety

  Unlike Apache::DBI or `connect_cached()`, DBIx::Connector will return a new
  database handle if a new thread has been spawned. As with `fork`ing,
  spawning a new thread can break database connections.

* Works Anywhere

  Unlike Apache::DBI, DBIx::Connector runs anywhere -- inside of mod_perl or
  not. Why limit yourself?

* Explicit Interface

  DBIx::Connector has an explicit interface. There is none of the magical
  action-at-a-distance crap that Apache::DBI is guilty of, and no global
  caching. I've personally diagnosed a few issues with Apache::DBI's magic,
  and killed it off in two different applications in favor of
  `connect_cached()`, only to be tripped up by other gotchas. No more.

* Optimistic Execution

  If you use `run()` and `txn()`, the database handle will be passed without
  first pinging the server. For the 99% or more of the time when the database
  is just there, you'll save a ton of overhead without the ping.

DBIx::Connector's other feature is transaction management. Borrowing from
DBIx::Class, DBIx::Connector offers an interface that efficiently handles the
scoping of database transactions so that you needn't worry about managing the
transaction yourself. Even better, it offers an interface for savepoints if
your database supports them. Within a transaction, you can scope savepoints to
behave like subtransactions, so that you can save some of your work in a
transaction even if some of it fails.

Installation
------------

[![Build Status](https://travis-ci.org/theory/dbix-connector.png)](https://travis-ci.org/theory/dbix-connector)

To install this module, type the following:

    perl Build.PL
    ./Build
    ./Build test
    ./Build install

Dependencies
------------

DBIx::Connection requires DBI 1.605 or higher.

Copyright and License
---------------------

Copyright (c) 2009-2013 David E. Wheeler. Some Rights Reserved.

This module is free software; you can redistribute it and/or modify it under
the same terms as Perl itself.
