# Copyrights 2011-2015 by [Mark Overmeer].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.01.
use warnings;
use strict;

package POSIX::1003::Socket;
use vars '$VERSION';
$VERSION = '0.99_02';

use base 'POSIX::1003::Module';

my (@sock, @sol, @so, @af, @pf, @constants);
my @functions    = qw/socket_names/;
our @IN_CORE     = qw//;   # to be added

our %EXPORT_TAGS =
  ( sock      => \@sock
  , so        => \@so
  , sol       => \@sol
  , af        => \@af
  , pf        => \@pf
  , constants => \@constants
  , functions => \@functions
  , tables    => [ qw/%sockets/ ]
  );

my ($socket, %socket);
BEGIN {
    $socket    = socket_table;
    @constants = sort keys %$socket;
    tie %socket, 'POSIX::1003::ReadOnlyTable', $socket;

    @sock      = grep /^SOCK/, @constants;
    @so        = grep /^SO_/,  @constants;
    @sol       = grep /^SOL_/, @constants;
    @af        = grep /^AF_/,  @constants;
    @pf        = grep /^PF_/,  @constants;
}


sub exampleValue($)
{   my ($class, $name) = @_;
    $socket{$name} // 'undef';
}

sub _create_constant($)
{   my ($class, $name) = @_;
    my $nr = $socket->{$name} // return sub() {undef};
    sub() {$nr};
}

#-------------

# get/setsockopt in XS

#------------

sub socket_names() { keys %$socket }

#------------

1;
