package Geo::TigerLine;

use strict;
use vars qw($VERSION);
$VERSION = '0.02';

=pod

=head1 NAME

Geo::TigerLine - TIGER/Line geographic data

=head1 DESCRIPTION

This is a module around the TIGER/Line geographic data generated by the
U.S. Census.  TIGER/Line data files contain detailed information about
roads, waterways, political and property boundaries, street addresses,
etc...  Almost (but not quite) everything you need to recreate something
like Mapquest.

Geo::TigerLine has been updated to reflect the structure of the
2003 TIGER/Line data sets. If you want to use older datasets, consider
regenerating the TIGER/Line data set parsers with the B<mk_parsers>
script distributed with this module.

=head1 AUTHORS

Originally written by Michael G Schwern <schwern@pobox.com>.

Currently maintained by Schuyler Erle <schuyler@nocat.net>.

=head1 LICENSE

Same as perl.

=head1 COPYRIGHT

Copyright (c) 2000 Michael G Schwern

TIGER and TIGER/Line are registered trademarks of the US Census Bureau.

=head1 BUGS, CAVEATS and Other Musings

Seeing as how TIGER is trademarked, we might want to call this module
something else.

=head1 ALL PRAISE TO

Bruce Perens, for putting the Census Bureau in the position of realizing
that they would be better off distributing this data themselves, for
free, over the web. Ain't America grand? ;-)

=head1 SEE ALSO

TIGER/Line data, manuals and additional info can be had from
http://www.census.gov/geo/www/tiger/. The TIGER/Line data itself is
probably most easily downloaded from http://www2.census.gov/geo/tiger/.

See <Geo::Coder::US(3pm)>, a Perl module for mapping US street address
to geographic coordinates, for one practical application based on
Geo::TigerLine.

=head1 ALSO, SEE ALSO

L<Geo::TigerLine::Record::1(3pm)>

L<Geo::TigerLine::Record::2(3pm)>

L<Geo::TigerLine::Record::4(3pm)>

L<Geo::TigerLine::Record::5(3pm)>

L<Geo::TigerLine::Record::6(3pm)>

L<Geo::TigerLine::Record::7(3pm)>

L<Geo::TigerLine::Record::8(3pm)>

L<Geo::TigerLine::Record::A(3pm)>

L<Geo::TigerLine::Record::B(3pm)>

L<Geo::TigerLine::Record::C(3pm)>

L<Geo::TigerLine::Record::E(3pm)>

L<Geo::TigerLine::Record::H(3pm)>

L<Geo::TigerLine::Record::I(3pm)>

L<Geo::TigerLine::Record::P(3pm)>

L<Geo::TigerLine::Record::R(3pm)>

L<Geo::TigerLine::Record::S(3pm)>

L<Geo::TigerLine::Record::T(3pm)>

L<Geo::TigerLine::Record::U(3pm)>

L<Geo::TigerLine::Record::Z(3pm)>

L<Geo::Coder::US(3pm)>

The L<mk_parsers> script distributed with this module.

=cut

return 'Mapquest must DIE!';
