#!/usr/bin/perl
use warnings;
use strict;
require 5.8.0;

# Automatically generated by ./mkbuild.pl

use Module::Build;

# Override the 'distmeta' action so that Module::Build won't delete
# my nice hand-crafted 'META.yml' file.
my $class = Module::Build->subclass(
    class => 'Daizu::Keep::Meta::Yml',
    code => q(
        sub ACTION_distmeta { $_[0]->{metafile} = 'META.yml' }
    ),
);

my $build = $class->new(
    module_name => 'Daizu',
    dist_version => '0.3',
    dist_abstract => 'Web publishing system built on Subversion',
    dist_author => 'Geoff Richards <geoff@laxan.com>',
    license => 'gpl',

    requires => {
        'Carp::Assert' => '0',
        'Compress::Zlib' => '0',
        'DBD::Pg' => '0',
        'DateTime' => '0',
        'DateTime::Format::Pg' => '0.08',
        'Digest::SHA1' => '0',
        'File::MMagic' => '0',
        'HTML::Entities' => '1.32',
        'HTML::Parser' => '0',
        'HTML::Tagset' => '0',
        'Image::Size' => '0',
        'Math::Round' => '0.03',
        'Path::Class' => '0.02',
        'SVN::Ra' => '0',
        'Template' => '2.15',
        'URI' => '0',
        'XML::LibXML' => '1.59',
    },
    build_requires => {
        'Module::Build' => '0',
    },
    recommends => {
        'Image::Magick' => '0',
        'Template::Plugin::Class' => '0',
        'Text::VimColor' => '0.09',
    },
    dynamic_config => 0,

    script_files => [qw[ bin/daizu ]],
    extra_files => {
        'lib/Daizu/pod/module-links.txt' => 'lib/Daizu/pod/module-links.txt',
        'lib/Daizu/template/article_extras.tt' => 'lib/Daizu/template/article_extras.tt',
        'lib/Daizu/template/article_meta.tt' => 'lib/Daizu/template/article_meta.tt',
        'lib/Daizu/template/article_meta/authors.tt' => 'lib/Daizu/template/article_meta/authors.tt',
        'lib/Daizu/template/article_meta/authors_pubdatetime.tt' => 'lib/Daizu/template/article_meta/authors_pubdatetime.tt',
        'lib/Daizu/template/article_meta/description.tt' => 'lib/Daizu/template/article_meta/description.tt',
        'lib/Daizu/template/article_meta/pubdatetime.tt' => 'lib/Daizu/template/article_meta/pubdatetime.tt',
        'lib/Daizu/template/article_pubdatetime.tt' => 'lib/Daizu/template/article_pubdatetime.tt',
        'lib/Daizu/template/article_retired.tt' => 'lib/Daizu/template/article_retired.tt',
        'lib/Daizu/template/article_tags.tt' => 'lib/Daizu/template/article_tags.tt',
        'lib/Daizu/template/blog/article_meta.tt' => 'lib/Daizu/template/blog/article_meta.tt',
        'lib/Daizu/template/blog/homepage.tt' => 'lib/Daizu/template/blog/homepage.tt',
        'lib/Daizu/template/blog/month_index.tt' => 'lib/Daizu/template/blog/month_index.tt',
        'lib/Daizu/template/blog/year_index.tt' => 'lib/Daizu/template/blog/year_index.tt',
        'lib/Daizu/template/body_bottom.tt' => 'lib/Daizu/template/body_bottom.tt',
        'lib/Daizu/template/extras_col.tt' => 'lib/Daizu/template/extras_col.tt',
        'lib/Daizu/template/footer.tt' => 'lib/Daizu/template/footer.tt',
        'lib/Daizu/template/head/html_decl.tt' => 'lib/Daizu/template/head/html_decl.tt',
        'lib/Daizu/template/head/meta.tt' => 'lib/Daizu/template/head/meta.tt',
        'lib/Daizu/template/head/page_title.tt' => 'lib/Daizu/template/head/page_title.tt',
        'lib/Daizu/template/head/styles.tt' => 'lib/Daizu/template/head/styles.tt',
        'lib/Daizu/template/header.tt' => 'lib/Daizu/template/header.tt',
        'lib/Daizu/template/nav_menu.tt' => 'lib/Daizu/template/nav_menu.tt',
        'lib/Daizu/template/nav_menu_sub.tt' => 'lib/Daizu/template/nav_menu_sub.tt',
        'lib/Daizu/template/navigation_col.tt' => 'lib/Daizu/template/navigation_col.tt',
        'lib/Daizu/template/page.tt' => 'lib/Daizu/template/page.tt',
        'lib/Daizu/template/page_content.tt' => 'lib/Daizu/template/page_content.tt',
        'lib/Daizu/template/page_layout.tt' => 'lib/Daizu/template/page_layout.tt',
        'lib/Daizu/template/plugin/podarticle_extras.tt' => 'lib/Daizu/template/plugin/podarticle_extras.tt',
        'lib/Daizu/template/plugin/relatedlinks_extras.tt' => 'lib/Daizu/template/plugin/relatedlinks_extras.tt',
        'lib/Daizu/template/prev_next_nav.tt' => 'lib/Daizu/template/prev_next_nav.tt',
        'lib/Daizu/xml/xhtml-entities.dtd' => 'lib/Daizu/xml/xhtml-entities.dtd',
        'lib/Daizu/xml/xhtml-lat1.ent' => 'lib/Daizu/xml/xhtml-lat1.ent',
        'lib/Daizu/xml/xhtml-special.ent' => 'lib/Daizu/xml/xhtml-special.ent',
        'lib/Daizu/xml/xhtml-symbol.ent' => 'lib/Daizu/xml/xhtml-symbol.ent',
    },
);

$build->add_build_element('extra');

$build->create_build_script;
