/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class ImplicitlyWait
extends WebDriverHandler<Void> {
    private volatile long millis;

    public ImplicitlyWait(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        try {
            this.millis = ((Number)allParameters.get("ms")).longValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) timeout value passed: " + allParameters.get("ms"), ex);
        }
    }

    @Override
    public Void call() throws Exception {
        this.getDriver().manage().timeouts().implicitlyWait(this.millis, TimeUnit.MILLISECONDS);
        return null;
    }

    public String toString() {
        return String.format("[implicitly wait: %s]", this.millis);
    }
}

