#!/usr/bin/perl

package eBay::API::XML::DataType::ItemType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ItemType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ItemType

=head1 DESCRIPTION

Contains the data defining one item. A seller populates an object of
this type at listing time with the definition of a new item. A seller
also uses an object of this type to re-list or revise an item. Calls
that retrieve item data (such as the GetSellerList call) return an object of
this type, filled with the item's data. Some fields are applicable both
to eBay listings and Half.com listings. Some fields are only applicable to eBay listings,
and others are only applicable to Half.com listings.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ItemType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::AttributeArrayType;
use eBay::API::XML::DataType::AttributeSetArrayType;
use eBay::API::XML::DataType::BestOfferDetailsType;
use eBay::API::XML::DataType::BiddingDetailsType;
use eBay::API::XML::DataType::BusinessSellerDetailsType;
use eBay::API::XML::DataType::BuyerProtectionDetailsType;
use eBay::API::XML::DataType::BuyerRequirementDetailsType;
use eBay::API::XML::DataType::CategoryType;
use eBay::API::XML::DataType::CharityType;
use eBay::API::XML::DataType::CrossPromotionsType;
use eBay::API::XML::DataType::DistanceType;
use eBay::API::XML::DataType::ExtendedContactDetailsType;
use eBay::API::XML::DataType::ExternalProductIDType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::ItemPolicyViolationType;
use eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType;
use eBay::API::XML::DataType::ListingDesignerType;
use eBay::API::XML::DataType::ListingDetailsType;
use eBay::API::XML::DataType::LiveAuctionDetailsType;
use eBay::API::XML::DataType::LookupAttributeArrayType;
use eBay::API::XML::DataType::NameValueListArrayType;
use eBay::API::XML::DataType::PaymentDetailsType;
use eBay::API::XML::DataType::PictureDetailsType;
use eBay::API::XML::DataType::ProductListingDetailsType;
use eBay::API::XML::DataType::ReviseStatusType;
use eBay::API::XML::DataType::SKUType;
use eBay::API::XML::DataType::SearchDetailsType;
use eBay::API::XML::DataType::SellingStatusType;
use eBay::API::XML::DataType::ShippingDetailsType;
use eBay::API::XML::DataType::StorefrontType;
use eBay::API::XML::DataType::UUIDType;
use eBay::API::XML::DataType::UserType;
use eBay::API::XML::DataType::VATDetailsType;
use eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType;
use eBay::API::XML::DataType::Enum::BuyerProtectionCodeType;
use eBay::API::XML::DataType::Enum::CountryCodeType;
use eBay::API::XML::DataType::Enum::CurrencyCodeType;
use eBay::API::XML::DataType::Enum::DescriptionReviseModeCodeType;
use eBay::API::XML::DataType::Enum::GiftServicesCodeType;
use eBay::API::XML::DataType::Enum::HitCounterCodeType;
use eBay::API::XML::DataType::Enum::ListingEnhancementsCodeType;
use eBay::API::XML::DataType::Enum::ListingSubtypeCodeType;
use eBay::API::XML::DataType::Enum::ListingTypeCodeType;
use eBay::API::XML::DataType::Enum::SiteCodeType;
use eBay::API::XML::DataType::Enum::SkypeContactOptionCodeType;


my @gaProperties = ( [ 'ApplicationData', 'xs:string', '', '', '' ]
	, [ 'ApplyBuyerProtection', 'ns:BuyerProtectionDetailsType', ''
	     ,'eBay::API::XML::DataType::BuyerProtectionDetailsType', '1' ]
	, [ 'ApplyShippingDiscount', 'xs:boolean', '', '', '' ]
	, [ 'AttributeArray', 'ns:AttributeArrayType', ''
	     ,'eBay::API::XML::DataType::AttributeArrayType', '1' ]
	, [ 'AttributeSetArray', 'ns:AttributeSetArrayType', ''
	     ,'eBay::API::XML::DataType::AttributeSetArrayType', '1' ]
	, [ 'AutoPay', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferDetails', 'ns:BestOfferDetailsType', ''
	     ,'eBay::API::XML::DataType::BestOfferDetailsType', '1' ]
	, [ 'BestOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BidGroupItem', 'xs:boolean', '', '', '' ]
	, [ 'BiddingDetails', 'ns:BiddingDetailsType', ''
	     ,'eBay::API::XML::DataType::BiddingDetailsType', '1' ]
	, [ 'BusinessSellerDetails', 'ns:BusinessSellerDetailsType', ''
	     ,'eBay::API::XML::DataType::BusinessSellerDetailsType', '1' ]
	, [ 'BuyItNowPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'BuyerGuaranteePrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'BuyerProtection', 'ns:BuyerProtectionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BuyerProtectionCodeType', '' ]
	, [ 'BuyerRequirementDetails', 'ns:BuyerRequirementDetailsType', ''
	     ,'eBay::API::XML::DataType::BuyerRequirementDetailsType', '1' ]
	, [ 'BuyerResponsibleForShipping', 'xs:boolean', '', '', '' ]
	, [ 'CategoryBasedAttributesPrefill', 'xs:boolean', '', '', '' ]
	, [ 'CategoryMappingAllowed', 'xs:boolean', '', '', '' ]
	, [ 'Charity', 'ns:CharityType', ''
	     ,'eBay::API::XML::DataType::CharityType', '1' ]
	, [ 'ClassifiedAdPayPerLeadFee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Country', 'ns:CountryCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CountryCodeType', '' ]
	, [ 'CrossBorderTrade', 'xs:string', '1', '', '' ]
	, [ 'CrossPromotion', 'ns:CrossPromotionsType', ''
	     ,'eBay::API::XML::DataType::CrossPromotionsType', '1' ]
	, [ 'Currency', 'ns:CurrencyCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CurrencyCodeType', '' ]
	, [ 'Description', 'xs:string', '', '', '' ]
	, [ 'DescriptionReviseMode', 'ns:DescriptionReviseModeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DescriptionReviseModeCodeType', '' ]
	, [ 'DisableBuyerRequirements', 'xs:boolean', '', '', '' ]
	, [ 'DispatchTimeMax', 'xs:int', '', '', '' ]
	, [ 'Distance', 'ns:DistanceType', ''
	     ,'eBay::API::XML::DataType::DistanceType', '1' ]
	, [ 'ExtendedSellerContactDetails', 'ns:ExtendedContactDetailsType', ''
	     ,'eBay::API::XML::DataType::ExtendedContactDetailsType', '1' ]
	, [ 'ExternalProductID', 'ns:ExternalProductIDType', ''
	     ,'eBay::API::XML::DataType::ExternalProductIDType', '1' ]
	, [ 'FreeAddedCategory', 'ns:CategoryType', ''
	     ,'eBay::API::XML::DataType::CategoryType', '1' ]
	, [ 'GetItFast', 'xs:boolean', '', '', '' ]
	, [ 'GiftIcon', 'xs:int', '', '', '' ]
	, [ 'GiftServices', 'ns:GiftServicesCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::GiftServicesCodeType', '' ]
	, [ 'GroupCategoryID', 'xs:string', '', '', '' ]
	, [ 'HitCount', 'xs:long', '', '', '' ]
	, [ 'HitCounter', 'ns:HitCounterCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::HitCounterCodeType', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'ItemPolicyViolation', 'ns:ItemPolicyViolationType', ''
	     ,'eBay::API::XML::DataType::ItemPolicyViolationType', '1' ]
	, [ 'ItemSpecifics', 'ns:NameValueListArrayType', ''
	     ,'eBay::API::XML::DataType::NameValueListArrayType', '1' ]
	, [ 'LeadCount', 'xs:int', '', '', '' ]
	, [ 'LimitedWarrantyEligible', 'xs:boolean', '', '', '' ]
	, [ 'ListingCheckoutRedirectPreference', 'ns:ListingCheckoutRedirectPreferenceType', ''
	     ,'eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType', '1' ]
	, [ 'ListingDesigner', 'ns:ListingDesignerType', ''
	     ,'eBay::API::XML::DataType::ListingDesignerType', '1' ]
	, [ 'ListingDetails', 'ns:ListingDetailsType', ''
	     ,'eBay::API::XML::DataType::ListingDetailsType', '1' ]
	, [ 'ListingDuration', 'xs:token', '', '', '' ]
	, [ 'ListingEnhancement', 'ns:ListingEnhancementsCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::ListingEnhancementsCodeType', '' ]
	, [ 'ListingSubtype2', 'ns:ListingSubtypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingSubtypeCodeType', '' ]
	, [ 'ListingType', 'ns:ListingTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingTypeCodeType', '' ]
	, [ 'LiveAuctionDetails', 'ns:LiveAuctionDetailsType', ''
	     ,'eBay::API::XML::DataType::LiveAuctionDetailsType', '1' ]
	, [ 'LocalListing', 'xs:boolean', '', '', '' ]
	, [ 'Location', 'xs:string', '', '', '' ]
	, [ 'LocationDefaulted', 'xs:boolean', '', '', '' ]
	, [ 'LookupAttributeArray', 'ns:LookupAttributeArrayType', ''
	     ,'eBay::API::XML::DataType::LookupAttributeArrayType', '1' ]
	, [ 'LotSize', 'xs:int', '', '', '' ]
	, [ 'MechanicalCheckAccepted', 'xs:boolean', '', '', '' ]
	, [ 'MotorsGermanySearchable', 'xs:boolean', '', '', '' ]
	, [ 'NewLeadCount', 'xs:int', '', '', '' ]
	, [ 'NowAndNew', 'xs:boolean', '', '', '' ]
	, [ 'PartnerCode', 'xs:string', '', '', '' ]
	, [ 'PartnerName', 'xs:string', '', '', '' ]
	, [ 'PayPalEmailAddress', 'xs:string', '', '', '' ]
	, [ 'PaymentDetails', 'ns:PaymentDetailsType', ''
	     ,'eBay::API::XML::DataType::PaymentDetailsType', '1' ]
	, [ 'PaymentMethods', 'ns:BuyerPaymentMethodCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType', '' ]
	, [ 'PictureDetails', 'ns:PictureDetailsType', ''
	     ,'eBay::API::XML::DataType::PictureDetailsType', '1' ]
	, [ 'PostalCode', 'xs:string', '', '', '' ]
	, [ 'PrimaryCategory', 'ns:CategoryType', ''
	     ,'eBay::API::XML::DataType::CategoryType', '1' ]
	, [ 'PrivateListing', 'xs:boolean', '', '', '' ]
	, [ 'PrivateNotes', 'xs:string', '', '', '' ]
	, [ 'ProductListingDetails', 'ns:ProductListingDetailsType', ''
	     ,'eBay::API::XML::DataType::ProductListingDetailsType', '1' ]
	, [ 'ProxyItem', 'xs:boolean', '', '', '' ]
	, [ 'Quantity', 'xs:int', '', '', '' ]
	, [ 'QuantityAvailable', 'xs:int', '', '', '' ]
	, [ 'QuestionCount', 'xs:long', '', '', '' ]
	, [ 'RegionID', 'xs:string', '', '', '' ]
	, [ 'RelistLink', 'xs:boolean', '', '', '' ]
	, [ 'Relisted', 'xs:boolean', '', '', '' ]
	, [ 'ReservePrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ReviseStatus', 'ns:ReviseStatusType', ''
	     ,'eBay::API::XML::DataType::ReviseStatusType', '1' ]
	, [ 'SKU', 'ns:SKUType', ''
	     ,'eBay::API::XML::DataType::SKUType', '1' ]
	, [ 'ScheduleTime', 'xs:dateTime', '', '', '' ]
	, [ 'SearchDetails', 'ns:SearchDetailsType', ''
	     ,'eBay::API::XML::DataType::SearchDetailsType', '1' ]
	, [ 'SecondaryCategory', 'ns:CategoryType', ''
	     ,'eBay::API::XML::DataType::CategoryType', '1' ]
	, [ 'Seller', 'ns:UserType', ''
	     ,'eBay::API::XML::DataType::UserType', '1' ]
	, [ 'SellerContactDetails', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'SellerInventoryID', 'xs:string', '', '', '' ]
	, [ 'SellerVacationNote', 'xs:string', '', '', '' ]
	, [ 'SellingStatus', 'ns:SellingStatusType', ''
	     ,'eBay::API::XML::DataType::SellingStatusType', '1' ]
	, [ 'ShipToLocations', 'xs:string', '1', '', '' ]
	, [ 'ShippingDetails', 'ns:ShippingDetailsType', ''
	     ,'eBay::API::XML::DataType::ShippingDetailsType', '1' ]
	, [ 'ShippingTermsInDescription', 'xs:boolean', '', '', '' ]
	, [ 'Site', 'ns:SiteCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SiteCodeType', '' ]
	, [ 'SkypeContactOption', 'ns:SkypeContactOptionCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::SkypeContactOptionCodeType', '' ]
	, [ 'SkypeEnabled', 'xs:boolean', '', '', '' ]
	, [ 'SkypeID', 'xs:string', '', '', '' ]
	, [ 'StartPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Storefront', 'ns:StorefrontType', ''
	     ,'eBay::API::XML::DataType::StorefrontType', '1' ]
	, [ 'SubTitle', 'xs:string', '', '', '' ]
	, [ 'ThirdPartyCheckout', 'xs:boolean', '', '', '' ]
	, [ 'ThirdPartyCheckoutIntegration', 'xs:boolean', '', '', '' ]
	, [ 'TimeLeft', 'xs:duration', '', '', '' ]
	, [ 'Title', 'xs:string', '', '', '' ]
	, [ 'TotalQuestionCount', 'xs:long', '', '', '' ]
	, [ 'UUID', 'ns:UUIDType', ''
	     ,'eBay::API::XML::DataType::UUIDType', '1' ]
	, [ 'UpdateReturnPolicy', 'xs:boolean', '', '', '' ]
	, [ 'UpdateSellerInfo', 'xs:boolean', '', '', '' ]
	, [ 'UseTaxTable', 'xs:boolean', '', '', '' ]
	, [ 'VATDetails', 'ns:VATDetailsType', ''
	     ,'eBay::API::XML::DataType::VATDetailsType', '1' ]
	, [ 'WatchCount', 'xs:long', '', '', '' ]
	, [ 'eBayNotes', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setApplicationData()

Returns custom, application-specific data associated with the item.
The data you specify is stored by eBay with the item for your own reference,
but it is not used by eBay in any way. Use ApplicationData to store
special information for yourself, such as a part number.
For a SKU in an eBay.com listing, use the SKU element instead.
To remove this value when revising or relisting an item, use DeletedField.
ApplicationData is not applicable to Half.com. For Half.com listings,
use SellerInventoryID instead.

ExcludeFromDefaultAreas: half
MaxLength: 32

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setApplicationData {
  my $self = shift;
  $self->{'ApplicationData'} = shift
}

=head2 getApplicationData()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getApplicationData {
  my $self = shift;
  return $self->{'ApplicationData'};
}


=head2 setApplyBuyerProtection()

Different Buyer protection schemes and the various status associated with each one of them.

#    Argument: 'ns:BuyerProtectionDetailsType'

=cut

sub setApplyBuyerProtection {
  my $self = shift;
  $self->{'ApplyBuyerProtection'} = shift
}

=head2 getApplyBuyerProtection()

  Calls: GetItem
  Returned: Conditionally

#    Returns: 'ns:BuyerProtectionDetailsType'

=cut

sub getApplyBuyerProtection {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ApplyBuyerProtection'
		,'eBay::API::XML::DataType::BuyerProtectionDetailsType');
}


=head2 setApplyShippingDiscount()

Multiple Item Shipping Discount. Seller specifies as input when listing,
re-listing, or revising an item to indicate whether a shipping discount is to
be applied when the buyer pays for the item in the checkout process and the
item's transaction is combined with other transactions into an order. Returned
with retrieved item data, indicating a shipping discount is applicable.<br>
<br>
Not returned by GetItem (see Item.ShippingDetails.ShippingDiscount instead).<br>
<br>
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setApplyShippingDiscount {
  my $self = shift;
  $self->{'ApplyShippingDiscount'} = shift
}

=head2 isApplyShippingDiscount()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isApplyShippingDiscount {
  my $self = shift;
  return $self->{'ApplyShippingDiscount'};
}


=head2 setAttributeArray()

Used to specify the item condition in AddItem.
Only applicable to Half.com (not eBay listings).
You can revise this property for Half.com listings.
For Half.com, AddItem does not use the same Attributes format as eBay's
Item Specifics.<br>
<br>
Not returned in GetItem. See AttributeSetArray instead.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=HalfOverview
Title: Half.com
, URL: GetItem.html#Response.Item.AttributeSetArray
Title: (GetItem) Item.AttributeSetArray


  Calls: AddItem
         VerifyAddItem
  RequiredInput: Yes

  Calls: ReviseItem
  RequiredInput: No

#    Argument: 'ns:AttributeArrayType'

=cut

sub setAttributeArray {
  my $self = shift;
  $self->{'AttributeArray'} = shift
}

=head2 getAttributeArray()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

#    Returns: 'ns:AttributeArrayType'

=cut

sub getAttributeArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AttributeArray'
		,'eBay::API::XML::DataType::AttributeArrayType');
}


=head2 setAttributeSetArray()

Item Specifics (such as new or used condition) in a listing.
Item Specifics (attributes) describe category-specific aspects or
features of an item in a standardized way.
Carries one or more instances of AttributeSet in a list.
For ID-based attributes in general, an item will be associated with no more
than two full attribute sets (one for the primary category and one for
the secondary category). For some international sites, an item can
specify additional site-wide attribute sets.<br>
<br>
Please note that AttributeSetArray does not support the new
"custom Item Specifics" model. See the ItemSpecifics node instead.<br>
<br>
<b>For the AddItem family of calls:</b> Some categories
(such as Event Tickets and US Real Estate) require Item Specifics.
See the eBay Web Services Guide links below for information on
working with Item Specifics. Use GetCategory2CS and GetAttributesCS
to determine when attributes are required for a category.
Also use attributes to specify the item condition and/or
return policy.<br>
<br>
For a listing to be eligible for eBay Express, the item condition is
required in most cases. Use GetCategoryFeatures to determine which
categories are exempt from this requirement.
See the eBay Web Services Guide links below for details.<br>
<br>
<b>For ReviseItem only:</b> When you revise a listing, if the
listing has bids and ends within 12 hours, you cannot change or add
attributes. If the listing has bids but ends in more
than 12 hours, you cannot change existing attribute data, but you can add
attributes that were not previously specified. The most reliable way to do this is
to pass in the entire AttributeSetArray with all the attributes you want
in the listing (not just the ones you want to change, because that usually
causes the others to be removed). To delete all attributes when
you revise or relist, specify Item.AttributeSetArray in DeletedField and don't
pass AttributeSetArray in the request. If the original listing's attributes
are no longer valid and you get errors when you try to revise the listing,
you can try to pass in the entire AttributeSetArray again with corrections.
If that doesn't work, you can end the item and relist it with a
set of valid attributes.<br>
<br>
<b>For AddLiveAuctionItem and ReviseLiveAuctionItem
only:</b>
For AddLiveAuctionItem and ReviseLiveAuctionItem, specify a maximum
of one AttributeSet for Item Specifics that are associated with
SecondaryCategory (a US eBay site category), plus any number of
additional AttributeSet properties for site-wide attributes that are
applicable to the US eBay site.<br>
<br>
<b>For GetCategoryListings only:</b> For GetCategoryListings,
AttributeSetArray can return the item condition
(not other Item Specifics), if specified.<br>
<br>
<b>For GetSearchResults only:</b>
GetSearchResults can return the item condition when the request either
specifies IncludeCondition as true; or specifies a
product finder search (and a detail level of ItemReturnAttributes
or ReturnAll). If IncludeCondition was true, see the ItemSpecific node
for a simpler view of the condition value. <br>
<span class="tablenote"><b>Note:</b>
AttributeSetArray only returns the condition attribute's ValueID.
You would need to use GetAttributesCS to figure out the meaning of this ID.
It's easier to just look at the ItemSpecific node.</span>
<br>
If SearchRequest or TicketFinder was used to perform a
product finder search, the list of attributes is limited to
Item Specifics that would be included in the
summary search results on the Web site, if any.
At this time, GetSearchResults only returns event ticket
venue name, section, and row (if specified) for eBay US (site 0);
and the mileage and year for eBay Motors vehicles (site 100 and
international eBay Motors sites that support this feature).
In other categories, no summary attributes are returned in
search results (even when the item is
listed with Item Specifics.) <br>
<br>
<b>For GetItemRecommendations only:</b>
In GetItemRecommendations, if you use the Suggested Attributes engine,
the engine interprets attributes you pass in as attributes that
do NOT need recommendations (i.e., attributes that the seller has
already filled in as desired). The engine only returns
recommendations for attributes that you do not specify, and only for
attributes associated with the primary category.<br>
<br>
For Half.com, this is only returned in GetItem. It is not applicable in
AddItem and other requests.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrOverview
Title: Working with Attribute-Based Features
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ItemCondition
Title: Specifying an Item's Condition
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ReturnPolicy
Title: Offering a Clear Return Policy
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressConditionRequired
Title: Specify the Item Condition for Express and eBay
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=LiveAuctions
Title: eBay Live Auctions
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrRevise
Title: Revising Items that Include Item Specifics (Attributes)
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrRelist
Title: Relisting Items that Include Item Specifics (Attributes)


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         AddLiveAuctionItem
         VerifyAddItem
  RequiredInput: Conditionally

  Calls: GetItemRecommendations
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: 'ns:AttributeSetArrayType'

=cut

sub setAttributeSetArray {
  my $self = shift;
  $self->{'AttributeSetArray'} = shift
}

=head2 getAttributeSetArray()

  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


#    Returns: 'ns:AttributeSetArrayType'

=cut

sub getAttributeSetArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AttributeSetArray'
		,'eBay::API::XML::DataType::AttributeSetArrayType');
}


=head2 setAutoPay()

If true, the seller requests immediate payment for the item.
If false or not specified, immediate payment is not requested.
(In responses, does not indicate whether the item is actually still a
candidate for purchase via immediate payment.)<br>
<br>
Only applicable to items listed on PayPal-enabled sites
in categories that support immediate payment (see AutoPayEnabled in
GetCategories), when seller has a Premier or Business PayPal account (see
PayPalAccountType in Getuser). If true, the seller must also accept PayPal as
a payment method for the item (see Item.PaymentMethods).<br>
<br>
Not supported if ThirdPartyCheckout is true.<br>
<br>
See the eBay Web
Services guide section on Immediate Payment for additional
requirements and dependencies. Also see the section on working with the
eBay Motors site for additional rules. Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AutoPay
Title: Requiring Immediate Payment
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MotorsAutoPay
Title: Requiring Immediate Payment of a Vehicle Deposit


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally
  Default: false

#    Argument: 'xs:boolean'

=cut

sub setAutoPay {
  my $self = shift;
  $self->{'AutoPay'} = shift
}

=head2 isAutoPay()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


#    Returns: 'xs:boolean'

=cut

sub isAutoPay {
  my $self = shift;
  return $self->{'AutoPay'};
}


=head2 setBestOfferDetails()

Container for BestOffer properties associated with the item.
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:BestOfferDetailsType'

=cut

sub setBestOfferDetails {
  my $self = shift;
  $self->{'BestOfferDetails'} = shift
}

=head2 getBestOfferDetails()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList

#    Returns: 'ns:BestOfferDetailsType'

=cut

sub getBestOfferDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOfferDetails'
		,'eBay::API::XML::DataType::BestOfferDetailsType');
}


=head2 setBestOfferEnabled()

Indicates, when true, that an item is available by Best Offer.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferEnabled {
  my $self = shift;
  $self->{'BestOfferEnabled'} = shift
}

=head2 isBestOfferEnabled()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetCategoryListings
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isBestOfferEnabled {
  my $self = shift;
  return $self->{'BestOfferEnabled'};
}


=head2 setBidGroupItem()

This flag is set to true if a watched item belongs to a bid
group. It will only be returned for the Watch container.

  Calls: GetMyeBayBuying
  RequiredInput: No
  Returned: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setBidGroupItem {
  my $self = shift;
  $self->{'BidGroupItem'} = shift
}

=head2 isBidGroupItem()

  Calls: GetMyeBayBuying
  RequiredInput: No
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isBidGroupItem {
  my $self = shift;
  return $self->{'BidGroupItem'};
}


=head2 setBiddingDetails()

Detailed information about a bid. For GetMyeBayBuying,
returned as a self-closed element if no bids meet the
request criteria. Not applicable to Half.com.

#    Argument: 'ns:BiddingDetailsType'

=cut

sub setBiddingDetails {
  my $self = shift;
  $self->{'BiddingDetails'} = shift
}

=head2 getBiddingDetails()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

#    Returns: 'ns:BiddingDetailsType'

=cut

sub getBiddingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BiddingDetails'
		,'eBay::API::XML::DataType::BiddingDetailsType');
}


=head2 setBusinessSellerDetails()

Returns the seller's information (in a business card format)
if the seller's SellerBusinessCodeType is set to 'Commercial'.
This is only applicable for sites where Business Seller options
are supported.

#    Argument: 'ns:BusinessSellerDetailsType'

=cut

sub setBusinessSellerDetails {
  my $self = shift;
  $self->{'BusinessSellerDetails'} = shift
}

=head2 getBusinessSellerDetails()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:BusinessSellerDetailsType'

=cut

sub getBusinessSellerDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BusinessSellerDetails'
		,'eBay::API::XML::DataType::BusinessSellerDetailsType');
}


=head2 setBuyItNowPrice()

For Chinese auction listings, Buy It Now allows a user to purchase the item at
a fixed price and end the auction immediately. Use this field to add Buy It
Now and specify the amount a buyer would need to bid to take advantage of the
Buy It Now feature.
<br><br>
On the main eBay site, not applicable to fixed-price items
(ListingType values StoresFixedPrice or FixedPriceItem), AdFormat
listings, or Half.com listings. For fixed-price and Half.com listings, see
StartPrice instead. See the eBay Web Services Guide for validation rules when
revising US eBay Motors listings, including rules for lowering the Buy It Now
price of a Motors listing.
<br><br>
Once a Chinese auction has bids (and the high bid exceeds the reserve price, if any),
the listing is no longer eligible for Buy It Now (with some exceptions noted below).
However, calls like GetItem and GetSearchResults still return the BuyItNowPrice that
the seller originally set for the listing. You can use Item.SellingStatus.BidCount to
determine whether an auction with Buy It Now has bids or not. With
GetSearchResults, you can use the Item.SearchDetails.BuyItNowEnabled flag
to determine whether the item can still be purchased using Buy It Now. With GetItem,
you can use the Item.ListingDetails.BuyItNowAvailable flag to determine
whether the item can still be purchased using Buy It Now.
<br><br>
On some sites, the Buy It Now price for a Chinese auction may remain available
for certain categories even after a bid is placed.
See the "Longer Lasting Buy It Now" link below for more details and the
latest list of eBay US categories that support this behavior.
The eBay Spain site supports this behavior for all categories.
<br><br>
For a listing to be eligible for Express, the max Buy It Now Price
is USD 10,000.00 for the US.
(Additional price limits may be imposed by the seller's PayPal account
or the payment method used. Such limits cannot be determined via the
eBay API and are not covered in eBay's API
documentation, as they may vary for each user.)
<br><br>
To remove this value when revising or relisting an item, use DeletedField.

SeeLink: URL: http://forums.ebay.com/db1/thread.jspa?threadID=2000449591&anticache=1207252776668
Title: Longer Lasting Buy It Now
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressPrice
Title: Specify a Fixed Price for Express and eBay
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ReviseMotors
Title: Revising US eBay Motors Listings

MaxLength: 16

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setBuyItNowPrice {
  my $self = shift;
  $self->{'BuyItNowPrice'} = shift
}

=head2 getBuyItNowPrice()

  Calls: GetBestOffers
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetCategoryListings
         GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Medium, Fine


  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WatchList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getBuyItNowPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyItNowPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setBuyerGuaranteePrice()

For the Australia site, BuyerGuaranteePrice is the PayPal Buyer Protection coverage,
offered for the item at the time of purchase.
Details of coverage are in the following sections
of the View Item page: the Buy Safely section and the Payment Details section.

#    Argument: 'ns:AmountType'

=cut

sub setBuyerGuaranteePrice {
  my $self = shift;
  $self->{'BuyerGuaranteePrice'} = shift
}

=head2 getBuyerGuaranteePrice()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


#    Returns: 'ns:AmountType'

=cut

sub getBuyerGuaranteePrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyerGuaranteePrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setBuyerProtection()

Indicates the status of the item's eligibility for the PayPal Buyer Protection
program. Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MiscellaneousItemFieldDifferences
Title: Miscellaneous Item Field Differences

#    Argument: 'ns:BuyerProtectionCodeType'

=cut

sub setBuyerProtection {
  my $self = shift;
  $self->{'BuyerProtection'} = shift
}

=head2 getBuyerProtection()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetBidderList
  Returned: Always

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:BuyerProtectionCodeType'

=cut

sub getBuyerProtection {
  my $self = shift;
  return $self->{'BuyerProtection'};
}


=head2 setBuyerRequirementDetails()

New Container for buyer requirements. The old container, BuyerRequirements, has been deprecated. All global MyeBay Buyer Requirements are
over-ridden by the contents of this container. This means that buyer
requirements set in MyeBay cannot be combined with buyer requirements included
in this container. When this container is present in an AddItem call, all
buyer requirements for the resulting listing are set by this container.
Furthermore, individual buyer requirements cannot be modified or added when
including this container in a ReviseItem call. The ReviseItem call needs to
provide the entire set of buyer requirements to modify or add any of the
requirements. Unless otherwise specified, most buyer requirements are only
returned if the caller is the seller. Not applicable to Half.com.

SeeLink: URL: http://pages.ebay.com/help/sell/buyer-requirements.html
Title: Selecting Buyer Requirements (eBay Web site help)

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:BuyerRequirementDetailsType'

=cut

sub setBuyerRequirementDetails {
  my $self = shift;
  $self->{'BuyerRequirementDetails'} = shift
}

=head2 getBuyerRequirementDetails()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:BuyerRequirementDetailsType'

=cut

sub getBuyerRequirementDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyerRequirementDetails'
		,'eBay::API::XML::DataType::BuyerRequirementDetailsType');
}


=head2 setBuyerResponsibleForShipping()

Applicable for listings in vehicle categories on the US eBay Motors site and
eBay Canada site. (No business effect if specified for other categories or
sites, as the Web site will not display the information to buyers.) If true,
the buyer is responsible for vehicle pickup or shipping. If false, specify
vehicle shipping arrangements in the item description. Default is true. (The
description can also include vehicle shipping arrangements when this value is
true.) If the item has bids or ends within 12 hours, you cannot modify this
flag. Do not specify ShippingDetails.ShippingServiceOptions
for vehicle listings.
<br><br>
If true and the listing is on the US eBay Motors site, and you want the
listing to be visible on the eBay Canada site, set Item.ShipToLocations to CA.
If true and the listing is on the eBay Canada site , and you want your listing
to be visible on the US eBay Motors site, set Item.ShipToLocations to US. Not
applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setBuyerResponsibleForShipping {
  my $self = shift;
  $self->{'BuyerResponsibleForShipping'} = shift
}

=head2 isBuyerResponsibleForShipping()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBuyerResponsibleForShipping {
  my $self = shift;
  return $self->{'BuyerResponsibleForShipping'};
}


=head2 setCategoryBasedAttributesPrefill()

Allows eBay to auto-fill some of a listing's Item Specifics (attribute) values
based on the listing's category (or categories). Auto-filling attributes based
on a category is not the same as using Pre-filled Item Information based on a
catalog product (see ProductListingDetails). If true, also specify
Item.CategoryMappingAllowed with a value of true. (Alternatively, you can
auto-fill attributes on the client side by using mapping meta-data returned by
GetAttributesCS.) See the eBay Web Services guide for more information.
Ignored if the category does not support auto-filling attributes.<br>
<br>
If you also pass in attributes in AttributeSetArray, your values will override
any auto-filled values for the same attributes. Once you have overridden the
value of an auto-filled attribute for a given listing, eBay will not auto-fill
it on subsequent ReviseItem requests (even if you remove the overridden
value). <br>
<br>
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         ReviseItem
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setCategoryBasedAttributesPrefill {
  my $self = shift;
  $self->{'CategoryBasedAttributesPrefill'} = shift
}

=head2 isCategoryBasedAttributesPrefill()

#    Returns: 'xs:boolean'

=cut

sub isCategoryBasedAttributesPrefill {
  my $self = shift;
  return $self->{'CategoryBasedAttributesPrefill'};
}


=head2 setCategoryMappingAllowed()

Controls how eBay handles cases in which an ID specified in PrimaryCategory
and/or SecondaryCategory no longer exists in the current category structure:
If you pass a value of true in CategoryMappingAllowed, eBay will look up the
current ID that is mapped to the same category and use the new ID for the
listing (if any). The new ID will be returned in the response as CategoryID
(for the primary category) or Category2ID (for the secondary category). If
CategoryMappingAllowed is not set or contains a value of "false" (the
default), an error will be returned if a selected category ID no longer
exists. Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         AddLiveAuctionItem
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No
  SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CategoryMapping, Title: Mapping Old Category IDs to Current IDs

#    Argument: 'xs:boolean'

=cut

sub setCategoryMappingAllowed {
  my $self = shift;
  $self->{'CategoryMappingAllowed'} = shift
}

=head2 isCategoryMappingAllowed()

#    Returns: 'xs:boolean'

=cut

sub isCategoryMappingAllowed {
  my $self = shift;
  return $self->{'CategoryMappingAllowed'};
}


=head2 setCharity()

Identifies a Giving Works listing and the benefiting nonprofit charity
organization selected by the charity seller, if any. If specified, the
seller must also accept PayPal as a payment method for the item (see
Item.PaymentMethods). <br>
<br>Giving Works listings are not eligible for
some eBay Express sites. (If ExpressListing is false in GetItem or
VerifyAddItem and you specified Charity, check whether
ExpressItemRequirements returns NoCharity as a cause.)
<br><br>
When you revise an item, you can add a charity to a non-charity listing,
but you cannot remove or change the charity designation. The rules for adding
a charity to a listing depend on the listing type. For an auction listing, you
can revise an item to add a charity if there are more than 12 hours left for
the listing (whether or not the item has bids). For a fixed-price listing, you
can revise an item to add a charity if there are more than 12 hours left for
the listing, and the item has not been sold. For a Store Inventory listing,
you can revise an item to add a charity if the item has not been sold. You
cannot revise listings to add charity for Ad Format listings.
<br><br>
When you relist an item, use DeletedField to remove charity information.
<br><br>
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MiscellaneousItemFieldDifferences
Title: Miscellaneous Item Field Differences
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CharityListings
Title: Identifying Listings that Benefit Nonprofits


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:CharityType'

=cut

sub setCharity {
  my $self = shift;
  $self->{'Charity'} = shift
}

=head2 getCharity()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


#    Returns: 'ns:CharityType'

=cut

sub getCharity {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Charity'
		,'eBay::API::XML::DataType::CharityType');
}


=head2 setClassifiedAdPayPerLeadFee()

The email and phone lead fee for a pay-per-lead item.

#    Argument: 'ns:AmountType'

=cut

sub setClassifiedAdPayPerLeadFee {
  my $self = shift;
  $self->{'ClassifiedAdPayPerLeadFee'} = shift
}

=head2 getClassifiedAdPayPerLeadFee()

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getClassifiedAdPayPerLeadFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdPayPerLeadFee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCountry()

Two-letter ISO 3166 country code. In some calls, used with the Location field
to indicate the city and country where the item is located. Also applicable as
input to AddItem and related calls when you list items to Half.com (specify
US).<br>
For English names that correspond to each code (e.g., KY="Cayman Islands"),
call GeteBayDetails or see the
ISO site:http://www.iso.ch/iso/en/prods-services/iso3166ma/02iso-3166-code-lists/list-en1.html
<br>
<br>
In GetSearchResultsExpress, only returned when ItemDetails
is set to Fine.

  Calls: AddItem
         VerifyAddItem
  RequiredInput: Yes

  Calls: RelistItem
         ReviseItem
  RequiredInput: No

#    Argument: 'ns:CountryCodeType'

=cut

sub setCountry {
  my $self = shift;
  $self->{'Country'} = shift
}

=head2 getCountry()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse


  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetItemRecommendations
         GetProducts
  Returned: Conditionally

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:CountryCodeType'

=cut

sub getCountry {
  my $self = shift;
  return $self->{'Country'};
}


=head2 setCrossBorderTrade()

For a fee, enables a listing to be displayed in the default search results
of another eBay site. Use this value if you want to take
advantage of the International Site Visibility listing upgrade.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ListingsAvailableOtherSites
Title: Making Listings Available by Default on Another Site

  Calls: AddItem
         VerifyAddItem
         ReviseItem
         RelistItem
  RequiredInput: No

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setCrossBorderTrade {
  my $self = shift;
  $self->{'CrossBorderTrade'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCrossBorderTrade()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getCrossBorderTrade {
  my $self = shift;
  return $self->_getDataTypeArray('CrossBorderTrade');
}


=head2 setCrossPromotion()

Container for cross-promoted items related to a specific item ID.
The items are either upsell or cross-sell, according to the promotion
method passed in the request.
Not applicable to Half.com.

#    Argument: 'ns:CrossPromotionsType'

=cut

sub setCrossPromotion {
  my $self = shift;
  $self->{'CrossPromotion'} = shift
}

=head2 getCrossPromotion()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:CrossPromotionsType'

=cut

sub getCrossPromotion {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CrossPromotion'
		,'eBay::API::XML::DataType::CrossPromotionsType');
}


=head2 setCurrency()

Currency associated with the item's price information. 3-letter ISO 4217
currency code that corresponds to the site specified in the item-listing
request. Also applicable as input to AddItem and related calls when you list
items to Half.com (specify USD). You cannot modify a listing's currency when
you revise or relist an item.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=FieldDifferences
Title: Field Differences for eBay Sites

  Calls: AddItem
         GetItemRecommendations
         VerifyAddItem
  RequiredInput: Yes
  OnlyTheseValues: INR, CAD, CNY, HKD, AUD, CHF, MYR, EUR, PHP, PLN, USD, SGD, SEK, TWD, GBP

#    Argument: 'ns:CurrencyCodeType'

=cut

sub setCurrency {
  my $self = shift;
  $self->{'Currency'} = shift
}

=head2 getCurrency()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetBestOffers
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetCategoryListings
         GetProducts
  Returned: Conditionally

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:CurrencyCodeType'

=cut

sub getCurrency {
  my $self = shift;
  return $self->{'Currency'};
}


=head2 setDescription()

Description of the item. In listing requests, you can submit your description
using CDATA if you want to use HTML or XML-reserved characters in the
description. An error is returned if this contains malicious JavaScript
content. (For related eBay policy, see
http://pages.ebay.com/help/policies/listing-javascript.html.)
<br><br>
The Description field is required for all listings, except certain listings
that include Pre-filled Item Information. (See "About the Pre- filled Item
Information API." in the eBay Web Services Guide.) Even if your application
does not support listings items with Pre-filled Item Information, you should
be aware that this also means GetItem, GetSellerList, and GetBidderList may
return some items with empty Description fields.
<br><br>
If you embed pictures in the description (by using IMG tags) instead of using
PictureURL, but you want a camera icon to appear in search and listing pages,
specify the following null-image URL in PictureURL:
http://pics.ebay.com/aw/pics/dot_clear.gif. See "Including Pictures in an Item
Listing" in the eBay Web Services Guide.
<br><br>
For eBay Live Auctions listings, JavaScript is not allowed.
<br><br>
Not applicable to Half.com. (For Half.com, use AttributeArray.Attribute with
attributeLabel="Notes" to specify a brief description or note to the buyer.)

MaxLength: 500000 (some sites may allow more, but the exact number may vary)

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setDescription {
  my $self = shift;
  $self->{'Description'} = shift
}

=head2 getDescription()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getDescription {
  my $self = shift;
  return $self->{'Description'};
}


=head2 setDescriptionReviseMode()

If you are changing the description of an item, specifies whether
the new next is an addition, a replacement, etc.

  Calls: ReviseItem
  RequiredInput: No

#    Argument: 'ns:DescriptionReviseModeCodeType'

=cut

sub setDescriptionReviseMode {
  my $self = shift;
  $self->{'DescriptionReviseMode'} = shift
}

=head2 getDescriptionReviseMode()

#    Returns: 'ns:DescriptionReviseModeCodeType'

=cut

sub getDescriptionReviseMode {
  my $self = shift;
  return $self->{'DescriptionReviseMode'};
}


=head2 setDisableBuyerRequirements()

If false (or omitted): if BuyerRequirementDetails are present, those requirements are to be used; otherwise, any requirements specified in
My eBay are to be used.
If true: no requirements are considered from any source (and if
BuyerRequirementDetails are present, they are ignored).

Default: false

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setDisableBuyerRequirements {
  my $self = shift;
  $self->{'DisableBuyerRequirements'} = shift
}

=head2 isDisableBuyerRequirements()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isDisableBuyerRequirements {
  my $self = shift;
  return $self->{'DisableBuyerRequirements'};
}


=head2 setDispatchTimeMax()

Specifies the maximum number of business days the seller
commits to for shipping an item to domestic buyers after receiving a
cleared payment. The seller sets this to an integer value (1, 2, 3,
4, 5, 10, 15, or 20) corresponding to the number of days. To add
Get It Fast to listings, in addition to setting GetItFast to true,
DispatchTimeMax must be set to 1 and the seller must specify at least
one qualifying expedited shipping service.
GetItem returns DispatchTimeMax only when shipping service options are
specified for the item and the seller specified a dispatch time.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setDispatchTimeMax {
  my $self = shift;
  $self->{'DispatchTimeMax'} = shift
}

=head2 getDispatchTimeMax()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

#    Returns: 'xs:int'

=cut

sub getDispatchTimeMax {
  my $self = shift;
  return $self->{'DispatchTimeMax'};
}


=head2 setDistance()

The distance used in a proximity search distance calculation.
Not applicable to Half.com.

#    Argument: 'ns:DistanceType'

=cut

sub setDistance {
  my $self = shift;
  $self->{'Distance'} = shift
}

=head2 getDistance()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetCategoryListings
  Returned: Conditionally

#    Returns: 'ns:DistanceType'

=cut

sub getDistance {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Distance'
		,'eBay::API::XML::DataType::DistanceType');
}


=head2 setExtendedSellerContactDetails()

Extended contact information for sellers using the Classified Ad format.
Specifies the days and hours when the seller can be contacted.
To remove seller contact information when revising or relisting an item, use
DeletedField.

  Calls: AddItem
         ReviseItem
         VerifyAddItem
         RelistItem
  RequiredInput: No

#    Argument: 'ns:ExtendedContactDetailsType'

=cut

sub setExtendedSellerContactDetails {
  my $self = shift;
  $self->{'ExtendedSellerContactDetails'} = shift
}

=head2 getExtendedSellerContactDetails()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:ExtendedContactDetailsType'

=cut

sub getExtendedSellerContactDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExtendedSellerContactDetails'
		,'eBay::API::XML::DataType::ExtendedContactDetailsType');
}


=head2 setExternalProductID()

An ISBN value, UPC value, EAN value, ticket keywords,
or eBay catalog product ID, plus other meta-data that you specify.
Only applicable to certain categories. See
the eBay Web Services Guide for information on the categories
that currently support usage of this field. <br>
<br>
<b>For AddItem and VerifyAddItem only:</b>
Causes eBay to list the item with Pre-filled Item Information
based on the value you specify. If you are listing in a
media category and the primary and secondary category are both
catalog-enabled, the external ID must be for a product associated with
the primary category. If only one category is
catalog-enabled, this external ID must be for a product that is
associated with the catalog-enabled category. If you are listing
an event ticket, the external ID must be associated with the
primary category.<br>
<br>
Either Item.ExternalProductID or Item.ProductListingDetails
can be specified in an AddItem (or VerifyAddItem) request.
Do not specify both.
If you use Item.ExternalProductID instead
of Item.ProductListingDetails, eBay sets IncludeStockPhotoURL
and IncludePrefilledItemInformation to true automatically.<br>
<br>
The stock photo URL satisfies the eBay Express picture requirement.
See the eBay Web Services Guide links below for more details.<br>
<br>
Optional for eBay.com listings. Applicable to Half.com listings.<br>
<br>
<b>For ReviseItem and RelistItem only:</b>
ExternalProductID is not applicable when revising and relisting items
(use Item.ProductListingDetails instead).<br>
<br>
<b>For GetItemRecommendations only:</b>
In GetItemRecommendations, only applicable when the value of
ListingFlow is AddItem. Not applicable when the recommendation engine
is ProductPricing.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=BMMGExternalID
Title: Pre-filling a Listing Based on ISBN, EAN, or UPC Values (ExternalProductID)
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=TicketKeywords
Title: Pre-filling a Ticket Listing Based on Keywords (Name, Venue, and Date)
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressPictureRequired
Title: Specify a Picture for Express and eBay
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=EngineListingAnalyzer
Title: Getting Listing Analyzer Tips on Making a Listing More Effective
, URL: ReviseItem.html#Request.Item.ProductListingDetails
Title: (ReviseItem) Item.ProductListingDetails


  Calls: AddItem
         GetItemRecommendations
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:ExternalProductIDType'

=cut

sub setExternalProductID {
  my $self = shift;
  $self->{'ExternalProductID'} = shift
}

=head2 getExternalProductID()

#    Returns: 'ns:ExternalProductIDType'

=cut

sub getExternalProductID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExternalProductID'
		,'eBay::API::XML::DataType::ExternalProductIDType');
}


=head2 setFreeAddedCategory()

ID for a second category that eBay added as a free promotion. You cannot add
this yourself. Only returned if the item was listed in a single category and
eBay added a free second category.
Not applicable to Half.com.

#    Argument: 'ns:CategoryType'

=cut

sub setFreeAddedCategory {
  my $self = shift;
  $self->{'FreeAddedCategory'} = shift
}

=head2 getFreeAddedCategory()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'ns:CategoryType'

=cut

sub getFreeAddedCategory {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FreeAddedCategory'
		,'eBay::API::XML::DataType::CategoryType');
}


=head2 setGetItFast()

Indicates whether the seller has opted the listing into the Get
It Fast feature. If GetItFast is true and if at least one of
the domestic shipping services offered by the seller is an
expedited shipping service, every shipping service offered by
the seller is considered a Get It Fast service, and the seller
commits to delivering the item to the buyer-selected shipping
service within one day.
Not applicable to Half.com.
GetItFast is not supported for UK Store Inventory format items.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SalesTax
Title: Enabling Multi-jurisdiction Sales Tax
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MiscellaneousItemFieldDifferences
Title: Miscellaneous Item Field Differences


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setGetItFast {
  my $self = shift;
  $self->{'GetItFast'} = shift
}

=head2 isGetItFast()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isGetItFast {
  my $self = shift;
  return $self->{'GetItFast'};
}


=head2 setGiftIcon()

If true, a generic gift icon displays next the listing's title in search and
browse pages. GiftIcon must be set to be able to use GiftServices options.
Note that one/zero is returned instead of true/false. Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:int'

=cut

sub setGiftIcon {
  my $self = shift;
  $self->{'GiftIcon'} = shift
}

=head2 getGiftIcon()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getGiftIcon {
  my $self = shift;
  return $self->{'GiftIcon'};
}


=head2 setGiftServices()

Optional gift services that the seller is offering if the buyer chooses to
purchase the item as a gift. Only returned if offered by the seller.
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:GiftServicesCodeType'

=cut

sub setGiftServices {
  my $self = shift;
  $self->{'GiftServices'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getGiftServices()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: reference to an array  
                      of 'ns:GiftServicesCodeType'

=cut

sub getGiftServices {
  my $self = shift;
  return $self->_getDataTypeArray('GiftServices');
}


=head2 setGroupCategoryID()

GroupCategoryID is returned if there is a value of BestMatchCategoryGroup in the
Order field for the GetSearchResults call. However, the results depend on the
items and groups requested. The Best Match algorithm will try to evenly fit the
items and return groups of 'Best Matching' Categories. A 'category group' can be
a parent category that contains the best-matching items from several of its
subcategories. Within each category group, items will be also sorted by best
match. The only condition when you may not get a GroupCategoryID returned at all
is when the request is for one group and there is more than one category that
has matching items. Very rarely, the same item will appear once in the group for
its primary category and once in another group for its secondary category, in
the same result set. Also very occasionally, a Store Inventory Item can appear
in the results before a regular listing.

#    Argument: 'xs:string'

=cut

sub setGroupCategoryID {
  my $self = shift;
  $self->{'GroupCategoryID'} = shift
}

=head2 getGroupCategoryID()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, ReturnAll, None

#    Returns: 'xs:string'

=cut

sub getGroupCategoryID {
  my $self = shift;
  return $self->{'GroupCategoryID'};
}


=head2 setHitCount()

The number of page views for the item. This number is calculated by eBay and
cannot be set via the API. Returned if the hit counter type is BasicStyle,
RetroStyle, or HiddenStyle. For HiddenStyle, HitCount is returned only if the
requestor is the item's seller.

#    Argument: 'xs:long'

=cut

sub setHitCount {
  my $self = shift;
  $self->{'HitCount'} = shift
}

=head2 getHitCount()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:long'

=cut

sub getHitCount {
  my $self = shift;
  return $self->{'HitCount'};
}


=head2 setHitCounter()

Indicates whether an optional hit counter is displayed on the item's listing
page and, if so, what type. See HitCounterCodeType for specific values.
Not applicable to Half.com.
This field is ignored when Item.ListingType=Express.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:HitCounterCodeType'

=cut

sub setHitCounter {
  my $self = shift;
  $self->{'HitCounter'} = shift
}

=head2 getHitCounter()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetSellerEvents
  Returned: Always
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:HitCounterCodeType'

=cut

sub getHitCounter {
  my $self = shift;
  return $self->{'HitCounter'};
}


=head2 setItemID()

The ID that uniquely identifies the item listing. The ID is generated
by eBay after an item is listed. You cannot choose or revise this
value.<br>
<br>
Also applicable to Half.com. For Half.com, you can specify either ItemID or
SellerInventoryID in a ReviseItem request to uniquely identify the
listing.<br>
<br>
In GetItemRecommendations, the item ID is required when the value of
ListingFlow is ReviseItem or RelistItem, but it is not applicable when the
value of ListingFlow is AddItem.<br>
<br>
In GetSearchResultsExpress, always returned when ItemArray.Item is returned.<br>
<br>
For GetCart/SetCart input, this is only required if the parent container is submitted.

MaxLength: 19. (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits.)

  Calls: AddOrder
         GetBestOffers
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
  RequiredInput: Yes

  Calls: GetItemRecommendations
  RequiredInput: Conditionally

#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

  Calls: GetBidderList
         GetDispute
  Returned: Always

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetBestOffers
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetItemsAwaitingFeedback
         GetMemberMessages
         GetProducts
  Returned: Conditionally

  Calls: GetUserDisputes
  Returned: Conditionally
  Details: DetailLevel: ReturnSummary, ReturnAll, none

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           SecondChanceOffer
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           BidList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setItemPolicyViolation()

Specifies the details of policy violations if the item was administratively canceled.

#    Argument: 'ns:ItemPolicyViolationType'

=cut

sub setItemPolicyViolation {
  my $self = shift;
  $self->{'ItemPolicyViolation'} = shift
}

=head2 getItemPolicyViolation()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally

#    Returns: 'ns:ItemPolicyViolationType'

=cut

sub getItemPolicyViolation {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemPolicyViolation'
		,'eBay::API::XML::DataType::ItemPolicyViolationType');
}


=head2 setItemSpecifics()

A list of attribute or Item Specific name and value pairs that the
seller specified for the item.<br>
<br>
In the AddItem family of calls, use this for specifying
custom Item Specifics. (If you are including an
Item Condition or Return Policy, use AttributeSetArray for these
details as usual instead. You can use AttributeSetArray and
ItemSpecifics in the same request in this case.)<br>
<br>
To determine which categories support
custom Item Specifics, use GetCategoryFeatures.<br>
<br>
<span class="tablenote"><b>Note:</b>
If you are trying to list with ID-based attributes
from GetAttributesCS or GetProductSellingPages,
use AttributeSetArray instead.</span><br>
<br>
To retrieve recommended Item Specifics, use GetCategorySpecifics or GetItemRecommendations.<br>
<br>
In GetItemRecommendations, pass in the PrimaryCategory and (optionally)
Title to retrieve recommended names and values. <br>
<br>
With GetItem, this is only returned when you specify
IncludeItemSpecifics in the request (and the seller included
custom Item Specifics in their listing).<br>
<br>
<b>For ReviseItem only:</b> When you revise a listing,
if the listing has bids and ends within 12 hours, you cannot change or
add Item Specifics. If the listing has bids but ends in more
than 12 hours, you cannot change existing Item Specifics, but you can
add Item Specifics that were not previously specified.<br>
<br>
To delete all Item Specifics when you revise or relist, specify
Item.ItemSpecifics in DeletedField and don't pass ItemSpecifics in the
request.<br>
<br>
With GetProducts, only the item condition is returned at the item level.
Additional attributes that were pre-filled from the catalog are returned
in Product.ItemSpecifics.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ItemSpecifics
Title: Working with Custom Item Specifics
, URL: GetProducts.html#Response.Product.ItemSpecifics
Title: (GetProducts) Product.ItemSpecifics


  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:NameValueListArrayType'

=cut

sub setItemSpecifics {
  my $self = shift;
  $self->{'ItemSpecifics'} = shift
}

=head2 getItemSpecifics()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'ns:NameValueListArrayType'

=cut

sub getItemSpecifics {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemSpecifics'
		,'eBay::API::XML::DataType::NameValueListArrayType');
}


=head2 setLeadCount()

Specifies the number of leads (emails) buyers have posted about the item. You must be the seller of the item to retrieve the lead count.

  Calls: GetMyeBaySelling
  RequiredInput: Conditionally

#    Argument: 'xs:int'

=cut

sub setLeadCount {
  my $self = shift;
  $self->{'LeadCount'} = shift
}

=head2 getLeadCount()

#    Returns: 'xs:int'

=cut

sub getLeadCount {
  my $self = shift;
  return $self->{'LeadCount'};
}


=head2 setLimitedWarrantyEligible()

Applicable to US eBay Motors vehicle listings only. If false, the vehicle will
not be considered for a limited warranty by eBay. If your application lists
Motors vehicles, you must provide the seller with an opportunity to indicate
whether the vehicle has not been modified and is not a special type (e.g.,
Corvette ZR1). If LimitedWarrantyEligible is passed in, it means the
application has presented the seller with checkboxes to indicate this
information. If true, the seller has verified that the vehicle has not been
modified and is not a special type. If false, the seller has verified that
vehicle has been modified or it is a special type. Passing a value of true
does not guarantee that eBay will offer a limited warranty. It only makes the
listing eligible for consideration. See the eBay Web Services Guide for more
information about Motors vehicle listings.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MotorsWarranty
Title: Short-Term Service Agreement (Limited Warranty)

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setLimitedWarrantyEligible {
  my $self = shift;
  $self->{'LimitedWarrantyEligible'} = shift
}

=head2 isLimitedWarrantyEligible()

#    Returns: 'xs:boolean'

=cut

sub isLimitedWarrantyEligible {
  my $self = shift;
  return $self->{'LimitedWarrantyEligible'};
}


=head2 setListingCheckoutRedirectPreference()

ProStores listing level preferences regarding the store to which
checkout should be redirected for the listing if ThirdPartyCheckout
is true.  If not set (and ThirdPartyCheckout is true), third
party checkout is redirected to the listing application.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ThirdPartyCheckoutRedirectProStores
Title: Third Party Checkout Redirect to ProStores

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:ListingCheckoutRedirectPreferenceType'

=cut

sub setListingCheckoutRedirectPreference {
  my $self = shift;
  $self->{'ListingCheckoutRedirectPreference'} = shift
}

=head2 getListingCheckoutRedirectPreference()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll

#    Returns: 'ns:ListingCheckoutRedirectPreferenceType'

=cut

sub getListingCheckoutRedirectPreference {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ListingCheckoutRedirectPreference'
		,'eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType');
}


=head2 setListingDesigner()

Contains the detail data for the Listing Designer theme and template (if either
are used), which can optionally be used to enhance the appearance of the
description area of an item's description. See ListingDesignerType for its
child elements.
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:ListingDesignerType'

=cut

sub setListingDesigner {
  my $self = shift;
  $self->{'ListingDesigner'} = shift
}

=head2 getListingDesigner()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'ns:ListingDesignerType'

=cut

sub getListingDesigner {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ListingDesigner'
		,'eBay::API::XML::DataType::ListingDesignerType');
}


=head2 setListingDetails()

Various details about a listing, some of which are
calculated or derived after the item is listed. These
include the start and end time, converted (localized)
prices, and certain flags that indicate whether the seller
specified fields whose values are not visible to the
requesting user. For GetMyeBayBuying, returned as a self-
closed element if no listings meet the request criteria.
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         ReviseItem
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:ListingDetailsType'

=cut

sub setListingDetails {
  my $self = shift;
  $self->{'ListingDetails'} = shift
}

=head2 getListingDetails()

  Calls: GetBestOffers
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetBidderList
         GetDispute
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetCategoryListings
         GetItemsAwaitingFeedback
         GetMemberMessages
         GetProducts
  Returned: Conditionally

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           SecondChanceOffer
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           BidList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


#    Returns: 'ns:ListingDetailsType'

=cut

sub getListingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ListingDetails'
		,'eBay::API::XML::DataType::ListingDetailsType');
}


=head2 setListingDuration()

Describes the number of days the seller wants the listing to be active
(available for bidding/buying).
The duration specifies the seller's initial
intent at listing time. The end time for a listing is calculated by
adding the duration to the item's start time.
If the listing ends early, the value of the
listing duration does not change. When a listing's duration is changed,
any related fees (e.g., 10-day fee) may be debited or credited
(as applicable).<br>
<br>
The valid choice of values depends on the listing format
(see Item.ListingType).
For a list of valid values, call GetCategoryFeatures with DetailLevel
set to ReturnAll and look for ListingDurations information. <br>
<br>
Also required for Half.com (but only specify GTC).<br>
<br>
When you revise a listing, the duration cannot be reduced if it
will result in ending the listing within 24 hours of the current
date-time.
You are only allowed to increase the duration of the listing if fewer
than 2 hours have passed since you initially listed the item and the listing
has no bids. You can decrease the value of this field only if the listing
has no bids (or no items have sold) and the listing does not end within 12 hours.

SeeLink: URL: GetCategoryFeatures.html#Response.FeatureDefinitions.ListingDurations
Title: GetCategoryFeatures
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=FeesPerSite
Title: Fees per Site


  Calls: AddItem
         VerifyAddItem
  RequiredInput: Yes

  Calls: GetItemRecommendations
         RelistItem
         ReviseItem
  RequiredInput: No

#    Argument: 'xs:token'

=cut

sub setListingDuration {
  my $self = shift;
  $self->{'ListingDuration'} = shift
}

=head2 getListingDuration()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetBidderList
         GetProducts
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ScheduledList

#    Returns: 'xs:token'

=cut

sub getListingDuration {
  my $self = shift;
  return $self->{'ListingDuration'};
}


=head2 setListingEnhancement()

Describes listing upgrades that sellers can select for a fee, such as the
BoldTitle upgrade. Also includes feature packs for saving on listing upgrades.
See <a href="http://pages.ebay.com/help/sell/ia/promoting_your_item.html">Listing Upgrades</a>
in the eBay Web site online help.
<br><br>
You cannot remove listing upgrades when you revise a listing. When you
relist an item, use DeletedField to remove a listing upgrades.
<br><br>
For AddLiveAuctionItem and ReviseLiveAuctionItem, you can specify a maximum of
10 featured lot items per live auction catalog.
Not applicable to Half.com.
This field is ignored when Item.ListingType=Express.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

  Calls: AddLiveAuctionItem
         ReviseLiveAuctionItem
  RequiredInput: No
  OnlyTheseValues: Border, BoldTitle, Featured, Highlight,
							HomePageFeatured

#    Argument: reference to an array  
                      of 'ns:ListingEnhancementsCodeType'

=cut

sub setListingEnhancement {
  my $self = shift;
  $self->{'ListingEnhancement'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getListingEnhancement()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetBidderList
         GetCategoryListings
         GetProducts
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: reference to an array  
                      of 'ns:ListingEnhancementsCodeType'

=cut

sub getListingEnhancement {
  my $self = shift;
  return $self->_getDataTypeArray('ListingEnhancement');
}


=head2 setListingSubtype2()

Indicates a specific type of lead generation format listing, such as classified
ad or local market best offer listing.
Only applicable when ListingType=LeadGeneration.
<span class="tablenote"><b>Note:</b>
ListingSubtype2 replaces the deprecated ListingSubtype field.
If both are specified in a request, ListingSubtype2 takes precedence.</span>

SeeLink: URL: http://pages.ebay.com/help/sell/motors-selling-locally.html
Title: About Local Market Listings
, URL: http://pages.ebay.com/help/sell/f-ad.html
Title: Advertising with Classified Ads


  Calls: AddItem
         RelistItem
         ReviseItem
  RequiredInput: No

#    Argument: 'ns:ListingSubtypeCodeType'

=cut

sub setListingSubtype2 {
  my $self = shift;
  $self->{'ListingSubtype2'} = shift
}

=head2 getListingSubtype2()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'ns:ListingSubtypeCodeType'

=cut

sub getListingSubtype2 {
  my $self = shift;
  return $self->{'ListingSubtype2'};
}


=head2 setListingType()

The format of the listing the seller wants to use, such as
Chinese auction or fixed price.<br>
<br>
Optional for eBay.com listings (defaults to Chinese) in AddItem and
VerifyAddItem. On the US, Germany, and UK sites, eligible items listed
in the fixed price, Store Inventory, or (for the US) in the
Chinese auction format with Buy It Now are also included on
eBay Express. Express Germany and UK also support an Express format
for listing only on Express.<br>
<br>
Do not specify ListingType for eBay.com listings in ReviseItem.
(You can't modify the listing type of an active eBay listing.<br>
<br>
Required for Half.com listings (and the value must be Half) in AddItem,
VerifyAddItem, and ReviseItem. If you don't specify Half when revising
Half.com listings, ReviseItem won't use the correct logic and you may
get strange errors (or unwanted side effects in the listing, even if no
errors are returned).

SeeLink: URL: http://pages.ebay.com/help/sell/ia/formats.html
Title: Different Ways of Selling
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ListingTypes
Title: Listing Types (Formats)
, URL: GetCategoryFeatures.html#Response.FeatureDefinitions.ListingDurations
Title: GetCategoryFeatures
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=FeesPerSite
Title: Fees per Site
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressListingCriteria
Title: Listing Criteria for eBay Express


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         VerifyAddItem
  RequiredInput: Conditionally
  AllValuesExcept: Unknown, Live, Auction, PersonalOffer, Shopping

  Calls: ReviseItem
  RequiredInput: Conditionally
  OnlyTheseValues: Half
  TheseAreas: half

#    Argument: 'ns:ListingTypeCodeType'

=cut

sub setListingType {
  my $self = shift;
  $self->{'ListingType'} = shift
}

=head2 getListingType()

  Calls: GetBidderList
  Returned: Always
  AllValuesExcept: Unknown, Auction, Half, PersonalOffer

  Calls: GetItem
  Returned: Always
  AllValuesExcept: Unknown, Auction, Half
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  AllValuesExcept: Unknown, Auction, Half, PersonalOffer, Shopping
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  AllValuesExcept: Unknown, Auction, Half, Shopping
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Always
  AllValuesExcept: Unknown, Auction, Half, Shopping
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  AllValuesExcept: Unknown, Auction, Half, PersonalOffer, Shopping
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetCategoryListings
         GetProducts
  Returned: Conditionally
  AllValuesExcept: Unknown, Auction, Half, PersonalOffer

  Calls: GetMyeBayBuying
  Returned: Conditionally
  AllValuesExcept: Unknown, Auction, Half
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  AllValuesExcept: Unknown, Auction, Half
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  AllValuesExcept: Unknown, Auction, Half
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

  Calls: GetSellerEvents
  Returned: Conditionally
  AllValuesExcept: Unknown, Auction, Half, Shopping
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ListingTypeCodeType'

=cut

sub getListingType {
  my $self = shift;
  return $self->{'ListingType'};
}


=head2 setLiveAuctionDetails()

Describes the live auction-specific details of a lot item.
Applicable to eBay Live Auctions only.

  Calls: AddLiveAuctionItem
         ReviseLiveAuctionItem
  RequiredInput: Yes

#    Argument: 'ns:LiveAuctionDetailsType'

=cut

sub setLiveAuctionDetails {
  my $self = shift;
  $self->{'LiveAuctionDetails'} = shift
}

=head2 getLiveAuctionDetails()

#    Returns: 'ns:LiveAuctionDetailsType'

=cut

sub getLiveAuctionDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LiveAuctionDetails'
		,'eBay::API::XML::DataType::LiveAuctionDetailsType');
}


=head2 setLocalListing()

Indicates, when true, that an item is available locally.

#    Argument: 'xs:boolean'

=cut

sub setLocalListing {
  my $self = shift;
  $self->{'LocalListing'} = shift
}

=head2 isLocalListing()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetCategoryListings
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isLocalListing {
  my $self = shift;
  return $self->{'LocalListing'};
}


=head2 setLocation()

Indicates the geographical location of the item (along with Country).
When you revise a listing, you can add or change this value only if the
listing has no bids (or no items have sold) and it does not end within
12 hours.
<br><br>
If you do not specify Location, you must specify Item.PostalCode. If you
specify a postal code, but do not specify a location, then the location is
given a default value derived from the postal code.
<br><br>
For the Classified Ad format for eBay Motors vehicles, the value
provided in the Location is used as item location only if the
SellerContactDetails.Street and the SellerContactDetails.Street2 are empty.
Else, the SellerContactDetails.Street and the SellerContactDetails.Street2
will be used for item location.
<br><br>
Also applicable as input to AddItem and related calls when you list items
to Half.com.

MaxLength: 45

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setLocation {
  my $self = shift;
  $self->{'Location'} = shift
}

=head2 getLocation()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetCategoryListings
         GetProducts
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getLocation {
  my $self = shift;
  return $self->{'Location'};
}


=head2 setLocationDefaulted()

True if eBay provided a central location as a result of the user
not specifying a location. This typically occurs when the seller
specifies PostalCode without Location.
Not applicable to Half.com.

#    Argument: 'xs:boolean'

=cut

sub setLocationDefaulted {
  my $self = shift;
  $self->{'LocationDefaulted'} = shift
}

=head2 isLocationDefaulted()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocationDefaulted {
  my $self = shift;
  return $self->{'LocationDefaulted'};
}


=head2 setLookupAttributeArray()

Use this as a shortcut for specifying the Condition attribute by name
instead of by ID. Only valid when using AddItem for items in Media categories
(Books, DVD and Movies, Music, and Video Game categories) on the eBay US site (site ID 0).
You can pass either AttributeSetArray or LookupAttributeArray, but you cannot pass
both in the same request. Typically used in combination with ExternalProductID.
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:LookupAttributeArrayType'

=cut

sub setLookupAttributeArray {
  my $self = shift;
  $self->{'LookupAttributeArray'} = shift
}

=head2 getLookupAttributeArray()

#    Returns: 'ns:LookupAttributeArrayType'

=cut

sub getLookupAttributeArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LookupAttributeArray'
		,'eBay::API::XML::DataType::LookupAttributeArrayType');
}


=head2 setLotSize()

A lot is a set of two or more similar items that must be purchased together in
a single transaction. A listing can have multiple lots (instead of multiple
items). When LotSize is specified, the listing price reflects the price of
each lot (not each item within the lot). In this case, Quantity indicates the
number of lots being listed, and LotSize indicates the number of items in each
lot. (If a listing has no lots, Quantity indicates the number of separate
items being listed.) Important: Lot items can be listed only in lot-enabled
categories. GetCategories returns LSD (lot size disabled) with a value of true
for categories that do not support lots.
Not applicable to Half.com.
This field is ignored when Item.ListingType=Express.

Max: 100000

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setLotSize {
  my $self = shift;
  $self->{'LotSize'} = shift
}

=head2 getLotSize()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getLotSize {
  my $self = shift;
  return $self->{'LotSize'};
}


=head2 setMechanicalCheckAccepted()

Indicates whether the seller allows the bidder to request mechanical
inspection services from RAC. For Car category listings on the UK site.

Default: false

#    Argument: 'xs:boolean'

=cut

sub setMechanicalCheckAccepted {
  my $self = shift;
  $self->{'MechanicalCheckAccepted'} = shift
}

=head2 isMechanicalCheckAccepted()

  Calls: GetItem
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isMechanicalCheckAccepted {
  my $self = shift;
  return $self->{'MechanicalCheckAccepted'};
}


=head2 setMotorsGermanySearchable()

Listing upgrade that features the item in eBay search results on
the mobile.de partner site. Applicable to eBay Germany.
If true in listing requests and responses,
the seller is purchasing or has purchased cross-promotional placement on
the mobile.de site.
See the eBay Web Services Guide for applicable categories,
revise and relist rules, and additional information on featuring
vehicles on the Mobile.de Site.
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setMotorsGermanySearchable {
  my $self = shift;
  $self->{'MotorsGermanySearchable'} = shift
}

=head2 isMotorsGermanySearchable()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetCategoryListings
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnDescription, none, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isMotorsGermanySearchable {
  my $self = shift;
  return $self->{'MotorsGermanySearchable'};
}


=head2 setNewLeadCount()

Specifies the number of new leads (unanswered emails) buyers have posted
about the item.

  Calls: GetMyeBaySelling
  RequiredInput: Conditionally

#    Argument: 'xs:int'

=cut

sub setNewLeadCount {
  my $self = shift;
  $self->{'NewLeadCount'} = shift
}

=head2 getNewLeadCount()

#    Returns: 'xs:int'

=cut

sub getNewLeadCount {
  my $self = shift;
  return $self->{'NewLeadCount'};
}


=head2 setNowAndNew()

If true in listing requests and responses, the item is listed with
Now and New. Only applicable to Buy It Now, fixed-price, and
Store Inventory listings on certain eBay sites.
See the eBay Web Services guide for details.
In requests that list items, only valid if the seller also specifies
the item condition (as new), predefined return policy attributes,
a buy it now or fixed price, and shipping costs.
To remove Now and New from a listing, set the value to false.
If the listing has bids (or items have been sold) or the listing
ends within 12 hours, you cannot add or remove NowAndNew
when you revise the listing.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MiscellaneousItemFieldDifferences
Title: Miscellaneous Item Field Differences

  Calls: AddItem
         GetItemRecommendations
         ReviseItem
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setNowAndNew {
  my $self = shift;
  $self->{'NowAndNew'} = shift
}

=head2 isNowAndNew()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isNowAndNew {
  my $self = shift;
  return $self->{'NowAndNew'};
}


=head2 setPartnerCode()

Not currently operational.

#    Argument: 'xs:string'

=cut

sub setPartnerCode {
  my $self = shift;
  $self->{'PartnerCode'} = shift
}

=head2 getPartnerCode()

#    Returns: 'xs:string'

=cut

sub getPartnerCode {
  my $self = shift;
  return $self->{'PartnerCode'};
}


=head2 setPartnerName()

Not currently operational.

#    Argument: 'xs:string'

=cut

sub setPartnerName {
  my $self = shift;
  $self->{'PartnerName'} = shift
}

=head2 getPartnerName()

#    Returns: 'xs:string'

=cut

sub getPartnerName {
  my $self = shift;
  return $self->{'PartnerName'};
}


=head2 setPayPalEmailAddress()

Valid PayPal email address for the PayPal account that the seller will use if
they offer PayPal as a payment method for the listing. eBay uses this to
identify the correct PayPal account when the buyer pays via PayPal during the
checkout process. (As a seller can have more than one PayPal account, you
cannot necessarily rely on PayPal account data returned from GetUser for
details about the account associated with the PayPal email address that the
seller specifies.)<br>
<br>
Required if seller has chosen PayPal as a payment method (PaymentMethods) for
the listing.<br>
<br>
For a listing to be eligible for Express US, the seller needs to use an email
address that is in good standing and that is associated with a PayPal Premier
or PayPal business account that is set to ship to unconfirmed addresses. For
Express Germany, PayPalEmailAddress must be specified for Express format
listings, but it is optional for other formats (as
long as an eligible default PayPal account is specified in the seller's
Express preferences). If the specified PayPal account becomes ineligible for
eBay Express payments (because the seller blocked unconfirmed addresses or
some other change occurred), the items associated with that account may become
ineligible for Express and may no longer appear on Express.
<p></p>
<span class="tablenote"><b>Note:</b>
At the end of April 2008, UK and Germany eBay Express will be shutdown. No
users will be eligible to list on these sites. All users previously registered
on UK and Germany Express will have their registered status revoked. Any
Express only items listed on these sites will be ended and credited the full
insertion fee to their sellers. Please refer to the respective Express sites
for more information.
</span>
<p></p>
See eBay Express information in the eBay Web Services Guide for more
information.<br>
<br>
For digital listings, the seller needs to use an email address that is
associated with a PayPal Premier or PayPal business account. <br>
<br>
<b>For ReviseItem and RelistItem only:</b>
To remove this value when you revise or relist an item, use DeletedField. When
you revise a listing, if the listing has bids (or items have been sold) or it
ends within 12 hours, you can add PayPalEmailAddress, but you cannot remove
it.<br>
<br>
Not applicable to eBay Motors listings. Also not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ListingAnItem
Title: Listing an Item
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressPaymentMethods
Title: Accept PayPal as a Payment Method for Express and eBay
, URL: SetUserPreferences.html#Request.SellerPaymentPreferences
Title: (SetUserPreferences) SellerPaymentPreferences
, URL: SetUserPreferences.html#Request.ExpressPreferences.DefaultPayPalAccount
Title: (SetUserPreferences) ExpressPreferences.DefaultPayPalAccount


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setPayPalEmailAddress {
  my $self = shift;
  $self->{'PayPalEmailAddress'} = shift
}

=head2 getPayPalEmailAddress()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getPayPalEmailAddress {
  my $self = shift;
  return $self->{'PayPalEmailAddress'};
}


=head2 setPaymentDetails()

Contains data associated with eBay Motors payments (Durations for deposit and
full payments). Returned for Motors listings. Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MotorsPayment
Title: Payment Methods for Motors

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:PaymentDetailsType'

=cut

sub setPaymentDetails {
  my $self = shift;
  $self->{'PaymentDetails'} = shift
}

=head2 getPaymentDetails()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:PaymentDetailsType'

=cut

sub getPaymentDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaymentDetails'
		,'eBay::API::XML::DataType::PaymentDetailsType');
}


=head2 setPaymentMethods()

Identifies the payment method (such as credit card or PayPal) the seller will
accept for the buyer to pay for the purchase of the item. <br><br>
If you specify multiple PaymentMethods fields, the repeating fields must be
contiguous. For example, you can specify PayPalEmailAddress after a list of
repeating PaymentMethods fields, but not between them:<br>
<br>
&lt;PaymentMethods&gt;AmEx&lt;/PaymentMethods&gt;<br>
&lt;PaymentMethods&gt;PersonalCheck&lt;/PaymentMethods&gt;<br>
&lt;PaymentMethods&gt;PayPal&lt;/PaymentMethods&gt;<br>
&lt;PayPalEmailAddress&gt;mypaypalemail@ebay.com&lt;/PayPalEmailAddress&gt;<br><br>
In general, if you separate repeating instances of a field, the results will
be unpredictable. This rule applies to all repeating fields
(maxOccurs="unbounded" or greater than 1) in the schema. See "Overview of the
Schema" in the eBay Web Services guide.<br>
<br>
<span class="tablenote"><b>Note:</b>
Required or allowed payment methods vary by site and category. Refer to
<a href="http://developer.ebay.com/DevZone/XML/docs/WebHelp/wwhelp/wwhimpl/js/html/wwhelp.htm?context=eBay_XML_API&topic=PaymentMethodDifferences">
Payment Method Differences (PaymentMethod)</a> in the eBay Trading
API Guide for information to help you determine which payment methods you
are required or allowed to specify.
</span><br>
<br>
For a listing to be eligible for Express US, PayPal is a required payment
method. For Express Germany, Express format listings
(Item.ListingType=Express) must include PayPal, but
fixed-price and Store Inventory listings do not require PayPal
as long as a default PayPal account is specified in the seller's Express preferences. See
eBay Express information in the eBay Web Services Guide.
<br>
<br>
Payment methods are not applicable to eBay Real Estate ad format listings,
Classified Ad format listings, or Half.com.
<p></p>
<span class="tablenote"><b>Note:</b>
At the end of April 2008, UK and Germany eBay Express will be shutdown. No
users will be eligible to list on these sites. All users previously registered
on UK and Germany Express will have their registered status revoked. Any
Express only items listed on these sites will be ended and credited the full
insertion fee to their sellers. Please refer to the respective Express sites
for more information.
</span>
<br>
<br>
<b>For ReviseItem and RelistItem only:</b>
A listing must have at least one valid payment method.
When you revise or relist an item and you specify a payment method
that is invalid for the target site, eBay ignores the
invalid payment method, applies the other valid
changes, and returns a warning to indicate that the
invalid payment method was ignored. If multiple payment methods were
invalid, the warning indicates that they were all ignored.
If you modify the listing so that it includes no valid
payment methods, an error is returned. This situation could occur when
the seller removes all valid payment methods or when all
the payment methods specified for the item are no longer valid
on the target site.<br>
<br><b>For GetProducts only:</b> Only PayPal is
returned in product search results.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=PaymentMethodDifferences
Title: Payment Method Differences (PaymentMethod)
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ListingAnItem
Title: Listing an Item
, URL: SetUserPreferences.html#Request.SellerPaymentPreferences
Title: (SetUserPreferences) SellerPaymentPreferences
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressPaymentMethods
Title: Accept PayPal as a Payment Method for Express and eBay
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SchemaOverview
For: rules regarding repeating nodes
Title: Overview of the API Schema


  Calls: AddItem
         VerifyAddItem
  RequiredInput: Conditionally

  Calls: GetItemRecommendations
         RelistItem
         ReviseItem
  RequiredInput: Conditionally

#    Argument: reference to an array  
                      of 'ns:BuyerPaymentMethodCodeType'

=cut

sub setPaymentMethods {
  my $self = shift;
  $self->{'PaymentMethods'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getPaymentMethods()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetProducts
  Returned: Conditionally
  OnlyTheseValues: PayPal

#    Returns: reference to an array  
                      of 'ns:BuyerPaymentMethodCodeType'

=cut

sub getPaymentMethods {
  my $self = shift;
  return $self->_getDataTypeArray('PaymentMethods');
}


=head2 setPictureDetails()

Contains the data for a picture associated with an item. <br>
<br>
For a listing to be eligible for eBay Express, it must include a picture,
gallery, or stock photo URL. Some categories are exempt from this requirement.
See the eBay Web Services Guide links below for details.<br>
<br>
Not applicable to Half.com.<br>
<br>
<span class="tablenote"><b>Note:</b>
PictureDetails replaces the deprecated SiteHostedPicture
and VendorHostedPicture in the response with request version 439
or greater. As SiteHostedPicture and VendorHostedPicture are also
no longer recommended on input, applications should use
PictureDetails in the input as well. If SiteHostedPicture or
VendorHostedPicture are passed in with PictureDetails, PictureDetails takes
precedence.</span>

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=Pictures
Title: Introduction to Pictures in Item Listings
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressPictureRequired
Title: Specify a Picture for Express and eBay


  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:PictureDetailsType'

=cut

sub setPictureDetails {
  my $self = shift;
  $self->{'PictureDetails'} = shift
}

=head2 getPictureDetails()

  Calls: GetBidderList
         GetCategoryListings
         GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           SecondChanceOffer
           WatchList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList
           BidList

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:PictureDetailsType'

=cut

sub getPictureDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PictureDetails'
		,'eBay::API::XML::DataType::PictureDetailsType');
}


=head2 setPostalCode()

Postal code of the place where the item is located. This value is used for
proximity searches. To remove this value when revising or relisting an item,
use DeletedField. If you do not specify PostalCode, you must specify
Item.Location. If you specify PostalCode, but do not specify Item.Location,
then Item.Location is given a default value derived from the postal code.
Not applicable to Half.com.

  Calls: AddItem
         GetItemRecommendations
         ReviseItem
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setPostalCode {
  my $self = shift;
  $self->{'PostalCode'} = shift
}

=head2 getPostalCode()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetBidderList
         GetProducts
  Returned: Conditionally

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getPostalCode {
  my $self = shift;
  return $self->{'PostalCode'};
}


=head2 setPrimaryCategory()

Category ID for the first (or only) category in which the item is
listed (or will be listed, if the item is new). A number of listing
features have dependencies on the primary category. We have pointed
out a few of the notable dependencies below. See the descriptions of
the fields you are using to determine whether the feature
you're supporting depends on the listing's primary category.
<br>
<br>
<b>For the AddItem family of calls:</b>
Use calls like GetCategories and GetCategoryFeatures to determine
valid values for the site on which you are listing (see the
eBay Web Services Guide for information on
working with categories). Also see Item.CategoryMappingAllowed and
Item.CategoryBasedAttributesPrefill.<br>
<br>
Most eBay.com categories are also eligible for eBay Express.
Categories not covered by PayPal Buyer Protection are excluded.
Also, certain categories that do not support item condition may be
excluded (use GetCategoryFeatures to determine eligible categories).
See "eBay Express" in the eBay Web Services Guide.<br>
<br>
There are a number of categories on some eBay sites that always add
the Gallery feature (for free) when you include a picture in
the listing and you don't specify the Gallery feature yourself.
See GalleryType for information about fees that could be charged
if you change the category in these cases.
<br>
<br>
Not applicable to Half.com.<br>
<br>
<b>For ReviseItem only:</b> When revising a listing,
you can change the primary category only if an item
has no bids (or no items have sold) and the listing does not end
within 12 hours. <br>
<br>If you change the listing category, any
Item Specifics (attributes) that were previously specified may be
dropped from the listing if they aren't
valid for the new category. See Item.AttributeSetArray.
For the eBay US site, we suggest that you avoid including a category ID
when you use ExternalProductID. See the KB article listed below
for details.<br>
<br>
You cannot change the meta-categories for vehicles
(i.e., you cannot change a truck to a motorcycle), but you can change
the leaf category (e.g., change one
motorcycle subcategory to another motorcycle subcategory).
See the eBay Web Services Guide for additional rules.
International sites (such as the eBay Germany site)
have similar rules for revising vehicle categories. <br>
<br>
<b>For AddLiveAuctionItem only:</b>
For eBay Live Auctions (e.g., in AddLiveAuctionItem), this is the
eBay Live Auctions site category in which to list the item.
This can be different from the category that is associated with the
seller's catalog. See Specifying eBay Live Auctions Categories in the
eBay Web Services guide.<br>
<br>
<b>For GetItemRecommendations only:</b>
For GetItemRecommendations, use this to control the category that
will be searched for recommendations. Specify the category in which
the item will be listed. See the eBay Web Services guide for
differences in validation rules depending on whether you are using
the Listing Analyzer engine, Product
Pricing engine, or Suggested Attributes engine.<br>
<br>
<b>For GetProducts:</b> Use GetCategories if you need to
determine the name of the category.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CategoryOverview
Title: Categories
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressListingCriteria
Title: Listing Criteria for eBay Express
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=LiveAuctionCategories
Title: Specifying eBay Live Auctions Categories
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MotorsListing
Title: Listing US and CA eBay Motors Items
, URL: RelistItem.html#Request.Item.PictureDetails.GalleryType
Title: (RelistItem) GalleryType
, URL: https://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=581
Title: KB Article: Listing with ExternalProductID and CategoryID


  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         VerifyAddItem
  RequiredInput: Yes

  Calls: GetItemRecommendations
  RequiredInput: Conditionally

  Calls: RelistItem
         ReviseItem
         ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: 'ns:CategoryType'

=cut

sub setPrimaryCategory {
  my $self = shift;
  $self->{'PrimaryCategory'} = shift
}

=head2 getPrimaryCategory()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetProducts
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories

#    Returns: 'ns:CategoryType'

=cut

sub getPrimaryCategory {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PrimaryCategory'
		,'eBay::API::XML::DataType::CategoryType');
}


=head2 setPrivateListing()

If true, designates the listing as private. When you create a private
listing, a buyer's User ID will not appear in the listing or in the
listing's bid history. Sellers may want to use this option when they believe
that potential bidders for a listing would not want their User IDs disclosed
to others. Not applicable to Half.com.

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setPrivateListing {
  my $self = shift;
  $self->{'PrivateListing'} = shift
}

=head2 isPrivateListing()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPrivateListing {
  my $self = shift;
  return $self->{'PrivateListing'};
}


=head2 setPrivateNotes()

A note a user makes on an item in their My eBay account.
The note is prefaced with the words My Note.
For eBay.com, only GetMyeBayBuying and GetMyeBaySelling (not GetItem)
return this field, and only if you pass IncludeNotes in the request.
Only visible to the user who created the note.<br>
<br>
Not supported as input in ReviseItem. Use SetUserNotes
instead<br>
<br>
Not applicable to Half.com (instead, use
Item.AttributeArray.Attribute.Value.ValueLiteral for Half.com notes.)

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setPrivateNotes {
  my $self = shift;
  $self->{'PrivateNotes'} = shift
}

=head2 getPrivateNotes()

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetMyeBayBuying
  Returned: Conditionally

  Calls: GetMyeBaySelling
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getPrivateNotes {
  my $self = shift;
  return $self->{'PrivateNotes'};
}


=head2 setProductListingDetails()

Specifies stock product information to include in a listing. Only applicable
when listing items with Pre-filled Item Information. If the item's primary and
secondary category are both catalog-enabled, the product listing details must
be applicable to the primary category. If only one category is catalog-
enabled, the product listing details must be applicable to the catalog-enabled
category. Either Item.ExternalProductID or Item.ProductListingDetails can be
specified in an AddItem request, but not both. See the eBay Web Services Guide
for information on listing with Pre-filled Item Information.<br>
<br>
<b>For ReviseItem and RelistItem only:</b> If a
listing includes Pre-filled Item Information and you
change a category, the rules for continuing to include Pre-filled Item
Information depend on whether or not the new category is mapped to a
characteristic set associated with the same product ID. When you revise a
listing, if it has bids or it ends within 12 hours, you cannot change the
product ID and you cannot remove existing product data. However, you can
change or add preferences such as IncludeStockPhotoURL,
UseStockPhotoURLAsGallery, and IncludePrefilledItemInformation. To delete all
catalog data when you revise or relist an item, specify
Item.ProductListingDetails in DeletedField and don't pass
ProductListingDetails in the request.<br>
<br>
<b>For GetItemRecommendations only:</b> For
GetItemRecommendations, see the eBay Web Services guide for
validation rule differences when using the Product Pricing engine.<br><br>
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrProductAPI
Title: The Catalog Product (Pre-filled Item) API
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=EngineProductPricing
Title: Getting eBay Pricing Data for Listings with Pre-filled Item Information


  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

  Calls: GetItemRecommendations
  RequiredInput: Conditionally

#    Argument: 'ns:ProductListingDetailsType'

=cut

sub setProductListingDetails {
  my $self = shift;
  $self->{'ProductListingDetails'} = shift
}

=head2 getProductListingDetails()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: 'ns:ProductListingDetailsType'

=cut

sub getProductListingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ProductListingDetails'
		,'eBay::API::XML::DataType::ProductListingDetailsType');
}


=head2 setProxyItem()

Some listings on the eBay platform originate from eBay affiliates.
Depending on the relationship the affiliate has with eBay, there are times
when the affiliate retains ownership of the listing. When this occurs
the representation of the listing on eBay is considered a proxy item.  Proxy
items can only be edited using API requests from the applications that
originally listed them.

#    Argument: 'xs:boolean'

=cut

sub setProxyItem {
  my $self = shift;
  $self->{'ProxyItem'} = shift
}

=head2 isProxyItem()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


#    Returns: 'xs:boolean'

=cut

sub isProxyItem {
  my $self = shift;
  return $self->{'ProxyItem'};
}


=head2 setQuantity()

For AddItem and related calls, this is the number of items in the listing. For
new listings being defined, this is the initial number of items the seller
offers for sale. Even during a Dutch auction, where one of several items can
be purchased during the auction, this number does not change. Sellers need to
meet certain feedback requirements to specify a quantity greater than 1.
<br><br>
When you revise a listing, you can add or change this value only if the
listing has no bids (or no items have sold) and it does not end within 12
hours. For auction items, a change in the auction's quantity could result in a
change in the auction type. For example, if the quantity is changed from 1 (a
Chinese auction) to 2, the auction is now a Dutch auction. This may impose new
requirements and fees on the seller. <br><br> For GetSellerEvents
calls, Quantity is returned only for listings where item quantity is greater
than 1.
<br><br>
For SetCart input, this is only required if the parent container is submitted.
<br><br>
Also applicable to Half.com (valid range 1 to 1000).
You can revise this field for Half.com listings.

  Calls: AddItem
         RelistItem
         VerifyAddItem
  RequiredInput: Yes

  Calls: GetItemRecommendations
         ReviseItem
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setQuantity {
  my $self = shift;
  $self->{'Quantity'} = shift
}

=head2 getQuantity()

  Calls: GetBidderList
         GetDispute
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getQuantity {
  my $self = shift;
  return $self->{'Quantity'};
}


=head2 setQuantityAvailable()

Specifies how many of a certain item are available.
Not applicable to Half.com.<br>
<br>
For GetSearchResultsExpress, only returned when ItemDetails is set to Fine.<br>

#    Argument: 'xs:int'

=cut

sub setQuantityAvailable {
  my $self = shift;
  $self->{'QuantityAvailable'} = shift
}

=head2 getQuantityAvailable()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           WatchList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList
           BidList

#    Returns: 'xs:int'

=cut

sub getQuantityAvailable {
  my $self = shift;
  return $self->{'QuantityAvailable'};
}


=head2 setQuestionCount()

Specifies the number of questions buyers have posted about the item.
Returned only if greater than 0.
Not applicable to Half.com.

#    Argument: 'xs:long'

=cut

sub setQuestionCount {
  my $self = shift;
  $self->{'QuestionCount'} = shift
}

=head2 getQuestionCount()

  Calls: GetMyeBaySelling
  Returned: Conditionally

#    Returns: 'xs:long'

=cut

sub getQuestionCount {
  my $self = shift;
  return $self->{'QuestionCount'};
}


=head2 setRegionID()

No longer used by any site.

Ignore: 
#    Argument: 'xs:string'

=cut

sub setRegionID {
  my $self = shift;
  $self->{'RegionID'} = shift
}

=head2 getRegionID()

#    Returns: 'xs:string'

=cut

sub getRegionID {
  my $self = shift;
  return $self->{'RegionID'};
}


=head2 setRelistLink()

Applicable only to re-listing an item. If true, creates a link in the item's
old listing for the item that points to the new relist page, which
accommodates users who might still look for the item under its old item ID.
Not applicable to Half.com.

  Calls: RelistItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setRelistLink {
  my $self = shift;
  $self->{'RelistLink'} = shift
}

=head2 isRelistLink()

#    Returns: 'xs:boolean'

=cut

sub isRelistLink {
  my $self = shift;
  return $self->{'RelistLink'};
}


=head2 setRelisted()

Whether or not the item is a relisted item. This value is
determined by eBay and cannot be set. Only returned if the
item was relisted.
<br /><br />
Note that when an item is relisted and is given a new
ItemID, the original item shows Relisted = true, but the new
item does NOT show Relisted = true. In this context, the new
item is a new listing, not a "Relisted" one.

#    Argument: 'xs:boolean'

=cut

sub setRelisted {
  my $self = shift;
  $self->{'Relisted'} = shift
}

=head2 isRelisted()

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Context: UnsoldList

#    Returns: 'xs:boolean'

=cut

sub isRelisted {
  my $self = shift;
  return $self->{'Relisted'};
}


=head2 setReservePrice()

The lowest price at which the seller is willing to sell the item. (StartPrice
must be lower than ReservePrice.) Not all categories support reserve prices.
See GetCategories and "Determining Whether a Category Supports Reserve Prices"
in the eBay Web Services guide. In calls that retrieve item data, ReservePrice
only has a non-zero value for listings with a reserve price and where the user
requesting the item data is also the item's seller. Not applicable to fixed-
price items or ad format listings.<br>
<br>
You can remove the reserve price of a US eBay Motors listing if the category
allows it, the current reserve price has not been met, and the reserve price
is at least $2.00 more than the current high bid. In this case, if the item
has bids, the reserve price is set to $1.00 over the current high bid. The
next bid meets the reserve and wins.
See the Fees Overview on the eBay Web site for information about fee credits
that may be available when the reserve price
is removed for a Motors listing. See the eBay Web Services guide for
validation rules when revising US Motors listings.<br><br>
For AddLiveAuctionItem and ReviseLiveAuctionItem, the seller needs to make
sure they specify the amount in the currency selected for the live auction
event. When you revise a Live Auction item, you can lower an existing reserve
price, but you cannot add a reserve price or remove an existing reserve price
if the item has absentee bids or ends in less than 12
hours.<br><br>
Not applicable to Half.com.
This field is ignored when Item.ListingType=Express.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ReviseMotors
Title: Revising US eBay Motors Listings
, URL: http://pages.ebay.com/help/sell/reserve.html
Title: Reserve Price (eBay Web site help)
, URL: http://pages.ebay.com/help/sell/fees.html
Title: Fees Overview (eBay Web site help)

MaxLength: 16

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setReservePrice {
  my $self = shift;
  $self->{'ReservePrice'} = shift
}

=head2 getReservePrice()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

#    Returns: 'ns:AmountType'

=cut

sub getReservePrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ReservePrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setReviseStatus()

Indicates whether an item has been revised since the listing became
active and, if so, which among a subset of properties have been changed
by the revision.
Output only.
Not applicable to Half.com.

#    Argument: 'ns:ReviseStatusType'

=cut

sub setReviseStatus {
  my $self = shift;
  $self->{'ReviseStatus'} = shift
}

=head2 getReviseStatus()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:ReviseStatusType'

=cut

sub getReviseStatus {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ReviseStatus'
		,'eBay::API::XML::DataType::ReviseStatusType');
}


=head2 setSKU()

This element is a SKU (stock-keeping unit) defined by a seller. The seller can
use a SKU to identify one item or use the same SKU for multiple items.
Preferable to ApplicationData for SKUs and inventory tracking. Different
sellers can use the same SKUs. This element can be used by sellers to track
complex flows of products and information. This element preserves a SKU,
enabling a seller to obtain it before and after a transaction is created. To
remove a SKU when you revise or relist an item, use DeletedField. Not
applicable to Half.com.
For GetMyeBaySelling, this is only returned if set.

MaxLength: 50

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:SKUType'

=cut

sub setSKU {
  my $self = shift;
  $self->{'SKU'} = shift
}

=head2 getSKU()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBaySelling
  Returned: Conditionally

#    Returns: 'ns:SKUType'

=cut

sub getSKU {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SKU'
		,'eBay::API::XML::DataType::SKUType');
}


=head2 setScheduleTime()

Allows a user to schedule a listing to start at the specified time
in the future. Specify the time (in GMT) that the item's listing
is scheduled to be active on eBay. In GetItem and related calls,
the scheduled time is returned in StartTime.
For ReviseItem, you can modify this value if the
current schedule time is in the future.
Not applicable to Half.com.
Also see the following article in the Knowledge Base:
<a href="http://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=1137">Why
scheduled time is sometimes getting reset</a>.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:dateTime'

=cut

sub setScheduleTime {
  my $self = shift;
  $self->{'ScheduleTime'} = shift
}

=head2 getScheduleTime()

#    Returns: 'xs:dateTime'

=cut

sub getScheduleTime {
  my $self = shift;
  return $self->{'ScheduleTime'};
}


=head2 setSearchDetails()

Container for values that indicate whether a listing uses the Buy It Now feature,
whether a listing is no more than one day old, and whether a listing has an image
associated with it. Not applicable to Half.com.

#    Argument: 'ns:SearchDetailsType'

=cut

sub setSearchDetails {
  my $self = shift;
  $self->{'SearchDetails'} = shift
}

=head2 getSearchDetails()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'ns:SearchDetailsType'

=cut

sub getSearchDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SearchDetails'
		,'eBay::API::XML::DataType::SearchDetailsType');
}


=head2 setSecondaryCategory()

ID for second category in which the item is listed (also see
Item.PrimaryCategory). <br>
<br>
<b>For the AddItem family of calls:</b> Listing an item in
a second category is optional. Also see Item.CategoryMappingAllowed
and Item.CategoryBasedAttributesPrefill. <br>
<br>
Most eBay.com categories are also eligible for eBay Express.
Categories not covered by PayPal Buyer Protection are excluded. Also,
certain categories that do not support item condition may be excluded.<br>
<br>
Not applicable to Half.com. <br>
<br>
You cannot list US eBay Motors vehicles in two categories.
However, you can list Parts & Accessories in two categories.
The Final Value Fee is based on the primary
category in which the item is listed.
Furthermore, you can list the same item in an eBay Motors
Parts & Accessories category
and in an eligible eBay category, as long as the primary category is
associated with the site on which you are listing.
That is, the two categories can be a mix of Motors
Parts & Accessories and eBay site categories.
(Real Estate, Mature Audience (adult), and Business & Industrial
categories are not eligible for listing in two categories
in this manner.) For example, if
you list on Motors, the primary category could be 6750
(eBay Motors > Parts & Accessories >
Apparel & Merchandise > Motorcycle > Jackets
& Leathers), and the secondary category could be 57988 (eBay >
Clothing, Shoes > Accessories > Men's Clothing > Outerwear).
If you list on the main eBay site, the primary category could be
57988 and the secondary category could be 6750. <br>
<br>
To remove this value when relisting an item, use DeletedField.
<br><br>
<b>For ReviseItem only:</b> When revising a listing, you
can add, remove, or change the secondary category
only if the listing has no bids (or no items have sold) and it does
not end within 12 hours. If you change the secondary category,
any corresponding Item Specifics (attributes) that were previously
specified may be dropped from the listing if they aren't valid for
the category. See Item.AttributeSetArray.<br>
<br>
When you revise an item, you can change the
secondary category from a Motors Parts & Accessories category
to an eBay category or vice versa if the listing has no bids
(or no items have sold) and it does not end within 12 hours. <br>
<br>
<b>For AddLiveAuctionItem only:</b> For eBay Live Auctions
(e.g., AddLiveAuctionItem), this is the eBay US site
category in which to list the item. (This can be any eBay US category
except Motors or Real Estate categories.) Note that eBay Live Auctions
does not charge a fee to specify an eBay category
(i.e., no List in Two Category fees).
See Specifying eBay Live Auctions Categories in the
eBay Web Services guide.
In AddLiveAuctionItem, you need to specify SecondaryCategory if you are
including Item Specifics (AttributeSetArray). <br>
<br>
<b>For ReviseLiveAuctionItem only:</b>
For eBay Live Auctions, you can add SecondaryCategory when you revise
the lot item, but you cannot change or remove an existing
secondary category if the item has absentee bids or it ends
in less than 12 hours.<br>
<br>
<b>For GetItemRecommendations only:</b>
For GetItemRecommendations, use this to control the category that
will be searched for recommendations. Specify the category in which the
item will be listed. See the eBay Web Services guide for differences in
validation rules depending on whether you are using the
Listing Analyzer engine, Product Pricing engine, or
Suggested Attributes engine.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CategoryOverview
Title: Categories
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressListingCriteria
Title: Listing Criteria for eBay Express
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=LiveAuctionCategories
Title: Specifying eBay Live Auctions Categories

MaxLength: 10

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:CategoryType'

=cut

sub setSecondaryCategory {
  my $self = shift;
  $self->{'SecondaryCategory'} = shift
}

=head2 getSecondaryCategory()

  Calls: GetBidderList
         GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'ns:CategoryType'

=cut

sub getSecondaryCategory {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SecondaryCategory'
		,'eBay::API::XML::DataType::CategoryType');
}


=head2 setSeller()

Container for information about this listing's seller.
Not applicable to Half.com.
<br><br>
In GetSearchResultsExpress, only returned when ItemDetails is set to Fine.
<br><br>
Returned by GetCart/SetCart only if there are items in the cart.
<br><br>
Returned by GetItemsAwaitingFeedback if Buyer is making the request.

  Calls: AddItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:UserType'

=cut

sub setSeller {
  my $self = shift;
  $self->{'Seller'} = shift
}

=head2 getSeller()

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetItemsAwaitingFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetCategoryListings
         GetProducts
  Returned: Conditionally

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

  Calls: GetBidderList
  Returned: Always

#    Returns: 'ns:UserType'

=cut

sub getSeller {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Seller'
		,'eBay::API::XML::DataType::UserType');
}


=head2 setSellerContactDetails()

Contact information for sellers using the Classified Ad format for eBay
Motors vehicles categories.
To remove seller contact information when revising or relisting an item, use
DeletedField. The seller contact details for the primary and secondary
phone numbers cannot be deleted individually.<br>
To provide City, State, and Zip code information in SellerContactDetails use the following field:<br>
Item.SellerContactDetails.Street2<br>
To delete the secondary phone
number, for example, you must delete all of the secondary phone
fields:<br>
Item.SellerContactDetails.Phone2AreaOrCityCode<br>
Item.SellerContactDetails.Phone2CountryCode<br>
Item.SellerContactDetails.Phone2CountryPrefix<br>
Item.SellerContactDetails.Phone2LocalNumber<br>

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ClassifiedAdListings
Title: Classified Ad Listings

  Calls: AddItem
         ReviseItem
         VerifyAddItem
         RelistItem
  RequiredInput: No

#    Argument: 'ns:AddressType'

=cut

sub setSellerContactDetails {
  my $self = shift;
  $self->{'SellerContactDetails'} = shift
}

=head2 getSellerContactDetails()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'ns:AddressType'

=cut

sub getSellerContactDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerContactDetails'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setSellerInventoryID()

Unique identifier for a Half.com item. Must be an alphanumeric value (with no
symbols) that is unique across the seller's active (unsold) inventory on
Half.com. For Half.com, you can specify either ItemID or SellerInventoryID in
a ReviseItem request to uniquely identify the listing. Only returned from
GetOrders if the seller specified a value when the item was listed. You cannot
revise this field. Not applicable to eBay.com listings.

MaxLength: 100

  Calls: AddItem
         GetItemRecommendations
         VerifyAddItem
         ReviseItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setSellerInventoryID {
  my $self = shift;
  $self->{'SellerInventoryID'} = shift
}

=head2 getSellerInventoryID()

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

#    Returns: 'xs:string'

=cut

sub getSellerInventoryID {
  my $self = shift;
  return $self->{'SellerInventoryID'};
}


=head2 setSellerVacationNote()

The seller is on vacation (as determined by the seller's store preferences) in
two cases: i.) the item is a Store Inventory item and the seller has chosen to
hide Store Inventory items while on vacation, and ii.) the seller has chosen
to add a message to listed items while on vacation.
Not applicable to Half.com.

#    Argument: 'xs:string'

=cut

sub setSellerVacationNote {
  my $self = shift;
  $self->{'SellerVacationNote'} = shift
}

=head2 getSellerVacationNote()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getSellerVacationNote {
  my $self = shift;
  return $self->{'SellerVacationNote'};
}


=head2 setSellingStatus()

Various details about the current status of the listing, such as the current
number of bids and the current high bidder. Not applicable to
Half.com.
<br><br>
For GetSearchResultsExpress, this is always returned when ItemArray.Item is returned.
<br><br>
Returned by GetCart/SetCart only if there are items in the cart.

#    Argument: 'ns:SellingStatusType'

=cut

sub setSellingStatus {
  my $self = shift;
  $self->{'SellingStatus'} = shift
}

=head2 getSellingStatus()

  Calls: GetBidderList
         GetDispute
  Returned: Always

  Calls: GetSellerEvents
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetCategoryListings
         GetMemberMessages
         GetProducts
  Returned: Conditionally

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           BidList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:SellingStatusType'

=cut

sub getSellingStatus {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellingStatus'
		,'eBay::API::XML::DataType::SellingStatusType');
}


=head2 setShipToLocations()

An international location or region to which the seller is willing to ship,
regardless of shipping service. The country of the listing site is added by
eBay. Use GeteBayDetails with a DetailName of ShippingLocationDetails to
determine which international locations are valid for the site. Omit
ShipToLocations if you want to ship only within the country of the listing
site. To state that you do not wish to ship at all, set ShipToLocations to
None. ReviseItem can add a ShipToLocations. On output, ShipToLocations is
the collection of all input item-level ShipToLocations plus international shipping
service-level ShipToLocation values.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShipToLocation
Title: ShipToLocation
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=GeteBayDetails
Title: GeteBayDetails

MaxLength: length of longest name in ShippingRegionCodeType and CountryCodeType

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setShipToLocations {
  my $self = shift;
  $self->{'ShipToLocations'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getShipToLocations()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getShipToLocations {
  my $self = shift;
  return $self->_getDataTypeArray('ShipToLocations');
}


=head2 setShippingDetails()

The shipping-related details for an item or transaction, including flat and
calculated shipping costs and shipping insurance costs.<br>
<br>
New users who list their first items in selected categories on the US site
must specify at least one domestic shipping service. This applies to a
category if GetCategoryFeatures returns true for Category.ShippingTermsRequired.
<br>
<br>
For multi-quantity Store Inventory Format listings and for multi-quantity
Fixed Price listings, a seller can revise all shipping details of the listing
(except for sales tax and for shipping type of Freight) for all unsold items.
This applies to both domestic and international shipping. Checkout is not
affected for those who bought items prior to the seller's shipping
changes--the shipping details that were in effect at the time of purchase are used for
that buyer at the time of checkout.
<br>
<br>
For a listing to be eligible for eBay Express, shipping details are
required (to support the eBay Express shopping cart).
For flat shipping, this means the shipping service and cost
are required. For calculated shipping, it means all of the
usual parameters (weight, originating postal code, etc.) are required.
See the the eBay Web Services Guide links below for more information.
In GetSearchResultsExpress, always returned when
ItemArray.Item is returned.<br>
<br>
This container is returned by GetCart or SetCart only when a valid postal code
is provided for the country (see SetCart.ShippingAddress) and there is
at least one item in the shopping cart for which calculated shipping is offered.<br>
<br>
Shipping details are not applicable to Real Estate listings and Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingGettingCosts
Title: Determining Shipping Costs for a Listing
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressShippingCosts
Title: Specify Domestic Shipping Costs for Express and eBay
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=RevisingItems
For: restrictions on changing item properties with ReviseItem
Title: Revising Items


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:ShippingDetailsType'

=cut

sub setShippingDetails {
  my $self = shift;
  $self->{'ShippingDetails'} = shift
}

=head2 getShippingDetails()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetBidderList
         GetProducts
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           WonList
           WatchList
           DeletedFromWonList
           BestOfferList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           BidList

#    Returns: 'ns:ShippingDetailsType'

=cut

sub getShippingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingDetails'
		,'eBay::API::XML::DataType::ShippingDetailsType');
}


=head2 setShippingTermsInDescription()

Indicates whether details about shipping costs and
arrangements are specified in the item description.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SearchResultsAndShippingCosts
Title: Search Results and Shipping Costs

  Calls: AddItem
         GetItemRecommendations
         ReviseItem
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setShippingTermsInDescription {
  my $self = shift;
  $self->{'ShippingTermsInDescription'} = shift
}

=head2 isShippingTermsInDescription()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isShippingTermsInDescription {
  my $self = shift;
  return $self->{'ShippingTermsInDescription'};
}


=head2 setSite()

The name of the site on which the item is listed.
The listing site affects the
business logic and validation rules that are applied to the request, which in
turn affect the values that are returned in the response, as well as values
that appear on the eBay Web site. For example, the listing site can affect the
validation of Category in listing requests, international business seller
requirements, the values of converted (localized) prices in responses, the
item-related time stamps that are displayed on the eBay Web site, the
visibility of the item in some types of searches (e.g., GetCategoryListings),
and other information. In some cases (such as with listings on eBay Express),
the rules are determined by a combination of the site, the user's registration
address, and other information. You cannot change the site when you revise a
listing.<br>
<br>
When you specify Item.Site in AddItem, it must be consistent with the numeric
site ID that you specify in the request URL (for the SOAP API) or the X-EBAY-
API-SITEID header (for the XML API).
Not applicable to Half.com.
For eBay Live Auctions, pass a value of US.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SitesIntro
Title: The US and International eBay Sites
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=TargetSite
Title: Specifying the Target Site
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=FieldDifferences
Title: Field Differences for eBay Sites
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressSellerCriteria
Title: Seller Criteria for eBay Express


  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         VerifyAddItem
  RequiredInput: Yes

#    Argument: 'ns:SiteCodeType'

=cut

sub setSite {
  my $self = shift;
  $self->{'Site'} = shift
}

=head2 getSite()

  Calls: GetBidderList
         GetDispute
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           SecondChanceOffer
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

  Calls: GetSearchResults
  Returned: Always
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:SiteCodeType'

=cut

sub getSite {
  my $self = shift;
  return $self->{'Site'};
}


=head2 setSkypeContactOption()

Specifies the Skype contact options supported. Requires that SkypeEnabled is
set to true. Available if the seller has a Skype account and has linked it (on
the eBay site) with his or her eBay account.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:SkypeContactOptionCodeType'

=cut

sub setSkypeContactOption {
  my $self = shift;
  $self->{'SkypeContactOption'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSkypeContactOption()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: reference to an array  
                      of 'ns:SkypeContactOptionCodeType'

=cut

sub getSkypeContactOption {
  my $self = shift;
  return $self->_getDataTypeArray('SkypeContactOption');
}


=head2 setSkypeEnabled()

Specifies that Skype-related information is included with an item listing,
including, for example, Skype Voice. Skype-related information provides
buttons that enable potential buyers to contact sellers through Skype.
Information about Skype is available at www.Skype.com. If all of the
prerequisites for adding Skype buttons to listings are met (see the eBay Web
Services Guide), you can make communication through Skype available in
listings. SkypeEnabled must be true if SkypeID and SkypeContactOption are
specified.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setSkypeEnabled {
  my $self = shift;
  $self->{'SkypeEnabled'} = shift
}

=head2 isSkypeEnabled()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSkypeEnabled {
  my $self = shift;
  return $self->{'SkypeEnabled'};
}


=head2 setSkypeID()

The Skype name of the seller. Requires that SkypeEnabled is set to true.
Available if the seller has a Skype account and has linked it (on the eBay
site) with his or her eBay account.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setSkypeID {
  my $self = shift;
  $self->{'SkypeID'} = shift
}

=head2 getSkypeID()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getSkypeID {
  my $self = shift;
  return $self->{'SkypeID'};
}


=head2 setStartPrice()

The original price of the item at listing or re-listing time. If this
value changes when the item is revised, the new value becomes the original
price.
<br><br>
For auction-type listings, competitive bidding starts at this value. Once at
least one bid has been placed, StartPrice remains the same but CurrentPrice is
incremented to the amount of each succeeding bid. If ReservePrice is also
specified, the value of StartPrice must be lower than the value of
ReservePrice.
<br><br>
For fixed-price listings (FixedPriceItem), Store Inventory (StoresFixedPrice)
listings, and Express format listings, this is the constant price at which a
buyer may purchase the item.
<br><br>
For a listing to be eligible for Express, the max start price is
USD 10,000.00 for the US, EUR 5000 for Germany, and GBP 5500 for the UK.
(Additional price limits may be imposed
by the seller's PayPal account or the payment method used. Such limits cannot
be determined via the eBay API and are not covered in eBay's API
documentation, as they may vary for each user.)<br>
<br>
Also applicable to Half.com (valid range 0.75 to 9999.99). You can revise this
field for Half.com listings.
<br>
For AddLiveAuctionItem and ReviseLiveAuctionItem, this is the amount at
which absentee Internet bidding for the item begins. Max length was 16
at the time this call was initially developed.
Must be greater than zero. The seller needs to make sure they specify
the amount in the currency selected for the live auction event.
When you revise a Live Auction item, you can change the start price.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressPrice
Title: Specify a Fixed Price for Express and eBay

  Calls: AddItem
         AddLiveAuctionItem
         VerifyAddItem
  RequiredInput: Yes

  Calls: GetItemRecommendations
         ReviseItem
         ReviseLiveAuctionItem
         RelistItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setStartPrice {
  my $self = shift;
  $self->{'StartPrice'} = shift
}

=head2 getStartPrice()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList
           BidList

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getStartPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'StartPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setStorefront()

Contains information related to the item in the context of a seller's eBay
Store. Applicable for auction formats, Basic Fixed Price, and Store Inventory
format items listed by eBay Stores sellers.
Not applicable to Half.com.
This field is ignored when Item.ListingType=Express.
In GetProducts, this node does not return useful data (at the time of
this writing.)

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:StorefrontType'

=cut

sub setStorefront {
  my $self = shift;
  $self->{'Storefront'} = shift
}

=head2 getStorefront()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetBidderList
         GetProducts
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


#    Returns: 'ns:StorefrontType'

=cut

sub getStorefront {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Storefront'
		,'eBay::API::XML::DataType::StorefrontType');
}


=head2 setSubTitle()

Subtitle to use in addition to the title. Provides more keywords when buyers
search in titles and descriptions. You cannot use HTML in the Subtitle. (HTML
characters will be interpreted literally as plain text.) If you pass any
value, this feature is applied (with applicable fees).<br>
<br>
Not applicable to listings in US eBay Motors passenger vehicle, motorcycle,
and "other vehicle" categories or to listings in CA eBay Motors passenger
vehicle and motorcycle categories. For eBay Motors categories that do
not support this field, use Item Specifics (AttributeSetArray) to specify the
vehicle subtitle.<br>
<br>
Not applicable to Half.com.<br>
<br>
When you revise a item, you can add, change, or remove the subtitle.
<br>
In GetSearchResultsExpress, only returned when ItemDetails is set to Fine
and a subtitle was specified for the item.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=RelistDeletedField
Title: Removing a Field When Relisting an Item
, URL: RelistItem.html#Request.DeletedField
Title: (RelistItem) DeletedField
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MotorsCarAttrs
Title: Valid Item Specifics for Listing eBay Motors US Cars & Trucks
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=MotorsSubtitle
Title: Specifying a Subtitle for a Motors Vehicle Listing

MaxLength: 55

  Calls: AddItem
         RelistItem
         AddLiveAuctionItem
         GetItemRecommendations
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setSubTitle {
  my $self = shift;
  $self->{'SubTitle'} = shift
}

=head2 getSubTitle()

  Calls: GetBidderList
         GetCategoryListings
         GetProducts
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getSubTitle {
  my $self = shift;
  return $self->{'SubTitle'};
}


=head2 setThirdPartyCheckout()

Whether checkout for this is to be handled by a Third-Party Checkout
application. Only for authorized Third-Party Checkout applications. See
"Third-Party Checkout" in the main documentation.<br>
<br>
If you are creating a listing, then for a listing to be eligible
to appear on eBay Express, you also need to agree
to use a Platform Notification (or transaction calls) instead of Third-Party
Checkout to process Express sales. To do this, specify
ThirdPartyCheckoutIntegration with a value of true.<br>
IMPORTANT: If you are not authorized to support Third Party Checkout and your
application is not the original listing application, never specify
ThirdPartyCheckout or ThirdPartyCheckoutIntegration in your request (even if
you revise a listing that already includes these flags). Otherwise, the
listing may be dropped from Express or you may get unexpected results.<br>
<br>
To determine whether an item was listed on Express, call GetItem and
check the value of Item.ListingDetails.ExpressListing.
To determine whether an item sold on Express, use a transaction call
like GetItemTransactions (or the Checkout notification),
and check the value of TransactionPlatform.<br>
<br>
The counterpart in the GetItem family of calls is
Item.ShippingDetails.ThirdPartyCheckout.
<br>
<br>
Not applicable to Half.com. Not supported if AutoPay is true.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ThirdPartyCheckout
Title: Third Party Checkout
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressTPCOListing
Title: Integrate Your Third-Party Checkout Process with Express
, URL: GetItem.html#Response.Item.ShippingDetails.ThirdPartyCheckout
Title: (GetItem) Item.ShippingDetails.ThirdPartyCheckout


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setThirdPartyCheckout {
  my $self = shift;
  $self->{'ThirdPartyCheckout'} = shift
}

=head2 isThirdPartyCheckout()

#    Returns: 'xs:boolean'

=cut

sub isThirdPartyCheckout {
  my $self = shift;
  return $self->{'ThirdPartyCheckout'};
}


=head2 setThirdPartyCheckoutIntegration()

Only authorized Third-Party Checkout providers can use this flag.
<br><br>
IMPORTANT: If you are not authorized to support Third Party Checkout and your
application is not the original listing application, never specify
ThirdPartyCheckout or ThirdPartyCheckoutIntegration in your request (even if
you revise a listing that already includes these flags). Otherwise, the
listing may be dropped from Express or you may get unexpected
results.<br>
<br>
A Third-Party Checkout provider uses this flag in two ways:<br>
<br>
1) Set this flag to true to specify that you consent to use the Checkout
notification (or calls like GetSellerTransactions and GetItemTransactions) to
obtain data about eBay Express sales from the item, and to confirm that buyers
will use the Express shopping cart for checkout processing without being
redirected to your Third-Party Checkout site. If ThirdPartyCheckout is true,
the ThirdPartyCheckoutIntegration field must also be true if you want an
eligible listing to be included on eBay Express (and the Third Party Checkout
checkout flow will be then be ignored for Express purchases).
See the eBay Web Services Guide.<br>
<br>
In other words, assuming the seller and item meet all other eligibility
requirements for Express, the seller opts into Express,
and the seller (optionally) subscribes to the Checkout notification:<br>
- If ThirdPartyCheckout == true
and ThirdPartyCheckoutIntegration == true,
the item will be listed on Express
and Checkout notifications will be sent.<br>
- If ThirdPartyCheckout == true
and ThirdPartyCheckoutIntegration == omitted or false,
the item will be disqualified for Express
and no Checkout notification will be sent.<br>
- If ThirdPartyCheckout == omitted or false,
and ThirdPartyCheckoutIntegration == true,
the item will be listed on Express
and Checkout notifications will be sent.<br>
- If ThirdPartyCheckout == omitted or false,
and ThirdPartyCheckoutIntegration == omitted or false,
the item will be listed on Express
but no Checkout notifications will be sent.<br>
<br>
2) If you subscribe to the Checkout notification, set this flag to true to
enable Checkout notifications for a particular listing. These notifications
can be sent for any transaction created from the listing, regardless of
whether the listing is included on Express and regardless of the value of
ThirdPartyCheckout. Checkout notifications are not sent if
ThirdPartyCheckoutIntegration is false.<br>
<br>
Returned only if true for a listing.<br>
<br>
Not applicable to Half.com.<br>
<br>
To determine whether an item was listed on Express, call GetItem and
check the value of Item.ListingDetails.ExpressListing.
To determine whether an item sold on Express, use a transaction call
like GetItemTransactions (or the Checkout notification),
and check the value of TransactionPlatform.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressTPCOListing
Title: Integrate Your Third-Party Checkout Process with Express
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ThirdPartyCheckoutIntegration
Title: Third Party Checkout and eBay Express
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=PlatformNotifications
Title: Working with Platform Notifications


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No
  Default: false

#    Argument: 'xs:boolean'

=cut

sub setThirdPartyCheckoutIntegration {
  my $self = shift;
  $self->{'ThirdPartyCheckoutIntegration'} = shift
}

=head2 isThirdPartyCheckoutIntegration()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isThirdPartyCheckoutIntegration {
  my $self = shift;
  return $self->{'ThirdPartyCheckoutIntegration'};
}


=head2 setTimeLeft()

Time left before the listing ends.
The duration is represented in the ISO 8601 duration format (PnYnMnDTnHnMnS).
See Data Types in the eBay Web Services guide for information about this format.
For ended listings, the time left is PT0S (zero seconds).
Not applicable to Half.com.

#    Argument: 'xs:duration'

=cut

sub setTimeLeft {
  my $self = shift;
  $self->{'TimeLeft'} = shift
}

=head2 getTimeLeft()

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           SecondChanceOffer
           WatchList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList
           BidList

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


#    Returns: 'xs:duration'

=cut

sub getTimeLeft {
  my $self = shift;
  return $self->{'TimeLeft'};
}


=head2 setTitle()

Name of the item as it appears in the listing or search results.
Required for most items. Optional if you list in Books, Music, Movies,
or Video Games categories and you use Pre-filled Item Information
(as the title can be pre-filled based on the catalog product title).
That is, optional if you specify Item.ExternalProductID or Item.ProductListingDetails.<br>
<br>
You cannot use HTML or JavaScript in the Title. (HTML characters will be
interpreted literally as plain text.)<br>
<br>
For AddItem, not applicable to Half.com. For GetOrders, not returned from eBay.com,
but a title from the Half.com catalog is returned from Half.com instead.<br>
<br>
You can add or change the value of this tag only if an item has no bids
(or no items have sold) and the listing does not end for 12 hours.
<br>
<br>
In GetSearchResultsExpress, always returned when ItemArray.Item is returned.<br>
<br>
In GetItemRecommendations, more keywords in the title usually
results in more relevant recommendations.

MaxLength: 55

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         VerifyAddItem
  RequiredInput: Conditionally

  Calls: RelistItem
         ReviseItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setTitle {
  my $self = shift;
  $self->{'Title'} = shift
}

=head2 getTitle()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetCategoryListings
         GetItemsAwaitingFeedback
         GetMemberMessages
         ReviseLiveAuctionItem
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetProducts
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           SecondChanceOffer
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList
           BidList

  Calls: GetBidderList
         GetDispute
  Returned: Always

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:string'

=cut

sub getTitle {
  my $self = shift;
  return $self->{'Title'};
}


=head2 setTotalQuestionCount()

The number of questions asked about this item. Applies to eBay Motors Pro
applications only.

#    Argument: 'xs:long'

=cut

sub setTotalQuestionCount {
  my $self = shift;
  $self->{'TotalQuestionCount'} = shift
}

=head2 getTotalQuestionCount()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:long'

=cut

sub getTotalQuestionCount {
  my $self = shift;
  return $self->{'TotalQuestionCount'};
}


=head2 setUUID()

Universally unique constraint tag. Use UUID to ensure that you only list a
particular item once, particularly if you are listing many items at once. If
you add an item and do not get a response, resend the request with the same
UUID. If the item was successfully listed the first time, you will receive
an error message for trying to use a UUID that you have already used. The
error will also include the item ID for the duplicated item and a boolean
value indicating whether the duplicate UUID was sent by the same application.
<br><br>
We recommend you use Item.UUID with calls that add item objects
(for example, AddItem, AddLiveAuctionItem, and RelistItem). For calls that
modify an existing item, such as ReviseItem, use InvocationID instead.
<br><br>
The UUID can only contain digits from 0-9 and letters from A-F and must be
32 characters long. The UUID value must be unique across all item listings
on all sites.
<br><br>
Also applicable as input to AddItem and related calls when you list
items to Half.com.

MaxLength: 32

  Calls: AddItem
         AddLiveAuctionItem
         RelistItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:UUIDType'

=cut

sub setUUID {
  my $self = shift;
  $self->{'UUID'} = shift
}

=head2 getUUID()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:UUIDType'

=cut

sub getUUID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UUID'
		,'eBay::API::XML::DataType::UUIDType');
}


=head2 setUpdateReturnPolicy()

Specifies whether the Return Policy Details have been updated
for the item specified in the request.

  Calls: ReviseItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setUpdateReturnPolicy {
  my $self = shift;
  $self->{'UpdateReturnPolicy'} = shift
}

=head2 isUpdateReturnPolicy()

#    Returns: 'xs:boolean'

=cut

sub isUpdateReturnPolicy {
  my $self = shift;
  return $self->{'UpdateReturnPolicy'};
}


=head2 setUpdateSellerInfo()

Specifies whether the following Business Seller fields have been updated for
the item specified in the request: First Name, Last Name, Fax, Email
Address, Additional Contact Information, Trade Registration Number,
VAT Identification Number.

  Calls: ReviseItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setUpdateSellerInfo {
  my $self = shift;
  $self->{'UpdateSellerInfo'} = shift
}

=head2 isUpdateSellerInfo()

#    Returns: 'xs:boolean'

=cut

sub isUpdateSellerInfo {
  my $self = shift;
  return $self->{'UpdateSellerInfo'};
}


=head2 setUseTaxTable()

Indicates whether the seller's tax table is to be used when applying and
calculating taxes. If true, a tax table must exist for the seller, and the
following tags should not be used: SalesTaxState, SalesTaxPercent,
ShippingIncludedInTax.<br>
<br>
If the seller wants to charge sales tax for eBay Express sales, the seller
needs to create a tax table on eBay and use it for their listings. As eBay
Express payments are handled via a shopping cart, you will not be able to
calculate and add sales tax during your own checkout flow.
<br><br>
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SalesTax
Title: Enabling Multi-jurisdiction Sales Tax
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressTax
Title: Specify Sales Tax for Express and eBay


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setUseTaxTable {
  my $self = shift;
  $self->{'UseTaxTable'} = shift
}

=head2 isUseTaxTable()

#    Returns: 'xs:boolean'

=cut

sub isUseTaxTable {
  my $self = shift;
  return $self->{'UseTaxTable'};
}


=head2 setVATDetails()

Container for eBay's VAT features. A business seller can choose to
offer an item exclusively to bidders and buyers that also represent businesses.
Only applicable when the item is listed in a B2B-enabled category (on a site
that supports B2B business features).
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=B2BVAT
Title: Working with Business Features and VAT
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=BusinessFeatureFieldDifferences
Title: Business Feature Field Differences


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:VATDetailsType'

=cut

sub setVATDetails {
  my $self = shift;
  $self->{'VATDetails'} = shift
}

=head2 getVATDetails()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:VATDetailsType'

=cut

sub getVATDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'VATDetails'
		,'eBay::API::XML::DataType::VATDetailsType');
}


=head2 setWatchCount()

The number of watches placed on this item from buyers' My eBay accounts.
Specify IncludeWatchCount as true in the request.
Returned by GetMyeBaySelling only if greater than 0.
Not applicable to Half.com.

#    Argument: 'xs:long'

=cut

sub setWatchCount {
  my $self = shift;
  $self->{'WatchCount'} = shift
}

=head2 getWatchCount()

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBaySelling
  Returned: Conditionally

#    Returns: 'xs:long'

=cut

sub getWatchCount {
  my $self = shift;
  return $self->{'WatchCount'};
}


=head2 setEBayNotes()

Returns a note from eBay displayed below items in the user's My eBay account.
Not applicable to Half.com.

#    Argument: 'xs:string'

=cut

sub setEBayNotes {
  my $self = shift;
  $self->{'eBayNotes'} = shift
}

=head2 getEBayNotes()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'xs:string'

=cut

sub getEBayNotes {
  my $self = shift;
  return $self->{'eBayNotes'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
