#!/usr/bin/perl

package eBay::API::XML::DataType::FeeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. FeeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::FeeType

=head1 DESCRIPTION

Identifies the name and monetary amount of a fee that a member pays to eBay
(or an eBay company). These fee names and values are intended only as an aid to
help estimate the fees for a listing. Use GetAccount for an accurate final fee
breakdown. Returned in AddItemResponseType and related response types.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::FeeType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;


my @gaProperties = ( [ 'Fee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Name', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFee()

Amount of the fee that eBay will charge the member for the item.
See the eBay.com Web site online help for a current fee schedule.

SeeLink: URL: http://pages.ebay.com/help/sell/fees.html
Title: eBay.com Fees

#    Argument: 'ns:AmountType'

=cut

sub setFee {
  my $self = shift;
  $self->{'Fee'} = shift
}

=head2 getFee()

  Calls: AddItem
         AddLiveAuctionItem
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  Returned: Always

#    Returns: 'ns:AmountType'

=cut

sub getFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Fee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setName()

Name of the fee, for identification purposes.
See the eBay Web Services guide for a list of current fee names.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/ListingItems-Fees_Resulting_from_Listing_an_Item.html
Title: Fees Resulting from Listing an Item

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: AddItem
         AddLiveAuctionItem
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
