#!/usr/bin/perl

package eBay::API::XML::Call::IssueRefund::IssueRefundRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. IssueRefundRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::IssueRefund::IssueRefundRequestType

=head1 DESCRIPTION

Issues a refund for a single Half.com transaction. This can only be
called by a seller. A refund may only be issued for a specific
transaction. Sellers do not have the ability to issue a general
refund (a refund not tied to a transaction) to a buyer.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::IssueRefund::IssueRefundRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::RefundReasonCodeType;
use eBay::API::XML::DataType::Enum::RefundTypeCodeType;


my @gaProperties = ( [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'RefundAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'RefundMessage', 'xs:string', '', '', '' ]
	, [ 'RefundReason', 'ns:RefundReasonCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::RefundReasonCodeType', '' ]
	, [ 'RefundType', 'ns:RefundTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::RefundTypeCodeType', '' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setItemID()

ID of the Half.com item associated with the refund payment to the buyer.
To uniquely identify a transaction, you need to specify both ItemID
and TransactionID. Use GetSellerPayments to determine the item ID
and transaction ID associated with the original sale payment.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setRefundAmount()

The amount the seller wants to refund to the buyer, in US Dollars (USD).
Must be greater than 0.00. Half.com allows a maximum of the original item
sale price (transaction price plus original shipping reimbursement) plus
return shipping costs (the amount the buyer paid to return the item).
Typically, the return shipping cost is based on the current cost of
shipping the individual item (not the discounted cost calculated during
the original checkout for a multi-item order). You can also issue a
partial refund for the amount you want the buyer to receive. If
RefundType=Full or RefundType=FullPlusShipping and you do not pass
RefundAmount in the request, Half.com will calculate the refund amount for
you. If you pass RefundAmount in the request, the amount you specify will
override Half.com's calculated value. Required if RefundType=
CustomOrPartial.

  RequiredInput: Conditionally
#    Argument: 'ns:AmountType'

=cut

sub setRefundAmount {
  my $self = shift;
  $self->{'RefundAmount'} = shift
}

=head2 getRefundAmount()

#    Returns: 'ns:AmountType'

=cut

sub getRefundAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'RefundAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setRefundMessage()

Note to the buyer. Cannot include HTML.

MaxLength: 400

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setRefundMessage {
  my $self = shift;
  $self->{'RefundMessage'} = shift
}

=head2 getRefundMessage()

#    Returns: 'xs:string'

=cut

sub getRefundMessage {
  my $self = shift;
  return $self->{'RefundMessage'};
}


=head2 setRefundReason()

Explanation of the reason that the refund is being issued.

  RequiredInput: Yes
#    Argument: 'ns:RefundReasonCodeType'

=cut

sub setRefundReason {
  my $self = shift;
  $self->{'RefundReason'} = shift
}

=head2 getRefundReason()

#    Returns: 'ns:RefundReasonCodeType'

=cut

sub getRefundReason {
  my $self = shift;
  return $self->{'RefundReason'};
}


=head2 setRefundType()

Explanation of the costs that the refund amount covers.

  RequiredInput: Yes
#    Argument: 'ns:RefundTypeCodeType'

=cut

sub setRefundType {
  my $self = shift;
  $self->{'RefundType'} = shift
}

=head2 getRefundType()

#    Returns: 'ns:RefundTypeCodeType'

=cut

sub getRefundType {
  my $self = shift;
  return $self->{'RefundType'};
}


=head2 setTransactionID()

ID of the Half.com transaction associated with the refund payment.
To uniquely identify a transaction, you need to specify both ItemID
and TransactionID. Use GetSellerPayments to determine the item ID
and transaction ID associated with the original sale payment.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
