#!/usr/bin/perl

package eBay::API::XML::Call::GetSellerList::GetSellerListResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSellerListResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSellerList::GetSellerListResponseType

=head1 DESCRIPTION

Contains a list of the items listed by the seller specified as input. The list of
items is returned in an ItemArrayType object, in which are returned zero, one, or
multiple ItemType objects. Each ItemType object contains the detail data for one
item listing.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSellerList::GetSellerListResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::ItemArrayType;
use eBay::API::XML::DataType::PaginationResultType;
use eBay::API::XML::DataType::UserType;


my @gaProperties = ( [ 'HasMoreItems', 'xs:boolean', '', '', '' ]
	, [ 'ItemArray', 'ns:ItemArrayType', ''
	     ,'eBay::API::XML::DataType::ItemArrayType', '1' ]
	, [ 'ItemsPerPage', 'xs:int', '', '', '' ]
	, [ 'PageNumber', 'xs:int', '', '', '' ]
	, [ 'PaginationResult', 'ns:PaginationResultType', ''
	     ,'eBay::API::XML::DataType::PaginationResultType', '1' ]
	, [ 'ReturnedItemCountActual', 'xs:int', '', '', '' ]
	, [ 'Seller', 'ns:UserType', ''
	     ,'eBay::API::XML::DataType::UserType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setHasMoreItems()

If true, there are more items yet to be retrieved. Additional
GetSellerList calls with higher page numbers or more items per page must
be made to retrieve these items. Not returned if no items match the
request.

#    Argument: 'xs:boolean'

=cut

sub setHasMoreItems {
  my $self = shift;
  $self->{'HasMoreItems'} = shift
}

=head2 isHasMoreItems()

  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
#    Returns: 'xs:boolean'

=cut

sub isHasMoreItems {
  my $self = shift;
  return $self->{'HasMoreItems'};
}


=head2 setItemArray()

Contains the list of the seller's items, one ItemType object per item.
Returns empty if no items are available that match the request.

#    Argument: 'ns:ItemArrayType'

=cut

sub setItemArray {
  my $self = shift;
  $self->{'ItemArray'} = shift
}

=head2 getItemArray()

  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
#    Returns: 'ns:ItemArrayType'

=cut

sub getItemArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemArray'
		,'eBay::API::XML::DataType::ItemArrayType');
}


=head2 setItemsPerPage()

Indicates the number of items that are being returned per page of data
(i.e., per call). Will be the same as the value specified in the
Pagination.EntriesPerPage input. Only returned if items are returned.

#    Argument: 'xs:int'

=cut

sub setItemsPerPage {
  my $self = shift;
  $self->{'ItemsPerPage'} = shift
}

=head2 getItemsPerPage()

  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
#    Returns: 'xs:int'

=cut

sub getItemsPerPage {
  my $self = shift;
  return $self->{'ItemsPerPage'};
}


=head2 setPageNumber()

Indicates which page of data was just returned. Will be the same as the
value specified in the Pagination.PageNumber input. (If the input is
higher than the total number of pages, the call fails with an error.)
Only returned if items are returned.

#    Argument: 'xs:int'

=cut

sub setPageNumber {
  my $self = shift;
  $self->{'PageNumber'} = shift
}

=head2 getPageNumber()

  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
#    Returns: 'xs:int'

=cut

sub getPageNumber {
  my $self = shift;
  return $self->{'PageNumber'};
}


=head2 setPaginationResult()

Contains information regarding the pagination of data (if pagination is
used), including total number of pages and total number of entries.

#    Argument: 'ns:PaginationResultType'

=cut

sub setPaginationResult {
  my $self = shift;
  $self->{'PaginationResult'} = shift
}

=head2 getPaginationResult()

  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
#    Returns: 'ns:PaginationResultType'

=cut

sub getPaginationResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaginationResult'
		,'eBay::API::XML::DataType::PaginationResultType');
}


=head2 setReturnedItemCountActual()

Indicates the total number of items returned (i.e., the number of
ItemType objects in ItemArray).

#    Argument: 'xs:int'

=cut

sub setReturnedItemCountActual {
  my $self = shift;
  $self->{'ReturnedItemCountActual'} = shift
}

=head2 getReturnedItemCountActual()

  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
#    Returns: 'xs:int'

=cut

sub getReturnedItemCountActual {
  my $self = shift;
  return $self->{'ReturnedItemCountActual'};
}


=head2 setSeller()

Indicates the seller whose items are returned. The seller is the eBay
member whose UserID was passed in the request. If UserID was not
specified, the seller is the user who made the request (identified by
eBayAuthToken).

#    Argument: 'ns:UserType'

=cut

sub setSeller {
  my $self = shift;
  $self->{'Seller'} = shift
}

=head2 getSeller()

  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

#    Returns: 'ns:UserType'

=cut

sub getSeller {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Seller'
		,'eBay::API::XML::DataType::UserType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
