package Lego::From::PNG::Const;

BEGIN {
    $Lego::From::PNG::Const::VERSION = '0.03';
}

require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(
    LEGO_COLORS
    LEGO_BRICK_LENGTHS
    LEGO_UNIT
    LEGO_UNIT_LENGTH
    LEGO_UNIT_DEPTH
    LEGO_UNIT_HEIGHT
    LEGO_UNIT_STUD_DIAMETER
    LEGO_UNIT_STUD_HEIGHT
    LEGO_UNIT_STUD_SPACING
    LEGO_UNIT_EDGE_TO_STUD
    MILLIMETER_TO_INCH
    METRIC_SUFFIX
    IMPERIAL_SUFFIX
    AQUA_OFFICIAL_NAME
    AQUA_COMMON_NAME
    AQUA_HEX_COLOR
    AQUA_RGB_COLOR_RED
    AQUA_RGB_COLOR_GREEN
    AQUA_RGB_COLOR_BLUE
    BLACK_OFFICIAL_NAME
    BLACK_COMMON_NAME
    BLACK_HEX_COLOR
    BLACK_RGB_COLOR_RED
    BLACK_RGB_COLOR_GREEN
    BLACK_RGB_COLOR_BLUE
    BRICK_YELLOW_OFFICIAL_NAME
    BRICK_YELLOW_COMMON_NAME
    BRICK_YELLOW_HEX_COLOR
    BRICK_YELLOW_RGB_COLOR_RED
    BRICK_YELLOW_RGB_COLOR_GREEN
    BRICK_YELLOW_RGB_COLOR_BLUE
    BRIGHT_BLUE_OFFICIAL_NAME
    BRIGHT_BLUE_COMMON_NAME
    BRIGHT_BLUE_HEX_COLOR
    BRIGHT_BLUE_RGB_COLOR_RED
    BRIGHT_BLUE_RGB_COLOR_GREEN
    BRIGHT_BLUE_RGB_COLOR_BLUE
    BRIGHT_GREEN_OFFICIAL_NAME
    BRIGHT_GREEN_COMMON_NAME
    BRIGHT_GREEN_HEX_COLOR
    BRIGHT_GREEN_RGB_COLOR_RED
    BRIGHT_GREEN_RGB_COLOR_GREEN
    BRIGHT_GREEN_RGB_COLOR_BLUE
    BRIGHT_ORANGE_OFFICIAL_NAME
    BRIGHT_ORANGE_COMMON_NAME
    BRIGHT_ORANGE_HEX_COLOR
    BRIGHT_ORANGE_RGB_COLOR_RED
    BRIGHT_ORANGE_RGB_COLOR_GREEN
    BRIGHT_ORANGE_RGB_COLOR_BLUE
    BRIGHT_PURPLE_OFFICIAL_NAME
    BRIGHT_PURPLE_COMMON_NAME
    BRIGHT_PURPLE_HEX_COLOR
    BRIGHT_PURPLE_RGB_COLOR_RED
    BRIGHT_PURPLE_RGB_COLOR_GREEN
    BRIGHT_PURPLE_RGB_COLOR_BLUE
    BRIGHT_RED_OFFICIAL_NAME
    BRIGHT_RED_COMMON_NAME
    BRIGHT_RED_HEX_COLOR
    BRIGHT_RED_RGB_COLOR_RED
    BRIGHT_RED_RGB_COLOR_GREEN
    BRIGHT_RED_RGB_COLOR_BLUE
    BRIGHT_REDDISH_VIOLET_OFFICIAL_NAME
    BRIGHT_REDDISH_VIOLET_COMMON_NAME
    BRIGHT_REDDISH_VIOLET_HEX_COLOR
    BRIGHT_REDDISH_VIOLET_RGB_COLOR_RED
    BRIGHT_REDDISH_VIOLET_RGB_COLOR_GREEN
    BRIGHT_REDDISH_VIOLET_RGB_COLOR_BLUE
    BRIGHT_YELLOW_OFFICIAL_NAME
    BRIGHT_YELLOW_COMMON_NAME
    BRIGHT_YELLOW_HEX_COLOR
    BRIGHT_YELLOW_RGB_COLOR_RED
    BRIGHT_YELLOW_RGB_COLOR_GREEN
    BRIGHT_YELLOW_RGB_COLOR_BLUE
    BRIGHT_YELLOWISH_GREEN_OFFICIAL_NAME
    BRIGHT_YELLOWISH_GREEN_COMMON_NAME
    BRIGHT_YELLOWISH_GREEN_HEX_COLOR
    BRIGHT_YELLOWISH_GREEN_RGB_COLOR_RED
    BRIGHT_YELLOWISH_GREEN_RGB_COLOR_GREEN
    BRIGHT_YELLOWISH_GREEN_RGB_COLOR_BLUE
    COOL_YELLOW_OFFICIAL_NAME
    COOL_YELLOW_COMMON_NAME
    COOL_YELLOW_HEX_COLOR
    COOL_YELLOW_RGB_COLOR_RED
    COOL_YELLOW_RGB_COLOR_GREEN
    COOL_YELLOW_RGB_COLOR_BLUE
    DARK_AZUR_OFFICIAL_NAME
    DARK_AZUR_COMMON_NAME
    DARK_AZUR_HEX_COLOR
    DARK_AZUR_RGB_COLOR_RED
    DARK_AZUR_RGB_COLOR_GREEN
    DARK_AZUR_RGB_COLOR_BLUE
    DARK_BROWN_OFFICIAL_NAME
    DARK_BROWN_COMMON_NAME
    DARK_BROWN_HEX_COLOR
    DARK_BROWN_RGB_COLOR_RED
    DARK_BROWN_RGB_COLOR_GREEN
    DARK_BROWN_RGB_COLOR_BLUE
    DARK_GREEN_OFFICIAL_NAME
    DARK_GREEN_COMMON_NAME
    DARK_GREEN_HEX_COLOR
    DARK_GREEN_RGB_COLOR_RED
    DARK_GREEN_RGB_COLOR_GREEN
    DARK_GREEN_RGB_COLOR_BLUE
    DARK_ORANGE_OFFICIAL_NAME
    DARK_ORANGE_COMMON_NAME
    DARK_ORANGE_HEX_COLOR
    DARK_ORANGE_RGB_COLOR_RED
    DARK_ORANGE_RGB_COLOR_GREEN
    DARK_ORANGE_RGB_COLOR_BLUE
    DARK_RED_OFFICIAL_NAME
    DARK_RED_COMMON_NAME
    DARK_RED_HEX_COLOR
    DARK_RED_RGB_COLOR_RED
    DARK_RED_RGB_COLOR_GREEN
    DARK_RED_RGB_COLOR_BLUE
    DARK_STONE_GREY_OFFICIAL_NAME
    DARK_STONE_GREY_COMMON_NAME
    DARK_STONE_GREY_HEX_COLOR
    DARK_STONE_GREY_RGB_COLOR_RED
    DARK_STONE_GREY_RGB_COLOR_GREEN
    DARK_STONE_GREY_RGB_COLOR_BLUE
    EARTH_BLUE_OFFICIAL_NAME
    EARTH_BLUE_COMMON_NAME
    EARTH_BLUE_HEX_COLOR
    EARTH_BLUE_RGB_COLOR_RED
    EARTH_BLUE_RGB_COLOR_GREEN
    EARTH_BLUE_RGB_COLOR_BLUE
    EARTH_GREEN_OFFICIAL_NAME
    EARTH_GREEN_COMMON_NAME
    EARTH_GREEN_HEX_COLOR
    EARTH_GREEN_RGB_COLOR_RED
    EARTH_GREEN_RGB_COLOR_GREEN
    EARTH_GREEN_RGB_COLOR_BLUE
    FLAME_YELLOWISH_ORANGE_OFFICIAL_NAME
    FLAME_YELLOWISH_ORANGE_COMMON_NAME
    FLAME_YELLOWISH_ORANGE_HEX_COLOR
    FLAME_YELLOWISH_ORANGE_RGB_COLOR_RED
    FLAME_YELLOWISH_ORANGE_RGB_COLOR_GREEN
    FLAME_YELLOWISH_ORANGE_RGB_COLOR_BLUE
    LAVENDER_OFFICIAL_NAME
    LAVENDER_COMMON_NAME
    LAVENDER_HEX_COLOR
    LAVENDER_RGB_COLOR_RED
    LAVENDER_RGB_COLOR_GREEN
    LAVENDER_RGB_COLOR_BLUE
    LIGHT_NOUGAT_OFFICIAL_NAME
    LIGHT_NOUGAT_COMMON_NAME
    LIGHT_NOUGAT_HEX_COLOR
    LIGHT_NOUGAT_RGB_COLOR_RED
    LIGHT_NOUGAT_RGB_COLOR_GREEN
    LIGHT_NOUGAT_RGB_COLOR_BLUE
    LIGHT_PURPLE_OFFICIAL_NAME
    LIGHT_PURPLE_COMMON_NAME
    LIGHT_PURPLE_HEX_COLOR
    LIGHT_PURPLE_RGB_COLOR_RED
    LIGHT_PURPLE_RGB_COLOR_GREEN
    LIGHT_PURPLE_RGB_COLOR_BLUE
    LIGHT_ROYAL_BLUE_OFFICIAL_NAME
    LIGHT_ROYAL_BLUE_COMMON_NAME
    LIGHT_ROYAL_BLUE_HEX_COLOR
    LIGHT_ROYAL_BLUE_RGB_COLOR_RED
    LIGHT_ROYAL_BLUE_RGB_COLOR_GREEN
    LIGHT_ROYAL_BLUE_RGB_COLOR_BLUE
    LIGHT_STONE_GREY_OFFICIAL_NAME
    LIGHT_STONE_GREY_COMMON_NAME
    LIGHT_STONE_GREY_HEX_COLOR
    LIGHT_STONE_GREY_RGB_COLOR_RED
    LIGHT_STONE_GREY_RGB_COLOR_GREEN
    LIGHT_STONE_GREY_RGB_COLOR_BLUE
    MEDIUM_AZUR_OFFICIAL_NAME
    MEDIUM_AZUR_COMMON_NAME
    MEDIUM_AZUR_HEX_COLOR
    MEDIUM_AZUR_RGB_COLOR_RED
    MEDIUM_AZUR_RGB_COLOR_GREEN
    MEDIUM_AZUR_RGB_COLOR_BLUE
    MEDIUM_BLUE_OFFICIAL_NAME
    MEDIUM_BLUE_COMMON_NAME
    MEDIUM_BLUE_HEX_COLOR
    MEDIUM_BLUE_RGB_COLOR_RED
    MEDIUM_BLUE_RGB_COLOR_GREEN
    MEDIUM_BLUE_RGB_COLOR_BLUE
    MEDIUM_LAVENDER_OFFICIAL_NAME
    MEDIUM_LAVENDER_COMMON_NAME
    MEDIUM_LAVENDER_HEX_COLOR
    MEDIUM_LAVENDER_RGB_COLOR_RED
    MEDIUM_LAVENDER_RGB_COLOR_GREEN
    MEDIUM_LAVENDER_RGB_COLOR_BLUE
    MEDIUM_LILAC_OFFICIAL_NAME
    MEDIUM_LILAC_COMMON_NAME
    MEDIUM_LILAC_HEX_COLOR
    MEDIUM_LILAC_RGB_COLOR_RED
    MEDIUM_LILAC_RGB_COLOR_GREEN
    MEDIUM_LILAC_RGB_COLOR_BLUE
    MEDIUM_NOUGAT_OFFICIAL_NAME
    MEDIUM_NOUGAT_COMMON_NAME
    MEDIUM_NOUGAT_HEX_COLOR
    MEDIUM_NOUGAT_RGB_COLOR_RED
    MEDIUM_NOUGAT_RGB_COLOR_GREEN
    MEDIUM_NOUGAT_RGB_COLOR_BLUE
    MEDIUM_STONE_GREY_OFFICIAL_NAME
    MEDIUM_STONE_GREY_COMMON_NAME
    MEDIUM_STONE_GREY_HEX_COLOR
    MEDIUM_STONE_GREY_RGB_COLOR_RED
    MEDIUM_STONE_GREY_RGB_COLOR_GREEN
    MEDIUM_STONE_GREY_RGB_COLOR_BLUE
    MEDIUM_YELLOWISH_GREEN_OFFICIAL_NAME
    MEDIUM_YELLOWISH_GREEN_COMMON_NAME
    MEDIUM_YELLOWISH_GREEN_HEX_COLOR
    MEDIUM_YELLOWISH_GREEN_RGB_COLOR_RED
    MEDIUM_YELLOWISH_GREEN_RGB_COLOR_GREEN
    MEDIUM_YELLOWISH_GREEN_RGB_COLOR_BLUE
    NOUGAT_OFFICIAL_NAME
    NOUGAT_COMMON_NAME
    NOUGAT_HEX_COLOR
    NOUGAT_RGB_COLOR_RED
    NOUGAT_RGB_COLOR_GREEN
    NOUGAT_RGB_COLOR_BLUE
    OLIVE_GREEN_OFFICIAL_NAME
    OLIVE_GREEN_COMMON_NAME
    OLIVE_GREEN_HEX_COLOR
    OLIVE_GREEN_RGB_COLOR_RED
    OLIVE_GREEN_RGB_COLOR_GREEN
    OLIVE_GREEN_RGB_COLOR_BLUE
    REDDISH_BROWN_OFFICIAL_NAME
    REDDISH_BROWN_COMMON_NAME
    REDDISH_BROWN_HEX_COLOR
    REDDISH_BROWN_RGB_COLOR_RED
    REDDISH_BROWN_RGB_COLOR_GREEN
    REDDISH_BROWN_RGB_COLOR_BLUE
    SAND_BLUE_OFFICIAL_NAME
    SAND_BLUE_COMMON_NAME
    SAND_BLUE_HEX_COLOR
    SAND_BLUE_RGB_COLOR_RED
    SAND_BLUE_RGB_COLOR_GREEN
    SAND_BLUE_RGB_COLOR_BLUE
    SAND_GREEN_OFFICIAL_NAME
    SAND_GREEN_COMMON_NAME
    SAND_GREEN_HEX_COLOR
    SAND_GREEN_RGB_COLOR_RED
    SAND_GREEN_RGB_COLOR_GREEN
    SAND_GREEN_RGB_COLOR_BLUE
    SAND_YELLOW_OFFICIAL_NAME
    SAND_YELLOW_COMMON_NAME
    SAND_YELLOW_HEX_COLOR
    SAND_YELLOW_RGB_COLOR_RED
    SAND_YELLOW_RGB_COLOR_GREEN
    SAND_YELLOW_RGB_COLOR_BLUE
    SPRING_YELLOWISH_GREEN_OFFICIAL_NAME
    SPRING_YELLOWISH_GREEN_COMMON_NAME
    SPRING_YELLOWISH_GREEN_HEX_COLOR
    SPRING_YELLOWISH_GREEN_RGB_COLOR_RED
    SPRING_YELLOWISH_GREEN_RGB_COLOR_GREEN
    SPRING_YELLOWISH_GREEN_RGB_COLOR_BLUE
    WHITE_OFFICIAL_NAME
    WHITE_COMMON_NAME
    WHITE_HEX_COLOR
    WHITE_RGB_COLOR_RED
    WHITE_RGB_COLOR_GREEN
    WHITE_RGB_COLOR_BLUE
    WHITE_GLOW_OFFICIAL_NAME
    WHITE_GLOW_COMMON_NAME
    WHITE_GLOW_HEX_COLOR
    WHITE_GLOW_RGB_COLOR_RED
    WHITE_GLOW_RGB_COLOR_GREEN
    WHITE_GLOW_RGB_COLOR_BLUE
);

%EXPORT_TAGS = ('all' => \@EXPORT_OK);

# List of basic lego colors
use constant LEGO_COLORS => qw(
    AQUA
    BLACK
    BRICK_YELLOW
    BRIGHT_BLUE
    BRIGHT_GREEN
    BRIGHT_ORANGE
    BRIGHT_PURPLE
    BRIGHT_RED
    BRIGHT_REDDISH_VIOLET
    BRIGHT_YELLOW
    BRIGHT_YELLOWISH_GREEN
    COOL_YELLOW
    DARK_AZUR
    DARK_BROWN
    DARK_GREEN
    DARK_ORANGE
    DARK_RED
    DARK_STONE_GREY
    EARTH_BLUE
    EARTH_GREEN
    FLAME_YELLOWISH_ORANGE
    LAVENDER
    LIGHT_NOUGAT
    LIGHT_PURPLE
    LIGHT_ROYAL_BLUE
    LIGHT_STONE_GREY
    MEDIUM_AZUR
    MEDIUM_BLUE
    MEDIUM_LAVENDER
    MEDIUM_LILAC
    MEDIUM_NOUGAT
    MEDIUM_STONE_GREY
    MEDIUM_YELLOWISH_GREEN
    NOUGAT
    OLIVE_GREEN
    REDDISH_BROWN
    SAND_BLUE
    SAND_GREEN
    SAND_YELLOW
    SPRING_YELLOWISH_GREEN
    WHITE
    WHITE_GLOW
);

# Common Brick Dimensions (by stud count)
use constant LEGO_BRICK_LENGTHS => qw(
    1
    2
    3
    4
    5
    6
    8
    10
    12
    16
);

# Lego Dimensions Info
use constant {
    LEGO_UNIT               => 1.6, # in millimeters
    # the rest of these values are in lego units
    LEGO_UNIT_LENGTH        => 5,
    LEGO_UNIT_DEPTH         => 5,
    LEGO_UNIT_HEIGHT        => 6,
    LEGO_UNIT_STUD_DIAMETER => 3,
    LEGO_UNIT_STUD_HEIGHT   => 1,
    LEGO_UNIT_STUD_SPACING  => 2, # space between the edge of two lego studs on a brick
    LEGO_UNIT_EDGE_TO_STUD  => 1, # distance from the edge of a brick to the edge of a stud (this is why stud spacing is double that)
    MILLIMETER_TO_INCH      => 0.0393701, # just so we can provide a conversion option
    METRIC_SUFFIX           => "mm",
    IMPERIAL_SUFFIX         => "in.",
};

# Color Info
use constant {
    AQUA_OFFICIAL_NAME => 'Aqua',
    AQUA_COMMON_NAME => 'Unikitty Blue',
    AQUA_HEX_COLOR => 'D3F2EA',
    AQUA_RGB_COLOR_RED => 211,
    AQUA_RGB_COLOR_GREEN => 242,
    AQUA_RGB_COLOR_BLUE => 234,

    BLACK_OFFICIAL_NAME => 'Black',
    BLACK_COMMON_NAME => 'Black',
    BLACK_HEX_COLOR => '010101',
    BLACK_RGB_COLOR_RED => 1,
    BLACK_RGB_COLOR_GREEN => 1,
    BLACK_RGB_COLOR_BLUE => 1,

    BRICK_YELLOW_OFFICIAL_NAME => 'Brick Yellow',
    BRICK_YELLOW_COMMON_NAME => 'Tan',
    BRICK_YELLOW_HEX_COLOR => 'D9BB7B',
    BRICK_YELLOW_RGB_COLOR_RED => 217,
    BRICK_YELLOW_RGB_COLOR_GREEN => 187,
    BRICK_YELLOW_RGB_COLOR_BLUE => 123,

    BRIGHT_BLUE_OFFICIAL_NAME => 'Bright Blue',
    BRIGHT_BLUE_COMMON_NAME => 'Blue',
    BRIGHT_BLUE_HEX_COLOR => '0057A8',
    BRIGHT_BLUE_RGB_COLOR_RED => 0,
    BRIGHT_BLUE_RGB_COLOR_GREEN => 87,
    BRIGHT_BLUE_RGB_COLOR_BLUE => 168,

    BRIGHT_GREEN_OFFICIAL_NAME => 'Bright Green',
    BRIGHT_GREEN_COMMON_NAME => 'Bright Green',
    BRIGHT_GREEN_HEX_COLOR => '009624',
    BRIGHT_GREEN_RGB_COLOR_RED => 0,
    BRIGHT_GREEN_RGB_COLOR_GREEN => 150,
    BRIGHT_GREEN_RGB_COLOR_BLUE => 36,

    BRIGHT_ORANGE_OFFICIAL_NAME => 'Bright Orange',
    BRIGHT_ORANGE_COMMON_NAME => 'Orange',
    BRIGHT_ORANGE_HEX_COLOR => 'E76318',
    BRIGHT_ORANGE_RGB_COLOR_RED => 231,
    BRIGHT_ORANGE_RGB_COLOR_GREEN => 99,
    BRIGHT_ORANGE_RGB_COLOR_BLUE => 24,

    BRIGHT_PURPLE_OFFICIAL_NAME => 'Bright Purple',
    BRIGHT_PURPLE_COMMON_NAME => 'Bright Pink',
    BRIGHT_PURPLE_HEX_COLOR => 'DE378B',
    BRIGHT_PURPLE_RGB_COLOR_RED => 222,
    BRIGHT_PURPLE_RGB_COLOR_GREEN => 55,
    BRIGHT_PURPLE_RGB_COLOR_BLUE => 139,

    BRIGHT_RED_OFFICIAL_NAME => 'Bright Red',
    BRIGHT_RED_COMMON_NAME => 'Red',
    BRIGHT_RED_HEX_COLOR => 'DE000D',
    BRIGHT_RED_RGB_COLOR_RED => 222,
    BRIGHT_RED_RGB_COLOR_GREEN => 0,
    BRIGHT_RED_RGB_COLOR_BLUE => 13,

    BRIGHT_REDDISH_VIOLET_OFFICIAL_NAME => 'Bright Reddish Violet',
    BRIGHT_REDDISH_VIOLET_COMMON_NAME => 'Magenta',
    BRIGHT_REDDISH_VIOLET_HEX_COLOR => '9C006B',
    BRIGHT_REDDISH_VIOLET_RGB_COLOR_RED => 156,
    BRIGHT_REDDISH_VIOLET_RGB_COLOR_GREEN => 0,
    BRIGHT_REDDISH_VIOLET_RGB_COLOR_BLUE => 107,

    BRIGHT_YELLOW_OFFICIAL_NAME => 'Bright Yellow',
    BRIGHT_YELLOW_COMMON_NAME => 'Yellow',
    BRIGHT_YELLOW_HEX_COLOR => 'FEC400',
    BRIGHT_YELLOW_RGB_COLOR_RED => 254,
    BRIGHT_YELLOW_RGB_COLOR_GREEN => 196,
    BRIGHT_YELLOW_RGB_COLOR_BLUE => 0,

    BRIGHT_YELLOWISH_GREEN_OFFICIAL_NAME => 'Bright Yellowish-Green',
    BRIGHT_YELLOWISH_GREEN_COMMON_NAME => 'Lime',
    BRIGHT_YELLOWISH_GREEN_HEX_COLOR => '95B90B',
    BRIGHT_YELLOWISH_GREEN_RGB_COLOR_RED => 149,
    BRIGHT_YELLOWISH_GREEN_RGB_COLOR_GREEN => 185,
    BRIGHT_YELLOWISH_GREEN_RGB_COLOR_BLUE => 11,

    COOL_YELLOW_OFFICIAL_NAME => 'Cool Yellow',
    COOL_YELLOW_COMMON_NAME => 'Blonde',
    COOL_YELLOW_HEX_COLOR => 'FFFF99',
    COOL_YELLOW_RGB_COLOR_RED => 255,
    COOL_YELLOW_RGB_COLOR_GREEN => 255,
    COOL_YELLOW_RGB_COLOR_BLUE => 153,

    DARK_AZUR_OFFICIAL_NAME => 'Dark Azur',
    DARK_AZUR_COMMON_NAME => '',
    DARK_AZUR_HEX_COLOR => '469BC3',
    DARK_AZUR_RGB_COLOR_RED => 70,
    DARK_AZUR_RGB_COLOR_GREEN => 155,
    DARK_AZUR_RGB_COLOR_BLUE => 195,

    DARK_BROWN_OFFICIAL_NAME => 'Dark Brown',
    DARK_BROWN_COMMON_NAME => 'Dark Brown',
    DARK_BROWN_HEX_COLOR => '300F06',
    DARK_BROWN_RGB_COLOR_RED => 48,
    DARK_BROWN_RGB_COLOR_GREEN => 15,
    DARK_BROWN_RGB_COLOR_BLUE => 6,

    DARK_GREEN_OFFICIAL_NAME => 'Dark Green',
    DARK_GREEN_COMMON_NAME => 'Green',
    DARK_GREEN_HEX_COLOR => '007B28',
    DARK_GREEN_RGB_COLOR_RED => 0,
    DARK_GREEN_RGB_COLOR_GREEN => 123,
    DARK_GREEN_RGB_COLOR_BLUE => 40,

    DARK_ORANGE_OFFICIAL_NAME => 'Dark Orange',
    DARK_ORANGE_COMMON_NAME => 'Dark Orange',
    DARK_ORANGE_HEX_COLOR => 'A83D15',
    DARK_ORANGE_RGB_COLOR_RED => 168,
    DARK_ORANGE_RGB_COLOR_GREEN => 61,
    DARK_ORANGE_RGB_COLOR_BLUE => 21,

    DARK_RED_OFFICIAL_NAME => 'Dark Red',
    DARK_RED_COMMON_NAME => 'Dark Red',
    DARK_RED_HEX_COLOR => '80081B',
    DARK_RED_RGB_COLOR_RED => 128,
    DARK_RED_RGB_COLOR_GREEN => 8,
    DARK_RED_RGB_COLOR_BLUE => 27,

    DARK_STONE_GREY_OFFICIAL_NAME => 'Dark Stone Grey',
    DARK_STONE_GREY_COMMON_NAME => 'Dark Grey',
    DARK_STONE_GREY_HEX_COLOR => '4C5156',
    DARK_STONE_GREY_RGB_COLOR_RED => 76,
    DARK_STONE_GREY_RGB_COLOR_GREEN => 81,
    DARK_STONE_GREY_RGB_COLOR_BLUE => 86,

    EARTH_BLUE_OFFICIAL_NAME => 'Earth Blue',
    EARTH_BLUE_COMMON_NAME => 'Dark Blue',
    EARTH_BLUE_HEX_COLOR => '002541',
    EARTH_BLUE_RGB_COLOR_RED => 0,
    EARTH_BLUE_RGB_COLOR_GREEN => 37,
    EARTH_BLUE_RGB_COLOR_BLUE => 65,

    EARTH_GREEN_OFFICIAL_NAME => 'Earth Green',
    EARTH_GREEN_COMMON_NAME => 'Dark Green',
    EARTH_GREEN_HEX_COLOR => '003416',
    EARTH_GREEN_RGB_COLOR_RED => 0,
    EARTH_GREEN_RGB_COLOR_GREEN => 52,
    EARTH_GREEN_RGB_COLOR_BLUE => 22,

    FLAME_YELLOWISH_ORANGE_OFFICIAL_NAME => 'Flame Yellowish Orange',
    FLAME_YELLOWISH_ORANGE_COMMON_NAME => 'Bright Light Orange',
    FLAME_YELLOWISH_ORANGE_HEX_COLOR => 'F49B00',
    FLAME_YELLOWISH_ORANGE_RGB_COLOR_RED => 244,
    FLAME_YELLOWISH_ORANGE_RGB_COLOR_GREEN => 155,
    FLAME_YELLOWISH_ORANGE_RGB_COLOR_BLUE => 0,

    LAVENDER_OFFICIAL_NAME => 'Lavender',
    LAVENDER_COMMON_NAME => 'Lavender',
    LAVENDER_HEX_COLOR => 'CDA4DE',
    LAVENDER_RGB_COLOR_RED => 205,
    LAVENDER_RGB_COLOR_GREEN => 164,
    LAVENDER_RGB_COLOR_BLUE => 222,

    LIGHT_NOUGAT_OFFICIAL_NAME => 'Light Nougat',
    LIGHT_NOUGAT_COMMON_NAME => 'Light Flesh',
    LIGHT_NOUGAT_HEX_COLOR => 'F5C189',
    LIGHT_NOUGAT_RGB_COLOR_RED => 245,
    LIGHT_NOUGAT_RGB_COLOR_GREEN => 193,
    LIGHT_NOUGAT_RGB_COLOR_BLUE => 137,

    LIGHT_PURPLE_OFFICIAL_NAME => 'Light Purple',
    LIGHT_PURPLE_COMMON_NAME => 'Light Pink',
    LIGHT_PURPLE_HEX_COLOR => 'EE9DC3',
    LIGHT_PURPLE_RGB_COLOR_RED => 238,
    LIGHT_PURPLE_RGB_COLOR_GREEN => 157,
    LIGHT_PURPLE_RGB_COLOR_BLUE => 195,

    LIGHT_ROYAL_BLUE_OFFICIAL_NAME => 'Light Royal Blue',
    LIGHT_ROYAL_BLUE_COMMON_NAME => 'Light Blue',
    LIGHT_ROYAL_BLUE_HEX_COLOR => '87C0EA',
    LIGHT_ROYAL_BLUE_RGB_COLOR_RED => 135,
    LIGHT_ROYAL_BLUE_RGB_COLOR_GREEN => 192,
    LIGHT_ROYAL_BLUE_RGB_COLOR_BLUE => 234,

    LIGHT_STONE_GREY_OFFICIAL_NAME => 'Light Stone Grey',
    LIGHT_STONE_GREY_COMMON_NAME => 'Very Light Grey',
    LIGHT_STONE_GREY_HEX_COLOR => 'E4E4DA',
    LIGHT_STONE_GREY_RGB_COLOR_RED => 228,
    LIGHT_STONE_GREY_RGB_COLOR_GREEN => 228,
    LIGHT_STONE_GREY_RGB_COLOR_BLUE => 218,

    MEDIUM_AZUR_OFFICIAL_NAME => 'Medium Azur',
    MEDIUM_AZUR_COMMON_NAME => 'Azure',
    MEDIUM_AZUR_HEX_COLOR => '68C3E2',
    MEDIUM_AZUR_RGB_COLOR_RED => 104,
    MEDIUM_AZUR_RGB_COLOR_GREEN => 195,
    MEDIUM_AZUR_RGB_COLOR_BLUE => 226,

    MEDIUM_BLUE_OFFICIAL_NAME => 'Medium Blue',
    MEDIUM_BLUE_COMMON_NAME => 'Medium Blue',
    MEDIUM_BLUE_HEX_COLOR => '478CC6',
    MEDIUM_BLUE_RGB_COLOR_RED => 71,
    MEDIUM_BLUE_RGB_COLOR_GREEN => 140,
    MEDIUM_BLUE_RGB_COLOR_BLUE => 198,

    MEDIUM_LAVENDER_OFFICIAL_NAME => 'Medium Lavender',
    MEDIUM_LAVENDER_COMMON_NAME => '',
    MEDIUM_LAVENDER_HEX_COLOR => 'A06EB9',
    MEDIUM_LAVENDER_RGB_COLOR_RED => 160,
    MEDIUM_LAVENDER_RGB_COLOR_GREEN => 110,
    MEDIUM_LAVENDER_RGB_COLOR_BLUE => 185,

    MEDIUM_LILAC_OFFICIAL_NAME => 'Medium Lilac',
    MEDIUM_LILAC_COMMON_NAME => 'Dark Purple',
    MEDIUM_LILAC_HEX_COLOR => '2C1577',
    MEDIUM_LILAC_RGB_COLOR_RED => 44,
    MEDIUM_LILAC_RGB_COLOR_GREEN => 21,
    MEDIUM_LILAC_RGB_COLOR_BLUE => 119,

    MEDIUM_NOUGAT_OFFICIAL_NAME => 'Medium Nougat',
    MEDIUM_NOUGAT_COMMON_NAME => 'Medium Dark Flesh',
    MEDIUM_NOUGAT_HEX_COLOR => 'AA7D55',
    MEDIUM_NOUGAT_RGB_COLOR_RED => 170,
    MEDIUM_NOUGAT_RGB_COLOR_GREEN => 125,
    MEDIUM_NOUGAT_RGB_COLOR_BLUE => 85,

    MEDIUM_STONE_GREY_OFFICIAL_NAME => 'Medium Stone Grey',
    MEDIUM_STONE_GREY_COMMON_NAME => 'Light Grey',
    MEDIUM_STONE_GREY_HEX_COLOR => '9C9291',
    MEDIUM_STONE_GREY_RGB_COLOR_RED => 156,
    MEDIUM_STONE_GREY_RGB_COLOR_GREEN => 146,
    MEDIUM_STONE_GREY_RGB_COLOR_BLUE => 145,

    MEDIUM_YELLOWISH_GREEN_OFFICIAL_NAME => 'Medium-Yellowish green',
    MEDIUM_YELLOWISH_GREEN_COMMON_NAME => 'Dark Lime; Medium Lime',
    MEDIUM_YELLOWISH_GREEN_HEX_COLOR => '96B93B',
    MEDIUM_YELLOWISH_GREEN_RGB_COLOR_RED => 150,
    MEDIUM_YELLOWISH_GREEN_RGB_COLOR_GREEN => 185,
    MEDIUM_YELLOWISH_GREEN_RGB_COLOR_BLUE => 59,

    NOUGAT_OFFICIAL_NAME => 'Nougat',
    NOUGAT_COMMON_NAME => 'Flesh',
    NOUGAT_HEX_COLOR => 'D67240',
    NOUGAT_RGB_COLOR_RED => 214,
    NOUGAT_RGB_COLOR_GREEN => 114,
    NOUGAT_RGB_COLOR_BLUE => 64,

    OLIVE_GREEN_OFFICIAL_NAME => 'Olive Green',
    OLIVE_GREEN_COMMON_NAME => 'Olive Green',
    OLIVE_GREEN_HEX_COLOR => '77774E',
    OLIVE_GREEN_RGB_COLOR_RED => 119,
    OLIVE_GREEN_RGB_COLOR_GREEN => 119,
    OLIVE_GREEN_RGB_COLOR_BLUE => 78,

    REDDISH_BROWN_OFFICIAL_NAME => 'Reddish Brown',
    REDDISH_BROWN_COMMON_NAME => 'Reddish Brown',
    REDDISH_BROWN_HEX_COLOR => '5B1C0C',
    REDDISH_BROWN_RGB_COLOR_RED => 91,
    REDDISH_BROWN_RGB_COLOR_GREEN => 28,
    REDDISH_BROWN_RGB_COLOR_BLUE => 12,

    SAND_BLUE_OFFICIAL_NAME => 'Sand Blue',
    SAND_BLUE_COMMON_NAME => 'Sand Blue',
    SAND_BLUE_HEX_COLOR => '5E748C',
    SAND_BLUE_RGB_COLOR_RED => 94,
    SAND_BLUE_RGB_COLOR_GREEN => 116,
    SAND_BLUE_RGB_COLOR_BLUE => 140,

    SAND_GREEN_OFFICIAL_NAME => 'Sand Green',
    SAND_GREEN_COMMON_NAME => 'Sand Green',
    SAND_GREEN_HEX_COLOR => '5F8265',
    SAND_GREEN_RGB_COLOR_RED => 95,
    SAND_GREEN_RGB_COLOR_GREEN => 130,
    SAND_GREEN_RGB_COLOR_BLUE => 101,

    SAND_YELLOW_OFFICIAL_NAME => 'Sand Yellow',
    SAND_YELLOW_COMMON_NAME => 'Dark Tan',
    SAND_YELLOW_HEX_COLOR => '8D7452',
    SAND_YELLOW_RGB_COLOR_RED => 141,
    SAND_YELLOW_RGB_COLOR_GREEN => 116,
    SAND_YELLOW_RGB_COLOR_BLUE => 82,

    SPRING_YELLOWISH_GREEN_OFFICIAL_NAME => 'Spring Yellowish Green',
    SPRING_YELLOWISH_GREEN_COMMON_NAME => 'Unikitty Green',
    SPRING_YELLOWISH_GREEN_HEX_COLOR => 'E2F99A',
    SPRING_YELLOWISH_GREEN_RGB_COLOR_RED => 226,
    SPRING_YELLOWISH_GREEN_RGB_COLOR_GREEN => 249,
    SPRING_YELLOWISH_GREEN_RGB_COLOR_BLUE => 154,

    WHITE_OFFICIAL_NAME => 'White',
    WHITE_COMMON_NAME => 'White',
    WHITE_HEX_COLOR => 'FFFFFF',
    WHITE_RGB_COLOR_RED => 255,
    WHITE_RGB_COLOR_GREEN => 255,
    WHITE_RGB_COLOR_BLUE => 255,

    WHITE_GLOW_OFFICIAL_NAME => 'White Glow',
    WHITE_GLOW_COMMON_NAME => 'Glow-in-the-dark',
    WHITE_GLOW_HEX_COLOR => 'F5F3D7',
    WHITE_GLOW_RGB_COLOR_RED => 245,
    WHITE_GLOW_RGB_COLOR_GREEN => 243,
    WHITE_GLOW_RGB_COLOR_BLUE => 215,
};

use strict;
use warnings;

=pod

=head1 NAME

Lego::From::PNG::Const - Lego::From::PNG related constants, mainly lego colors

=head1 SYNOPSIS

  # Get specific constants
  use Lego::From::PNG::Const qw/PNG_TRANSFORM_INVERT_ALPHA
                             PNG_COLOR_MASK_ALPHA/;

  # Get all constants
  use Image::PNG::Const ':all';

=head1 DESCRIPTION

Constants used in L<Lego::From::PNG>

=head1 CONSTANTS

=over

=item LEGO_COLORS

    List of colors that have constant definitions in this file. Note: these names are made from a color's original name.

=item (COLOR)_COMMON_NAME

    The common name of a color.

=item (COLOR)_HEX_COLOR

    The rgb hex value for a color

=item (COLOR)_RGB_COLOR_RED

    The red number part of a rgb value for a color

=item (COLOR)_RGB_COLOR_GREEN

    The green number part of a rgb value for a color

=item (COLOR)_RGB_COLOR_BLUE

    The blue number part of a rgb value for a color

=back

=head1 AUTHOR

    Travis Chase
    CPAN ID: GAUDEON
    gaudeon@cpan.org
    https://github.com/gaudeon/Lego-From-Png

=head1 COPYRIGHT

This program is free software licensed under the...

    The MIT License

The full text of the license can be found in the
LICENSE file included with this module.

=head1 SEE ALSO

perl(1).

=cut

1;
