use v5.10;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME               => "Devel::WatchVars",
    AUTHOR             => q{Tom Christiansen <tchrist53147@gmail.com>},
    VERSION_FROM       => "lib/Devel/WatchVars.pm",
    ABSTRACT_FROM      => "lib/Devel/WatchVars.pm",
    LICENSE            => "perl_5",
    PL_FILES           => {},
    MIN_PERL_VERSION   => 5.010,
    CONFIGURE_REQUIRES => {
        "ExtUtils::MakeMaker" => 0,    # core
    },
    BUILD_REQUIRES => {
        "feature"             => 0,     # core
        "Cwd"                 => 0,     # core
        "Capture::Tiny"       => 0,
        "FindBin"             => 0,     # core
        "Import::Base"        => 0,
        "Scalar::Util"        => 0,     # core
        "Test::CheckManifest" => 0.9,
        "Test::More"          => 0,     # core
        "Test::Script"        => 0,
        "Test::Warn"          => 0,
        "Test2::V0"           => 0,
        "Tie::Scalar"         => 0,     # core
    },
    PREREQ_PM => {
        "namespace::clean"         => 0,
        "overloading"              => 0,    # core
        "strict"                   => 0,    # core
        "warnings"                 => 0,    # core
        "Carp"                     => 0,    # core
        "Devel::GlobalDestruction" => 0,
        "Exporter"                 => 0,    # core
    },
    dist  => { COMPRESS => "gzip -9f", SUFFIX => "gz" },
    clean => { FILES    => "Devel-WatchVars-*" },
);
