# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230113181720;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"7385", "Altai\ Territory",
"7388", "Republic\ of\ Altai",
"771035", "Ulytau",
"77272", "Almaty",
"7835", "Chuvashi\ Republic",
"77232", "Ust\-Kamenogorsk",
"7394", "Republic\ of\ Tuva",
"77242", "Kyzylorda",
"772632", "Merke",
"771535", "Novoishimski",
"77185", "Shaldai",
"772146", "Karkaralinsk",
"77245", "Kyzylorda\ Region",
"772335", "Zyryanovsk",
"772435", "Zhanakorgan",
"772643", "Shu",
"7484", "Kaluga",
"77152", "Petropavlovsk",
"77182", "Pavlodar",
"7483", "Bryansk",
"7811", "Pskov",
"772777", "Kegen",
"7487", "Tula",
"77102", "Zhezkazgan",
"772239", "Makanchi",
"7495", "Moscow",
"7498", "Moscow",
"771141", "Zhangala",
"7353", "Orenburg",
"7712302", "Tengizshevroil",
"771451", "Sarykol",
"771645", "Stepnogorsk",
"772542", "Asykata",
"771137", "Chingirlau",
"772540", "Arys",
"772840", "Saryozek",
"772842", "Kogaly",
"771333", "Kandyagash",
"771433", "Lisakovsk",
"772931", "Shetpe",
"771458", "Kostanai\ Region",
"7421", "Khabarovsk\ Territory",
"772533", "Turkestan",
"733", "Baikonur",
"771149", "Zelenovsky\ District",
"772833", "Usharal",
"771340", "Khobdinsky\ District",
"771459", "Kostanai\ Region",
"771342", "Badamsha",
"771440", "Amangeldy",
"771442", "Fyodorovka",
"772938", "Fort\ Shevchenko",
"771236", "Makhambet",
"7820", "Cherepovets",
"7879", "Mineranye\ Vody",
"772257", "Shulbinsk",
"772638", "Tole\ bi",
"771546", "Talshik",
"772334", "Tavricheskoye",
"77212", "Karaganda",
"772639", "Saudakent",
"7851", "Astrakhan",
"7391", "Krasnoyarsk\ Territory",
"7814", "Republic\ of\ Karelia",
"771534", "Sergeyevka",
"7481", "Smolensk",
"7813", "Leningrad\ region",
"771834", "Uspenka",
"772156", "Shakhtinsk",
"772346", "Aksuat",
"772773", "Bakanas",
"772230", "Urdzhar",
"77274", "Karassaisky\ District",
"771034", "Zhezdy",
"772631", "Kulan",
"7817", "Vologda",
"7351", "Chelyabinsk",
"7872", "Republic\ of\ Daghestan",
"771441", "Karabalyk",
"771341", "Khobda",
"771133", "Aksai",
"7415", "Kamchatka\ Region",
"771636", "Shuchinsk",
"772548", "Shayan",
"771337", "Alga",
"771437", "Kamysty",
"772537", "Saryagash",
"771142", "Taipak",
"771140", "Saikhin",
"771348", "Shalkarsky\ District",
"772837", "Kabanbai",
"771448", "Oktyabrskoye",
"771452", "Karasu",
"771349", "Shalkarsky\ District",
"7423", "Primorie\ territory",
"771644", "Arshaly",
"771449", "Taranovskoye",
"7424", "Sakhalin\ Region",
"7427", "Chukotka\ Autonomous\ District",
"772841", "Kapal",
"772541", "Myrzakent",
"772932", "Beineu",
"771651", "Kabanbai\ Batyr",
"771445", "Ubaganskoye",
"771136", "Chapayev",
"771345", "Karauylkeldy",
"771633", "Ereimentau",
"7873", "Ingushi\ Republic",
"736", "Simferopol",
"771144", "Kaztalovka",
"772545", "Ikan",
"771642", "Egendykol",
"771454", "Karamendy",
"771640", "Balkashino",
"7877", "Republic\ of\ Adygeya",
"77279", "Almaty",
"771237", "Kulsary",
"772934", "Zhanaozen",
"7812", "St\ Petersburg",
"77224", "Barshatas",
"771043", "Zhairem",
"7865", "Stavropol\ territory",
"771843", "Maisky\ District",
"771543", "Yavlenka",
"77262", "Taraz",
"7475", "Tambov",
"772432", "Shiyeli",
"77187", "Ekibastuz",
"772138", "Gabidena\ Mustafina",
"772330", "Zyryanovsky\ District",
"772332", "Shemonaikha",
"772153", "Topar",
"771832", "Irtyshsk",
"771532", "Smirnovo",
"772147", "Egindybulak",
"772635", "Bauyrzhan\ Mamyshuly",
"7486", "Orel",
"772343", "Terekty",
"772757", "Akshi",
"772131", "Abai",
"772776", "Shelek",
"771032", "Karazhal",
"771030", "Atasu",
"772935", "Zhetybai",
"771641", "Astrakhanka",
"771455", "Zatobolsk",
"772544", "Shaulder",
"771436", "Taranovskoye",
"771145", "Karatobe\ District",
"771637", "Korgalzhyn",
"771336", "Khromtau",
"772836", "Karabulak",
"772536", "Kentau",
"771648", "Derzhavinsk",
"7871", "Chechen\ Republic",
"771444", "Uzunkol",
"77106", "Satpaev",
"7426", "Jewish\ Autonomous\ Region",
"7352", "Kurgan",
"77145834", "Krasnogorsk",
"771649", "Zhaksynsky\ District",
"7845", "Saratov",
"7848", "Tolyatti",
"77292", "Aktau",
"771233", "Ganyushkino",
"771531", "Bulayevo",
"771831", "Zhelezinka",
"772256", "Kainar",
"7482", "Tver",
"772438", "Aiteke\ bi",
"772132", "Nurinsky\ District",
"771547", "Zhambylsky\ District",
"772338", "Bozanbai\/Molodezhnyi",
"772439", "Aralsky\ District",
"772339", "Kurchum",
"772634", "Zhanatas",
"771031", "Aksu\-Ayuly",
"771839", "Akku",
"7816", "Veliky\ Novgorod",
"77272956", "Talgar",
"771539", "Beskol",
"772353", "Novaya\ Shulba",
"7345", "Tyumen",
"771838", "Koktobe",
"771538", "Beskol",
"772347", "Kalbatau",
"771038", "Shashubai",
"77222", "Semey",
"772331", "Glubokoye",
"771039", "Priozersk",
"772431", "Zhalagash",
"771343", "Irgiz",
"7473", "Voronezh",
"771457", "Dzhangildinsky\ District",
"7867", "Republic\ of\ North\ Ossetia",
"771443", "Borovskoi",
"7474", "Lipetsk",
"772530", "Temirlanovka",
"771635", "Zhaksy",
"771147", "Akzhaiksky\ District",
"772532", "Abai",
"772832", "Zhansugurov",
"772830", "Alakolsky\ District",
"772937", "Kuryk",
"771234", "Indernborski",
"7836", "Republic\ of\ Marij\ El",
"7717", "Astana",
"7863", "Rostov",
"771131", "Darinskoye",
"7496", "Moscow",
"771332", "Uil",
"771330", "Khromtau\ District",
"771138", "Zhalpaktal",
"7341", "Udmurtian\ Republic",
"771430", "Arkalyk",
"771139", "Taskala",
"77162", "Kokshetau\/Krasni\ Yar",
"772543", "Aqsumbe",
"772843", "Lepsy",
"772640", "Moiynkumsky\ District",
"772642", "Moiynkum",
"771545", "Zhambylsky\ District",
"771845", "Pavlodar\ Area",
"772144", "Kiyevka",
"7302", "Chita",
"77149", "Kostanai",
"772778", "Chundzha",
"772237", "Ayagoz",
"772779", "Narynkol",
"772252", "Karaul",
"7841", "Penza",
"7878", "Karachayevo\-Cherkessian\ Republic",
"77213", "Aktau\/Temirtau",
"772633", "Asa",
"772345", "Shar",
"772771", "Kaskelen",
"771347", "Aitekebisky\ District",
"771646", "Makinsk",
"771453", "Auliekol",
"772538", "Turara\ Ryskulova",
"772838", "Balpyk\ bi",
"771447", "Karabalyksky\ District",
"7471", "Kursk",
"772539", "Kazygurt",
"771143", "Akzhaik",
"7492", "Vladimir",
"772839", "Sarkand",
"771431", "Rudny",
"7861", "Krasnodar\ Territory",
"771331", "Martuk",
"77122", "Atyrau",
"7347", "Republic\ of\ Bashkortostan",
"771235", "Dossor",
"772831", "Zharkent",
"77125", "Atyrau\ Region",
"772531", "Aksukent",
"7382", "Tomsk",
"771339", "Komsomolskoye",
"771439", "Torgai",
"771130", "Peremetnoye",
"772547", "Lenger",
"771132", "Fyodorovka",
"771438", "Amangeldy",
"7343", "Ekaterinburg",
"772251", "Kurchatov",
"772344", "Akzhar",
"7416", "Amur\ Region",
"7499", "Moscow",
"771536", "Taiynsha",
"771836", "Sharbakty",
"772154", "Botakara",
"772725", "Otegen\ Batyra",
"771036", "Balkhash",
"772772", "Kapchagai",
"772770", "Uzynagash",
"77273", "Almaty",
"7844", "Volgograd",
"772641", "Akkol",
"7843", "Republic\ of\ Tatarstan",
"772336", "Ridder",
"772637", "Sarykemer",
"772436", "Terenozek",
"771544", "Presnovka",
"7847", "Republic\ of\ Kalmykia",
"771844", "Irtyshsky\ District",
"7842", "Ulyanovsk",
"772342", "Katon\-Karagai",
"772148", "Molodezhnoye",
"772340", "Zaisan",
"771833", "Terenkol",
"772149", "Osakarovka",
"7411", "Republic\ of\ Sakha",
"771533", "Saumalkol",
"771033", "Agadyr",
"772236", "Beskaragai",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"772759", "Almaty\ Region",
"772774", "Talgar",
"771040", "Zhairem\ \(GOK\)",
"771042", "Zharyk",
"772351", "Borodulikha",
"7301", "Republic\ of\ Buryatia",
"772433", "Aralsk",
"772333", "Samarskoye",
"771842", "Koktobe",
"771840", "Bayanaul",
"771540", "Kishkenekol",
"771542", "Kishkenekol",
"772137", "Saran",
"7821", "Komi\ Republic",
"77282", "Taldykorgan",
"7395", "Irkutsk",
"7855", "Naberezhnye\ Chelny",
"77252", "Shymkent",
"771643", "Atbasar",
"771456", "Kachar",
"771435", "Zhitikara",
"77135", "Aktobe\ Region",
"771335", "Shalkar",
"771146", "Akzhaiksky\ District",
"7384", "Kemerovo",
"771239", "Makat",
"7383", "Novosibirsk",
"7834", "Republic\ of\ Mordovia",
"7342", "Perm",
"771238", "Miyaly",
"7833", "Kirov",
"7866", "Kabardino\-Balkarian\ Republic",
"7390", "Republic\ of\ Khakassia",
"7494", "Kostroma",
"772835", "Tekeli",
"771231", "Akkystau",
"771630", "Burabay",
"772535", "Shardara",
"771632", "Zerenda",
"77142", "Kostanai",
"7485", "Yaroslavl",
"771134", "Zhympity",
"77132", "Aktobe\/Kargalinskoye",
"772644", "Karatau",
"771041", "Aktau\,\ Zhezkazgan",
"7413", "Magadan",
"771837", "Aksu",
"772159", "Karaganda\ Region",
"772348", "Kokpekty",
"771537", "Timiryazevo",
"771037", "Aktogai",
"771541", "Mamlutka",
"772752", "Otegen\ Batyra",
"771841", "Aktogai",
"7846", "Samara",
"772341", "Ulken\ Naryn",
"772775", "Esik",
"772437", "Zhosaly",
"740", "Kaliningrad",
"772337", "Serebryansk",
"772636", "Kordai",
"7869", "Sevastopol",
"771446", "Uzunkolsky\ District",
"771346", "Shubarkuduk",
"771135", "Zhanibek",
"771647", "Esil",
"772834", "Ushtobe",
"772534", "Zhetysai",
"77272983", "Kaskelen",
"771631", "Shortandy",
"771232", "Atyrau\ Region",
"7831", "Nizhni\ Novgorod",
"771230", "Atyrau\ Region",
"7381", "Omsk",
"7491", "Ryazan",
"7472", "Belgorod",
"7815", "Murmansk",
"771434", "Denisovka",
"7712303", "Tengizs",
"771639", "Stepnyak",
"77112", "Uralsk",
"7818", "Arkhangelsk",
"771334", "Emba",
"7346", "Surgut",
"7862", "Sochi",
"772546", "Sholakkorgan",
"771638", "Akkol",};
$areanames{ru} = {"733", "Байконыр",
"771149", "Акжаикский\ р\-н",
"772533", "Туркестан",
"7421", "Хабаровский\ край",
"771458", "Костанайская\ область",
"772833", "Алакольский\ р\-н",
"771459", "Костанайская\ область",
"771342", "Каргалинский\ р\-н",
"771340", "Хобдинский\ р\-н",
"771442", "Федоровский\ р\-н",
"771440", "Амангельдинский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"771236", "Махамбетский\ р\-н",
"771141", "Жангалинский\ р\-н",
"7353", "Оренбургская\ обл\.",
"7712302", "Тенгизшевройл",
"771451", "Сарыкольский\ р\-н",
"772540", "Арыс",
"771645", "Степногорск",
"771137", "Чингирлауский\ р\-н",
"772542", "Асыката",
"772842", "Кербулакский\ р\-н",
"772840", "Кербулакский\ р\-н",
"771333", "Мугалжарский\ р\-н",
"771433", "Лисаковск",
"772931", "Мангистауский\ р\-н",
"77245", "Кызылординская\ область",
"772335", "Зыряновск",
"772146", "Каркаралинск",
"772435", "Жанакорганский\ р\-н",
"77152", "Петропавловск",
"7484", "Калужская\ обл\.",
"772643", "Шуский\ р\-н",
"7483", "Брянская\ обл\.",
"7811", "Псковская\ обл\.",
"77182", "Павлодар",
"772777", "Райымбекский\ р\-н",
"77102", "Жезказган",
"7487", "Тульская\ обл\.",
"7495", "Московская\ обл\.",
"772239", "Урджарский\ р\-н",
"7498", "Московская\ обл\.",
"7385", "Алтайский\ край",
"771035", "Улытауский\ р\-н",
"7388", "Республика\ Алтай",
"77272", "Алма\-Ата",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"7394", "Республика\ Тыва",
"77232", "Усть\-Каменогорск",
"77242", "Кызылорда",
"77185", "Шалдай",
"772632", "Меркенский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"771140", "Бокейординский\ р\-н",
"771348", "Шалкарский\ р\-н",
"772537", "Сарыагаш",
"771142", "Акжаикский\ р\-н",
"772837", "Алакольский\ р\-н",
"771448", "Карасуский\ р\-н",
"7423", "Приморский\ край",
"771644", "Аршалынский\ р\-н",
"771452", "Карасуский\ р\-н",
"771349", "Шалкарский\ р\-н",
"7424", "Сахалинская\ обл\.",
"771449", "Тарановский\ р\-н",
"7427", "Чукотский\ АО",
"772841", "Аксуский\ р\-н",
"772541", "Мырзакент",
"772932", "Бейнеуский\ р\-н",
"7351", "Челябинская\ обл\.",
"7872", "Республика\ Дагестан",
"771441", "Карабалыкский\ р\-н",
"771341", "Хобдинский\ р\-н",
"771133", "Бурлинский\ р\-н",
"7415", "Камчатский\ край",
"771337", "Алгинский\ р\-н",
"771636", "Щучинский\ р\-н",
"772548", "Шаян",
"771437", "Камыстинский\ р\-н",
"771534", "Шал\ Акына\ р\-н",
"7814", "Республика\ Карелия",
"772156", "Шахтинск",
"7481", "Смоленская\ обл\.",
"771834", "Успенский\ р\-н",
"7813", "Ленинградская\ обл\.",
"772346", "Тарбагатайский\ р\-н",
"772773", "Балхашский\ р\-н",
"77274", "Карасайский\ р\-н",
"772230", "Урджарский\ р\-н",
"771034", "Улытауский\ р\-н",
"7817", "Вологодская\ обл\.",
"772631", "Турара\ Рыскулова\ р\-н",
"7820", "Вологодская\ обл\.",
"7879", "Ставропольский\ край",
"772257", "Шульбинск",
"772638", "Шуский\ р\-н",
"771546", "Акжарский\ р\-н",
"77212", "Караганда",
"772639", "Сарысуский\ р\-н",
"7851", "Астраханская\ обл\.",
"772334", "Уланский\ р\-н",
"7391", "Красноярский\ край",
"772153", "Абайский\ р\-н",
"771832", "Иртышский\ р\-н",
"772147", "Каркаралинский\ р\-н",
"771532", "Аккайынский\ р\-н",
"772635", "Жуалынский\ р\-н",
"7486", "Орловская\ обл\.",
"772343", "Курчумский\ р\-н",
"772131", "Абайский\ р\-н",
"772757", "Акший",
"772776", "Енбекшиказахский\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"771032", "Каражал",
"7812", "г\.\ Санкт\-Петербург",
"77224", "Эмельтау",
"771043", "Жайрем\ \(поселок\)",
"7865", "Ставропольский\ край",
"771843", "Майский\ р\-н",
"77262", "Тараз",
"7475", "Тамбовская\ обл\.",
"771543", "Есильский\ р\-н",
"772432", "Шиелийский\ р\-н",
"77187", "Экибастуз",
"772332", "Шемонаихинский\ р\-н",
"772138", "Бухар\-Жырауский\ р\-н",
"772330", "Зыряновский\ р\-н",
"7873", "Республика\ Ингушетия",
"771144", "Казталовский\ р\-н",
"736", "Республика\ Крым",
"771640", "Сандыктауский\ р\-н",
"771454", "Наурзумский\ р\-н",
"772545", "Икан",
"771642", "Егиндыкольский\ р\-н",
"77279", "Алматы",
"7877", "Республика\ Адыгея",
"771237", "Жылыойский\ р\-н",
"772934", "Жанаозен",
"771651", "Целиноградский\ р\-н",
"771445", "Алтынсаринский\ р\-н",
"771345", "Байганинский\ р\-н",
"771136", "Акжаикский\ р\-н",
"771633", "Ерейментауский\ р\-н",
"7816", "Новгородская\ обл\.",
"771839", "Лебяжинский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"77272956", "Талгар",
"771838", "Майский\ р\-он",
"7345", "Тюменская\ обл\.",
"772353", "Бородулихинский\ р\-н",
"772347", "Жарминский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"771038", "Сыры\-Шаган",
"77222", "Семипалатинск",
"771039", "Приозерск",
"772331", "Глубоковский\ р\-н",
"772431", "Жалагашский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"771831", "Железинский\ р\-н",
"7482", "Тверская\ обл\.",
"772256", "Алгабас",
"772438", "Казалинский\ р\-н",
"772338", "Уланский\ р\-н",
"772132", "Нуринский\ р\-н",
"771547", "Жамбылский\ р\-н",
"772439", "Аральский\ р\-н",
"772634", "Жанатас",
"771031", "Шетский\ р\-н",
"772339", "Курчумский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"772536", "Кентау",
"771648", "Жаркаинский\ р\-н",
"7871", "Республика\ Чеченская",
"771444", "Узункольский\ р\-н",
"771649", "Жаксынский\ р\-н",
"77106", "Сатпаев",
"7426", "Еврейская\ автономная\ обл\.",
"77145834", "Красногорск",
"7352", "Курганская\ обл\.",
"7845", "Саратовская\ обл\.",
"77292", "Актау",
"7848", "Самарская\ обл\.",
"771233", "Курмангазинский\ р\-н",
"772935", "Каракиянский\ р\-н",
"771641", "Астраханский\ р\-н",
"772544", "Шаульдер",
"771455", "Костанайский\ р\-н",
"771436", "Тарановский\ р\-н",
"771336", "Хромтауский\ р\-н",
"771145", "Каратобинский\ р\-н",
"771637", "Коргалжынский\ р\-н",
"772252", "Абайский\ р\-н",
"7841", "Пензенская\ обл\.",
"772633", "Жамбылский\ р\-н",
"7878", "Республика\ Карачаево\-Черкесская",
"77213", "Темиртау",
"772345", "Жарминский\ р\-н",
"772771", "Карасайский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"771545", "Жамбылский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"771845", "Павлодар",
"77149", "Костанай",
"772144", "Нуринский\ р\-н",
"7302", "Забайкальский\ край",
"772237", "Аязог",
"772778", "Уйгурский\ р\-н",
"772779", "Райымбекский\ р\-н",
"7496", "г\.\ Москва",
"771330", "Хромтауский\ р\-н",
"771138", "Казталовский\ р\-н",
"771332", "Уилский\ р\-н",
"771430", "Аркалык",
"7341", "Республика\ Удмуртская",
"772543", "Аксумбе",
"77162", "Кокшетау",
"771139", "Таскалинский\ р\-н",
"772843", "Лепсы",
"771457", "Джангильдинский\ р\-н",
"7473", "Воронежская\ обл\.",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"771343", "Иргизский\ р\-н",
"7474", "Липецкая\ обл\.",
"771443", "Мендыкаринский\ р\-н",
"771635", "Жаксынский\ р\-н",
"771147", "Акжаикский\ р\-н",
"772532", "Абая",
"772530", "Темирлановка",
"772830", "Алакольский\ р\-н",
"772832", "Аксуский\ р\-н",
"772937", "Каракиянский\ р\-н",
"771234", "Индерский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"7863", "Ростовская\ обл\.",
"7717", "Астана",
"771131", "Зеленовский\ р\-н",
"7844", "Волгоградская\ обл\.",
"77273", "Алма\-Ата",
"7843", "Республика\ Татарстан",
"772641", "Таласский\ р\-н",
"772637", "Байзакский\ р\-н",
"772336", "Риддер",
"772436", "Сырдарьинский\ р\-н",
"771544", "Жамбылский\ р\-н",
"771844", "Иртышский\ р\-н",
"7847", "Республика\ Калмыкия",
"772344", "Тарбагатайский\ р\-н",
"7416", "Амурская\ обл\.",
"772251", "Курчатов",
"771536", "Тайыншинский\ р\-н",
"7499", "г\.\ Москва",
"772154", "Бухар\-Жырауский\ р\-н",
"771836", "Щербактинский\ р\-н",
"772725", "Отеген\-Батыр",
"771036", "Балхаш",
"772770", "Жамбылский\ р\-н",
"772772", "Капчагай",
"7347", "Республика\ Башкортостан",
"772831", "Панфиловский\ р\-н",
"771235", "Макатский\ р\-н",
"77125", "Атырауская\ область",
"772531", "Аксукент",
"7382", "Томская\ обл\.",
"771339", "Айтекебийский\ р\-н",
"771439", "Джангильдинский\ р\-н",
"772547", "Ленгер",
"771132", "Теректинский\ р\-н",
"771130", "Зеленовский\ р\-н",
"7343", "Свердловская\ обл",
"771438", "Амангельдинский\ р\-н",
"771646", "Буландинский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"771347", "Айтекебийский\ р\-н",
"772838", "Коксуский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"771143", "Теректинский\ р\-н",
"7492", "Владимирская\ обл\.",
"7471", "Курская\ обл\.",
"772539", "Казыгурт",
"772839", "Саркандский\ р\-н",
"771431", "Рудный",
"7861", "Краснодарский\ край",
"771331", "Мартукский\ р\-н",
"77122", "Атырау",
"7494", "Костромская\ обл\.",
"7493", "Ивановская\ обл\.",
"771231", "Исатайский\ р\-н",
"772835", "Текели",
"772535", "Шардара",
"771632", "Зерендинский\ р\-н",
"771630", "Боровое",
"77142", "Костанай",
"7485", "Ярославская\ обл\.",
"77132", "Актобе\/Актюбинск",
"771134", "Сырымский\ р\-н",
"77282", "Талдыкорган",
"7395", "Иркутская\ обл\.",
"7821", "Республика\ Коми",
"771643", "Атбасарский\ р\-н",
"771456", "Качар",
"7855", "Республика\ Татарстан",
"77252", "Шымкент",
"771435", "Житикаринский\ р\-н",
"77135", "Актюбинская\ область",
"771146", "Акжаикский\ р\-н",
"771335", "Шалкарский\ р\-н",
"7384", "Кемеровская\ обл\.",
"771239", "Макатский\ р\-н",
"7383", "Новосибирская\ обл\.",
"7834", "Республика\ Мордовия",
"7342", "Пермский\ край",
"7833", "Кировская\ обл\.",
"7390", "Республика\ Хакасия",
"7866", "Республика\ Кабардино\-Балкарская",
"771238", "Кзылкогинский\ р\-н",
"771042", "Акой",
"771040", "Жайрем\ \(ГОК\)",
"7301", "Республика\ Бурятия",
"772351", "Бородулихинский\ р\-н",
"772433", "Аральский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"771840", "Баянаульский\ р\-н",
"771842", "Майский\ р\-он",
"772137", "Сарань",
"771542", "Уалихановский\ р\-н",
"771540", "Уалихановский\ р\-н",
"7842", "Ульяновская\ обл\.",
"772148", "Осакаровский\ р\-н",
"772340", "Зайсанский\ р\-н",
"772342", "Катон\-Карагайский\ р\-н",
"771833", "Качирский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"771533", "Айыртауский\ р\-н",
"772149", "Осакаровский\ р\-н",
"771033", "Шетский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"772759", "Алматинская\ область",
"7349", "Ямало\-Ненецкий\ АО",
"772774", "Талгарский\ р\-н",
"7472", "Белгородская\ обл\.",
"7491", "Рязанская\ обл\.",
"771434", "Денисовский\ р\-н",
"7712303", "Тензиз",
"7815", "Мурманская\ обл\.",
"7818", "Архангельская\ обл\.",
"771334", "Мугалжарский\ р\-н",
"77112", "Уральск",
"771639", "Енбекшилдерский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"772546", "Шолаккорган",
"771638", "Аккольский\ р\-н",
"7862", "Краснодарский\ край",
"771446", "Узункольский\ р\-н",
"771135", "Жанибекский\ р\-н",
"771647", "Есильский\ р\-н",
"771346", "Темирский\ р\-н",
"772834", "Каратальский\ р\-н",
"772534", "Жетысай",
"771631", "Шортандинский\ р\-н",
"77272983", "Каскелен",
"771230", "Атырауская\ область",
"771232", "Атырауская\ область",
"7831", "Нижегородская\ обл\.",
"7381", "Омская\ обл\.",
"772341", "Катон\-Карагайский\ р\-н",
"7846", "Самарская\ обл\.",
"772775", "Енбекшиказахский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"740", "Калининградская\ обл\.",
"772636", "Кордай",
"772337", "Серебрянск",
"7869", "г\.\ Севастополь",
"772644", "Таласский\ р\-н",
"7413", "Магаданская\ обл\.",
"771041", "Актау\,\ Жезказган",
"772159", "Карагандинская\ область",
"771837", "Аксуский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"771037", "Актогайский\ р\-н",
"771541", "Мамлютский\ р\-н",
"772752", "Илийский\ р\-н",
"771841", "Актогайский\ р\-н",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;