# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230113181719;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '575',
                  'pattern' => '(\\d{7})'
                },
                {
                  'format' => '$1',
                  'leading_digits' => '
            5(?:
              0|
              2(?:
                21|
                3
              )|
              3(?:
                0|
                3[23]
              )|
              616|
              717|
              8888
            )
          ',
                  'pattern' => '(\\d{8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1800',
                  'pattern' => '(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '140',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            11|
            2[02]|
            33|
            4[04]|
            79(?:
              [124-6]|
              3(?:
                [02-9]|
                1[0-24-9]
              )|
              7(?:
                1|
                9[1-6]
              )
            )|
            80(?:
              [2-4]|
              6[0-589]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              2[0-24]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[1-9]|
              7[1257]|
              8[1-57-9]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[058]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[1-3]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[0-24-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12(?:
                [2-6]|
                7[0-8]
              )|
              74[2-7]
            )|
            7(?:
              (?:
                2[14]|
                5[15]
              )[2-6]|
              3171|
              61[346]|
              88(?:
                [2-7]|
                82
              )
            )|
            8(?:
              70[2-6]|
              84(?:
                [2356]|
                7[19]
              )|
              91(?:
                [3-6]|
                7[19]
              )
            )|
            73[134][2-6]|
            (?:
              74[47]|
              8(?:
                16|
                2[014]|
                3[126]|
                6[136]|
                7[78]|
                83
              )
            )(?:
              [2-6]|
              7[19]
            )|
            (?:
              1(?:
                29|
                60|
                8[06]
              )|
              261|
              552|
              6(?:
                [2-4]1|
                5[17]|
                6[13]|
                7(?:
                  1|
                  4[0189]
                )|
                80
              )|
              7(?:
                12|
                88[01]
              )
            )[2-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              [2-479]|
              5(?:
                [0236-9]|
                5[013-9]
              )
            )|
            [2-5]|
            6(?:
              2(?:
                84|
                95
              )|
              355|
              83
            )|
            73179|
            807(?:
              1|
              9[1-3]
            )|
            (?:
              1552|
              6(?:
                1[1358]|
                2[2457]|
                3[2-4]|
                4[235-7]|
                5[2-689]|
                6[24578]|
                7[235689]|
                8[124-6]
              )\\d|
              7(?:
                1(?:
                  [013-8]\\d|
                  9[6-9]
                )|
                28[6-8]|
                3(?:
                  2[0-49]|
                  9[2-57]
                )|
                4(?:
                  1[2-4]|
                  [29][0-7]|
                  3[0-8]|
                  [56]\\d|
                  8[0-24-7]
                )|
                5(?:
                  2[1-3]|
                  9[0-6]
                )|
                6(?:
                  0[5689]|
                  2[5-9]|
                  3[02-8]|
                  4\\d|
                  5[0-367]
                )|
                70[13-7]
              )
            )[2-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[6-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6|
              8[06]0
            )
          ',
                  'pattern' => '(\\d{4})(\\d{2,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '18',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2717(?:
            [2-7]\\d|
            95
          )\\d{4}|
          (?:
            271[0-689]|
            782[0-6]
          )[2-7]\\d{5}|
          (?:
            170[24]|
            2(?:
              (?:
                [02][2-79]|
                90
              )\\d|
              80[13468]
            )|
            (?:
              3(?:
                23|
                80
              )|
              683|
              79[1-7]
            )\\d|
            4(?:
              20[24]|
              72[2-8]
            )|
            552[1-7]
          )\\d{6}|
          (?:
            11|
            33|
            4[04]|
            80
          )[2-7]\\d{7}|
          (?:
            342|
            674|
            788
          )(?:
            [0189][2-7]|
            [2-7]\\d
          )\\d{5}|
          (?:
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[014]|
              7[1257]|
              8[01346]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[13]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[014-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          )[2-7]\\d{6}|
          (?:
            1(?:
              2[35-8]|
              3[346-9]|
              4[236-9]|
              [59][0235-9]|
              6[235-9]|
              7[34689]|
              8[257-9]
            )|
            2(?:
              1[134689]|
              3[24-8]|
              4[2-8]|
              5[25689]|
              6[2-4679]|
              7[3-79]|
              8[2-479]|
              9[235-9]
            )|
            3(?:
              01|
              1[79]|
              2[1245]|
              4[5-8]|
              5[125689]|
              6[235-7]|
              7[157-9]|
              8[2-46-8]
            )|
            4(?:
              1[14578]|
              2[5689]|
              3[2-467]|
              5[4-7]|
              6[35]|
              73|
              8[2689]|
              9[2389]
            )|
            5(?:
              [16][146-9]|
              2[14-8]|
              3[1346]|
              4[14-69]|
              5[46]|
              7[2-4]|
              8[2-8]|
              9[246]
            )|
            6(?:
              1[1358]|
              2[2457]|
              3[2-4]|
              4[235-7]|
              5[2-689]|
              6[24578]|
              7[235689]|
              8[124-6]
            )|
            7(?:
              1[013-9]|
              2[0235-9]|
              3[2679]|
              4[1-35689]|
              5[2-46-9]|
              [67][02-9]|
              8[013-7]|
              9[089]
            )|
            8(?:
              1[1357-9]|
              2[235-8]|
              3[03-57-9]|
              4[0-24-9]|
              5\\d|
              6[2457-9]|
              7[1-6]|
              8[1256]|
              9[2-4]
            )
          )\\d[2-7]\\d{5}
        ',
                'geographic' => '
          2717(?:
            [2-7]\\d|
            95
          )\\d{4}|
          (?:
            271[0-689]|
            782[0-6]
          )[2-7]\\d{5}|
          (?:
            170[24]|
            2(?:
              (?:
                [02][2-79]|
                90
              )\\d|
              80[13468]
            )|
            (?:
              3(?:
                23|
                80
              )|
              683|
              79[1-7]
            )\\d|
            4(?:
              20[24]|
              72[2-8]
            )|
            552[1-7]
          )\\d{6}|
          (?:
            11|
            33|
            4[04]|
            80
          )[2-7]\\d{7}|
          (?:
            342|
            674|
            788
          )(?:
            [0189][2-7]|
            [2-7]\\d
          )\\d{5}|
          (?:
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[014]|
              7[1257]|
              8[01346]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[13]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[014-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          )[2-7]\\d{6}|
          (?:
            1(?:
              2[35-8]|
              3[346-9]|
              4[236-9]|
              [59][0235-9]|
              6[235-9]|
              7[34689]|
              8[257-9]
            )|
            2(?:
              1[134689]|
              3[24-8]|
              4[2-8]|
              5[25689]|
              6[2-4679]|
              7[3-79]|
              8[2-479]|
              9[235-9]
            )|
            3(?:
              01|
              1[79]|
              2[1245]|
              4[5-8]|
              5[125689]|
              6[235-7]|
              7[157-9]|
              8[2-46-8]
            )|
            4(?:
              1[14578]|
              2[5689]|
              3[2-467]|
              5[4-7]|
              6[35]|
              73|
              8[2689]|
              9[2389]
            )|
            5(?:
              [16][146-9]|
              2[14-8]|
              3[1346]|
              4[14-69]|
              5[46]|
              7[2-4]|
              8[2-8]|
              9[246]
            )|
            6(?:
              1[1358]|
              2[2457]|
              3[2-4]|
              4[235-7]|
              5[2-689]|
              6[24578]|
              7[235689]|
              8[124-6]
            )|
            7(?:
              1[013-9]|
              2[0235-9]|
              3[2679]|
              4[1-35689]|
              5[2-46-9]|
              [67][02-9]|
              8[013-7]|
              9[089]
            )|
            8(?:
              1[1357-9]|
              2[235-8]|
              3[03-57-9]|
              4[0-24-9]|
              5\\d|
              6[2457-9]|
              7[1-6]|
              8[1256]|
              9[2-4]
            )
          )\\d[2-7]\\d{5}
        ',
                'mobile' => '
          (?:
            61279|
            7(?:
              887[02-9]|
              9(?:
                313|
                79[07-9]
              )
            )|
            8(?:
              079[04-9]|
              (?:
                84|
                91
              )7[02-8]
            )
          )\\d{5}|
          (?:
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )[0189]|
            7(?:
              1(?:
                2[0189]|
                9[0-5]
              )|
              2(?:
                [14][017-9]|
                8[0-59]
              )|
              3(?:
                2[5-8]|
                [34][017-9]|
                9[016-9]
              )|
              4(?:
                1[015-9]|
                [29][89]|
                39|
                8[389]
              )|
              5(?:
                [15][017-9]|
                2[04-9]|
                9[7-9]
              )|
              6(?:
                0[0-47]|
                1[0-257-9]|
                2[0-4]|
                3[19]|
                5[4589]
              )|
              70[0289]|
              88[089]|
              97[02-8]
            )|
            8(?:
              0(?:
                6[67]|
                7[02-8]
              )|
              70[017-9]|
              84[01489]|
              91[0-289]
            )
          )\\d{6}|
          (?:
            7(?:
              31|
              4[47]
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[78]|
              83
            )
          )(?:
            [0189]\\d|
            7[02-8]
          )\\d{5}|
          (?:
            6(?:
              [09]\\d|
              1[04679]|
              2[03689]|
              3[05-9]|
              4[0489]|
              50|
              6[069]|
              7[07]|
              8[7-9]
            )|
            7(?:
              0\\d|
              2[0235-79]|
              3[05-8]|
              40|
              5[0346-8]|
              6[6-9]|
              7[1-9]|
              8[0-79]|
              9[089]
            )|
            8(?:
              0[01589]|
              1[0-57-9]|
              2[235-9]|
              3[03-57-9]|
              [45]\\d|
              6[02457-9]|
              7[1-69]|
              8[0-25-9]|
              9[02-9]
            )|
            9\\d\\d
          )\\d{7}|
          (?:
            6(?:
              (?:
                1[1358]|
                2[2457]|
                3[2-4]|
                4[235-7]|
                5[2-689]|
                6[24578]|
                8[124-6]
              )\\d|
              7(?:
                [235689]\\d|
                4[0189]
              )
            )|
            7(?:
              1(?:
                [013-8]\\d|
                9[6-9]
              )|
              28[6-8]|
              3(?:
                2[0-49]|
                9[2-5]
              )|
              4(?:
                1[2-4]|
                [29][0-7]|
                3[0-8]|
                [56]\\d|
                8[0-24-7]
              )|
              5(?:
                2[1-3]|
                9[0-6]
              )|
              6(?:
                0[5689]|
                2[5-9]|
                3[02-8]|
                4\\d|
                5[0-367]
              )|
              70[13-7]|
              881
            )
          )[0189]\\d{5}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(1860\\d{7})|(186[12]\\d{9})|(140\\d{7})',
                'toll_free' => '
          000800\\d{7}|
          1(?:
            600\\d{6}|
            80(?:
              0\\d{4,9}|
              3\\d{9}
            )
          )
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"918814", "Eluru\ Narsapur\/Palakole\,\ Andhra\ Pradesh",
"9168184", "Buguda\,\ Odisha",
"911482", "Bhilwara\,\ Rajasthan",
"9189465", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"911998", "Ramban\,\ Jammu\ And\ Kashmir",
"9174808", "Goharganj\,\ Madhya\ Pradesh",
"9174267", "Sitamau\,\ Madhya\ Pradesh",
"9163274", "Rafiganj\,\ Bihar",
"915442", "Mirzapur\,\ Uttar\ Pradesh",
"918426", "Telgi\,\ Karnataka",
"9173228", "Depalpur\,\ Madhya\ Pradesh",
"9161827", "Arrah\,\ Bihar",
"912848", "Palitana\,\ Gujarat",
"9167297", "Pattamundai\,\ Odisha",
"9162535", "Narkatiaganj\,\ Bihar",
"917843", "Durgakondal\,\ Madhya\ Pradesh",
"9164217", "Naugachia\,\ Bihar",
"9174815", "Gairatganj\,\ Madhya\ Pradesh",
"9164386", "Madhupur\,\ Bihar",
"9167407", "Bhubaneshwar\,\ Odisha",
"9171485", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"912822", "Morvi\,\ Gujarat",
"9167236", "Athgarh\,\ Odisha",
"912580", "Jamner\,\ Maharashtra",
"9166547", "Sonapur\,\ Odisha",
"915733", "Pahasu\,\ Uttar\ Pradesh",
"9161876", "Mohania\,\ Bihar",
"918505", "Kodangal\,\ Andhra\ Pradesh",
"917516", "Gwalior\,\ Madhya\ Pradesh",
"9165425", "Bokaro\,\ Bihar",
"911978", "Bilaspur\,\ Himachal\ Pradesh",
"9171723", "Chandrapur\,\ Maharashtra",
"91260", "Vapi\,\ Gujarat",
"9162292", "Bidupur\,\ Bihar",
"918840", "Kakinada\,\ Andhra\ Pradesh",
"9177039", "Manpur\,\ Madhya\ Pradesh",
"9171572", "Arvi\,\ Maharashtra",
"914885", "Kunnamkulam\,\ Kerala",
"9174569", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"918829", "Bhimadole\,\ Andhra\ Pradesh",
"916743", "Bhubaneshwar\,\ Odisha",
"91476", "Karunagapally\,\ Kerala",
"9165844", "Bishrampur\,\ Bihar",
"917779", "Ramchandrapur\,\ Madhya\ Pradesh",
"918588", "Vaimpalli\,\ Andhra\ Pradesh",
"9171363", "Etapalli\,\ Maharashtra",
"9165285", "Khunti\,\ Bihar",
"9165916", "Chandil\,\ Bihar",
"9174923", "Shivpuri\,\ Madhya\ Pradesh",
"913552", "Kalimpong\,\ West\ Bengal",
"917664", "Hanumana\,\ Madhya\ Pradesh",
"9174338", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9161865", "Aurangabad\,\ Bihar",
"9171183", "Kalmeshwar\,\ Maharashtra",
"914862", "Thodupuzha\,\ Kerala",
"915142", "Purwa\/Bighapur\,\ Uttar\ Pradesh",
"9174225", "Mandsaur\,\ Madhya\ Pradesh",
"9176537", "Bandhavgarh\,\ Madhya\ Pradesh",
"911374", "Bhatwari\/Uttarkashi\,\ Uttarakhand",
"918373", "Ranebennur\,\ Karnataka",
"917390", "Thandla\,\ Madhya\ Pradesh",
"9171815", "Lakhandur\,\ Maharashtra",
"9167314", "Anandapur\,\ Odisha",
"9175966", "Gyraspur\,\ Madhya\ Pradesh",
"911421", "Kotputli\,\ Rajasthan",
"912923", "Phalodi\/Lohawat\,\ Rajasthan",
"9163497", "Jhajha\,\ Bihar",
"9168196", "Surada\,\ Odisha",
"9164313", "Jharmundi\,\ Bihar",
"913639", "Baghmara\,\ Meghalaya",
"9165467", "Hazaribagh\,\ Bihar",
"9174572", "Mangrol\,\ Rajasthan",
"913243", "Khatra\,\ West\ Bengal",
"915834", "Bisauli\,\ Uttar\ Pradesh",
"9173937", "Jobat\,\ Madhya\ Pradesh",
"917370", "Khilchipur\,\ Madhya\ Pradesh",
"918393", "Kurugodu\,\ Karnataka",
"918713", "Parkal\,\ Andhra\ Pradesh",
"918537", "Lingsugur\,\ Karnataka",
"911465", "Thanaghazi\,\ Rajasthan",
"9174363", "Hindoli\,\ Rajasthan",
"917744", "Rajandgaon\,\ Madhya\ Pradesh",
"918541", "Achampet\,\ Andhra\ Pradesh",
"9181700", "Alur\,\ Karnataka",
"917270", "Sonkatch\,\ Madhya\ Pradesh",
"9175290", "Laher\,\ Madhya\ Pradesh",
"9165577", "Bagodar\,\ Bihar",
"917684", "Baldeogarh\,\ Madhya\ Pradesh",
"915614", "Jarar\,\ Uttar\ Pradesh",
"91816", "Tumkur\,\ Karnataka",
"9167492", "Bhubaneshwar\,\ Odisha",
"9164627", "Dhamdaha\,\ Bihar",
"912646", "Ankleshwar\,\ Gujarat",
"9174513", "Atru\,\ Rajasthan",
"9161882", "Rohtas\,\ Bihar",
"9171615", "Parasia\,\ Madhya\ Pradesh",
"9171753", "Bhadrawati\,\ Maharashtra",
"9164372", "Mahagama\,\ Bihar",
"9164676", "Banmankhi\,\ Bihar",
"914549", "Thirumanglam\,\ Tamil\ Nadu",
"9165455", "Mandu\,\ Bihar",
"918502", "Alampur\,\ Andhra\ Pradesh",
"917290", "Badwani\,\ Madhya\ Pradesh",
"911274", "Rewari\,\ Haryana",
"9171586", "Deoli\,\ Maharashtra",
"914346", "Harur\,\ Tamil\ Nadu",
"9177005", "Nagri\,\ Madhya\ Pradesh",
"915640", "Kaman\,\ Rajasthan",
"912825", "Gondal\,\ Gujarat",
"912766", "Patan\,\ Gujarat",
"9171044", "Hingua\,\ Maharashtra",
"914257", "Kangeyam\,\ Tamil\ Nadu",
"9161857", "Bikramganj\,\ Bihar",
"9168593", "Motu\,\ Odisha",
"915445", "Robertsganj\/Obra\,\ Uttar\ Pradesh",
"9174594", "Ramganj\ Mandi\,\ Rajasthan",
"911485", "Jahazpur\,\ Rajasthan",
"9177018", "Pingeshwar\,\ Madhya\ Pradesh",
"9167564", "Balugaon\,\ Odisha",
"913824", "Kailsahar\,\ Tripura",
"9162436", "Begusarai\,\ Bihar",
"9174608", "Sahabad\,\ Rajasthan",
"9174930", "Karera\,\ Madhya\ Pradesh",
"911462", "Beawar\,\ Rajasthan",
"91224", "Mumbai",
"9164665", "Kishanganj\,\ Bihar",
"9165504", "Hunterganj\,\ Bihar",
"9161563", "Gopalganj\,\ Bihar",
"9171462", "Ghorandogri\,\ Madhya\ Pradesh",
"9174615", "Mahuwa\,\ Rajasthan",
"915853", "Shahabad\,\ Uttar\ Pradesh",
"9171513", "Samudrapur\,\ Maharashtra",
"912560", "Kusumba\,\ Maharashtra",
"9174319", "Aklera\,\ Rajasthan",
"914574", "Manamadurai\,\ Tamil\ Nadu",
"917224", "Daryapur\,\ Maharashtra",
"9177043", "Deobhog\,\ Madhya\ Pradesh",
"9174586", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"915566", "Salempur\,\ Uttar\ Pradesh",
"9165262", "Lohardaga\,\ Bihar",
"913870", "Ukhrursouth\/Kassemkhulen\,\ Manipur",
"9176347", "Lamta\,\ Madhya\ Pradesh",
"918634", "Guntur\,\ Andhra\ Pradesh",
"9162747", "Samastipur\,\ Bihar",
"911633", "Muktasar\,\ Punjab",
"912554", "Malegaon\,\ Maharashtra",
"9167942", "Rairangpur\,\ Odisha",
"9174548", "Chhipaborad\,\ Rajasthan",
"9174255", "Garoth\,\ Madhya\ Pradesh",
"914865", "Munnar\,\ Kerala",
"9168695", "Papadhandi\,\ Odisha",
"9176495", "Kakaiya\,\ Madhya\ Pradesh",
"91478", "Cherthala\,\ Kerala",
"9165644", "Nagarutari\,\ Bihar",
"91353", "Siliguri\,\ West\ Bengal",
"9162274", "Mahua\,\ Bihar",
"9166735", "Jayapatna\,\ Odisha",
"9175212", "Seondha\,\ Madhya\ Pradesh",
"9174953", "Badarwas\,\ Madhya\ Pradesh",
"918568", "Pulivendla\,\ Andhra\ Pradesh",
"9181737", "Sakleshpur\,\ Karnataka",
"918190", "Tallak\,\ Karnataka",
"91206", "Pune\,\ Maharashtra",
"9174549", "Chhipaborad\,\ Rajasthan",
"9164333", "Jamtara\,\ Bihar",
"918419", "Yellapur\,\ Karnataka",
"9171343", "Bhamregadh\,\ Maharashtra",
"9167283", "Jajapur\ Town\,\ Odisha",
"913241", "Gangajalghati\,\ West\ Bengal",
"9165864", "Chainpur\,\ Bihar",
"9161803", "Adhaura\,\ Bihar",
"9174974", "Khaniadhana\,\ Madhya\ Pradesh",
"9161146", "Jahanabad\,\ Bihar",
"917514", "Gwalior\,\ Madhya\ Pradesh",
"918391", "Kudligi\,\ Karnataka",
"918711", "Wardhannapet\/Ghanapur\,\ Andhra\ Pradesh",
"918543", "Wanaparthy\,\ Andhra\ Pradesh",
"917326", "Baldi\,\ Madhya\ Pradesh",
"912965", "Kushalgarh\,\ Rajasthan",
"9174136", "Sailana\,\ Madhya\ Pradesh",
"9163376", "Arwal\,\ Bihar",
"9171707", "Chumur\,\ Maharashtra",
"9167826", "Balasore\,\ Odisha",
"9176355", "Lanji\,\ Madhya\ Pradesh",
"9162755", "Rosera\,\ Bihar",
"9165936", "Manoharpur\,\ Bihar",
"9168522", "Koraput\,\ Odisha",
"9163416", "Seikhpura\,\ Bihar",
"9174318", "Aklera\,\ Rajasthan",
"9168117", "Chhatrapur\,\ Odisha",
"9167334", "Ghatgaon\,\ Odisha",
"9174609", "Sahabad\,\ Rajasthan",
"9171835", "Tumsar\,\ Maharashtra",
"918371", "Mundargi\,\ Karnataka",
"9163327", "Nabinagar\,\ Bihar",
"917805", "Singrauli\,\ Madhya\ Pradesh",
"9176517", "Jaisinghnagar\,\ Madhya\ Pradesh",
"918816", "Bhimavaram\,\ Andhra\ Pradesh",
"917540", "Bamori\,\ Madhya\ Pradesh",
"9174305", "Khanpur\,\ Rajasthan",
"9164284", "Nala\,\ Bihar",
"9174247", "Malhargarh\,\ Madhya\ Pradesh",
"918424", "Devarahippargi\,\ Karnataka",
"911423", "Amber\/Chomu\,\ Rajasthan",
"912921", "Phalodi\/Bap\,\ Rajasthan",
"915872", "Kheri\,\ Uttar\ Pradesh",
"912478", "Bhoom\,\ Maharashtra",
"918838", "Rajahmundri\,\ Andhra\ Pradesh",
"9163223", "Wazirganj\,\ Bihar",
"911396", "Jansath\/Khatauli\,\ Uttar\ Pradesh",
"9174907", "Pohari\,\ Madhya\ Pradesh",
"917473", "Bundi\,\ Rajasthan",
"918490", "Pamuru\,\ Andhra\ Pradesh",
"917746", "Manpur\,\ Madhya\ Pradesh",
"913785", "Bameng\,\ Arunachal\ Pradesh",
"9171974", "Mohadi\,\ Maharashtra",
"9175224", "Datia\,\ Madhya\ Pradesh",
"9177019", "Pingeshwar\,\ Madhya\ Pradesh",
"9174343", "Pirawa\/Raipur\,\ Rajasthan",
"918119", "Doddaballapur\,\ Karnataka",
"9165395", "Bolwa\,\ Bihar",
"9165447", "Gomia\,\ Bihar",
"9166853", "Sohela\,\ Odisha",
"915836", "Gunnaur\,\ Uttar\ Pradesh",
"9171136", "Saoner\,\ Maharashtra",
"9163483", "Mallehpur\,\ Bihar",
"916513", "Ranchi\,\ Bihar",
"9167656", "Palla\ Hara\,\ Odisha",
"9167352", "Telkoi\,\ Odisha",
"912982", "Barmer\,\ Rajasthan",
"912830", "Rahpar\,\ Gujarat",
"9164296", "Kahalgaon\,\ Bihar",
"918470", "Afzalpur\,\ Karnataka",
"911376", "Tehri\,\ Uttarakhand",
"9174707", "Bundi\,\ Rajasthan",
"9166456", "Jharsuguda\,\ Odisha",
"917841", "Sarona\,\ Madhya\ Pradesh",
"9166525", "Balangir\,\ Odisha",
"9171774", "Brahmapuri\,\ Maharashtra",
"9162515", "Bagaha\,\ Bihar",
"9175946", "Ganjbasoda\,\ Madhya\ Pradesh",
"912112", "Baramati\,\ Maharashtra",
"9174520", "Chhabra\,\ Rajasthan",
"9163365", "Rajauli\,\ Bihar",
"9164237", "Maheshpur\ Raj\,\ Bihar",
"9161845", "Sasaram\,\ Bihar",
"915731", "Garhmukteshwar\,\ Uttar\ Pradesh",
"918355", "Bableshwar\,\ Karnataka",
"911332", "Roorkee\,\ Uttarakhand",
"91257", "Jalgaon\,\ Maharashtra",
"9167216", "Narsinghpur\,\ Odisha",
"9166404", "Bagdihi\,\ Odisha",
"9173240", "Mhow\,\ Madhya\ Pradesh",
"913826", "Ambasa\,\ Tripura",
"917802", "Churhat\,\ Madhya\ Pradesh",
"918255", "Bantwal\,\ Karnataka",
"9161505", "Hathua\,\ Bihar",
"911232", "Modinagar\,\ Uttar\ Pradesh",
"914344", "Hosur\,\ Tamil\ Nadu",
"9168552", "Laxmipur\,\ Odisha",
"911276", "Bahadurgarh\,\ Haryana",
"9162725", "Darbhanga\,\ Bihar",
"9171992", "Deori\,\ Maharashtra",
"9166715", "Rajkhariar\,\ Odisha",
"9176325", "Balaghat\,\ Madhya\ Pradesh",
"9171064", "Bhiwapur\,\ Maharashtra",
"912764", "Kalol\,\ Gujarat",
"912962", "Banswara\,\ Rajasthan",
"9174910", "Narwar\,\ Madhya\ Pradesh",
"912644", "Jambusar\,\ Gujarat",
"917757", "Shakti\,\ Madhya\ Pradesh",
"914111", "Sriperumbudur\,\ Tamil\ Nadu",
"9176263", "Vijayraghogarh\,\ Madhya\ Pradesh",
"918618", "Nellore\,\ Andhra\ Pradesh",
"917686", "Khajuraho\,\ Madhya\ Pradesh",
"915851", "Bilgam\/Madhoganj\,\ Uttar\ Pradesh",
"9171533", "Hinganghat\,\ Maharashtra",
"9166213", "Hemgiri\,\ Odisha",
"9168587", "Nowrangapur\,\ Odisha",
"9174635", "Gangapur\,\ Rajasthan",
"9162223", "Sheohar\,\ Bihar",
"9171792", "Nagbhir\,\ Maharashtra",
"9167604", "Talcher\,\ Odisha",
"9174339", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9164543", "Purnea\,\ Bihar",
"91135", "Dehradun\,\ Uttarakhand",
"912908", "Amet\,\ Rajasthan",
"918672", "Bandar\/Machilipatnam\,\ Andhra\ Pradesh",
"912699", "Thasra\,\ Gujarat",
"9174568", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"918352", "Bijapur\,\ Karnataka",
"9165664", "Japla\,\ Bihar",
"9166477", "Naktideul\,\ Odisha",
"9174550", "Digod\/Sultanpur\,\ Rajasthan",
"9176500", "Beohari\,\ Madhya\ Pradesh",
"912115", "Saswad\,\ Maharashtra",
"9165242", "Gumla\,\ Bihar",
"915564", "Padrauna\,\ Uttar\ Pradesh",
"9166555", "Titlagarh\,\ Odisha",
"912556", "Chanwad\,\ Maharashtra",
"9167962", "Karanjia\,\ Odisha",
"9177038", "Manpur\,\ Madhya\ Pradesh",
"9166426", "Kuchinda\,\ Odisha",
"912985", "Barmer\/Ramsar\,\ Rajasthan",
"9176367", "Baihar\,\ Madhya\ Pradesh",
"918636", "Guntur\,\ Andhra\ Pradesh",
"9162767", "Madhubani\,\ Bihar",
"9167626", "Dhenkanal\,\ Odisha",
"9167322", "Hindol\,\ Odisha",
"912359", "Guhagar\,\ Maharashtra",
"918692", "Nampalle\,\ Andhra\ Pradesh",
"912679", "Jhalod\,\ Gujarat",
"9166823", "Attabira\,\ Odisha",
"917868", "Kanker\,\ Madhya\ Pradesh",
"9177063", "Gariaband\,\ Madhya\ Pradesh",
"914576", "Mudukulathur\,\ Tamil\ Nadu",
"917226", "Dharani\,\ Maharashtra",
"9174809", "Goharganj\,\ Madhya\ Pradesh",
"9172863", "Khetia\,\ Madhya\ Pradesh",
"9174533", "Baran\,\ Rajasthan",
"9167677", "Barbil\,\ Odisha",
"913782", "Kalaktung\/Bomdila\,\ Arunachal\ Pradesh",
"9161543", "Siwan\,\ Bihar",
"9163253", "Pakribarwan\,\ Bihar",
"9171442", "Atner\,\ Madhya\ Pradesh",
"9168534", "Sunabeda\,\ Odisha",
"914922", "Alathur\,\ Kerala",
"9173229", "Depalpur\,\ Madhya\ Pradesh",
"915875", "Mohammadi\/Maigalganj\,\ Uttar\ Pradesh",
"911858", "Ajnala\,\ Punjab",
"9162734", "Jhajharpur\,\ Bihar",
"9176334", "Waraseoni\,\ Madhya\ Pradesh",
"918403", "Yerragondapalem\,\ Andhra\ Pradesh",
"915255", "Kaisarganh\/Mahasi\,\ Uttar\ Pradesh",
"913842", "Silchar\,\ Assam",
"9165696", "Garu\,\ Bihar",
"9165392", "Bolwa\,\ Bihar",
"9177016", "Pingeshwar\,\ Madhya\ Pradesh",
"9164536", "Araria\,\ Bihar",
"9185860", "Vayalpad\,\ Andhra\ Pradesh",
"9165637", "Bhawanathpur\,\ Bihar",
"913797", "Pangin\,\ Arunachal\ Pradesh",
"9171854", "Pauni\,\ Maharashtra",
"9167355", "Telkoi\,\ Odisha",
"9164597", "Thakurganj\,\ Bihar",
"9174270", "Bhanpura\,\ Madhya\ Pradesh",
"9166522", "Balangir\,\ Odisha",
"9168623", "Gudari\,\ Odisha",
"9162512", "Bagaha\,\ Bihar",
"917688", "Gourihar\,\ Madhya\ Pradesh",
"911795", "Nalagarh\,\ Himachal\ Pradesh",
"9176423", "Mandla\,\ Madhya\ Pradesh",
"9168567", "Rayagada\,\ Odisha",
"9166773", "Narlaroad\,\ Odisha",
"9175949", "Ganjbasoda\,\ Madhya\ Pradesh",
"9174624", "Sawaimadhopur\,\ Rajasthan",
"912135", "Rajgurunagar\,\ Maharashtra",
"9161842", "Sasaram\,\ Bihar",
"91215", "Navi\ Mumbai\/Turbhe\,\ Maharashtra",
"9171606", "Jamai\,\ Madhya\ Pradesh",
"913777", "Yangkiyang\,\ Arunachal\ Pradesh",
"9162463", "Jainagar\,\ Bihar",
"9163362", "Rajauli\,\ Bihar",
"918616", "Nellore\,\ Andhra\ Pradesh",
"9176283", "Karpa\,\ Madhya\ Pradesh",
"917605", "Patera\,\ Madhya\ Pradesh",
"914147", "Tindivanam\,\ Tamil\ Nadu",
"9171037", "Butibori\,\ Maharashtra",
"9144", "Chennai\,\ Tamil\ Nadu",
"9174546", "Chhipaborad\,\ Rajasthan",
"915271", "Akbarpur\,\ Uttar\ Pradesh",
"9161536", "Maharajganj\,\ Bihar",
"912558", "Peint\,\ Maharashtra",
"915672", "Mainpuri\,\ Uttar\ Pradesh",
"9162787", "Dalsinghsarai\,\ Bihar",
"918638", "Guntur\,\ Andhra\ Pradesh",
"9176387", "Damoh\,\ Madhya\ Pradesh",
"9171096", "Kamptee\,\ Maharashtra",
"9174854", "Udaipura\,\ Madhya\ Pradesh",
"912906", "Salumber\,\ Rajasthan",
"9166266", "Banaigarh\,\ Odisha",
"9174588", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"918564", "Proddatur\,\ Andhra\ Pradesh",
"917761", "Tapkara\,\ Madhya\ Pradesh",
"918227", "T\.Narsipur\,\ Karnataka",
"911563", "Sardarshahar\/Jaitsisar\,\ Rajasthan",
"9175920", "Vidisha\,\ Madhya\ Pradesh",
"9161597", "Masrakh\,\ Bihar",
"9174139", "Sailana\,\ Madhya\ Pradesh",
"9165684", "Balumath\,\ Bihar",
"9172883", "Bhikangaon\,\ Madhya\ Pradesh",
"9168525", "Koraput\,\ Odisha",
"915692", "Farrukhabad\/Fategarh\,\ Uttar\ Pradesh",
"912630", "Bansada\,\ Gujarat",
"9171624", "Chhindwara\,\ Madhya\ Pradesh",
"9167957", "Udala\,\ Odisha",
"918550", "Yellanuru\,\ Andhra\ Pradesh",
"9176352", "Lanji\,\ Madhya\ Pradesh",
"9162752", "Rosera\,\ Bihar",
"9168456", "Phiringia\,\ Odisha",
"91374", "Tinsukhia\,\ Assam",
"9174302", "Khanpur\,\ Rajasthan",
"9174606", "Sahabad\,\ Rajasthan",
"912435", "Kannad\,\ Maharashtra",
"917866", "Konta\,\ Madhya\ Pradesh",
"917725", "Saraipali\,\ Madhya\ Pradesh",
"9171832", "Tumsar\,\ Maharashtra",
"917228", "Morshi\,\ Maharashtra",
"912997", "Jaisalmer\/Mohargarh\,\ Rajasthan",
"917817", "Janjgir\,\ Madhya\ Pradesh",
"917201", "Kalamb\,\ Maharashtra",
"91368", "Passighat\,\ Arunachal\ Pradesh",
"912323", "Ajara\,\ Maharashtra",
"9168404", "Tumudibandha\,\ Odisha",
"917328", "Khalwa\,\ Madhya\ Pradesh",
"912132", "Junnar\,\ Maharashtra",
"915190", "Baberu\,\ Uttar\ Pradesh",
"9174654", "Sapotra\,\ Rajasthan",
"9167965", "Karanjia\,\ Odisha",
"915543", "Naugarh\/Barhani\,\ Uttar\ Pradesh",
"9165943", "Baharagora\,\ Bihar",
"9165245", "Gumla\,\ Bihar",
"911583", "Jayal\,\ Rajasthan",
"9173944", "Alirajpur\,\ Madhya\ Pradesh",
"918584", "Piler\,\ Andhra\ Pradesh",
"917781", "Narainpur\,\ Madhya\ Pradesh",
"911792", "Solan\,\ Himachal\ Pradesh",
"9176453", "Karanjia\,\ Madhya\ Pradesh",
"9165884", "Jagarnathpur\,\ Bihar",
"9165307", "Bundu\,\ Bihar",
"9166552", "Titlagarh\,\ Odisha",
"9167263", "Jajapur\ Road\,\ Odisha",
"9168653", "Kashipur\,\ Odisha",
"9168144", "Digapahandi\,\ Odisha",
"912977", "Jalore\/Sayla\,\ Rajasthan",
"918818", "Tadepalligudem\,\ Andhra\ Pradesh",
"9176430", "Bijadandi\,\ Madhya\ Pradesh",
"918327", "Goa",
"9167325", "Hindol\,\ Odisha",
"9164264", "Rajmahal\,\ Bihar",
"9171824", "Gondia\,\ Maharashtra",
"9171397", "Kurkheda\,\ Maharashtra",
"9174143", "Jaora\,\ Madhya\ Pradesh",
"915170", "Chirgaon\/Moth\,\ Uttar\ Pradesh",
"912844", "Mahuva\,\ Gujarat",
"918139", "Turuvekere\,\ Karnataka",
"9174214", "Manasa\,\ Madhya\ Pradesh",
"9174806", "Goharganj\,\ Madhya\ Pradesh",
"9171445", "Atner\,\ Madhya\ Pradesh",
"9164346", "Dumka\,\ Bihar",
"9171336", "Aheri\,\ Maharashtra",
"915252", "Bahraich\/Bahrailh\,\ Uttar\ Pradesh",
"916717", "Cuttack\,\ Odisha",
"913845", "Ukhrul\ Central\,\ Manipur",
"9173226", "Depalpur\,\ Madhya\ Pradesh",
"9168213", "Bhanjanagar\,\ Odisha",
"9167976", "Jashipur\,\ Odisha",
"91490", "Tellicherry\,\ Kerala",
"9182890", "Athani\,\ Karnataka",
"9165896", "Jhinkpani\,\ Bihar",
"913010", "Jaisalmer\/Shahgarh\,\ Rajasthan",
"9168477", "G\.Udayagiri\,\ Odisha",
"918667", "Vijayawada\,\ Andhra\ Pradesh",
"917722", "Dhamtari\,\ Madhya\ Pradesh",
"9161502", "Hathua\,\ Bihar",
"912432", "Aurangabad\,\ Maharashtra",
"9163463", "Lakhisarai\,\ Bihar",
"9171995", "Deori\,\ Maharashtra",
"9165837", "Kharsawa\,\ Bihar",
"9168426", "Phulbani\,\ Odisha",
"9162722", "Darbhanga\,\ Bihar",
"9176322", "Balaghat\,\ Madhya\ Pradesh",
"9166712", "Rajkhariar\,\ Odisha",
"9167927", "Baripada\,\ Odisha",
"911398", "Kairana\/Shamli\,\ Uttar\ Pradesh",
"918836", "Rajahmundri\,\ Andhra\ Pradesh",
"9171654", "Saunsar\,\ Madhya\ Pradesh",
"913453", "Katwa\,\ West\ Bengal",
"9162573", "Barachakia\,\ Bihar",
"917748", "Dallirajhara\,\ Madhya\ Pradesh",
"9168555", "Laxmipur\,\ Odisha",
"9165414", "Chatra\,\ Bihar",
"9181764", "Cannarayapatna\,\ Karnataka",
"9175933", "Kurwai\,\ Madhya\ Pradesh",
"9173204", "Pandhana\,\ Madhya\ Pradesh",
"914283", "Sankagiri\,\ Tamil\ Nadu",
"9175950", "Nateran\,\ Madhya\ Pradesh",
"912663", "Dabhoi\,\ Gujarat",
"913801", "Anini\,\ Arunachal\ Pradesh",
"913217", "Basirhat\,\ West\ Bengal",
"91294", "Udaipur\ Girwa\/Udaipur\,\ Rajasthan",
"9171143", "Ramtek\,\ Maharashtra",
"9174824", "Raisen\,\ Madhya\ Pradesh",
"9175968", "Gyraspur\,\ Madhya\ Pradesh",
"9166534", "Dunguripali\,\ Odisha",
"9171795", "Nagbhir\,\ Maharashtra",
"917534", "Bhind\,\ Madhya\ Pradesh",
"9171806", "Salekasa\,\ Maharashtra",
"911378", "Devprayag\,\ Uttarakhand",
"9165493", "Bermo\,\ Bihar",
"918731", "Utnor\,\ Andhra\ Pradesh",
"9178089", "\`",
"918747", "Nuguru\/Cherla\,\ Andhra\ Pradesh",
"9174336", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9174632", "Gangapur\,\ Rajasthan",
"9161862", "Aurangabad\,\ Bihar",
"91796", "Ahmedabad\ Local\,\ Gujarat",
"9174222", "Mandsaur\,\ Madhya\ Pradesh",
"918614", "Nellore\,\ Andhra\ Pradesh",
"91484", "Ernakulam\,\ Kerala",
"917239", "Wani\,\ Maharashtra",
"9162443", "Khagaria\,\ Bihar",
"9178088", "\`",
"912385", "Udgir\,\ Maharashtra",
"9168547", "Jeypore\,\ Odisha",
"918952", "Chepurupalli\/Garividi\,\ Andhra\ Pradesh",
"9175969", "Gyraspur\,\ Madhya\ Pradesh",
"9171812", "Lakhandur\,\ Maharashtra",
"912622", "Bardoli\,\ Gujarat",
"9174575", "Mangrol\,\ Rajasthan",
"9165353", "Chainpur\,\ Bihar",
"9171673", "Amarwada\,\ Madhya\ Pradesh",
"9168607", "Boriguma\,\ Odisha",
"918640", "Krosuru\,\ Andhra\ Pradesh",
"9164756", "S\.Bakhtiarpur\,\ Bihar",
"9176407", "Shahpur\,\ Madhya\ Pradesh",
"914322", "Pudukkottai\,\ Tamil\ Nadu",
"913192", "Andaman\ \&\ Nicobar\,\ Andaman\ Islands",
"9162554", "Raxaul\,\ Bihar",
"9161516", "Sidhawalia\,\ Bihar",
"9167584", "Nimapara\,\ Odisha",
"915273", "Tandai\/Tanda\,\ Uttar\ Pradesh",
"914348", "Palakkodu\,\ Tamil\ Nadu",
"9171566", "Talegaokarangal\,\ Maharashtra",
"912959", "Jhadol\,\ Rajasthan",
"9166706", "Bhawanipatna\,\ Odisha",
"911561", "Taranagar\,\ Rajasthan",
"918629", "Vinjamuru\,\ Andhra\ Pradesh",
"917763", "Jashpurnagar\,\ Madhya\ Pradesh",
"9176297", "Pushprajgarh\,\ Madhya\ Pradesh",
"9162532", "Narkatiaganj\,\ Bihar",
"911907", "Sundernagar\,\ Himachal\ Pradesh",
"917864", "Sukma\,\ Madhya\ Pradesh",
"9162793", "Barauni\,\ Bihar",
"913472", "Krishna\ Nagar\,\ West\ Bengal",
"9189462", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"918369", "Hubli\,\ Karnataka",
"9165257", "Simdega\,\ Bihar",
"9174812", "Gairatganj\,\ Madhya\ Pradesh",
"9171482", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9161583", "Sonepur\,\ Bihar",
"9166246", "Rajgangpur\,\ Odisha",
"914728", "Nedumangad\,\ Kerala",
"9162295", "Bidupur\,\ Bihar",
"9174673", "Bamanwas\,\ Rajasthan",
"9167537", "Nayagarh\,\ Odisha",
"9166724", "Dharamgarh\,\ Odisha",
"917575", "Sohagpur\,\ Madhya\ Pradesh",
"9162714", "Benipatti\,\ Bihar",
"912904", "Deogarh\,\ Rajasthan",
"9171575", "Arvi\,\ Maharashtra",
"913839", "Jalukie\,\ Nagaland",
"9165422", "Bokaro\,\ Bihar",
"9164516", "Barsoi\,\ Bihar",
"918566", "Koduru\,\ Andhra\ Pradesh",
"914897", "Kadamath\,\ Lakshadweep",
"9168674", "Jharigan\,\ Odisha",
"9177036", "Manpur\,\ Madhya\ Pradesh",
"9176474", "Ghughari\,\ Madhya\ Pradesh",
"915568", "Deoria\,\ Uttar\ Pradesh",
"912362", "Kudal\,\ Maharashtra",
"9174566", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9165617", "Garhwa\,\ Bihar",
"9165282", "Khunti\,\ Bihar",
"918709", "Warangal\,\ Andhra\ Pradesh",
"917850", "Bhanupratappur\,\ Madhya\ Pradesh",
"916415", "Bhagalpur\,\ Bihar",
"9171457", "Chicholi\,\ Madhya\ Pradesh",
"912194", "Roha\,\ Maharashtra",
"9164662", "Kishanganj\,\ Bihar",
"9164366", "Sahibganj\,\ Bihar",
"913803", "Roing\,\ Arunachal\ Pradesh",
"91144", "Alwar\,\ Rajasthan",
"912661", "Naswadi\,\ Gujarat",
"9171465", "Ghorandogri\,\ Madhya\ Pradesh",
"918442", "Jewargi\,\ Karnataka",
"914281", "Yercaud\,\ Tamil\ Nadu",
"9164777", "Triveniganj\,\ Bihar",
"91548", "Ghazipur\,\ Uttar\ Pradesh",
"9176564", "Kannodi\,\ Madhya\ Pradesh",
"918733", "Asifabad\,\ Andhra\ Pradesh",
"918389", "Siddapur\,\ Karnataka",
"911734", "Naraingarh\,\ Haryana",
"911996", "Doda\,\ Jammu\ And\ Kashmir",
"9162524", "Motihari\,\ Bihar",
"918517", "Atmakur\,\ Andhra\ Pradesh",
"9168164", "Mohana\,\ Odisha",
"9166514", "Birmaharajpur\,\ Odisha",
"912846", "Sihor\,\ Gujarat",
"9174612", "Mahuwa\,\ Rajasthan",
"9174316", "Aklera\,\ Rajasthan",
"9165323", "Giridih\,\ Bihar",
"9164244", "Banka\,\ Bihar",
"9174873", "Begamganj\,\ Madhya\ Pradesh",
"9174589", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9165963", "Noamundi\,\ Bihar",
"913759", "Bihupuria\,\ Assam",
"911522", "Bikaner\/Jamsar\,\ Rajasthan",
"912625", "Valod\,\ Gujarat",
"9167945", "Rairangpur\,\ Odisha",
"9174138", "Sailana\,\ Madhya\ Pradesh",
"9167243", "Jagatsinghpur\,\ Odisha",
"9165265", "Lohardaga\,\ Bihar",
"9171383", "Dhanora\,\ Maharashtra",
"918586", "Vayalpad\,\ Andhra\ Pradesh",
"911932", "Anantnag\,\ Jammu\ And\ Kashmir",
"912382", "Latur\,\ Maharashtra",
"917518", "Gwalior\,\ Madhya\ Pradesh",
"917730", "Ajaigarh\,\ Madhya\ Pradesh",
"912737", "Tharad\,\ Gujarat",
"913624", "Nalbari\,\ Assam",
"9175215", "Seondha\,\ Madhya\ Pradesh",
"9166732", "Jayapatna\,\ Odisha",
"9165817", "Bhandaria\,\ Bihar",
"911976", "Amb\,\ Himachal\ Pradesh",
"9175913", "Sironj\,\ Madhya\ Pradesh",
"9174252", "Garoth\,\ Madhya\ Pradesh",
"9165434", "Barhi\,\ Bihar",
"9168692", "Papadhandi\,\ Odisha",
"913451", "Seharabazar\,\ West\ Bengal",
"9176492", "Kakaiya\,\ Madhya\ Pradesh",
"9171427", "Bhimpur\,\ Madhya\ Pradesh",
"916412", "Bhagalpur\,\ Bihar",
"9176410", "Niwas\,\ Madhya\ Pradesh",
"917536", "Sabalgarh\,\ Madhya\ Pradesh",
"91798", "Ahmedabad\ Local\,\ Gujarat",
"9167495", "Bhubaneshwar\,\ Odisha",
"911477", "Nimbahera\,\ Rajasthan",
"9161113", "Hilsa\,\ Bihar",
"91591", "Moradabad\,\ Uttar\ Pradesh",
"918200", "Udupi\,\ Karnataka",
"9162506", "Dhaka\,\ Bihar",
"9176370", "Birsa\,\ Madhya\ Pradesh",
"912365", "Malwan\,\ Maharashtra",
"9164375", "Mahagama\,\ Bihar",
"9165452", "Mandu\,\ Bihar",
"9171476", "Multai\,\ Madhya\ Pradesh",
"9174234", "Neemuch\,\ Madhya\ Pradesh",
"9166754", "T\.Rampur\,\ Odisha",
"917572", "Itarsi\,\ Madhya\ Pradesh",
"9175948", "Ganjbasoda\,\ Madhya\ Pradesh",
"9171612", "Parasia\,\ Madhya\ Pradesh",
"9171316", "Sironcha\,\ Maharashtra",
"918780", "Karimnagar\,\ Andhra\ Pradesh",
"9171163", "Umrer\,\ Maharashtra",
"9161885", "Rohtas\,\ Bihar",
"9177002", "Nagri\,\ Madhya\ Pradesh",
"912149", "Mahasala\,\ Maharashtra",
"918834", "Rajahmundri\,\ Andhra\ Pradesh",
"917203", "Babhulgaon\,\ Maharashtra",
"911497", "Kishangarh\,\ Rajasthan",
"9171873", "Goregaon\,\ Maharashtra",
"9174690", "Hindaun\,\ Rajasthan",
"9165227", "Muri\,\ Bihar",
"9181744", "Arsikere\,\ Karnataka",
"9174383", "Keshoraipatan\/Patan\,\ Rajasthan",
"912321", "Radhanagar\,\ Maharashtra",
"913670", "Maibong\,\ Assam",
"915541", "Domariyaganj\,\ Uttar\ Pradesh",
"9165487", "Ichak\,\ Bihar",
"917127", "Nagpur\,\ Maharashtra",
"917783", "Padamkot\,\ Madhya\ Pradesh",
"9163443", "Monghyr\,\ Bihar",
"9165276", "Kolebira\,\ Bihar",
"911581", "Ladnun\,\ Rajasthan",
"914143", "Virudhachalam\,\ Tamil\ Nadu",
"9171162", "Umrer\,\ Maharashtra",
"915863", "Biswan\,\ Uttar\ Pradesh",
"9171613", "Parasia\,\ Madhya\ Pradesh",
"913874", "Churchandpur\,\ Manipur",
"9176560", "Kannodi\,\ Madhya\ Pradesh",
"9174515", "Atru\,\ Rajasthan",
"9165453", "Mandu\,\ Bihar",
"9176307", "Katangi\,\ Madhya\ Pradesh",
"918630", "Guntur\,\ Andhra\ Pradesh",
"9161576", "Mairwa\,\ Bihar",
"9171755", "Bhadrawati\,\ Maharashtra",
"913521", "Gangarampur\,\ West\ Bengal",
"912550", "Niphad\,\ Maharashtra",
"9166847", "Paikamal\,\ Odisha",
"9171026", "Parseoni\,\ Maharashtra",
"9174508", "Sangod\,\ Rajasthan",
"912875", "Una\/Diu\,\ Gujarat",
"9174357", "Gangdhar\,\ Rajasthan",
"9181729", "Hassan\,\ Karnataka",
"9165604", "Patan\,\ Bihar",
"918223", "K\.R\.Nagar\,\ Karnataka",
"911567", "Ratangarh\,\ Rajasthan",
"9161112", "Hilsa\,\ Bihar",
"9161527", "Chapra\,\ Bihar",
"9168595", "Motu\,\ Odisha",
"9163442", "Monghyr\,\ Bihar",
"9174648", "Karauli\,\ Rajasthan",
"91483", "Manjeri\,\ Kerala",
"9174869", "Bareli\,\ Madhya\ Pradesh",
"9171694", "Batkakhapa\,\ Madhya\ Pradesh",
"918558", "Tadipatri\,\ Andhra\ Pradesh",
"9173958", "Sondhwa\,\ Madhya\ Pradesh",
"913565", "Nagarakata\,\ West\ Bengal",
"9165544", "Rajdhanwar\,\ Bihar",
"912895", "Lalpur\,\ Gujarat",
"917915", "Ahmedabad\ Local\,\ Gujarat",
"9174686", "Khandar\,\ Rajasthan",
"9174382", "Keshoraipatan\/Patan\,\ Rajasthan",
"9182207", "Gundlupet\,\ Karnataka",
"917220", "Chhikaldara\,\ Maharashtra",
"9171872", "Goregaon\,\ Maharashtra",
"912564", "Nandurbar\,\ Maharashtra",
"9165856", "Ghatsila\,\ Bihar",
"9177003", "Nagri\,\ Madhya\ Pradesh",
"915115", "Ghatampur\,\ Uttar\ Pradesh",
"9162774", "Phulparas\,\ Bihar",
"9171515", "Samudrapur\,\ Maharashtra",
"9176374", "Birsa\,\ Madhya\ Pradesh",
"918407", "Darsi\,\ Andhra\ Pradesh",
"917294", "Dharampuri\,\ Madhya\ Pradesh",
"9174613", "Mahuwa\,\ Rajasthan",
"918683", "Hazurnagar\,\ Andhra\ Pradesh",
"911684", "Narwana\,\ Haryana",
"9165322", "Giridih\,\ Bihar",
"9165626", "Daltonganj\,\ Bihar",
"9176414", "Niwas\,\ Madhya\ Pradesh",
"914891", "Amini\,\ Lakshadweep",
"9177045", "Deobhog\,\ Madhya\ Pradesh",
"915644", "Bharatpur\,\ Rajasthan",
"9168614", "Malkangiri\,\ Odisha",
"9164576", "Korha\,\ Bihar",
"9171004", "Kuhi\,\ Maharashtra",
"915962", "Almora\,\ Uttar\ Pradesh",
"9166464", "Bargarh\,\ Odisha",
"9162247", "Hajipur\,\ Bihar",
"913582", "Coochbehar\,\ West\ Bengal",
"918135", "Sira\,\ Karnataka",
"9165677", "Barwadih\,\ Bihar",
"9171357", "Chamorshi\,\ Maharashtra",
"913793", "Mechuka\,\ Arunachal\ Pradesh",
"9161565", "Gopalganj\,\ Bihar",
"9164527", "Katihar\,\ Bihar",
"9164663", "Kishanganj\,\ Bihar",
"9174230", "Neemuch\,\ Madhya\ Pradesh",
"9168693", "Papadhandi\,\ Odisha",
"917274", "Khategaon\,\ Madhya\ Pradesh",
"916634", "Sambalpur\,\ Odisha",
"9181740", "Arsikere\,\ Karnataka",
"9176493", "Kakaiya\,\ Madhya\ Pradesh",
"9175912", "Sironj\,\ Madhya\ Pradesh",
"9174253", "Garoth\,\ Madhya\ Pradesh",
"917680", "Niwari\,\ Madhya\ Pradesh",
"9166733", "Jayapatna\,\ Odisha",
"9174955", "Badarwas\,\ Madhya\ Pradesh",
"9167664", "Keonjhar\,\ Odisha",
"9174694", "Hindaun\,\ Rajasthan",
"9171686", "Harrai\,\ Madhya\ Pradesh",
"9171382", "Dhanora\,\ Maharashtra",
"9167242", "Jagatsinghpur\,\ Odisha",
"9165962", "Noamundi\,\ Bihar",
"9174872", "Begamganj\,\ Madhya\ Pradesh",
"912756", "Muli\,\ Gujarat",
"9167936", "Betanati\,\ Odisha",
"913018", "Jaisalmer\/Sadhna\,\ Rajasthan",
"9171483", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9161582", "Sonepur\,\ Bihar",
"915112", "Bilhaur\,\ Uttar\ Pradesh",
"9168437", "Puruna\ Katak\,\ Odisha",
"911664", "Bhiwani\,\ Haryana",
"9165826", "Chaibasa\,\ Bihar",
"917729", "Bhilaigarh\,\ Madhya\ Pradesh",
"9174813", "Gairatganj\,\ Madhya\ Pradesh",
"918663", "Vijayawada\,\ Andhra\ Pradesh",
"9185861", "Vayalpad\,\ Andhra\ Pradesh",
"912439", "Golegaon\,\ Maharashtra",
"917912", "Ahmedabad\ Local\,\ Gujarat",
"915498", "Ballia\,\ Uttar\ Pradesh",
"912892", "Okha\,\ Gujarat",
"9174967", "Pichhore\,\ Madhya\ Pradesh",
"9168496", "Daringbadi\,\ Odisha",
"9165877", "Chakardharpur\,\ Bihar",
"9162792", "Barauni\,\ Bihar",
"914367", "Mannargudi\,\ Tamil\ Nadu",
"918496", "Uravakonda\,\ Andhra\ Pradesh",
"9173928", "Jhabua\,\ Madhya\ Pradesh",
"9189463", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"917374", "Biaora\,\ Madhya\ Pradesh",
"913562", "Mal\ Bazar\,\ West\ Bengal",
"9175398", "Ambah\,\ Madhya\ Pradesh",
"9165334", "Basia\,\ Bihar",
"9162533", "Narkatiaganj\,\ Bihar",
"917740", "Bodla\,\ Madhya\ Pradesh",
"912747", "Thara\,\ Gujarat",
"914287", "Rasipuram\,\ Tamil\ Nadu",
"9161557", "Ekma\,\ Bihar",
"9163247", "Nawada\,\ Bihar",
"912667", "Savli\,\ Gujarat",
"917660", "Sirmour\,\ Madhya\ Pradesh",
"913213", "Dhaniakhali\,\ West\ Bengal",
"9167864", "Chandbali\,\ Odisha",
"9174327", "Jhalawar\,\ Rajasthan",
"9164717", "Birpur\,\ Bihar",
"9171365", "Etapalli\,\ Maharashtra",
"9181759", "Holenarasipur\,\ Karnataka",
"9165283", "Khunti\,\ Bihar",
"912872", "Vanthali\,\ Gujarat",
"9171056", "Narkhed\,\ Maharashtra",
"9166574", "Kantabhanji\,\ Odisha",
"9176528", "Shahdol\,\ Madhya\ Pradesh",
"9171725", "Chandrapur\,\ Maharashtra",
"918476", "Wadi\,\ Karnataka",
"911370", "Devprayag\/Jakholi\,\ Uttarakhand",
"912836", "Anjar\/Gandhidham\,\ Gujarat",
"9165423", "Bokaro\,\ Bihar",
"918743", "Bhadrachalam\,\ Andhra\ Pradesh",
"911744", "Kurukshetra\,\ Haryana",
"9174672", "Bamanwas\,\ Rajasthan",
"9174376", "Nainwa\,\ Rajasthan",
"917609", "Buxwaha\,\ Madhya\ Pradesh",
"9175266", "Ghatigaon\,\ Madhya\ Pradesh",
"911491", "Nasirabad\,\ Rajasthan",
"912993", "Jaisalmer\/Devikot\,\ Rajasthan",
"9171813", "Lakhandur\,\ Maharashtra",
"917813", "Barpalli\,\ Madhya\ Pradesh",
"915412", "Chandauli\/Mugalsarai\,\ Uttar\ Pradesh",
"916126", "Patna\,\ Bihar",
"9168484", "Kotagarh\,\ Odisha",
"915198", "Karvi\,\ Uttar\ Pradesh",
"912327", "Gadhinglaj\,\ Maharashtra",
"91461", "Thoothukudi\,\ Tamil\ Nadu",
"918844", "Kakinada\,\ Andhra\ Pradesh",
"912139", "Pirangut\,\ Maharashtra",
"9162442", "Khagaria\,\ Bihar",
"915921", "Bilari\,\ Uttar\ Pradesh",
"915547", "Khalilabad\,\ Uttar\ Pradesh",
"9168224", "Aska\,\ Odisha",
"9174925", "Shivpuri\,\ Madhya\ Pradesh",
"918196", "Jagalur\,\ Karnataka",
"9171967", "Arjuni\ Morgaon\,\ Maharashtra",
"9161863", "Aurangabad\,\ Bihar",
"9171185", "Kalmeshwar\,\ Maharashtra",
"911587", "Degana\,\ Rajasthan",
"9174223", "Mandsaur\,\ Madhya\ Pradesh",
"9165387", "Torpa\,\ Bihar",
"911799", "Rajgarh\,\ Himachal\ Pradesh",
"911471", "Rashmi\,\ Rajasthan",
"912973", "Jalore\,\ Rajasthan",
"9174848", "Silwani\,\ Madhya\ Pradesh",
"9174669", "Bonli\,\ Rajasthan",
"9176470", "Ghughari\,\ Madhya\ Pradesh",
"9164557", "Forbesganj\,\ Bihar",
"9173237", "Punasa\,\ Madhya\ Pradesh",
"918323", "Goa",
"915178", "Mauranipur\,\ Uttar\ Pradesh",
"9171894", "Amagaon\,\ Maharashtra",
"91475", "Punalur\,\ Kerala",
"9174365", "Hindoli\,\ Rajasthan",
"918132", "Kunigal\,\ Karnataka",
"9171327", "Gadchiroli\,\ Maharashtra",
"914735", "Ranni\,\ Kerala",
"917546", "Chachaura\,\ Madhya\ Pradesh",
"915965", "Champawat\,\ Uttar\ Pradesh",
"9171416", "Betul\,\ Madhya\ Pradesh",
"9171767", "Warora\,\ Maharashtra",
"9164315", "Jharmundi\,\ Bihar",
"9171376", "Desaiganj\,\ Maharashtra",
"9171672", "Amarwada\,\ Madhya\ Pradesh",
"912584", "Raver\,\ Maharashtra",
"9165656", "Latehar\,\ Bihar",
"91231", "Kolhapur\,\ Maharashtra",
"9165352", "Chainpur\,\ Bihar",
"916713", "Cuttack\,\ Odisha",
"9173296", "Khakner\,\ Madhya\ Pradesh",
"9175932", "Kurwai\,\ Madhya\ Pradesh",
"9162572", "Barachakia\,\ Bihar",
"911903", "Banjar\,\ Himachal\ Pradesh",
"9162723", "Darbhanga\,\ Bihar",
"912566", "Sindkheda\,\ Maharashtra",
"9166713", "Rajkhariar\,\ Odisha",
"9176323", "Balaghat\,\ Madhya\ Pradesh",
"918362", "Hubli\,\ Karnataka",
"913771", "Mariani\,\ Assam",
"9173940", "Alirajpur\,\ Madhya\ Pradesh",
"9161154", "Danapur\,\ Bihar",
"9174668", "Bonli\,\ Rajasthan",
"9174849", "Silwani\,\ Madhya\ Pradesh",
"9163462", "Lakhisarai\,\ Bihar",
"9174650", "Sapotra\,\ Rajasthan",
"9165564", "Tisri\,\ Bihar",
"9161503", "Hathua\,\ Bihar",
"918857", "Ramachandrapuram\,\ Andhra\ Pradesh",
"912145", "Mahad\,\ Maharashtra",
"9166215", "Hemgiri\,\ Odisha",
"918282", "Bhadravati\,\ Karnataka",
"9176817", "Jatara\,\ Madhya\ Pradesh",
"9174633", "Gangapur\,\ Rajasthan",
"9162225", "Sheohar\,\ Bihar",
"9167577", "Daspalla\,\ Odisha",
"918681", "Chandoor\,\ Andhra\ Pradesh",
"9166794", "Komana\,\ Odisha",
"914188", "Chengam\,\ Tamil\ Nadu",
"9171535", "Hinganghat\,\ Maharashtra",
"9165492", "Bermo\,\ Bihar",
"9164545", "Purnea\,\ Bihar",
"914893", "Androth\,\ Lakshadweep",
"9177076", "Bagbahera\,\ Madhya\ Pradesh",
"9168634", "Bisam\ Cuttack\,\ Odisha",
"9176434", "Bijadandi\,\ Madhya\ Pradesh",
"913876", "Jiribam\,\ Manipur",
"913791", "Taliha\,\ Arunachal\ Pradesh",
"9172876", "Gogaon\,\ Madhya\ Pradesh",
"9167526", "Puri\,\ Odisha",
"9171142", "Ramtek\,\ Maharashtra",
"9176265", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9174210", "Manasa\,\ Madhya\ Pradesh",
"918702", "Warangal\,\ Andhra\ Pradesh",
"917858", "Kuakunda\,\ Madhya\ Pradesh",
"9176452", "Karanjia\,\ Madhya\ Pradesh",
"9167262", "Jajapur\ Road\,\ Odisha",
"9168652", "Kashipur\,\ Odisha",
"9166553", "Titlagarh\,\ Odisha",
"915825", "Nawabganj\,\ Uttar\ Pradesh",
"912640", "Rajpipla\,\ Gujarat",
"9176529", "Shahdol\,\ Madhya\ Pradesh",
"911802", "Panipat\,\ Haryana",
"9165942", "Baharagora\,\ Bihar",
"912754", "Dhrangadhra\,\ Gujarat",
"9182894", "Athani\,\ Karnataka",
"917232", "Yeotmal\,\ Maharashtra",
"916636", "Sambalpur\,\ Odisha",
"9181760", "Cannarayapatna\,\ Karnataka",
"914936", "Kalpetta\,\ Kerala",
"912445", "Kaij\,\ Maharashtra",
"912629", "M\.M\.Mangrol\,\ Gujarat",
"9181758", "Holenarasipur\,\ Karnataka",
"918265", "Koppa\,\ Karnataka",
"91373", "Dibrugarh\,\ Assam",
"9167644", "Anugul\,\ Odisha",
"9168687", "Nandapur\,\ Odisha",
"9174535", "Baran\,\ Rajasthan",
"9176487", "Mawai\,\ Madhya\ Pradesh",
"9168212", "Bhanjanagar\,\ Odisha",
"918648", "Repalle\,\ Andhra\ Pradesh",
"915861", "Misrikh\/Aurangabad\,\ Uttar\ Pradesh",
"9174820", "Raisen\,\ Madhya\ Pradesh",
"9166444", "Rairakhol\,\ Odisha",
"9162267", "Sitamarhi\,\ Bihar",
"9173929", "Jhabua\,\ Madhya\ Pradesh",
"9172865", "Khetia\,\ Madhya\ Pradesh",
"9173200", "Pandhana\,\ Madhya\ Pradesh",
"914329", "Ariyalur\,\ Tamil\ Nadu",
"9176276", "Manpur\,\ Madhya\ Pradesh",
"913523", "Raiganj\,\ West\ Bengal",
"9161545", "Siwan\,\ Bihar",
"918385", "Bhatkal\,\ Karnataka",
"9175954", "Nateran\,\ Madhya\ Pradesh",
"9163255", "Pakribarwan\,\ Bihar",
"9174142", "Jaora\,\ Madhya\ Pradesh",
"911686", "Safidon\,\ Haryana",
"912952", "Rajsamand\/Kankorli\,\ Rajasthan",
"917296", "Sardarpur\,\ Madhya\ Pradesh",
"9166786", "Nowparatan\,\ Odisha",
"918221", "Nanjangud\,\ Karnataka",
"9166825", "Attabira\,\ Odisha",
"9177065", "Gariaband\,\ Madhya\ Pradesh",
"917767", "Gharghoda\,\ Madhya\ Pradesh",
"918622", "Kovvur\,\ Andhra\ Pradesh",
"915646", "Baseri\,\ Rajasthan",
"9164784", "Saharsa\,\ Bihar",
"9171497", "Tamia\,\ Madhya\ Pradesh",
"912834", "Kutchmandvi\,\ Gujarat",
"918208", "Udupi\,\ Karnataka",
"911473", "Barisadri\,\ Rajasthan",
"912971", "Pindwara\,\ Rajasthan",
"918474", "Chittapur\,\ Karnataka",
"9177057", "Kurud\,\ Madhya\ Pradesh",
"918705", "Warangal\,\ Andhra\ Pradesh",
"9167556", "Khurda\,\ Odisha",
"9176330", "Waraseoni\,\ Madhya\ Pradesh",
"911746", "Kaithal\,\ Haryana",
"9162586", "Areraj\,\ Bihar",
"9175906", "Lateri\,\ Madhya\ Pradesh",
"9173217", "Sanwer\,\ Madhya\ Pradesh",
"9164335", "Jamtara\,\ Bihar",
"91385", "Imphal\,\ Manipur",
"9171436", "Bhainsdehi\,\ Madhya\ Pradesh",
"913835", "Saiha\,\ Mizoram",
"9174274", "Bhanpura\,\ Madhya\ Pradesh",
"9163267", "Sherghati\,\ Bihar",
"9167285", "Jajapur\ Town\,\ Odisha",
"918788", "Karimnagar\,\ Andhra\ Pradesh",
"9161805", "Adhaura\,\ Bihar",
"9167844", "Bhadrak\,\ Odisha",
"9171345", "Bhamregadh\,\ Maharashtra",
"912142", "Pali\,\ Maharashtra",
"9174947", "Kolaras\,\ Madhya\ Pradesh",
"918494", "Kadiri\,\ Andhra\ Pradesh",
"917811", "Pasan\,\ Madhya\ Pradesh",
"9174620", "Sawaimadhopur\,\ Rajasthan",
"915881", "Bisalpur\,\ Uttar\ Pradesh",
"911493", "Tijara\,\ Rajasthan",
"912991", "Jaisalmer\/Ramgarh\,\ Rajasthan",
"9171833", "Tumsar\,\ Maharashtra",
"913678", "Morigaon\,\ Assam",
"9165297", "Itki\,\ Bihar",
"9161124", "Biharsharif\,\ Bihar",
"9174303", "Khanpur\,\ Rajasthan",
"918365", "Hubli\,\ Karnataka",
"9176353", "Lanji\,\ Madhya\ Pradesh",
"911666", "Sirsa\,\ Haryana",
"9162753", "Rosera\,\ Bihar",
"9165407", "Govindpur\,\ Bihar",
"915923", "Sambhal\,\ Uttar\ Pradesh",
"917123", "Nagpur\,\ Maharashtra",
"9172882", "Bhikangaon\,\ Madhya\ Pradesh",
"917787", "Jarwa\,\ Madhya\ Pradesh",
"9165236", "Ghaghra\,\ Bihar",
"913211", "Arambag\,\ West\ Bengal",
"9176257", "Umariapan\,\ Madhya\ Pradesh",
"913807", "Miao\,\ Arunachal\ Pradesh",
"9171747", "Mul\,\ Maharashtra",
"918625", "Venkatgiri\,\ Andhra\ Pradesh",
"9166855", "Sohela\,\ Odisha",
"912955", "Malvi\/Fatehnagar\,\ Rajasthan",
"912586", "Chopda\,\ Maharashtra",
"9164737", "Supaul\,\ Bihar",
"9163485", "Mallehpur\,\ Bihar",
"9174868", "Bareli\,\ Madhya\ Pradesh",
"918737", "Chinnor\,\ Andhra\ Pradesh",
"9174649", "Karauli\,\ Rajasthan",
"9163225", "Wazirganj\,\ Bihar",
"918382", "Karwar\,\ Karnataka",
"91205", "Pune\,\ Maharashtra",
"9175924", "Vidisha\,\ Madhya\ Pradesh",
"9162594", "Pakridayal\,\ Bihar",
"918513", "Nandikotkur\,\ Andhra\ Pradesh",
"9164796", "Udakishanganj\,\ Bihar",
"9174345", "Pirawa\/Raipur\,\ Rajasthan",
"918741", "Sudhimalla\/Tekulapalli\,\ Andhra\ Pradesh",
"9174850", "Udaipura\,\ Madhya\ Pradesh",
"917544", "Raghogarh\,\ Madhya\ Pradesh",
"9173959", "Sondhwa\,\ Madhya\ Pradesh",
"9165393", "Bolwa\,\ Bihar",
"9174207", "Jawad\,\ Madhya\ Pradesh",
"9140", "Hyderabad\ Local\,\ Andhra\ Pradesh",
"9181728", "Hassan\,\ Karnataka",
"918194", "Chitradurga\,\ Karnataka",
"911529", "Lunkaransar\/Kanholi\,\ Rajasthan",
"9168417", "Boudh\,\ Odisha",
"913752", "Lakhimpur\,\ Assam",
"9176282", "Karpa\,\ Madhya\ Pradesh",
"918262", "Chikmagalur\,\ Karnataka",
"912442", "Bhir\,\ Maharashtra",
"9174509", "Sangod\,\ Rajasthan",
"9162462", "Jainagar\,\ Bihar",
"9167916", "Bangiriposi\,\ Odisha",
"9163363", "Rajauli\,\ Bihar",
"9161843", "Sasaram\,\ Bihar",
"9165314", "Mandar\,\ Bihar",
"916124", "Patna\,\ Bihar",
"912733", "Harij\,\ Gujarat",
"917235", "Pandharkawada\,\ Maharashtra",
"917510", "Gwalior\,\ Madhya\ Pradesh",
"9166772", "Narlaroad\,\ Odisha",
"911805", "Panipat\,\ Haryana",
"912428", "Pathardi\,\ Maharashtra",
"918846", "Kakinada\,\ Andhra\ Pradesh",
"915822", "Baheri\,\ Uttar\ Pradesh",
"9165474", "Chavparan\,\ Bihar",
"9168622", "Gudari\,\ Odisha",
"9166523", "Balangir\,\ Odisha",
"9176422", "Mandla\,\ Madhya\ Pradesh",
"9162513", "Bagaha\,\ Bihar",
"9165945", "Baharagora\,\ Bihar",
"9171554", "Seloo\,\ Maharashtra",
"9173244", "Mhow\,\ Madhya\ Pradesh",
"9163287", "Daudnagar\,\ Bihar",
"9176526", "Shahdol\,\ Madhya\ Pradesh",
"9163316", "Imamganj\,\ Bihar",
"9167963", "Karanjia\,\ Odisha",
"9174378", "Nainwa\,\ Rajasthan",
"9168177", "R\.Udayigiri\,\ Odisha",
"9176455", "Karanjia\,\ Madhya\ Pradesh",
"918786", "Karimnagar\,\ Andhra\ Pradesh",
"9168655", "Kashipur\,\ Odisha",
"9167265", "Jajapur\ Road\,\ Odisha",
"9164324", "Deoghar\,\ Bihar",
"9165243", "Gumla\,\ Bihar",
"9163476", "Chakai\,\ Bihar",
"914869", "Peermedu\,\ Kerala",
"913463", "Bolpur\,\ West\ Bengal",
"9176577", "Jaitpur\,\ Madhya\ Pradesh",
"918206", "Udupi\,\ Karnataka",
"9167817", "Basta\,\ Odisha",
"918377", "Nargund\,\ Karnataka",
"9164764", "Madhepura\,\ Bihar",
"912713", "Dhandhuka\,\ Gujarat",
"9171846", "Bhandara\,\ Maharashtra",
"917530", "Sheopurkalan\,\ Madhya\ Pradesh",
"911748", "Gharaunda\,\ Haryana",
"912927", "Osian\/Dhanwara\,\ Rajasthan",
"9163427", "H\.Kharagpur\,\ Bihar",
"9162566", "Ramnagar\,\ Bihar",
"911668", "Dabwali\,\ Haryana",
"9173926", "Jhabua\,\ Madhya\ Pradesh",
"9161542", "Siwan\,\ Bihar",
"9163252", "Pakribarwan\,\ Bihar",
"9171443", "Atner\,\ Madhya\ Pradesh",
"913014", "Jaisalmer\/Khuri\,\ Rajasthan",
"9174914", "Narwar\,\ Madhya\ Pradesh",
"9174532", "Baran\,\ Rajasthan",
"91291", "Jodhpur\,\ Rajasthan",
"915494", "Bansdeeh\,\ Uttar\ Pradesh",
"9168215", "Bhanjanagar\,\ Odisha",
"9176279", "Manpur\,\ Madhya\ Pradesh",
"9172862", "Khetia\,\ Madhya\ Pradesh",
"912373", "Mahaswad\,\ Maharashtra",
"918397", "H\.B\.Halli\,\ Karnataka",
"918717", "Eturnagaram\,\ Andhra\ Pradesh",
"9166822", "Attabira\,\ Odisha",
"911534", "Kolayat\,\ Rajasthan",
"917658", "Kotma\,\ Madhya\ Pradesh",
"918533", "Gangavathi\,\ Karnataka",
"9177062", "Gariaband\,\ Madhya\ Pradesh",
"9174145", "Jaora\,\ Madhya\ Pradesh",
"911924", "Akhnoor\,\ Jammu\ And\ Kashmir",
"913676", "Howraghat\,\ Assam",
"9167323", "Hindol\,\ Odisha",
"9168104", "Khalikote\,\ Odisha",
"911602", "Kharar\,\ Punjab",
"911990", "Ramnagar\,\ Jammu\ And\ Kashmir",
"9171993", "Deori\,\ Maharashtra",
"917831", "Balrampur\,\ Madhya\ Pradesh",
"911489", "Mandalgarh\,\ Rajasthan",
"9174554", "Digod\/Sultanpur\,\ Rajasthan",
"9168553", "Laxmipur\,\ Odisha",
"9163234", "Dumraon\,\ Bihar",
"9161897", "Bhabhua\,\ Bihar",
"9175935", "Kurwai\,\ Madhya\ Pradesh",
"9173298", "Khakner\,\ Madhya\ Pradesh",
"9171714", "Gond\ Pipri\,\ Maharashtra",
"9161324", "Barh\,\ Bihar",
"9167227", "Pardip\,\ Odisha",
"9162575", "Barachakia\,\ Bihar",
"915174", "Jhansi\,\ Uttar\ Pradesh",
"917847", "Antagarh\,\ Madhya\ Pradesh",
"911342", "Bijnor\,\ Uttar\ Pradesh",
"9167487", "Bhubaneshwar\,\ Odisha",
"9174846", "Silwani\,\ Madhya\ Pradesh",
"9162457", "Gogri\,\ Bihar",
"912829", "Maliya\ Miyana\,\ Gujarat",
"911781", "Rohru\,\ Himachal\ Pradesh",
"9176504", "Beohari\,\ Madhya\ Pradesh",
"9167276", "Kendrapara\,\ Odisha",
"917583", "Banda\,\ Madhya\ Pradesh",
"9163465", "Lakhisarai\,\ Bihar",
"917792", "Narsinghpur\,\ Madhya\ Pradesh",
"9161836", "Buxar\,\ Bihar",
"912588", "Erandul\,\ Maharashtra",
"911970", "Dehra\ Gopipur\,\ Himachal\ Pradesh",
"9164542", "Purnea\,\ Bihar",
"9165495", "Bermo\,\ Bihar",
"914545", "Palani\,\ Tamil\ Nadu",
"9171793", "Nagbhir\,\ Maharashtra",
"9166212", "Hemgiri\,\ Odisha",
"918848", "Kakinada\,\ Andhra\ Pradesh",
"9162222", "Sheohar\,\ Bihar",
"912426", "Rahuri\,\ Maharashtra",
"915262", "Gonda\,\ Uttar\ Pradesh",
"915194", "Karvi\/Manikpur\,\ Uttar\ Pradesh",
"9177079", "Bagbahera\,\ Madhya\ Pradesh",
"9171532", "Hinganghat\,\ Maharashtra",
"915661", "Sadabad\,\ Uttar\ Pradesh",
"9168444", "Kantamal\,\ Odisha",
"9176262", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9172879", "Gogaon\,\ Madhya\ Pradesh",
"9175268", "Ghatigaon\,\ Madhya\ Pradesh",
"916747", "Bhubaneshwar\,\ Odisha",
"911886", "Tanda\ Urmar\,\ Punjab",
"9127174", "Sanand\,\ Gujarat",
"9175384", "Ambah\,\ Madhya\ Pradesh",
"9165347", "Jhumaritalaiya\,\ Bihar",
"917772", "Wadrainagar\,\ Madhya\ Pradesh",
"9171145", "Ramtek\,\ Maharashtra",
"9174688", "Khandar\,\ Rajasthan",
"9167353", "Telkoi\,\ Odisha",
"9163482", "Mallehpur\,\ Bihar",
"9174970", "Khaniadhana\,\ Madhya\ Pradesh",
"911469", "Tijara\,\ Rajasthan",
"9184536", "Medak\,\ Andhra\ Pradesh",
"9165584", "Dumri\(Isribazar\)\,\ Bihar",
"9166852", "Sohela\,\ Odisha",
"912634", "Billimora\,\ Gujarat",
"918554", "Anantapur\,\ Andhra\ Pradesh",
"917751", "Pendra\,\ Madhya\ Pradesh",
"9174646", "Karauli\,\ Rajasthan",
"9174342", "Pirawa\/Raipur\,\ Rajasthan",
"917563", "Nasrullaganj\,\ Madhya\ Pradesh",
"9163222", "Wazirganj\,\ Bihar",
"9133", "Kolkata\,\ West\ Bengal",
"9173956", "Sondhwa\,\ Madhya\ Pradesh",
"912568", "Sakri\,\ Maharashtra",
"915362", "Sultanpur\,\ Uttar\ Pradesh",
"9168156", "Parlakhemundi\,\ Odisha",
"913878", "Chakpikarong\,\ Manipur",
"9174506", "Sangod\,\ Rajasthan",
"9163457", "Jamui\,\ Bihar",
"911637", "Malaut\,\ Punjab",
"9176285", "Karpa\,\ Madhya\ Pradesh",
"915681", "Bidhuna\,\ Uttar\ Pradesh",
"9162465", "Jainagar\,\ Bihar",
"915282", "Hamirpur\,\ Uttar\ Pradesh",
"917856", "Dantewada\,\ Madhya\ Pradesh",
"9164354", "Pakur\,\ Bihar",
"9168625", "Gudari\,\ Odisha",
"916616", "Rourkela\,\ Odisha",
"9176425", "Mandla\,\ Madhya\ Pradesh",
"918560", "Jammalamadugu\,\ Andhra\ Pradesh",
"9162234", "Motipur\,\ Bihar",
"9166775", "Narlaroad\,\ Odisha",
"9171524", "Wardha\,\ Maharashtra",
"917775", "Surajpur\,\ Madhya\ Pradesh",
"9175220", "Datia\,\ Madhya\ Pradesh",
"9165537", "Ramgarh\,\ Bihar",
"913483", "Murshidabad\/Jiaganj\,\ West\ Bengal",
"9175909", "Lateri\,\ Madhya\ Pradesh",
"9165596", "Simaria\,\ Bihar",
"9167282", "Jajapur\ Town\,\ Odisha",
"915265", "Utraula\,\ Uttar\ Pradesh",
"9167617", "Chhendipada\,\ Odisha",
"9161802", "Adhaura\,\ Bihar",
"9171342", "Bhamregadh\,\ Maharashtra",
"9171646", "Pandhurna\,\ Madhya\ Pradesh",
"9164332", "Jamtara\,\ Bihar",
"914542", "Kodaikanal\,\ Tamil\ Nadu",
"9166834", "Padmapur\,\ Odisha",
"9166417", "Deodgarh\,\ Odisha",
"9162427", "Benipur\,\ Bihar",
"915648", "Bayana\,\ Rajasthan",
"9166766", "M\.Rampur\,\ Odisha",
"911345", "Bijnor\/Chandpur\,\ Uttar\ Pradesh",
"918646", "Vinukonda\,\ Andhra\ Pradesh",
"9176467", "Nainpur\,\ Madhya\ Pradesh",
"9161354", "Bikram\,\ Bihar",
"9167257", "Dhanmandal\,\ Odisha",
"9168667", "Umerkote\,\ Odisha",
"914253", "Anamalai\,\ Tamil\ Nadu",
"9172885", "Bhikangaon\,\ Madhya\ Pradesh",
"9162287", "Pupri\,\ Bihar",
"9168523", "Koraput\,\ Odisha",
"9174524", "Chhabra\,\ Rajasthan",
"911605", "Kharar\,\ Punjab",
"9162476", "Singhwara\,\ Bihar",
"918830", "Rajahmundri\,\ Andhra\ Pradesh",
"911536", "Kolayat\/Daitra\,\ Rajasthan",
"918498", "Nallacheruvu\/Tanakallu\,\ Andhra\ Pradesh",
"9177042", "Deobhog\,\ Madhya\ Pradesh",
"917477", "Bundi\,\ Rajasthan",
"9171512", "Samudrapur\,\ Maharashtra",
"9181704", "Alur\,\ Karnataka",
"9174711", "Bundi\,\ Rajasthan",
"9175294", "Laher\,\ Madhya\ Pradesh",
"9171127", "Katol\,\ Maharashtra",
"9165325", "Giridih\,\ Bihar",
"913674", "Hojai\,\ Assam",
"9161562", "Gopalganj\,\ Bihar",
"9171463", "Ghorandogri\,\ Madhya\ Pradesh",
"913016", "Jaisalmer\/Jheenjaniyali\,\ Rajasthan",
"911572", "Sikar\,\ Rajasthan",
"912675", "Santrampur\,\ Gujarat",
"91233", "Sangli\,\ Maharashtra",
"912355", "Chiplun\,\ Maharashtra",
"916517", "Ranchi\,\ Bihar",
"915496", "Ballia\/Raniganj\,\ Uttar\ Pradesh",
"9171866", "Sakoli\,\ Maharashtra",
"9174952", "Badarwas\,\ Madhya\ Pradesh",
"918478", "Kamalapur\,\ Karnataka",
"9175213", "Seondha\,\ Madhya\ Pradesh",
"9164226", "Godda\,\ Bihar",
"912989", "Chohtan\,\ Rajasthan",
"917833", "Udaipur\,\ Madhya\ Pradesh",
"918204", "Udupi\,\ Karnataka",
"912838", "Mundra\,\ Gujarat",
"9162546", "Bettiah\,\ Bihar",
"9171734", "Rajura\,\ Maharashtra",
"9175915", "Sironj\,\ Madhya\ Pradesh",
"912119", "Kedgaon\,\ Maharashtra",
"9174590", "Ramganj\ Mandi\,\ Rajasthan",
"9167943", "Rairangpur\,\ Odisha",
"9174875", "Begamganj\,\ Madhya\ Pradesh",
"9165965", "Noamundi\,\ Bihar",
"9164277", "Kathikund\,\ Bihar",
"9165263", "Lohardaga\,\ Bihar",
"9171385", "Dhanora\,\ Maharashtra",
"9161816", "Piro\,\ Bihar",
"9175908", "Lateri\,\ Madhya\ Pradesh",
"9167884", "Soro\,\ Odisha",
"911592", "Jhunjhunu\,\ Rajasthan",
"917581", "Khurai\,\ Madhya\ Pradesh",
"918784", "Karimnagar\,\ Andhra\ Pradesh",
"911783", "Theog\,\ Himachal\ Pradesh",
"9167245", "Jagatsinghpur\,\ Odisha",
"915844", "Powayan\,\ Uttar\ Pradesh",
"914292", "Valapady\,\ Tamil\ Nadu",
"9171987", "Tirora\,\ Maharashtra",
"918198", "Molkalmuru\,\ Karnataka",
"9171752", "Bhadrawati\,\ Maharashtra",
"9164373", "Mahagama\,\ Bihar",
"9165367", "Palkot\,\ Bihar",
"9174127", "Ratlam\,\ Madhya\ Pradesh",
"918412", "Pargi\,\ Andhra\ Pradesh",
"9171165", "Umrer\,\ Maharashtra",
"9161883", "Rohtas\,\ Bihar",
"91141", "Jaipur\,\ Rajasthan",
"911884", "Garhashanker\,\ Punjab",
"9174934", "Karera\,\ Madhya\ Pradesh",
"9174512", "Atru\,\ Rajasthan",
"918531", "Deodurga\,\ Karnataka",
"9167493", "Bhubaneshwar\,\ Odisha",
"917734", "Shahnagar\,\ Madhya\ Pradesh",
"9161115", "Hilsa\,\ Bihar",
"9181726", "Hassan\,\ Karnataka",
"912371", "Wathar\,\ Maharashtra",
"9168464", "Baliguda\,\ Odisha",
"912424", "Akole\,\ Maharashtra",
"9166254", "Lahunipara\,\ Odisha",
"9165976", "Saraikela\/Adstyapur\,\ Bihar",
"9174866", "Bareli\,\ Madhya\ Pradesh",
"9171787", "Sinderwahi\,\ Maharashtra",
"913461", "Rampur\ Hat\,\ West\ Bengal",
"9163445", "Monghyr\,\ Bihar",
"9168592", "Motu\,\ Odisha",
"9171875", "Goregaon\,\ Maharashtra",
"918259", "Shankarnarayana\,\ Karnataka",
"912711", "Barwala\,\ Gujarat",
"9174689", "Khandar\,\ Rajasthan",
"9175381", "Ambah\,\ Madhya\ Pradesh",
"915176", "Lalitpur\,\ Uttar\ Pradesh",
"9167414", "Bhubaneshwar\,\ Odisha",
"917548", "Mungaoli\,\ Madhya\ Pradesh",
"918965", "Gajapathinagaram\,\ Andhra\ Pradesh",
"911427", "Dausa\,\ Rajasthan",
"9174385", "Keshoraipatan\/Patan\,\ Rajasthan",
"9164204", "Amarpur\,\ Bihar",
"9175269", "Ghatigaon\,\ Madhya\ Pradesh",
"9172878", "Gogaon\,\ Madhya\ Pradesh",
"916614", "Rourkela\,\ Odisha",
"9166814", "Jujumura\,\ Odisha",
"912900", "Siwana\/Samdari\,\ Rajasthan",
"912692", "Anand\,\ Gujarat",
"911595", "Jhunjhunu\/Bissau\,\ Rajasthan",
"918359", "Indi\,\ Karnataka",
"918863", "Chavitidibbalu\,\ Andhra\ Pradesh",
"9166437", "Barkot\,\ Odisha",
"914652", "Nagercoil\,\ Tamil\ Nadu",
"9171182", "Kalmeshwar\,\ Maharashtra",
"914372", "Orathanad\,\ Tamil\ Nadu",
"9162445", "Khagaria\,\ Bihar",
"9177078", "Bagbahera\,\ Madhya\ Pradesh",
"9166496", "Jamankira\,\ Odisha",
"917854", "Ilamidi\,\ Madhya\ Pradesh",
"9164256", "Katoria\,\ Bihar",
"9174922", "Shivpuri\,\ Madhya\ Pradesh",
"9167696", "Kamakhyanagar\,\ Odisha",
"9165517", "Barkagaon\,\ Bihar",
"912352", "Ratnagiri\,\ Maharashtra",
"9174362", "Hindoli\,\ Rajasthan",
"9174666", "Bonli\,\ Rajasthan",
"912672", "Godhra\,\ Gujarat",
"911575", "Srimadhopur\,\ Rajasthan",
"913481", "Islampur\,\ West\ Bengal",
"9165355", "Chainpur\,\ Bihar",
"9171675", "Amarwada\,\ Madhya\ Pradesh",
"9171157", "Mouda\,\ Maharashtra",
"9174573", "Mangrol\,\ Rajasthan",
"9167637", "Athmallik\,\ Odisha",
"913789", "Huri\,\ Arunachal\ Pradesh",
"918556", "Hindupur\,\ Andhra\ Pradesh",
"9168574", "Gunupur\,\ Odisha",
"9164616", "Raniganj\,\ Bihar",
"9164312", "Jharmundi\,\ Bihar",
"9173299", "Khakner\,\ Madhya\ Pradesh",
"9166484", "Patnagarh\,\ Odisha",
"918644", "Tenali\,\ Andhra\ Pradesh",
"9176447", "Dindori\,\ Madhya\ Pradesh",
"91481", "Kottayam\,\ Kerala",
"9168647", "Mathili\,\ Odisha",
"915683", "Auraiya\,\ Uttar\ Pradesh",
"9161585", "Sonepur\,\ Bihar",
"91795", "Ahmedabad\ Local\,\ Gujarat",
"91354", "Darjeeling\,\ West\ Bengal",
"918304", "Kundgol\,\ Karnataka",
"9162795", "Barauni\,\ Bihar",
"9176278", "Manpur\,\ Madhya\ Pradesh",
"917525", "Bhitarwar\,\ Madhya\ Pradesh",
"9166224", "Sundargarh\,\ Odisha",
"91515", "Unnao\,\ Uttar\ Pradesh",
"912969", "Bhinmal\,\ Rajasthan",
"9171666", "Chaurai\,\ Madhya\ Pradesh",
"9171362", "Etapalli\,\ Maharashtra",
"917753", "Kota\,\ Madhya\ Pradesh",
"91223", "Mumbai",
"918610", "Nellore\,\ Andhra\ Pradesh",
"9181756", "Holenarasipur\,\ Karnataka",
"912758", "Halvad\,\ Gujarat",
"9171573", "Arvi\,\ Maharashtra",
"9168507", "Kalimela\,\ Odisha",
"918415", "Hyderabad\ East\/Ghatkeswar\,\ Andhra\ Pradesh",
"9162293", "Bidupur\,\ Bihar",
"9174675", "Bamanwas\,\ Rajasthan",
"9167684", "Parajang\,\ Odisha",
"9171722", "Chandrapur\,\ Maharashtra",
"911763", "Sarhind\,\ Punjab",
"9187596", "Outsarangapalle\,\ Andhra\ Pradesh",
"914295", "Sathiyamangalam\,\ Tamil\ Nadu",
"917561", "Ichhawar\,\ Madhya\ Pradesh",
"913254", "Jhalda\,\ West\ Bengal",
"9174379", "Nainwa\,\ Rajasthan",
"9165686", "Balumath\,\ Bihar",
"9165382", "Torpa\,\ Bihar",
"912163", "Koregaon\,\ Maharashtra",
"916213", "Muzaffarpur\,\ Bihar",
"9166264", "Banaigarh\,\ Odisha",
"9162447", "Khagaria\,\ Bihar",
"9171094", "Kamptee\,\ Maharashtra",
"9174856", "Udaipura\,\ Madhya\ Pradesh",
"9171962", "Arjuni\ Morgaon\,\ Maharashtra",
"9174979", "Khaniadhana\,\ Madhya\ Pradesh",
"915175", "Lalitpur\/Talbehat\,\ Uttar\ Pradesh",
"9168543", "Jeypore\,\ Odisha",
"918966", "Srungavarapukota\/Kothavalasa\,\ Andhra\ Pradesh",
"9161534", "Maharajganj\,\ Bihar",
"915451", "Mariyahu\,\ Uttar\ Pradesh",
"9174544", "Chhipaborad\,\ Rajasthan",
"9166435", "Barkot\,\ Odisha",
"9168603", "Boriguma\,\ Odisha",
"9171677", "Amarwada\,\ Madhya\ Pradesh",
"9165357", "Chainpur\,\ Bihar",
"9176403", "Shahpur\,\ Madhya\ Pradesh",
"9171155", "Mouda\,\ Maharashtra",
"9167635", "Athmallik\,\ Odisha",
"91227", "Mumbai",
"917689", "Badamalhera\,\ Madhya\ Pradesh",
"9171762", "Warora\,\ Maharashtra",
"9174604", "Sahabad\,\ Rajasthan",
"915195", "Mau\/Rajapur\,\ Uttar\ Pradesh",
"9173232", "Punasa\,\ Madhya\ Pradesh",
"9168454", "Phiringia\,\ Odisha",
"9165515", "Barkagaon\,\ Bihar",
"9171322", "Gadchiroli\,\ Maharashtra",
"9171626", "Chhindwara\,\ Madhya\ Pradesh",
"914544", "Natham\,\ Tamil\ Nadu",
"9176293", "Pushprajgarh\,\ Madhya\ Pradesh",
"911507", "Raisinghnagar\,\ Rajasthan",
"9164552", "Forbesganj\,\ Bihar",
"918243", "Mangalore\,\ Karnataka",
"912463", "Degloor\,\ Maharashtra",
"9174962", "Pichhore\,\ Madhya\ Pradesh",
"9165872", "Chakardharpur\,\ Bihar",
"9162797", "Barauni\,\ Bihar",
"9171856", "Pauni\,\ Maharashtra",
"918639", "Guntur\,\ Andhra\ Pradesh",
"915284", "Maudaha\,\ Uttar\ Pradesh",
"912559", "Yeola\,\ Maharashtra",
"9164534", "Araria\,\ Bihar",
"9165253", "Simdega\,\ Bihar",
"9174598", "Ramganj\ Mandi\,\ Rajasthan",
"912696", "Borsad\,\ Gujarat",
"9176445", "Dindori\,\ Madhya\ Pradesh",
"9168645", "Mathili\,\ Odisha",
"9175229", "Datia\,\ Madhya\ Pradesh",
"9177014", "Pingeshwar\,\ Madhya\ Pradesh",
"913713", "Mangaldoi\,\ Assam",
"9175900", "Lateri\,\ Madhya\ Pradesh",
"9161587", "Sonepur\,\ Bihar",
"9165694", "Garu\,\ Bihar",
"9168432", "Puruna\ Katak\,\ Odisha",
"9162736", "Jhajharpur\,\ Bihar",
"914332", "Manaparai\,\ Tamil\ Nadu",
"9176336", "Waraseoni\,\ Madhya\ Pradesh",
"9168505", "Kalimela\,\ Odisha",
"9167533", "Nayagarh\,\ Odisha",
"918467", "Bodhan\,\ Andhra\ Pradesh",
"9174677", "Bamanwas\,\ Rajasthan",
"9171604", "Jamai\,\ Madhya\ Pradesh",
"911535", "Kolayat\/Bajju\,\ Rajasthan",
"912632", "Valsad\,\ Gujarat",
"915690", "Kaimganj\,\ Uttar\ Pradesh",
"918552", "Gooty\/Guntakal\,\ Andhra\ Pradesh",
"912676", "Halol\,\ Gujarat",
"9165613", "Garhwa\,\ Bihar",
"9174322", "Jhalawar\,\ Rajasthan",
"9174626", "Sawaimadhopur\,\ Rajasthan",
"9164712", "Birpur\,\ Bihar",
"912356", "Khed\,\ Maharashtra",
"915495", "Saidpur\,\ Uttar\ Pradesh",
"9161552", "Ekma\,\ Bihar",
"913653", "Amlarem\/Dawki\,\ Meghalaya",
"917229", "Warlydwarud\,\ Maharashtra",
"9163242", "Nawada\,\ Bihar",
"9171453", "Chicholi\,\ Madhya\ Pradesh",
"913015", "Jaisalmer\/Myajlar\,\ Rajasthan",
"915364", "Kadipur\,\ Uttar\ Pradesh",
"9164522", "Katihar\,\ Bihar",
"9165416", "Chatra\,\ Bihar",
"9181766", "Cannarayapatna\,\ Karnataka",
"911981", "Nyoma\,\ Jammu\ And\ Kashmir",
"912483", "Ambad\,\ Maharashtra",
"9164773", "Triveniganj\,\ Bihar",
"9162242", "Hajipur\,\ Bihar",
"9165672", "Barwadih\,\ Bihar",
"9171656", "Saunsar\,\ Madhya\ Pradesh",
"9171352", "Chamorshi\,\ Maharashtra",
"9168424", "Phulbani\,\ Odisha",
"915192", "Banda\,\ Uttar\ Pradesh",
"912130", "Velhe\,\ Maharashtra",
"915264", "Balarampur\/Tulsipur\,\ Uttar\ Pradesh",
"912347", "Vita\,\ Maharashtra",
"911823", "Nawanshahar\,\ Punjab",
"914296", "Avanashi\,\ Tamil\ Nadu",
"9165894", "Jhinkpani\,\ Bihar",
"9167974", "Jashipur\,\ Odisha",
"9171125", "Katol\,\ Maharashtra",
"918416", "Vikrabad\,\ Andhra\ Pradesh",
"918571", "Madanapalli\,\ Andhra\ Pradesh",
"9165327", "Giridih\,\ Bihar",
"917774", "Ambikapur\,\ Madhya\ Pradesh",
"918819", "Tanuku\,\ Andhra\ Pradesh",
"911604", "Kharar\,\ Punjab",
"9174334", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"918487", "Shirahatti\,\ Karnataka",
"9165967", "Noamundi\,\ Bihar",
"9174877", "Begamganj\,\ Madhya\ Pradesh",
"9164275", "Kathikund\,\ Bihar",
"918138", "Koratageri\,\ Karnataka",
"9171387", "Dhanora\,\ Maharashtra",
"9171804", "Salekasa\,\ Maharashtra",
"9166536", "Dunguripali\,\ Odisha",
"915172", "Mehraun\,\ Uttar\ Pradesh",
"9167247", "Jagatsinghpur\,\ Odisha",
"9174826", "Raisen\,\ Madhya\ Pradesh",
"911344", "Dhampur\,\ Uttar\ Pradesh",
"9165813", "Bhandaria\,\ Bihar",
"915250", "Bahraich\/Bhinga\,\ Uttar\ Pradesh",
"917794", "Gotegaon\,\ Madhya\ Pradesh",
"9173206", "Pandhana\,\ Madhya\ Pradesh",
"9175917", "Sironj\,\ Madhya\ Pradesh",
"91551", "Gorakhpur\,\ Uttar\ Pradesh",
"9176270", "Manpur\,\ Madhya\ Pradesh",
"9165886", "Jagarnathpur\,\ Bihar",
"91469", "Tiruvalla\,\ Kerala",
"912183", "Madha\,\ Maharashtra",
"9161117", "Hilsa\,\ Bihar",
"913012", "Jaisalmer\/Mehsana\,\ Rajasthan",
"9171423", "Bhimpur\,\ Madhya\ Pradesh",
"9173946", "Alirajpur\,\ Madhya\ Pradesh",
"9161522", "Chapra\,\ Bihar",
"917720", "Arang\,\ Madhya\ Pradesh",
"912430", "Sillod\,\ Maharashtra",
"912898", "Jamjodhpur\,\ Gujarat",
"9174656", "Sapotra\,\ Rajasthan",
"9174352", "Gangdhar\,\ Rajasthan",
"911576", "Dantaramgarh\/Shyamji\,\ Rajasthan",
"9168406", "Tumudibandha\,\ Odisha",
"9176302", "Katangi\,\ Madhya\ Pradesh",
"91265", "Vadodara\,\ Gujarat",
"9171985", "Tirora\,\ Maharashtra",
"911532", "Nokha\/Nathusar\,\ Rajasthan",
"9166842", "Paikamal\,\ Odisha",
"9165365", "Palkot\,\ Bihar",
"9171167", "Umrer\,\ Maharashtra",
"911922", "Kathua\,\ Jammu\ And\ Kashmir",
"9174125", "Ratlam\,\ Madhya\ Pradesh",
"917749", "Balod\,\ Madhya\ Pradesh",
"9182202", "Gundlupet\,\ Karnataka",
"91435", "Kumbakonam\,\ Tamil\ Nadu",
"9173224", "Depalpur\,\ Madhya\ Pradesh",
"9172870", "Gogaon\,\ Madhya\ Pradesh",
"9171877", "Goregaon\,\ Maharashtra",
"918187", "Shikaripura\,\ Karnataka",
"9171334", "Aheri\,\ Maharashtra",
"918723", "Sircilla\,\ Andhra\ Pradesh",
"912878", "Mangrol\,\ Gujarat",
"9164344", "Dumka\,\ Bihar",
"9174216", "Manasa\,\ Madhya\ Pradesh",
"911596", "Chirawa\,\ Rajasthan",
"9174804", "Goharganj\,\ Madhya\ Pradesh",
"9174387", "Keshoraipatan\/Patan\,\ Rajasthan",
"918917", "Visakhapatnam\,\ Andhra\ Pradesh",
"9165223", "Muri\,\ Bihar",
"911659", "Sardulgarh\,\ Punjab",
"911379", "Pratapnagar\,\ Uttarakhand",
"9165483", "Ichak\,\ Bihar",
"9164266", "Rajmahal\,\ Bihar",
"9171785", "Sinderwahi\,\ Maharashtra",
"9171826", "Gondia\,\ Maharashtra",
"916313", "Gaya\,\ Bihar",
"9177070", "Bagbahera\,\ Madhya\ Pradesh",
"9163447", "Monghyr\,\ Bihar",
"9168146", "Digapahandi\,\ Odisha",
"912425", "Sangamner\,\ Maharashtra",
"912649", "Dediapada\,\ Gujarat",
"9174202", "Jawad\,\ Madhya\ Pradesh",
"917238", "Darwaha\,\ Maharashtra",
"914546", "Theni\,\ Tamil\ Nadu",
"911885", "Balachaur\,\ Punjab",
"9175260", "Ghatigaon\,\ Madhya\ Pradesh",
"9164732", "Supaul\,\ Bihar",
"9165633", "Bhawanathpur\,\ Bihar",
"9176252", "Umariapan\,\ Madhya\ Pradesh",
"9171742", "Mul\,\ Maharashtra",
"913252", "Purulia\,\ West\ Bengal",
"9164593", "Thakurganj\,\ Bihar",
"913651", "Tura\,\ Meghalaya",
"9168563", "Rayagada\,\ Odisha",
"91164", "Bhatinda\,\ Punjab",
"918964", "Saluru\,\ Andhra\ Pradesh",
"912461", "Mukhed\,\ Maharashtra",
"9168627", "Gudari\,\ Odisha",
"9176427", "Mandla\,\ Madhya\ Pradesh",
"918642", "Guntur\ Palnad\/Macherala\,\ Andhra\ Pradesh",
"914998", "Uppala\,\ Kerala",
"9173290", "Khakner\,\ Madhya\ Pradesh",
"914320", "Aravakurichi\,\ Tamil\ Nadu",
"9166777", "Narlaroad\,\ Odisha",
"91761", "Jabalpur\,\ Madhya\ Pradesh",
"9174564", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9177034", "Manpur\,\ Madhya\ Pradesh",
"9168676", "Jharigan\,\ Odisha",
"912958", "Kotra\,\ Rajasthan",
"91130", "Sonipat\,\ Haryana",
"9176476", "Ghughari\,\ Madhya\ Pradesh",
"9164514", "Barsoi\,\ Bihar",
"9163455", "Jamui\,\ Bihar",
"9166726", "Dharamgarh\,\ Odisha",
"9168412", "Boudh\,\ Odisha",
"9176287", "Karpa\,\ Madhya\ Pradesh",
"9162716", "Benipatti\,\ Bihar",
"918628", "Chejerla\,\ Andhra\ Pradesh",
"9166244", "Rajgangpur\,\ Odisha",
"9162467", "Jainagar\,\ Bihar",
"913711", "Udalguri\,\ Assam",
"9171033", "Butibori\,\ Maharashtra",
"9167615", "Chhendipada\,\ Odisha",
"912674", "Lunavada\,\ Gujarat",
"912354", "Sanganeshwar\/Deorukh\,\ Maharashtra",
"911697", "Ratia\,\ Haryana",
"9162783", "Dalsinghsarai\,\ Bihar",
"9176383", "Damoh\,\ Madhya\ Pradesh",
"9163262", "Sherghati\,\ Bihar",
"913675", "Bokajan\,\ Assam",
"918368", "Hubli\,\ Karnataka",
"9165535", "Ramgarh\,\ Bihar",
"9173212", "Sanwer\,\ Madhya\ Pradesh",
"9171492", "Tamia\,\ Madhya\ Pradesh",
"9161593", "Masrakh\,\ Bihar",
"9177052", "Kurud\,\ Madhya\ Pradesh",
"9176465", "Nainpur\,\ Madhya\ Pradesh",
"918785", "Karimnagar\,\ Andhra\ Pradesh",
"916612", "Rourkela\,\ Odisha",
"9167255", "Dhanmandal\,\ Odisha",
"9168665", "Umerkote\,\ Odisha",
"914182", "Tiruvettipuram\,\ Tamil\ Nadu",
"916807", "Berhampur\,\ Odisha",
"9172887", "Bhikangaon\,\ Madhya\ Pradesh",
"918288", "Bailhongal\,\ Karnataka",
"9166704", "Bhawanipatna\,\ Odisha",
"912161", "Vaduj\,\ Maharashtra",
"912694", "Kheda\,\ Gujarat",
"9162285", "Pupri\,\ Bihar",
"9171564", "Talegaokarangal\,\ Maharashtra",
"9165402", "Govindpur\,\ Bihar",
"9174370", "Nainwa\,\ Rajasthan",
"913838", "Aizwal\/Serchip\,\ Mizoram",
"9167953", "Udala\,\ Odisha",
"914374", "Papanasam\,\ Tamil\ Nadu",
"9161514", "Sidhawalia\,\ Bihar",
"917367", "Badnagar\,\ Madhya\ Pradesh",
"9167586", "Nimapara\,\ Odisha",
"9165292", "Itki\,\ Bihar",
"91522", "Lucknow\,\ Uttar\ Pradesh",
"9162556", "Raxaul\,\ Bihar",
"918205", "Udupi\,\ Karnataka",
"917852", "Toynar\,\ Madhya\ Pradesh",
"9166415", "Deodgarh\,\ Odisha",
"9164754", "S\.Bakhtiarpur\,\ Bihar",
"9162425", "Benipur\,\ Bihar",
"9174942", "Kolaras\,\ Madhya\ Pradesh",
"918708", "Warangal\,\ Andhra\ Pradesh",
"915453", "Shahganj\,\ Uttar\ Pradesh",
"9167815", "Basta\,\ Odisha",
"917267", "Malkapur\,\ Maharashtra",
"9176575", "Jaitpur\,\ Madhya\ Pradesh",
"91532", "Allahabad\,\ Uttar\ Pradesh",
"9171314", "Sironcha\,\ Maharashtra",
"918721", "Husnabad\,\ Andhra\ Pradesh",
"917524", "Dabra\,\ Madhya\ Pradesh",
"9166756", "T\.Rampur\,\ Odisha",
"911346", "Pauri\/Bubakhal\,\ Uttarakhand",
"918440", "Nimburga\,\ Karnataka",
"9163425", "H\.Kharagpur\,\ Bihar",
"9171474", "Multai\,\ Madhya\ Pradesh",
"9174236", "Neemuch\,\ Madhya\ Pradesh",
"9165947", "Baharagora\,\ Bihar",
"9162504", "Dhaka\,\ Bihar",
"911257", "Meham\,\ Haryana",
"911606", "Kharar\,\ Punjab",
"9163285", "Daudnagar\,\ Bihar",
"918388", "Ankola\,\ Karnataka",
"9168175", "R\.Udayigiri\,\ Odisha",
"9176457", "Karanjia\,\ Madhya\ Pradesh",
"918645", "Mangalagiri\,\ Andhra\ Pradesh",
"9167267", "Jajapur\ Road\,\ Odisha",
"9168657", "Kashipur\,\ Odisha",
"9165303", "Bundu\,\ Bihar",
"9175228", "Datia\,\ Madhya\ Pradesh",
"914294", "Perundurai\,\ Tamil\ Nadu",
"915842", "Shahjahanpur\,\ Uttar\ Pradesh",
"911520", "Bikaner\/Chhatargarh\,\ Rajasthan",
"9165274", "Kolebira\,\ Bihar",
"917443", "Ladpura\/Kota\,\ Rajasthan",
"9174599", "Ramganj\ Mandi\,\ Rajasthan",
"913758", "Dhakuakhana\,\ Assam",
"912181", "Akkalkot\,\ Maharashtra",
"918414", "Ibrahimpatnam\,\ Andhra\ Pradesh",
"9171393", "Kurkheda\,\ Maharashtra",
"9174147", "Jaora\,\ Madhya\ Pradesh",
"917776", "Premnagar\,\ Madhya\ Pradesh",
"911882", "Hoshiarpur\,\ Punjab",
"917732", "Panna\,\ Madhya\ Pradesh",
"915317", "Dalmau\,\ Uttar\ Pradesh",
"917519", "Gwalior\,\ Madhya\ Pradesh",
"9181746", "Arsikere\,\ Karnataka",
"9168682", "Nandapur\,\ Odisha",
"9176482", "Mawai\,\ Madhya\ Pradesh",
"9168217", "Bhanjanagar\,\ Odisha",
"912422", "Shri\ Rampur\,\ Maharashtra",
"9162262", "Sitamarhi\,\ Bihar",
"9167485", "Bhubaneshwar\,\ Odisha",
"9168473", "G\.Udayagiri\,\ Odisha",
"91120", "Ghaziabad\/Dadri\,\ Uttar\ Pradesh",
"9164246", "Banka\,\ Bihar",
"9162455", "Gogri\,\ Bihar",
"9174314", "Aklera\,\ Rajasthan",
"917855", "Chingmut\,\ Madhya\ Pradesh",
"918202", "Udupi\,\ Karnataka",
"9162526", "Motihari\,\ Bihar",
"9168166", "Mohana\,\ Odisha",
"9166516", "Birmaharajpur\,\ Odisha",
"914633", "Tenkasi\,\ Tamil\ Nadu",
"9163467", "Lakhisarai\,\ Bihar",
"9167923", "Baripada\,\ Odisha",
"9176566", "Kannodi\,\ Madhya\ Pradesh",
"9165833", "Kharsawa\,\ Bihar",
"911594", "Udaipurwati\,\ Rajasthan",
"917570", "Seonimalwa\,\ Madhya\ Pradesh",
"9161895", "Bhabhua\,\ Bihar",
"9175937", "Kurwai\,\ Madhya\ Pradesh",
"918593", "Medarmetla\,\ Andhra\ Pradesh",
"9164364", "Sahibganj\,\ Bihar",
"918337", "Murugod\,\ Karnataka",
"9167225", "Pardip\,\ Odisha",
"9162577", "Barachakia\,\ Bihar",
"918782", "Karimnagar\,\ Andhra\ Pradesh",
"916615", "Rourkela\,\ Odisha",
"911983", "Zanaskar\,\ Jammu\ And\ Kashmir",
"912481", "Ner\,\ Maharashtra",
"9174680", "Khandar\,\ Rajasthan",
"913867", "Zuenheboto\,\ Nagaland",
"9174978", "Khaniadhana\,\ Madhya\ Pradesh",
"9165436", "Barhi\,\ Bihar",
"912148", "Karjat\,\ Maharashtra",
"913672", "Nagaon\,\ Assam",
"9165345", "Jhumaritalaiya\,\ Bihar",
"915943", "Khatima\,\ Uttar\ Pradesh",
"9171147", "Ramtek\,\ Maharashtra",
"911821", "Nakodar\,\ Punjab",
"9165497", "Bermo\,\ Bihar",
"918573", "Bangarupalem\,\ Andhra\ Pradesh",
"912597", "Parola\,\ Maharashtra",
"9176812", "Jatara\,\ Madhya\ Pradesh",
"911574", "Neem\ Ka\ Thana\,\ Rajasthan",
"9167572", "Daspalla\,\ Odisha",
"9168194", "Surada\,\ Odisha",
"9164337", "Jamtara\,\ Bihar",
"911999", "Mahore\,\ Jammu\ And\ Kashmir",
"9175964", "Gyraspur\,\ Madhya\ Pradesh",
"918386", "Kumta\,\ Karnataka",
"911480", "Asind\,\ Rajasthan",
"9181733", "Sakleshpur\,\ Karnataka",
"9163265", "Sherghati\,\ Bihar",
"9174828", "Raisen\,\ Madhya\ Pradesh",
"915440", "Mirzapur\/Hallia\,\ Uttar\ Pradesh",
"9167287", "Jajapur\ Town\,\ Odisha",
"9173208", "Pandhana\,\ Madhya\ Pradesh",
"9167612", "Chhendipada\,\ Odisha",
"9167316", "Anandapur\,\ Odisha",
"9161807", "Adhaura\,\ Bihar",
"915721", "Sikandra\ Rao\,\ Uttar\ Pradesh",
"9171347", "Bhamregadh\,\ Maharashtra",
"912849", "Botad\,\ Gujarat",
"918134", "Tiptur\,\ Karnataka",
"9171495", "Tamia\,\ Madhya\ Pradesh",
"911348", "Lansdowne\/Syunsi\,\ Uttarakhand",
"912820", "Paddhari\,\ Gujarat",
"915645", "Rupbas\,\ Rajasthan",
"9177055", "Kurud\,\ Madhya\ Pradesh",
"911685", "Guruharsahai\,\ Punjab",
"912582", "Bhusawal\,\ Maharashtra",
"9165532", "Ramgarh\,\ Bihar",
"914561", "Devakottai\,\ Tamil\ Nadu",
"9165914", "Chandil\,\ Bihar",
"917295", "Badnawar\,\ Madhya\ Pradesh",
"912793", "Damnagar\,\ Gujarat",
"918777", "Tirupathi\,\ Andhra\ Pradesh",
"9173215", "Sanwer\,\ Madhya\ Pradesh",
"9165405", "Govindpur\,\ Bihar",
"9171703", "Chumur\,\ Maharashtra",
"915414", "Bhadohi\,\ Uttar\ Pradesh",
"9176462", "Nainpur\,\ Madhya\ Pradesh",
"9168113", "Chhatrapur\,\ Odisha",
"91184", "Karnal\,\ Haryana",
"9168662", "Umerkote\,\ Odisha",
"9167252", "Dhanmandal\,\ Odisha",
"918842", "Kakinada\,\ Andhra\ Pradesh",
"9162282", "Pupri\,\ Bihar",
"9163323", "Nabinagar\,\ Bihar",
"9166412", "Deodgarh\,\ Odisha",
"914935", "Mananthavady\,\ Kerala",
"91495", "Kozhikode\,\ Kerala",
"9162422", "Benipur\,\ Bihar",
"912446", "Ambejogai\,\ Maharashtra",
"9176513", "Jaisinghnagar\,\ Madhya\ Pradesh",
"918266", "Narsimharajapur\,\ Karnataka",
"9174945", "Kolaras\,\ Madhya\ Pradesh",
"9181768", "Cannarayapatna\,\ Karnataka",
"913756", "Sadiya\,\ Assam",
"917778", "Semaria\,\ Madhya\ Pradesh",
"918589", "Siddavattam\,\ Andhra\ Pradesh",
"9174243", "Malhargarh\,\ Madhya\ Pradesh",
"9165295", "Itki\,\ Bihar",
"918317", "Belgaum\,\ Karnataka",
"912773", "Malpur\,\ Gujarat",
"916635", "Sambalpur\,\ Odisha",
"9181750", "Holenarasipur\,\ Karnataka",
"9163227", "Wazirganj\,\ Bihar",
"9161874", "Mohania\,\ Bihar",
"9174903", "Pohari\,\ Madhya\ Pradesh",
"9167234", "Athgarh\,\ Odisha",
"912521", "Talasari\,\ Maharashtra",
"9174347", "Pirawa\/Raipur\,\ Rajasthan",
"912931", "Jodhpur\/Jhanwar\,\ Rajasthan",
"911433", "Todaraisingh\,\ Rajasthan",
"911897", "Pangi\/Killar\,\ Himachal\ Pradesh",
"912874", "Manavadar\,\ Gujarat",
"9174205", "Jawad\,\ Madhya\ Pradesh",
"9164384", "Madhupur\,\ Bihar",
"9171745", "Mul\,\ Maharashtra",
"9176255", "Umariapan\,\ Madhya\ Pradesh",
"9166857", "Sohela\,\ Odisha",
"917539", "Gohad\,\ Madhya\ Pradesh",
"9165443", "Gomia\,\ Bihar",
"911381", "Joshimath\/Badrinath\,\ Uttarakhand",
"9163276", "Rafiganj\,\ Bihar",
"915341", "Kunda\,\ Uttar\ Pradesh",
"9168186", "Buguda\,\ Odisha",
"9174218", "Manasa\,\ Madhya\ Pradesh",
"9163487", "Mallehpur\,\ Bihar",
"9164735", "Supaul\,\ Bihar",
"915114", "Derapur\/Jhinjak\,\ Uttar\ Pradesh",
"9165846", "Bishrampur\,\ Bihar",
"913638", "Nongpoh\,\ Meghalaya",
"912565", "Shahada\,\ Maharashtra",
"911662", "Hissar\,\ Haryana",
"912894", "Kalawad\,\ Gujarat",
"917914", "Ahmedabad\ Local\,\ Gujarat",
"917251", "Risod\,\ Maharashtra",
"913564", "Alipurduar\,\ West\ Bengal",
"9173948", "Alirajpur\,\ Madhya\ Pradesh",
"917372", "Rajgarh\,\ Madhya\ Pradesh",
"9174660", "Bonli\,\ Rajasthan",
"9164233", "Maheshpur\ Raj\,\ Bihar",
"9176479", "Ghughari\,\ Madhya\ Pradesh",
"913227", "Amlagora\,\ West\ Bengal",
"9168415", "Boudh\,\ Odisha",
"9174658", "Sapotra\,\ Rajasthan",
"9163452", "Jamui\,\ Bihar",
"9181720", "Hassan\,\ Karnataka",
"916632", "Sambalpur\,\ Odisha",
"917671", "Jaitwara\,\ Madhya\ Pradesh",
"917272", "Dewas\,\ Madhya\ Pradesh",
"9167482", "Bhubaneshwar\,\ Odisha",
"9162452", "Gogri\,\ Bihar",
"9165506", "Hunterganj\,\ Bihar",
"9176569", "Kannodi\,\ Madhya\ Pradesh",
"918845", "Kakinada\,\ Andhra\ Pradesh",
"9161892", "Bhabhua\,\ Bihar",
"9167222", "Pardip\,\ Odisha",
"917236", "Maregaon\,\ Maharashtra",
"911806", "Panipat\,\ Haryana",
"917292", "Dhar\,\ Madhya\ Pradesh",
"912956", "Gogunda\,\ Rajasthan",
"917691", "Chhapara\,\ Madhya\ Pradesh",
"914177", "Arkonam\,\ Tamil\ Nadu",
"9165646", "Nagarutari\,\ Bihar",
"9165342", "Jhumaritalaiya\,\ Bihar",
"912585", "Yawal\,\ Maharashtra",
"911682", "Zira\,\ Punjab",
"9162276", "Mahua\,\ Bihar",
"911281", "Jatusana\,\ Haryana",
"915642", "Dholpur\,\ Rajasthan",
"918626", "Kavali\,\ Andhra\ Pradesh",
"9176267", "Vijayraghogarh\,\ Madhya\ Pradesh",
"915241", "Ramsanehi\ Ghat\,\ Uttar\ Pradesh",
"915964", "Pithoragarh\,\ Uttar\ Pradesh",
"9166217", "Hemgiri\,\ Odisha",
"9167575", "Daspalla\,\ Odisha",
"9162227", "Sheohar\,\ Bihar",
"913584", "Mekhliganj\,\ West\ Bengal",
"914734", "Adoor\,\ Kerala",
"9176815", "Jatara\,\ Madhya\ Pradesh",
"9174860", "Bareli\,\ Madhya\ Pradesh",
"9168583", "Nowrangapur\,\ Odisha",
"9171537", "Hinganghat\,\ Maharashtra",
"918153", "Bangarpet\,\ Karnataka",
"9174858", "Udaipura\,\ Madhya\ Pradesh",
"9164547", "Purnea\,\ Bihar",
"9174584", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9163422", "H\.Kharagpur\,\ Bihar",
"9174628", "Sawaimadhopur\,\ Rajasthan",
"9164674", "Banmankhi\,\ Bihar",
"918366", "Hubli\,\ Karnataka",
"911460", "Kishangarhbas\/Khairthal\,\ Rajasthan",
"9176572", "Jaitpur\,\ Madhya\ Pradesh",
"9167812", "Basta\,\ Odisha",
"9174239", "Neemuch\,\ Madhya\ Pradesh",
"9166473", "Naktideul\,\ Odisha",
"917655", "Birsinghpur\,\ Madhya\ Pradesh",
"918217", "Mysore\,\ Karnataka",
"917375", "Narsingharh\,\ Madhya\ Pradesh",
"9168172", "R\.Udayigiri\,\ Odisha",
"912457", "Jintdor\,\ Maharashtra",
"9176363", "Baihar\,\ Madhya\ Pradesh",
"912562", "Dhule\,\ Maharashtra",
"915368", "Amethi\,\ Uttar\ Pradesh",
"9162763", "Madhubani\,\ Bihar",
"9163282", "Daudnagar\,\ Bihar",
"9167566", "Balugaon\,\ Odisha",
"911745", "Nilokheri\,\ Haryana",
"9162434", "Begusarai\,\ Bihar",
"9174596", "Ramganj\ Mandi\,\ Rajasthan",
"913872", "Chandel\,\ Manipur",
"9178081", "\`",
"9176338", "Waraseoni\,\ Madhya\ Pradesh",
"9166827", "Attabira\,\ Odisha",
"918706", "Warangal\,\ Andhra\ Pradesh",
"9177067", "Gariaband\,\ Madhya\ Pradesh",
"913667", "Bilasipara\,\ Assam",
"9167673", "Barbil\,\ Odisha",
"9174537", "Baran\,\ Rajasthan",
"9168685", "Nandapur\,\ Odisha",
"9171046", "Hingua\,\ Maharashtra",
"9176485", "Mawai\,\ Madhya\ Pradesh",
"9162265", "Sitamarhi\,\ Bihar",
"9181749", "Arsikere\,\ Karnataka",
"9172867", "Khetia\,\ Madhya\ Pradesh",
"918569", "Badvel\,\ Andhra\ Pradesh",
"9171584", "Deoli\,\ Maharashtra",
"9161547", "Siwan\,\ Bihar",
"9163257", "Pakribarwan\,\ Bihar",
"913836", "Saiha\/Tuipang\,\ Mizoram",
"9181748", "Arsikere\,\ Karnataka",
"918192", "Davangere\,\ Karnataka",
"9165875", "Chakardharpur\,\ Bihar",
"913754", "Moranhat\,\ Assam",
"9174965", "Pichhore\,\ Madhya\ Pradesh",
"9167654", "Palla\ Hara\,\ Odisha",
"911263", "Gohana\,\ Haryana",
"918941", "Palakonda\/Rajam\,\ Andhra\ Pradesh",
"9171134", "Saoner\,\ Maharashtra",
"914298", "Metturdam\,\ Tamil\ Nadu",
"912444", "Patoda\,\ Maharashtra",
"9167293", "Pattamundai\,\ Odisha",
"9174263", "Sitamau\,\ Madhya\ Pradesh",
"918418", "Medchal\,\ Andhra\ Pradesh",
"918937", "Chintapalle\,\ Andhra\ Pradesh",
"9161823", "Arrah\,\ Bihar",
"9167403", "Bhubaneshwar\,\ Odisha",
"916122", "Patna\,\ Bihar",
"9164213", "Naugachia\,\ Bihar",
"9171976", "Mohadi\,\ Maharashtra",
"9168435", "Puruna\ Katak\,\ Odisha",
"917253", "Mangrulpur\,\ Maharashtra",
"912755", "Sayla\,\ Gujarat",
"9175226", "Datia\,\ Madhya\ Pradesh",
"915824", "Aonla\/Ramnagar\,\ Uttar\ Pradesh",
"9176442", "Dindori\,\ Madhya\ Pradesh",
"9166543", "Sonapur\,\ Odisha",
"9176339", "Waraseoni\,\ Madhya\ Pradesh",
"9168642", "Mathili\,\ Odisha",
"9111", "New\ Delhi",
"9167214", "Narsinghpur\,\ Odisha",
"9171727", "Chandrapur\,\ Maharashtra",
"917528", "Bijaypur\,\ Madhya\ Pradesh",
"9168502", "Kalimela\,\ Odisha",
"912933", "Bali\/Sumerpur\,\ Rajasthan",
"911431", "Lalsot\,\ Rajasthan",
"9175944", "Ganjbasoda\,\ Madhya\ Pradesh",
"918384", "Sirsi\,\ Karnataka",
"9161555", "Ekma\,\ Bihar",
"9163245", "Nawada\,\ Bihar",
"9174629", "Sawaimadhopur\,\ Rajasthan",
"916577", "Jamshedpur\,\ Bihar",
"9171776", "Brahmapuri\,\ Maharashtra",
"917542", "Guna\,\ Madhya\ Pradesh",
"9166454", "Jharsuguda\,\ Odisha",
"9171367", "Etapalli\,\ Maharashtra",
"918136", "Pavagada\,\ Karnataka",
"9164715", "Birpur\,\ Bihar",
"9174325", "Jhalawar\,\ Rajasthan",
"9174238", "Neemuch\,\ Madhya\ Pradesh",
"915343", "Patti\,\ Uttar\ Pradesh",
"9164294", "Kahalgaon\,\ Bihar",
"915870", "Bhira\,\ Uttar\ Pradesh",
"912144", "Murud\,\ Maharashtra",
"918839", "Rajahmundri\,\ Andhra\ Pradesh",
"9174134", "Sailana\,\ Madhya\ Pradesh",
"913566", "Kalchini\,\ West\ Bengal",
"9174640", "Karauli\,\ Rajasthan",
"918492", "Kambadur\,\ Andhra\ Pradesh",
"9171965", "Arjuni\ Morgaon\,\ Maharashtra",
"9174927", "Shivpuri\,\ Madhya\ Pradesh",
"918118", "Nelamangala\,\ Karnataka",
"9171187", "Kalmeshwar\,\ Maharashtra",
"9165385", "Torpa\,\ Bihar",
"9174859", "Udaipura\,\ Madhya\ Pradesh",
"9161144", "Jahanabad\,\ Bihar",
"9173950", "Sondhwa\,\ Madhya\ Pradesh",
"9174976", "Khaniadhana\,\ Madhya\ Pradesh",
"9165866", "Chainpur\,\ Bihar",
"9176533", "Bandhavgarh\,\ Madhya\ Pradesh",
"9166432", "Barkot\,\ Odisha",
"912896", "Bhanvad\,\ Gujarat",
"917916", "Ahmedabad\ Local\,\ Gujarat",
"912771", "Bhiloda\,\ Gujarat",
"9163493", "Jhajha\,\ Bihar",
"9165463", "Hazaribagh\,\ Bihar",
"912832", "Bhuj\,\ Gujarat",
"912980", "Pachpadra\/Korna\,\ Rajasthan",
"9164317", "Jharmundi\,\ Bihar",
"918472", "Gulbarga\,\ Karnataka",
"9176568", "Kannodi\,\ Madhya\ Pradesh",
"9171765", "Warora\,\ Maharashtra",
"9164286", "Nala\,\ Bihar",
"9171152", "Mouda\,\ Maharashtra",
"915723", "Atrauli\,\ Uttar\ Pradesh",
"9167632", "Athmallik\,\ Odisha",
"9167336", "Ghatgaon\,\ Odisha",
"9174500", "Sangod\,\ Rajasthan",
"9173933", "Jobat\,\ Madhya\ Pradesh",
"9164555", "Forbesganj\,\ Bihar",
"9163414", "Seikhpura\,\ Bihar",
"912791", "Babra\,\ Gujarat",
"9173235", "Punasa\,\ Madhya\ Pradesh",
"9165512", "Barkagaon\,\ Bihar",
"914563", "Rajapalayam\,\ Tamil\ Nadu",
"9165934", "Manoharpur\,\ Bihar",
"912876", "Veraval\,\ Gujarat",
"9163374", "Arwal\,\ Bihar",
"9171325", "Gadchiroli\,\ Maharashtra",
"9174367", "Hindoli\,\ Rajasthan",
"9167824", "Balasore\,\ Odisha",
"914994", "Kasaragod\,\ Kerala",
"9165573", "Bagodar\,\ Bihar",
"9176478", "Ghughari\,\ Madhya\ Pradesh",
"9174355", "Gangdhar\,\ Rajasthan",
"917545", "Arone\,\ Madhya\ Pradesh",
"9173949", "Alirajpur\,\ Madhya\ Pradesh",
"9174840", "Silwani\,\ Madhya\ Pradesh",
"9166424", "Kuchinda\,\ Odisha",
"9164623", "Dhamdaha\,\ Bihar",
"9174659", "Sapotra\,\ Rajasthan",
"9161525", "Chapra\,\ Bihar",
"9165666", "Japla\,\ Bihar",
"9165362", "Palkot\,\ Bihar",
"9174122", "Ratlam\,\ Madhya\ Pradesh",
"912954", "Kumbalgarh\/Charbhujaji\,\ Rajasthan",
"918451", "Zahirabad\,\ Andhra\ Pradesh",
"9174517", "Atru\,\ Rajasthan",
"915966", "Ranikhet\,\ Uttar\ Pradesh",
"9176305", "Katangi\,\ Madhya\ Pradesh",
"918624", "Gudur\,\ Andhra\ Pradesh",
"9171982", "Tirora\,\ Maharashtra",
"9171757", "Bhadrawati\,\ Maharashtra",
"9166845", "Paikamal\,\ Odisha",
"912960", "Sojat\,\ Rajasthan",
"9168536", "Sunabeda\,\ Odisha",
"912752", "Surendranagar\,\ Gujarat",
"9182205", "Gundlupet\,\ Karnataka",
"918619", "Nellore\,\ Andhra\ Pradesh",
"911804", "Panipat\,\ Haryana",
"9174219", "Manasa\,\ Madhya\ Pradesh",
"916125", "Patna\,\ Bihar",
"917234", "Digras\,\ Maharashtra",
"9161853", "Bikramganj\,\ Bihar",
"9168597", "Motu\,\ Odisha",
"911957", "Bandipur\,\ Jammu\ And\ Kashmir",
"9167624", "Dhenkanal\,\ Odisha",
"9171782", "Sinderwahi\,\ Maharashtra",
"918195", "Challakere\,\ Karnataka",
"9162245", "Hajipur\,\ Bihar",
"912698", "Khambat\,\ Gujarat",
"9181769", "Cannarayapatna\,\ Karnataka",
"9171355", "Chamorshi\,\ Maharashtra",
"918284", "Haliyal\,\ Karnataka",
"9165675", "Barwadih\,\ Bihar",
"912909", "Bhim\/Dawer\,\ Rajasthan",
"917693", "Ghansour\,\ Madhya\ Pradesh",
"918350", "Mudhol\,\ Karnataka",
"9171066", "Bhiwapur\,\ Maharashtra",
"9164525", "Katihar\,\ Bihar",
"9161567", "Gopalganj\,\ Bihar",
"913834", "Demagiri\,\ Mizoram",
"9171517", "Samudrapur\,\ Maharashtra",
"9176520", "Shahdol\,\ Madhya\ Pradesh",
"918151", "Malur\,\ Karnataka",
"9171122", "Katol\,\ Maharashtra",
"918704", "Warangal\,\ Andhra\ Pradesh",
"9166406", "Bagdihi\,\ Odisha",
"9177047", "Deobhog\,\ Madhya\ Pradesh",
"918475", "Chincholi\,\ Karnataka",
"912835", "Nakhatrana\,\ Gujarat",
"91285", "Junagarh\,\ Gujarat",
"912358", "Dapoli\,\ Maharashtra",
"9167606", "Talcher\,\ Odisha",
"912678", "Devgadhbaria\,\ Gujarat",
"917673", "Nagod\,\ Madhya\ Pradesh",
"91487", "Thrissur\,\ Kerala",
"9176343", "Lamta\,\ Madhya\ Pradesh",
"9164272", "Kathikund\,\ Bihar",
"9162743", "Samastipur\,\ Bihar",
"9174829", "Raisen\,\ Madhya\ Pradesh",
"9173920", "Jhabua\,\ Madhya\ Pradesh",
"911363", "Karnaprayag\,\ Uttarakhand",
"918364", "Hubli\,\ Karnataka",
"9175390", "Ambah\,\ Madhya\ Pradesh",
"913780", "Dirang\,\ Arunachal\ Pradesh",
"918495", "Rayadurg\,\ Andhra\ Pradesh",
"9174957", "Badarwas\,\ Madhya\ Pradesh",
"911859", "Goindwal\,\ Punjab",
"9173209", "Pandhana\,\ Madhya\ Pradesh",
"9161834", "Buxar\,\ Bihar",
"9167274", "Kendrapara\,\ Odisha",
"9176506", "Beohari\,\ Madhya\ Pradesh",
"918565", "Rajampeta\,\ Andhra\ Pradesh",
"9171123", "Katol\,\ Maharashtra",
"914868", "Nedumkandam\,\ Kerala",
"911437", "Malpura\,\ Rajasthan",
"917576", "Piparia\,\ Madhya\ Pradesh",
"911893", "Nurpur\,\ Himachal\ Pradesh",
"9174844", "Silwani\,\ Madhya\ Pradesh",
"9161326", "Barh\,\ Bihar",
"9171716", "Gond\ Pipri\,\ Maharashtra",
"915333", "Karchhana\/Shankergarh\,\ Uttar\ Pradesh",
"917532", "Morena\,\ Madhya\ Pradesh",
"9163236", "Dumraon\,\ Bihar",
"916416", "Bhagalpur\,\ Bihar",
"9171467", "Ghorandogri\,\ Madhya\ Pradesh",
"9174556", "Digod\/Sultanpur\,\ Rajasthan",
"911749", "Assandh\,\ Haryana",
"9168106", "Khalikote\,\ Odisha",
"9164775", "Triveniganj\,\ Bihar",
"91470", "Attingal\,\ Kerala",
"918947", "Sompeta\,\ Andhra\ Pradesh",
"917724", "Basana\,\ Madhya\ Pradesh",
"9127176", "Sanand\,\ Gujarat",
"9175217", "Seondha\,\ Madhya\ Pradesh",
"9175386", "Ambah\,\ Madhya\ Pradesh",
"911669", "Adampur\ Mandi\,\ Haryana",
"9165815", "Bhandaria\,\ Bihar",
"918931", "Yelamanchili\,\ Andhra\ Pradesh",
"9176342", "Lamta\,\ Madhya\ Pradesh",
"9168446", "Kantamal\,\ Odisha",
"9162742", "Samastipur\,\ Bihar",
"9164273", "Kathikund\,\ Bihar",
"913223", "Nayagarh\/Kultikri\,\ West\ Bengal",
"917659", "Jaithari\,\ Madhya\ Pradesh",
"9176439", "Bijadandi\,\ Madhya\ Pradesh",
"9167947", "Rairangpur\,\ Odisha",
"9165267", "Lohardaga\,\ Bihar",
"911488", "Kotri\,\ Rajasthan",
"9171983", "Tirora\,\ Maharashtra",
"9162564", "Ramnagar\,\ Bihar",
"9164377", "Mahagama\,\ Bihar",
"911992", "Udhampur\,\ Jammu\ And\ Kashmir",
"9171844", "Bhandara\,\ Maharashtra",
"915181", "Bindki\,\ Uttar\ Pradesh",
"9165363", "Palkot\,\ Bihar",
"9164766", "Madhepura\,\ Bihar",
"9161887", "Rohtas\,\ Bihar",
"9174123", "Ratlam\,\ Madhya\ Pradesh",
"912842", "Talaja\,\ Gujarat",
"9163474", "Chakai\,\ Bihar",
"9171425", "Bhimpur\,\ Madhya\ Pradesh",
"912828", "Wankaner\,\ Gujarat",
"9167497", "Bhubaneshwar\,\ Odisha",
"917823", "Dongargarh\,\ Madhya\ Pradesh",
"9182899", "Athani\,\ Karnataka",
"9164326", "Deoghar\,\ Bihar",
"9164622", "Dhamdaha\,\ Bihar",
"91462", "Tirunelvelli\,\ Tamil\ Nadu",
"915254", "Nanparah\/Mihinpurwa\,\ Uttar\ Pradesh",
"9176524", "Shahdol\,\ Madhya\ Pradesh",
"9163314", "Imamganj\,\ Bihar",
"912589", "Chalisgaon\,\ Maharashtra",
"9165572", "Bagodar\,\ Bihar",
"9171556", "Seloo\,\ Maharashtra",
"9173246", "Mhow\,\ Madhya\ Pradesh",
"912797", "Dhari\,\ Gujarat",
"917790", "Babaichichli\,\ Madhya\ Pradesh",
"918773", "Tirupathi\,\ Andhra\ Pradesh",
"911972", "Hamirpur\,\ Himachal\ Pradesh",
"917604", "Hatta\,\ Madhya\ Pradesh",
"9171783", "Sinderwahi\,\ Maharashtra",
"9165485", "Ichak\,\ Bihar",
"9178080", "\`",
"918849", "Kakinada\,\ Andhra\ Pradesh",
"9161852", "Bikramganj\,\ Bihar",
"915260", "Tarabganj\,\ Uttar\ Pradesh",
"9175959", "Nateran\,\ Madhya\ Pradesh",
"9174916", "Narwar\,\ Madhya\ Pradesh",
"911526", "Lunkaransar\/Mahajan\,\ Rajasthan",
"911936", "Pahalgam\,\ Jammu\ And\ Kashmir",
"9173924", "Jhabua\,\ Madhya\ Pradesh",
"918582", "B\.Kothakota\,\ Andhra\ Pradesh",
"9165225", "Muri\,\ Bihar",
"918313", "Belgaum\,\ Karnataka",
"917770", "Kathdol\,\ Madhya\ Pradesh",
"9168545", "Jeypore\,\ Odisha",
"9163492", "Jhajha\,\ Bihar",
"911468", "Ramgarh\,\ Rajasthan",
"9174698", "Hindaun\,\ Rajasthan",
"9176532", "Bandhavgarh\,\ Madhya\ Pradesh",
"9171644", "Pandhurna\,\ Madhya\ Pradesh",
"9174279", "Bhanpura\,\ Madhya\ Pradesh",
"915694", "Kannauj\,\ Uttar\ Pradesh",
"9166433", "Barkot\,\ Odisha",
"9165594", "Simaria\,\ Bihar",
"918213", "Mysore\,\ Karnataka",
"911951", "Badgam\,\ Jammu\ And\ Kashmir",
"912453", "Gangakhed\,\ Maharashtra",
"913511", "Bubulchandi\,\ West\ Bengal",
"912569", "Navapur\,\ Maharashtra",
"9185869", "Vayalpad\,\ Andhra\ Pradesh",
"91222", "Mumbai",
"9176418", "Niwas\,\ Madhya\ Pradesh",
"9162474", "Singhwara\,\ Bihar",
"9174526", "Chhabra\,\ Rajasthan",
"912366", "Vengurla\,\ Maharashtra",
"913879", "Bishenpur\,\ Manipur",
"9165513", "Barkagaon\,\ Bihar",
"9173932", "Jobat\,\ Madhya\ Pradesh",
"91755", "Bhopal\,\ Madhya\ Pradesh",
"9176378", "Birsa\,\ Madhya\ Pradesh",
"917535", "Raghunathpur\,\ Madhya\ Pradesh",
"912801", "Ranavav\,\ Gujarat",
"9176295", "Pushprajgarh\,\ Madhya\ Pradesh",
"9161356", "Bikram\,\ Bihar",
"915280", "Rath\,\ Uttar\ Pradesh",
"913663", "Goalpara\,\ Assam",
"9167633", "Athmallik\,\ Odisha",
"918457", "Siddipet\,\ Andhra\ Pradesh",
"9174577", "Mangrol\,\ Rajasthan",
"9166764", "M\.Rampur\,\ Odisha",
"9168605", "Boriguma\,\ Odisha",
"9176405", "Shahpur\,\ Madhya\ Pradesh",
"9171153", "Mouda\,\ Maharashtra",
"9175940", "Ganjbasoda\,\ Madhya\ Pradesh",
"9166836", "Padmapur\,\ Odisha",
"918562", "Kadapa\,\ Andhra\ Pradesh",
"9165462", "Hazaribagh\,\ Bihar",
"91268", "Nadiad\,\ Gujarat",
"9176443", "Dindori\,\ Madhya\ Pradesh",
"917279", "Nandnva\,\ Maharashtra",
"9168643", "Mathili\,\ Odisha",
"9166542", "Sonapur\,\ Odisha",
"9165255", "Simdega\,\ Bihar",
"9173954", "Sondhwa\,\ Madhya\ Pradesh",
"918585", "Pakala\,\ Andhra\ Pradesh",
"9164212", "Naugachia\,\ Bihar",
"912626", "Vyara\,\ Gujarat",
"9174130", "Sailana\,\ Madhya\ Pradesh",
"9167402", "Bhubaneshwar\,\ Odisha",
"9174644", "Karauli\,\ Rajasthan",
"9175929", "Vidisha\,\ Madhya\ Pradesh",
"915461", "Ghosi\,\ Uttar\ Pradesh",
"9174262", "Sitamau\,\ Madhya\ Pradesh",
"9161822", "Arrah\,\ Bihar",
"9167292", "Pattamundai\,\ Odisha",
"9165586", "Dumri\(Isribazar\)\,\ Bihar",
"9184534", "Medak\,\ Andhra\ Pradesh",
"911975", "Una\,\ Himachal\ Pradesh",
"9171526", "Wardha\,\ Maharashtra",
"914173", "Arni\,\ Tamil\ Nadu",
"9165615", "Garhwa\,\ Bihar",
"913844", "Hailakandi\,\ Assam",
"9162236", "Motipur\,\ Bihar",
"9164356", "Pakur\,\ Bihar",
"9171455", "Chicholi\,\ Madhya\ Pradesh",
"912845", "Savarkundla\,\ Gujarat",
"9167535", "Nayagarh\,\ Odisha",
"9162297", "Bidupur\,\ Bihar",
"9168503", "Kalimela\,\ Odisha",
"9171577", "Arvi\,\ Maharashtra",
"918157", "Srinivasapur\,\ Karnataka",
"9174504", "Sangod\,\ Rajasthan",
"911995", "Kishtwar\,\ Jammu\ And\ Kashmir",
"9168154", "Parlakhemundi\,\ Odisha",
"914326", "Musiri\,\ Tamil\ Nadu",
"918832", "Rajahmundri\,\ Andhra\ Pradesh",
"9163283", "Daudnagar\,\ Bihar",
"9167967", "Karanjia\,\ Odisha",
"9176362", "Baihar\,\ Madhya\ Pradesh",
"9162762", "Madhubani\,\ Bihar",
"9168466", "Baliguda\,\ Odisha",
"912472", "Osmanabad\,\ Maharashtra",
"918499", "Podili\,\ Andhra\ Pradesh",
"91183", "Amritsar\,\ Punjab",
"9181724", "Hassan\,\ Karnataka",
"9165247", "Gumla\,\ Bihar",
"9168173", "R\.Udayigiri\,\ Odisha",
"918110", "Anekal\,\ Karnataka",
"9165305", "Bundu\,\ Bihar",
"917726", "Bhatapara\,\ Madhya\ Pradesh",
"917865", "Gogunda\,\ Madhya\ Pradesh",
"9174936", "Karera\,\ Madhya\ Pradesh",
"9167813", "Basta\,\ Odisha",
"9176573", "Jaitpur\,\ Madhya\ Pradesh",
"9166472", "Naktideul\,\ Odisha",
"91571", "Aligarh\,\ Uttar\ Pradesh",
"911570", "Laxmangarh\/Nechwa\,\ Rajasthan",
"9163423", "H\.Kharagpur\,\ Bihar",
"912436", "Vijapur\,\ Maharashtra",
"9164206", "Amarpur\,\ Bihar",
"9171447", "Atner\,\ Madhya\ Pradesh",
"916414", "Bhagalpur\,\ Bihar",
"912839", "Lakhpat\,\ Gujarat",
"918479", "Shahapur\,\ Karnataka",
"912988", "Pachpadra\/Balotra\,\ Rajasthan",
"9167416", "Bhubaneshwar\,\ Odisha",
"912118", "Walchandnagar\,\ Maharashtra",
"915183", "Fatehpur\/Gazipur\,\ Uttar\ Pradesh",
"9167672", "Barbil\,\ Odisha",
"917821", "Dhamda\,\ Madhya\ Pradesh",
"9174580", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9175928", "Vidisha\,\ Madhya\ Pradesh",
"9167327", "Hindol\,\ Odisha",
"917574", "Hoshangabad\,\ Madhya\ Pradesh",
"91565", "Mathura\,\ Uttar\ Pradesh",
"914567", "Ramanathpuram\,\ Tamil\ Nadu",
"911590", "Merta\,\ Rajasthan",
"9174864", "Bareli\,\ Madhya\ Pradesh",
"912905", "Sarada\/Chawand\,\ Rajasthan",
"9165974", "Saraikela\/Adstyapur\,\ Bihar",
"9166256", "Lahunipara\,\ Odisha",
"9171395", "Kurkheda\,\ Maharashtra",
"918199", "Hosadurga\,\ Karnataka",
"9171997", "Deori\,\ Maharashtra",
"9165835", "Kharsawa\,\ Bihar",
"911267", "Nuh\,\ Haryana",
"918523", "Alur\,\ Andhra\ Pradesh",
"914290", "Omalur\,\ Tamil\ Nadu",
"9167925", "Baripada\,\ Odisha",
"911871", "Batala\,\ Punjab",
"9167223", "Pardip\,\ Odisha",
"911796", "Arki\,\ Himachal\ Pradesh",
"9168557", "Laxmipur\,\ Odisha",
"9161893", "Bhabhua\,\ Bihar",
"918933", "Bheemunipatnam\,\ Andhra\ Pradesh",
"9162453", "Gogri\,\ Bihar",
"912384", "Nilanga\,\ Maharashtra",
"91251", "Kalyan\,\ Maharashtra",
"9167483", "Bhubaneshwar\,\ Odisha",
"918615", "Nellore\,\ Andhra\ Pradesh",
"9181706", "Alur\,\ Karnataka",
"913221", "Jhargram\,\ West\ Bengal",
"9168475", "G\.Udayagiri\,\ Odisha",
"9176419", "Niwas\,\ Madhya\ Pradesh",
"917606", "Jabera\,\ Madhya\ Pradesh",
"9175296", "Laher\,\ Madhya\ Pradesh",
"917257", "Balapur\,\ Maharashtra",
"912136", "Urlikanchan\,\ Maharashtra",
"9176379", "Birsa\,\ Madhya\ Pradesh",
"912527", "Shahapur\,\ Maharashtra",
"9171797", "Nagbhir\,\ Maharashtra",
"912192", "Khopoli\,\ Maharashtra",
"918444", "Hunsagi\,\ Karnataka",
"9161814", "Piro\,\ Bihar",
"9167886", "Soro\,\ Odisha",
"912937", "Raipur\,\ Rajasthan",
"9185868", "Vayalpad\,\ Andhra\ Pradesh",
"9168582", "Nowrangapur\,\ Odisha",
"911732", "Jagadhari\,\ Haryana",
"918258", "Karkala\,\ Karnataka",
"9174699", "Hindaun\,\ Rajasthan",
"916573", "Jamshedpur\,\ Bihar",
"915331", "Bharwari\,\ Uttar\ Pradesh",
"9171736", "Rajura\,\ Maharashtra",
"9162544", "Bettiah\,\ Bihar",
"9165343", "Jhumaritalaiya\,\ Bihar",
"9171864", "Sakoli\,\ Maharashtra",
"9174278", "Bhanpura\,\ Madhya\ Pradesh",
"9164224", "Godda\,\ Bihar",
"918678", "Nandigama\,\ Andhra\ Pradesh",
"918358", "Basavanabagewadi\,\ Karnataka",
"9166226", "Sundargarh\,\ Odisha",
"9165635", "Bhawanathpur\,\ Bihar",
"912690", "Balasinor\,\ Gujarat",
"912902", "Barmer\/Kanot\,\ Rajasthan",
"914171", "Gudiyatham\,\ Tamil\ Nadu",
"9167357", "Telkoi\,\ Odisha",
"9175958", "Nateran\,\ Madhya\ Pradesh",
"9165442", "Gomia\,\ Bihar",
"9164595", "Thakurganj\,\ Bihar",
"9175960", "Gyraspur\,\ Madhya\ Pradesh",
"912364", "Deogad\,\ Maharashtra",
"915676", "Shikohabad\,\ Uttar\ Pradesh",
"9174902", "Pohari\,\ Madhya\ Pradesh",
"9166486", "Patnagarh\,\ Odisha",
"9182898", "Athani\,\ Karnataka",
"9187594", "Outsarangapalle\,\ Andhra\ Pradesh",
"9163453", "Jamui\,\ Bihar",
"9167686", "Parajang\,\ Odisha",
"912350", "Madangad\,\ Maharashtra",
"912670", "Shehra\,\ Gujarat",
"915463", "Lalganj\,\ Uttar\ Pradesh",
"913474", "Bethuadahari\,\ West\ Bengal",
"917862", "Bastanar\,\ Madhya\ Pradesh",
"9164232", "Maheshpur\ Raj\,\ Bihar",
"913788", "Kolaring\,\ Arunachal\ Pradesh",
"9168565", "Rayagada\,\ Odisha",
"9181754", "Holenarasipur\,\ Karnataka",
"912475", "Omerga\,\ Maharashtra",
"911852", "Taran\,\ Punjab",
"9174702", "Bundi\,\ Rajasthan",
"9171664", "Chaurai\,\ Madhya\ Pradesh",
"918835", "Rajahmundri\,\ Andhra\ Pradesh",
"9164254", "Katoria\,\ Bihar",
"9165533", "Ramgarh\,\ Bihar",
"9176438", "Bijadandi\,\ Madhya\ Pradesh",
"9166494", "Jamankira\,\ Odisha",
"913661", "Kokrajhar\,\ Assam",
"918752", "Bhainsa\,\ Andhra\ Pradesh",
"912803", "Khavda\,\ Gujarat",
"91413", "Pondicherry\,\ Tamil\ Nadu",
"914324", "Karur\,\ Tamil\ Nadu",
"91175", "Patiala\,\ Punjab",
"9161595", "Masrakh\,\ Bihar",
"911735", "Chaaharauli\,\ Haryana",
"9171035", "Butibori\,\ Maharashtra",
"9167613", "Chhendipada\,\ Odisha",
"9181732", "Sakleshpur\,\ Karnataka",
"9162785", "Dalsinghsarai\,\ Bihar",
"9176385", "Damoh\,\ Madhya\ Pradesh",
"9166816", "Jujumura\,\ Odisha",
"9164614", "Raniganj\,\ Bihar",
"912968", "Bagidora\,\ Rajasthan",
"9174242", "Malhargarh\,\ Madhya\ Pradesh",
"9168576", "Gunupur\,\ Odisha",
"913174", "Diamond\ Harbour\,\ West\ Bengal",
"912759", "Lakhtar\,\ Gujarat",
"918612", "Nellore\,\ Andhra\ Pradesh",
"91161", "Ludhiana\,\ Punjab",
"9163322", "Nabinagar\,\ Bihar",
"9166413", "Deodgarh\,\ Odisha",
"9176512", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9162423", "Benipur\,\ Bihar",
"9168527", "Koraput\,\ Odisha",
"9162283", "Pupri\,\ Bihar",
"9176463", "Nainpur\,\ Madhya\ Pradesh",
"912451", "Pathari\,\ Maharashtra",
"9167253", "Dhanmandal\,\ Odisha",
"9168663", "Umerkote\,\ Odisha",
"9168112", "Chhatrapur\,\ Odisha",
"9174664", "Bonli\,\ Rajasthan",
"9171702", "Chumur\,\ Maharashtra",
"9167955", "Udala\,\ Odisha",
"9167694", "Kamakhyanagar\,\ Odisha",
"912624", "Fortsongadh\,\ Gujarat",
"913513", "Harishchandrapur\,\ West\ Bengal",
"918247", "Mangalore\,\ Karnataka",
"912467", "Bhokar\,\ Maharashtra",
"9165832", "Kharsawa\,\ Bihar",
"918231", "Malavalli\,\ Karnataka",
"9162727", "Darbhanga\,\ Bihar",
"918632", "Guntur\,\ Andhra\ Pradesh",
"9176327", "Balaghat\,\ Madhya\ Pradesh",
"9166717", "Rajkhariar\,\ Odisha",
"911375", "Rajgarhi\,\ Uttarakhand",
"9166466", "Bargarh\,\ Odisha",
"9167922", "Baripada\,\ Odisha",
"911655", "Raman\,\ Punjab",
"912552", "Nandgaon\,\ Maharashtra",
"9164574", "Korha\,\ Bihar",
"918356", "Muddebihal\,\ Karnataka",
"9171006", "Kuhi\,\ Maharashtra",
"9174528", "Chhabra\,\ Rajasthan",
"918676", "Vuyyuru\,\ Andhra\ Pradesh",
"9181709", "Alur\,\ Karnataka",
"9176416", "Niwas\,\ Madhya\ Pradesh",
"9175299", "Laher\,\ Madhya\ Pradesh",
"9168616", "Malkangiri\,\ Odisha",
"9165624", "Daltonganj\,\ Bihar",
"914339", "Keeranur\,\ Tamil\ Nadu",
"9162776", "Phulparas\,\ Bihar",
"9168472", "G\.Udayagiri\,\ Odisha",
"9176376", "Birsa\,\ Madhya\ Pradesh",
"9161507", "Hathua\,\ Bihar",
"917745", "Chhuriakala\,\ Madhya\ Pradesh",
"913786", "Khonsa\,\ Arunachal\ Pradesh",
"911464", "Rajgarh\,\ Rajasthan",
"918463", "Armoor\,\ Andhra\ Pradesh",
"9167573", "Daspalla\,\ Odisha",
"9174637", "Gangapur\,\ Rajasthan",
"9176813", "Jatara\,\ Madhya\ Pradesh",
"9168585", "Nowrangapur\,\ Odisha",
"91372", "Lungleh\,\ Mizoram",
"914926", "Shoranur\,\ Kerala",
"918559", "Dharmavaram\,\ Andhra\ Pradesh",
"9171684", "Harrai\,\ Madhya\ Pradesh",
"9174696", "Hindaun\,\ Rajasthan",
"9167666", "Keonjhar\,\ Odisha",
"917222", "Chandurrly\,\ Maharashtra",
"913657", "Mairang\,\ Meghalaya",
"917621", "Patan\,\ Madhya\ Pradesh",
"913848", "Thonbal\,\ Manipur",
"912167", "Wai\,\ Maharashtra",
"916217", "Muzaffarpur\,\ Bihar",
"9165302", "Bundu\,\ Bihar",
"9166557", "Titlagarh\,\ Odisha",
"9165606", "Patan\,\ Bihar",
"915960", "Shahabad\,\ Uttar\ Pradesh",
"9171024", "Parseoni\,\ Maharashtra",
"9174310", "Aklera\,\ Rajasthan",
"9176365", "Baihar\,\ Madhya\ Pradesh",
"9162765", "Madhubani\,\ Bihar",
"9174939", "Karera\,\ Madhya\ Pradesh",
"917361", "Susner\,\ Madhya\ Pradesh",
"9161574", "Mairwa\,\ Bihar",
"917806", "Chitrangi\,\ Madhya\ Pradesh",
"913822", "Dharam\ Nagar\,\ Tripura",
"9166475", "Naktideul\,\ Odisha",
"9162263", "Sitamarhi\,\ Bihar",
"917281", "Sendhwa\,\ Madhya\ Pradesh",
"9167675", "Barbil\,\ Odisha",
"915612", "Ferozabad\,\ Uttar\ Pradesh",
"9168683", "Nandapur\,\ Odisha",
"917682", "Chhatarpur\,\ Madhya\ Pradesh",
"9165854", "Ghatsila\,\ Bihar",
"9176483", "Mawai\,\ Madhya\ Pradesh",
"9174684", "Khandar\,\ Rajasthan",
"914884", "Vadakkanchery\,\ Kerala",
"91360", "Itanagar\/Ziro\,\ Arunachal\ Pradesh",
"9165546", "Rajdhanwar\,\ Bihar",
"9171696", "Batkakhapa\,\ Madhya\ Pradesh",
"9171392", "Kurkheda\,\ Maharashtra",
"917325", "Burhanpur\,\ Madhya\ Pradesh",
"912966", "Sagwara\,\ Rajasthan",
"918504", "Atmakur\,\ Andhra\ Pradesh",
"911503", "Sadulshahar\,\ Rajasthan",
"912187", "Sangola\,\ Maharashtra",
"917728", "Kasdol\,\ Madhya\ Pradesh",
"9177053", "Kurud\,\ Madhya\ Pradesh",
"913019", "Pokhran\/Phalsoond\,\ Rajasthan",
"9171493", "Tamia\,\ Madhya\ Pradesh",
"917225", "Tiwasa\,\ Maharashtra",
"9161592", "Masrakh\,\ Bihar",
"914575", "Sivaganga\,\ Tamil\ Nadu",
"9168226", "Aska\,\ Odisha",
"9173213", "Sanwer\,\ Madhya\ Pradesh",
"912438", "Soyegaon\,\ Maharashtra",
"915832", "Badaun\,\ Uttar\ Pradesh",
"9175388", "Ambah\,\ Madhya\ Pradesh",
"9181735", "Sakleshpur\,\ Karnataka",
"911392", "Budhana\,\ Uttar\ Pradesh",
"9163263", "Sherghati\,\ Bihar",
"915311", "Salon\,\ Uttar\ Pradesh",
"9168486", "Kotagarh\,\ Odisha",
"9162782", "Dalsinghsarai\,\ Bihar",
"915876", "Mohammadi\,\ Uttar\ Pradesh",
"9176382", "Damoh\,\ Madhya\ Pradesh",
"911539", "Tibbi\,\ Rajasthan",
"9175264", "Ghatigaon\,\ Madhya\ Pradesh",
"9171032", "Butibori\,\ Maharashtra",
"9173294", "Khakner\,\ Madhya\ Pradesh",
"9174943", "Kolaras\,\ Madhya\ Pradesh",
"9171837", "Tumsar\,\ Maharashtra",
"918183", "Sagar\,\ Karnataka",
"917662", "Rewa\,\ Madhya\ Pradesh",
"918727", "Huzurabad\,\ Andhra\ Pradesh",
"9163325", "Nabinagar\,\ Bihar",
"9171374", "Desaiganj\,\ Maharashtra",
"9165654", "Latehar\,\ Bihar",
"917261", "Deolgaonraja\,\ Maharashtra",
"9176515", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9174560", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9174307", "Khanpur\,\ Rajasthan",
"911336", "Deoband\,\ Uttar\ Pradesh",
"9174245", "Malhargarh\,\ Madhya\ Pradesh",
"915144", "Safipur\,\ Uttar\ Pradesh",
"9174558", "Digod\/Sultanpur\,\ Rajasthan",
"912870", "Malia\ Hatina\,\ Gujarat",
"9165293", "Itki\,\ Bihar",
"918913", "Visakhapatnam\,\ Andhra\ Pradesh",
"9171414", "Betul\,\ Madhya\ Pradesh",
"914864", "Adimaly\,\ Kerala",
"912555", "Satana\,\ Maharashtra",
"911652", "Mansa\,\ Punjab",
"911372", "Chamoli\,\ Uttarakhand",
"9176508", "Beohari\,\ Madhya\ Pradesh",
"911251", "Jhajjar\,\ Haryana",
"9171705", "Chumur\,\ Maharashtra",
"9167952", "Udala\,\ Odisha",
"91253", "Nasik\ City\,\ Maharashtra",
"918635", "Guntur\,\ Andhra\ Pradesh",
"9176357", "Lanji\,\ Madhya\ Pradesh",
"912986", "Barmer\/Dhorimanna\,\ Rajasthan",
"9165403", "Govindpur\,\ Bihar",
"9171896", "Amagaon\,\ Maharashtra",
"9162757", "Rosera\,\ Bihar",
"916317", "Gaya\,\ Bihar",
"9177030", "Manpur\,\ Madhya\ Pradesh",
"9168115", "Chhatrapur\,\ Odisha",
"9164592", "Thakurganj\,\ Bihar",
"9165445", "Gomia\,\ Bihar",
"913861", "Tuengsang\,\ Nagaland",
"9174918", "Narwar\,\ Madhya\ Pradesh",
"917608", "Bijawar\,\ Madhya\ Pradesh",
"9171743", "Mul\,\ Maharashtra",
"9176253", "Umariapan\,\ Madhya\ Pradesh",
"912487", "Shrigonda\,\ Maharashtra",
"9164733", "Supaul\,\ Bihar",
"9165632", "Bhawanathpur\,\ Bihar",
"9165336", "Basia\,\ Bihar",
"914551", "Vedasandur\,\ Tamil\ Nadu",
"912138", "Shirur\,\ Maharashtra",
"9168494", "Daringbadi\,\ Odisha",
"915523", "Maharajganj\,\ Uttar\ Pradesh",
"912343", "Atpadi\,\ Maharashtra",
"9174905", "Pohari\,\ Madhya\ Pradesh",
"917685", "Nowgaon\,\ Madhya\ Pradesh",
"9165824", "Chaibasa\,\ Bihar",
"9174203", "Jawad\,\ Madhya\ Pradesh",
"9167934", "Betanati\,\ Odisha",
"9165397", "Bolwa\,\ Bihar",
"912591", "Manmad\,\ Maharashtra",
"918812", "Eluru\,\ Andhra\ Pradesh",
"918256", "Belthangady\,\ Karnataka",
"9163367", "Rajauli\,\ Bihar",
"9174374", "Nainwa\,\ Rajasthan",
"913825", "Khowai\,\ Tripura",
"91496", "Vatakara\,\ Kerala",
"918483", "Humnabad\,\ Karnataka",
"9164235", "Maheshpur\ Raj\,\ Bihar",
"91181", "Jallandhar\,\ Punjab",
"911484", "Shahapura\,\ Rajasthan",
"9168413", "Boudh\,\ Odisha",
"9161847", "Sasaram\,\ Bihar",
"9173248", "Mhow\,\ Madhya\ Pradesh",
"915444", "Robertsganj\,\ Uttar\ Pradesh",
"9166576", "Kantabhanji\,\ Odisha",
"9171054", "Narkhed\,\ Maharashtra",
"912824", "Dhoraji\,\ Gujarat",
"9174705", "Bundi\,\ Rajasthan",
"9167866", "Chandbali\,\ Odisha",
"9166527", "Balangir\,\ Odisha",
"918331", "Raibag\/Kudchi\,\ Karnataka",
"9162517", "Bagaha\,\ Bihar",
"9168562", "Rayagada\,\ Odisha",
"911275", "Palwal\,\ Haryana",
"917283", "Maheshwar\,\ Madhya\ Pradesh",
"9167646", "Anugul\,\ Odisha",
"918694", "Ramannapet\,\ Andhra\ Pradesh",
"9171617", "Parasia\,\ Madhya\ Pradesh",
"911693", "Barwala\,\ Haryana",
"91286", "Porbander\,\ Gujarat",
"9166843", "Paikamal\,\ Odisha",
"9165457", "Mandu\,\ Bihar",
"9176303", "Katangi\,\ Madhya\ Pradesh",
"918360", "Hubli\,\ Karnataka",
"911466", "Kekri\,\ Rajasthan",
"9174353", "Gangdhar\,\ Rajasthan",
"9165575", "Bagodar\,\ Bihar",
"913784", "Nefra\,\ Arunachal\ Pradesh",
"9182896", "Athani\,\ Karnataka",
"9171422", "Bhimpur\,\ Madhya\ Pradesh",
"914924", "Mannarkad\,\ Kerala",
"911501", "Srikaranpur\,\ Rajasthan",
"9161523", "Chapra\,\ Bihar",
"9173249", "Mhow\,\ Madhya\ Pradesh",
"9164625", "Dhamdaha\,\ Bihar",
"9166784", "Nowparatan\,\ Odisha",
"916803", "Berhampur\,\ Odisha",
"91790", "Ahmedabad\ Local\,\ Gujarat",
"918354", "Bagalkot\,\ Karnataka",
"9161855", "Bikramganj\,\ Bihar",
"918674", "Gudivada\,\ Andhra\ Pradesh",
"913830", "Champai\/Chiapui\,\ Mizoram",
"9174330", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9165482", "Ichak\,\ Bihar",
"9175956", "Nateran\,\ Madhya\ Pradesh",
"9165222", "Muri\,\ Bihar",
"917363", "Berchha\,\ Madhya\ Pradesh",
"9174919", "Narwar\,\ Madhya\ Pradesh",
"9176274", "Manpur\,\ Madhya\ Pradesh",
"9166446", "Rairakhol\,\ Odisha",
"918700", "Warangal\,\ Andhra\ Pradesh",
"9177007", "Nagri\,\ Madhya\ Pradesh",
"917859", "Lohadigundah\,\ Madhya\ Pradesh",
"9182203", "Gundlupet\,\ Karnataka",
"918461", "Dichpalli\,\ Andhra\ Pradesh",
"9174617", "Mahuwa\,\ Rajasthan",
"912964", "Dungarpur\,\ Rajasthan",
"9176509", "Beohari\,\ Madhya\ Pradesh",
"912642", "Bharuch\,\ Gujarat",
"9165566", "Tisri\,\ Bihar",
"918506", "Narayanpet\,\ Andhra\ Pradesh",
"917515", "Gwalior\,\ Madhya\ Pradesh",
"917230", "Ghatanji\,\ Maharashtra",
"9161156", "Danapur\,\ Bihar",
"9164772", "Triveniganj\,\ Bihar",
"9162243", "Hajipur\,\ Bihar",
"9171353", "Chamorshi\,\ Maharashtra",
"9165673", "Barwadih\,\ Bihar",
"9164667", "Kishanganj\,\ Bihar",
"912628", "Nizar\,\ Gujarat",
"9174559", "Digod\/Sultanpur\,\ Rajasthan",
"917623", "Kundam\,\ Madhya\ Pradesh",
"9164523", "Katihar\,\ Bihar",
"918425", "Biligi\,\ Karnataka",
"9174257", "Garoth\,\ Madhya\ Pradesh",
"9168697", "Papadhandi\,\ Odisha",
"9174800", "Goharganj\,\ Madhya\ Pradesh",
"918649", "Piduguralla\,\ Andhra\ Pradesh",
"9176497", "Kakaiya\,\ Madhya\ Pradesh",
"917804", "Kusmi\,\ Madhya\ Pradesh",
"9173220", "Depalpur\,\ Madhya\ Pradesh",
"9172874", "Gogaon\,\ Madhya\ Pradesh",
"9167524", "Puri\,\ Odisha",
"914328", "Perambalur\,\ Tamil\ Nadu",
"9166737", "Jayapatna\,\ Odisha",
"911234", "Baghpat\/Baraut\,\ Uttar\ Pradesh",
"9165812", "Bhandaria\,\ Bihar",
"914342", "Dharmapuri\,\ Tamil\ Nadu",
"9168636", "Bisam\ Cuttack\,\ Odisha",
"9177074", "Bagbahera\,\ Madhya\ Pradesh",
"9176436", "Bijadandi\,\ Madhya\ Pradesh",
"912950", "Dhariawad\,\ Rajasthan",
"9166796", "Komana\,\ Odisha",
"9176345", "Lamta\,\ Madhya\ Pradesh",
"9162745", "Samastipur\,\ Bihar",
"912762", "Mehsana\,\ Gujarat",
"918620", "Udaygiri\,\ Andhra\ Pradesh",
"9164215", "Naugachia\,\ Bihar",
"912984", "Barmer\/Sindari\,\ Rajasthan",
"9168433", "Puruna\ Katak\,\ Odisha",
"918481", "Basavakalyan\,\ Karnataka",
"9174817", "Gairatganj\,\ Madhya\ Pradesh",
"9171487", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9164794", "Udakishanganj\,\ Bihar",
"9167405", "Bhubaneshwar\,\ Odisha",
"918209", "Udupi\,\ Karnataka",
"9162596", "Pakridayal\,\ Bihar",
"9166545", "Sonapur\,\ Odisha",
"914637", "Valliyoor\,\ Tamil\ Nadu",
"9165252", "Simdega\,\ Bihar",
"912114", "Lonavala\,\ Maharashtra",
"9175926", "Vidisha\,\ Madhya\ Pradesh",
"9174540", "Chhipaborad\,\ Rajasthan",
"9165873", "Chakardharpur\,\ Bihar",
"9174963", "Pichhore\,\ Madhya\ Pradesh",
"9189467", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9174265", "Sitamau\,\ Madhya\ Pradesh",
"9161825", "Arrah\,\ Bihar",
"9162537", "Narkatiaganj\,\ Bihar",
"918333", "Hukkeri\/Sankeshwar\,\ Karnataka",
"9167295", "Pattamundai\,\ Odisha",
"918789", "Karimnagar\,\ Andhra\ Pradesh",
"911334", "Roorkee\/Haridwar\,\ Uttarakhand",
"917578", "Pachmarhi\,\ Madhya\ Pradesh",
"912140", "Mangaon\,\ Maharashtra",
"915874", "Nighasan\/Dhaurehra\,\ Uttar\ Pradesh",
"9161553", "Ekma\,\ Bihar",
"913863", "Kiphire\,\ Nagaland",
"9174938", "Karera\,\ Madhya\ Pradesh",
"9163243", "Nawada\,\ Bihar",
"9171452", "Chicholi\,\ Madhya\ Pradesh",
"9174600", "Sahabad\,\ Rajasthan",
"9165476", "Chavparan\,\ Bihar",
"915521", "Bansgaon\/Barhal\ Ganj\,\ Uttar\ Pradesh",
"9165316", "Mandar\,\ Bihar",
"9165612", "Garhwa\,\ Bihar",
"914553", "Oddanchatram\,\ Tamil\ Nadu",
"915947", "Kashipur\,\ Uttar\ Pradesh",
"9165287", "Khunti\,\ Bihar",
"9164713", "Birpur\,\ Bihar",
"9174323", "Jhalawar\,\ Rajasthan",
"9165427", "Bokaro\,\ Bihar",
"912341", "Kavathemankal\,\ Maharashtra",
"918577", "Putturu\,\ Andhra\ Pradesh",
"912593", "Surgena\,\ Maharashtra",
"9167914", "Bangiriposi\,\ Odisha",
"9167532", "Nayagarh\,\ Odisha",
"917263", "Khamgaon\,\ Maharashtra",
"912826", "Upleta\,\ Gujarat",
"912765", "Visnagar\,\ Gujarat",
"9176535", "Bandhavgarh\,\ Madhya\ Pradesh",
"9167846", "Bhadrak\,\ Odisha",
"9171817", "Lakhandur\,\ Maharashtra",
"918181", "Thirthahalli\,\ Karnataka",
"9163495", "Jhajha\,\ Bihar",
"9168542", "Jeypore\,\ Odisha",
"9171434", "Bhainsdehi\,\ Madhya\ Pradesh",
"9174276", "Bhanpura\,\ Madhya\ Pradesh",
"91288", "Jamnagar\,\ Gujarat",
"9162584", "Areraj\,\ Bihar",
"918380", "Navalgund\,\ Karnataka",
"9175904", "Lateri\,\ Madhya\ Pradesh",
"9171963", "Arjuni\ Morgaon\,\ Maharashtra",
"911486", "Mandal\,\ Rajasthan",
"9167554", "Khurda\,\ Odisha",
"911253", "Tohsham\,\ Haryana",
"918254", "Kundapur\,\ Karnataka",
"9164786", "Saharsa\,\ Bihar",
"9161867", "Aurangabad\,\ Bihar",
"918422", "Chadchan\,\ Karnataka",
"9165383", "Torpa\,\ Bihar",
"915446", "Dudhi\/Pipri\,\ Uttar\ Pradesh",
"9174227", "Mandsaur\,\ Madhya\ Pradesh",
"9177010", "Pingeshwar\,\ Madhya\ Pradesh",
"9175298", "Laher\,\ Madhya\ Pradesh",
"9173935", "Jobat\,\ Madhya\ Pradesh",
"9164553", "Forbesganj\,\ Bihar",
"9165234", "Ghaghra\,\ Bihar",
"9181708", "Alur\,\ Karnataka",
"9174529", "Chhabra\,\ Rajasthan",
"917447", "Ladpura\/Kota\,\ Rajasthan",
"911528", "Lunkaransar\,\ Rajasthan",
"9176292", "Pushprajgarh\,\ Madhya\ Pradesh",
"9171323", "Gadchiroli\,\ Maharashtra",
"9174411", "Ladpura\/Kota\,\ Rajasthan",
"9173233", "Punasa\,\ Madhya\ Pradesh",
"9161126", "Biharsharif\,\ Bihar",
"9171763", "Warora\,\ Maharashtra",
"915313", "Salon\/Jais\,\ Uttar\ Pradesh",
"9165465", "Hazaribagh\,\ Bihar",
"917512", "Gwalior\,\ Madhya\ Pradesh",
"912645", "Jhagadia\,\ Gujarat",
"912429", "Shevgaon\,\ Maharashtra",
"9168602", "Boriguma\,\ Odisha",
"9176402", "Shahpur\,\ Madhya\ Pradesh",
"911341", "Najibabad\,\ Uttar\ Pradesh",
"9165843", "Bishrampur\,\ Bihar",
"9164297", "Kahalgaon\,\ Bihar",
"9167865", "Chandbali\,\ Odisha",
"9166457", "Jharsuguda\,\ Odisha",
"9174570", "Mangrol\,\ Rajasthan",
"9174706", "Bundi\,\ Rajasthan",
"915742", "Etah\,\ Uttar\ Pradesh",
"918865", "Yelavaram\,\ Andhra\ Pradesh",
"9171364", "Etapalli\,\ Maharashtra",
"911782", "Rampur\ Bushahar\,\ Himachal\ Pradesh",
"9175947", "Ganjbasoda\,\ Madhya\ Pradesh",
"917791", "Gadarwara\,\ Madhya\ Pradesh",
"918594", "Chirala\,\ Andhra\ Pradesh",
"911593", "Khetri\,\ Rajasthan",
"916316", "Gaya\,\ Bihar",
"917832", "Rajpur\,\ Madhya\ Pradesh",
"9164236", "Maheshpur\ Raj\,\ Bihar",
"912987", "Sheo\,\ Rajasthan",
"915180", "Fatehpur\,\ Uttar\ Pradesh",
"912117", "Daund\,\ Maharashtra",
"9167682", "Parajang\,\ Odisha",
"9166575", "Kantabhanji\,\ Odisha",
"914634", "Ambasamudram\,\ Tamil\ Nadu",
"91369", "Mokokchung\,\ Nagaland",
"9167217", "Narsinghpur\,\ Odisha",
"9171724", "Chandrapur\,\ Maharashtra",
"912186", "Pandharpur\,\ Maharashtra",
"918821", "Jangareddygudem\,\ Andhra\ Pradesh",
"9174906", "Pohari\,\ Madhya\ Pradesh",
"9166482", "Patnagarh\,\ Odisha",
"91212", "Chinchwad\,\ Maharashtra",
"911573", "Laxmangarh\,\ Rajasthan",
"917771", "Manendragarh\,\ Madhya\ Pradesh",
"9163273", "Rafiganj\,\ Bihar",
"9165446", "Gomia\,\ Bihar",
"917479", "Bundi\,\ Rajasthan",
"9171137", "Saoner\,\ Maharashtra",
"918113", "Channapatna\,\ Karnataka",
"915944", "Kichha\/Rudrapur\,\ Uttar\ Pradesh",
"9165335", "Basia\,\ Bihar",
"9166222", "Sundargarh\,\ Odisha",
"9168183", "Buguda\,\ Odisha",
"915662", "Chhata\/Kosikalan\,\ Uttar\ Pradesh",
"9167657", "Palla\ Hara\,\ Odisha",
"915261", "Tarabganj\/Colonelganj\,\ Uttar\ Pradesh",
"918257", "Sullia\,\ Karnataka",
"9163377", "Arwal\,\ Bihar",
"9174364", "Hindoli\,\ Rajasthan",
"9167827", "Balasore\,\ Odisha",
"9171706", "Chumur\,\ Maharashtra",
"9171895", "Amagaon\,\ Maharashtra",
"9165937", "Manoharpur\,\ Bihar",
"911429", "Bassi\,\ Rajasthan",
"9163417", "Seikhpura\,\ Bihar",
"9168116", "Chhatrapur\,\ Odisha",
"912528", "Dahanu\,\ Maharashtra",
"917523", "Bhander\,\ Madhya\ Pradesh",
"9163326", "Nabinagar\,\ Bihar",
"9176516", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9164314", "Jharmundi\,\ Bihar",
"9174246", "Malhargarh\,\ Madhya\ Pradesh",
"917410", "Alot\,\ Madhya\ Pradesh",
"912938", "Bali\,\ Rajasthan",
"9168572", "Gunupur\,\ Odisha",
"9181736", "Sakleshpur\,\ Karnataka",
"917755", "Mungeli\,\ Madhya\ Pradesh",
"9168485", "Kotagarh\,\ Odisha",
"9166812", "Jujumura\,\ Odisha",
"917258", "Akot\,\ Maharashtra",
"9167313", "Anandapur\,\ Odisha",
"9176389", "Damoh\,\ Madhya\ Pradesh",
"918549", "Kalwakurthy\,\ Andhra\ Pradesh",
"911268", "Ferojpur\,\ Haryana",
"91416", "Vellore\,\ Tamil\ Nadu",
"9161147", "Jahanabad\,\ Bihar",
"917444", "Ladpura\/Kota\,\ Rajasthan",
"9171184", "Kalmeshwar\,\ Maharashtra",
"918520", "Pattikonda\,\ Andhra\ Pradesh",
"911765", "Nabha\,\ Punjab",
"911826", "Phillaur\,\ Punjab",
"9168225", "Aska\,\ Odisha",
"9174924", "Shivpuri\,\ Madhya\ Pradesh",
"918413", "Hyderabad\ West\/Shamshabad\,\ Andhra\ Pradesh",
"9174137", "Sailana\,\ Madhya\ Pradesh",
"9174593", "Ramganj\ Mandi\,\ Rajasthan",
"9167627", "Dhenkanal\,\ Odisha",
"911368", "Pauri\,\ Uttarakhand",
"9165545", "Rajdhanwar\,\ Bihar",
"913787", "Seppa\,\ Arunachal\ Pradesh",
"9167563", "Balugaon\,\ Odisha",
"9171695", "Batkakhapa\,\ Madhya\ Pradesh",
"9166252", "Lahunipara\,\ Odisha",
"9168594", "Motu\,\ Odisha",
"9175210", "Seondha\,\ Madhya\ Pradesh",
"912353", "Rajapur\,\ Maharashtra",
"912673", "Dahod\,\ Gujarat",
"9167676", "Barbil\,\ Odisha",
"9171043", "Hingua\,\ Maharashtra",
"9164202", "Amarpur\,\ Bihar",
"913656", "Mawkyrwat\,\ Meghalaya",
"915460", "Phulpur\,\ Uttar\ Pradesh",
"9167412", "Bhubaneshwar\,\ Odisha",
"9171754", "Bhadrawati\,\ Maharashtra",
"918246", "Mangalore\,\ Karnataka",
"914373", "Pattukottai\,\ Tamil\ Nadu",
"912466", "Kandhar\,\ Maharashtra",
"917835", "Bharathpur\,\ Madhya\ Pradesh",
"915454", "Machlishahar\,\ Uttar\ Pradesh",
"9174932", "Karera\,\ Madhya\ Pradesh",
"9174514", "Atru\,\ Rajasthan",
"9166476", "Naktideul\,\ Odisha",
"918677", "Kaikaluru\,\ Andhra\ Pradesh",
"918357", "Badami\,\ Karnataka",
"911785", "Pooh\,\ Himachal\ Pradesh",
"9165605", "Patan\,\ Bihar",
"918862", "Razole\,\ Andhra\ Pradesh",
"915745", "Jalesar\,\ Uttar\ Pradesh",
"9166427", "Kuchinda\,\ Odisha",
"91491", "Palakkad\,\ Kerala",
"9176366", "Baihar\,\ Madhya\ Pradesh",
"915248", "Barabanki\,\ Uttar\ Pradesh",
"9168462", "Baliguda\,\ Odisha",
"9162766", "Madhubani\,\ Bihar",
"91186", "Pathankot\,\ Punjab",
"914829", "Vaikom\,\ Kerala",
"9165643", "Nagarutari\,\ Bihar",
"9174695", "Hindaun\,\ Rajasthan",
"9162273", "Mahua\,\ Bihar",
"9174954", "Badarwas\,\ Madhya\ Pradesh",
"9167665", "Keonjhar\,\ Odisha",
"911762", "Rajpura\,\ Punjab",
"915361", "Musafirkhana\,\ Uttar\ Pradesh",
"9171732", "Rajura\,\ Maharashtra",
"912967", "Aspur\,\ Rajasthan",
"9168586", "Nowrangapur\,\ Odisha",
"917752", "Bilaspur\,\ Madhya\ Pradesh",
"9167882", "Soro\,\ Odisha",
"9171005", "Kuhi\,\ Maharashtra",
"912166", "Phaltan\,\ Maharashtra",
"9176415", "Niwas\,\ Madhya\ Pradesh",
"9168615", "Malkangiri\,\ Odisha",
"916216", "Muzaffarpur\,\ Bihar",
"9177044", "Deobhog\,\ Madhya\ Pradesh",
"9176298", "Pushprajgarh\,\ Madhya\ Pradesh",
"9171514", "Samudrapur\,\ Maharashtra",
"9181702", "Alur\,\ Karnataka",
"9162775", "Phulparas\,\ Bihar",
"9175292", "Laher\,\ Madhya\ Pradesh",
"911628", "Samrala\,\ Punjab",
"9176375", "Birsa\,\ Madhya\ Pradesh",
"9176408", "Shahpur\,\ Madhya\ Pradesh",
"911964", "Kalakot\,\ Jammu\ And\ Kashmir",
"9165503", "Hunterganj\,\ Bihar",
"9161564", "Gopalganj\,\ Bihar",
"918963", "Parvathipuram\,\ Andhra\ Pradesh",
"911237", "Sardhana\,\ Uttar\ Pradesh",
"9166465", "Bargarh\,\ Odisha",
"915281", "Mahoba\,\ Uttar\ Pradesh",
"9161125", "Biharsharif\,\ Bihar",
"9166832", "Padmapur\,\ Odisha",
"918532", "Raichur\,\ Karnataka",
"9164283", "Nala\,\ Bihar",
"918719", "Mahabubbad\,\ Andhra\ Pradesh",
"912372", "Patan\,\ Maharashtra",
"918399", "Huvinahadagali\,\ Karnataka",
"9165466", "Hazaribagh\,\ Bihar",
"911555", "Nohar\,\ Rajasthan",
"913220", "Contai\,\ West\ Bengal",
"9176409", "Shahpur\,\ Madhya\ Pradesh",
"9167333", "Ghatgaon\,\ Odisha",
"918922", "Vizayanagaram\,\ Andhra\ Pradesh",
"915946", "Haldwani\,\ Uttar\ Pradesh",
"9173936", "Jobat\,\ Madhya\ Pradesh",
"917565", "Berasia\,\ Madhya\ Pradesh",
"9161352", "Bikram\,\ Bihar",
"912184", "Barsi\,\ Maharashtra",
"918411", "Tanduru\,\ Andhra\ Pradesh",
"911870", "Jugial\,\ Punjab",
"918576", "Satyavedu\,\ Andhra\ Pradesh",
"9174522", "Chhabra\,\ Rajasthan",
"9176299", "Pushprajgarh\,\ Madhya\ Pradesh",
"9165917", "Chandil\,\ Bihar",
"916314", "Gaya\,\ Bihar",
"918659", "Mylavaram\,\ Andhra\ Pradesh",
"918379", "Hangal\,\ Karnataka",
"912712", "Gandhi\ Nagar\,\ Gujarat",
"914636", "Sankarankovil\,\ Tamil\ Nadu",
"912929", "Shergarh\/Balesar\,\ Rajasthan",
"9164785", "Saharsa\,\ Bihar",
"9176536", "Bandhavgarh\,\ Madhya\ Pradesh",
"9167845", "Bhadrak\,\ Odisha",
"9171344", "Bhamregadh\,\ Maharashtra",
"918724", "Jagtial\,\ Andhra\ Pradesh",
"9167284", "Jajapur\ Town\,\ Odisha",
"9174973", "Khaniadhana\,\ Madhya\ Pradesh",
"9161804", "Adhaura\,\ Bihar",
"9165863", "Chainpur\,\ Bihar",
"9175967", "Gyraspur\,\ Madhya\ Pradesh",
"918596", "Markapur\,\ Andhra\ Pradesh",
"9163496", "Jhajha\,\ Bihar",
"911438", "Newai\,\ Rajasthan",
"9174275", "Bhanpura\,\ Madhya\ Pradesh",
"913462", "Suri\,\ West\ Bengal",
"9168197", "Surada\,\ Odisha",
"9164334", "Jamtara\,\ Bihar",
"918823", "Chintalapudi\,\ Andhra\ Pradesh",
"911824", "Phagwara\,\ Punjab",
"917446", "Ladpura\/Kota\,\ Rajasthan",
"913485", "Dhuliyan\,\ West\ Bengal",
"918310", "Belgaum\,\ Karnataka",
"917773", "Odgi\,\ Madhya\ Pradesh",
"911571", "Fatehpur\,\ Rajasthan",
"912778", "Idar\,\ Gujarat",
"912484", "Partur\,\ Maharashtra",
"91281", "Rajkot\,\ Gujarat",
"9164352", "Pakur\,\ Bihar",
"9171773", "Brahmapuri\,\ Maharashtra",
"91799", "Ahmedabad\ Local\,\ Gujarat",
"9165475", "Chavparan\,\ Bihar",
"915263", "Balarampur\/Balrampur\,\ Uttar\ Pradesh",
"9171522", "Wardha\,\ Maharashtra",
"9165315", "Mandar\,\ Bihar",
"9162232", "Motipur\,\ Bihar",
"918111", "Hosakote\,\ Karnataka",
"9163484", "Mallehpur\,\ Bihar",
"912827", "Kotdasanghani\,\ Gujarat",
"917820", "Khairagarh\,\ Madhya\ Pradesh",
"911343", "Nagina\,\ Uttar\ Pradesh",
"9174266", "Sitamau\,\ Madhya\ Pradesh",
"911591", "Merta\/Gotan\,\ Rajasthan",
"9161826", "Arrah\,\ Bihar",
"917793", "Kareli\,\ Madhya\ Pradesh",
"918770", "Tirupathi\,\ Andhra\ Pradesh",
"9167296", "Pattamundai\,\ Odisha",
"9165582", "Dumri\(Isribazar\)\,\ Bihar",
"9166854", "Sohela\,\ Odisha",
"917582", "Sagar\,\ Madhya\ Pradesh",
"9171973", "Mohadi\,\ Maharashtra",
"91797", "Ahmedabad\ Local\,\ Gujarat",
"9164216", "Naugachia\,\ Bihar",
"911487", "Banera\,\ Rajasthan",
"9175223", "Datia\,\ Madhya\ Pradesh",
"9164387", "Madhupur\,\ Bihar",
"9167406", "Bhubaneshwar\,\ Odisha",
"9174344", "Pirawa\/Raipur\,\ Rajasthan",
"911603", "Kharar\,\ Punjab",
"9167237", "Athgarh\,\ Odisha",
"9162595", "Pakridayal\,\ Bihar",
"917849", "Baderajpur\,\ Madhya\ Pradesh",
"9166546", "Sonapur\,\ Odisha",
"9163224", "Wazirganj\,\ Bihar",
"915447", "Dudhi\,\ Uttar\ Pradesh",
"91423", "Udhagamandalam\,\ Tamil\ Nadu",
"9175925", "Vidisha\,\ Madhya\ Pradesh",
"9161877", "Mohania\,\ Bihar",
"914255", "Palladam\,\ Tamil\ Nadu",
"9168635", "Bisam\ Cuttack\,\ Odisha",
"9174587", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"918458", "Narsapur\,\ Andhra\ Pradesh",
"9176435", "Bijadandi\,\ Madhya\ Pradesh",
"9167603", "Talcher\,\ Odisha",
"913465", "Nalhati\,\ West\ Bengal",
"9164544", "Purnea\,\ Bihar",
"9176346", "Lamta\,\ Madhya\ Pradesh",
"9166795", "Komana\,\ Odisha",
"9162746", "Samastipur\,\ Bihar",
"9171534", "Hinganghat\,\ Maharashtra",
"9168442", "Kantamal\,\ Odisha",
"9166214", "Hemgiri\,\ Odisha",
"9162224", "Sheohar\,\ Bihar",
"913714", "Rangapara\,\ Assam",
"9176264", "Vijayraghogarh\,\ Madhya\ Pradesh",
"918244", "Mangalore\,\ Karnataka",
"9176388", "Damoh\,\ Madhya\ Pradesh",
"912715", "Viramgam\,\ Gujarat",
"915283", "Charkhari\,\ Uttar\ Pradesh",
"9127172", "Sanand\,\ Gujarat",
"911639", "Faridakot\,\ Punjab",
"9175382", "Ambah\,\ Madhya\ Pradesh",
"9174552", "Digod\/Sultanpur\,\ Rajasthan",
"9171063", "Bhiwapur\,\ Maharashtra",
"9176241", "Sihora\,\ Madhya\ Pradesh",
"9168102", "Khalikote\,\ Odisha",
"9171712", "Gond\ Pipri\,\ Maharashtra",
"9161322", "Barh\,\ Bihar",
"917562", "Sehore\,\ Madhya\ Pradesh",
"9163232", "Dumraon\,\ Bihar",
"913654", "Nongstoin\,\ Meghalaya",
"911467", "Kekri\,\ Rajasthan",
"9165565", "Tisri\,\ Bihar",
"911552", "Hanumangarh\,\ Rajasthan",
"914119", "Ponneri\,\ Tamil\ Nadu",
"918210", "Mysore\,\ Karnataka",
"912375", "Pusegaon\,\ Maharashtra",
"9176502", "Beohari\,\ Madhya\ Pradesh",
"918535", "Sindhanur\,\ Karnataka",
"9161155", "Danapur\,\ Bihar",
"9166403", "Bagdihi\,\ Odisha",
"9175955", "Nateran\,\ Madhya\ Pradesh",
"914371", "Arantangi\,\ Tamil\ Nadu",
"914252", "Udumalpet\,\ Tamil\ Nadu",
"9161544", "Siwan\,\ Bihar",
"9168533", "Sunabeda\,\ Odisha",
"9163254", "Pakribarwan\,\ Bihar",
"914651", "Kuzhithurai\,\ Tamil\ Nadu",
"918158", "Sidlaghatta\,\ Karnataka",
"9171587", "Deoli\,\ Maharashtra",
"9166445", "Rairakhol\,\ Odisha",
"9172864", "Khetia\,\ Madhya\ Pradesh",
"9174912", "Narwar\,\ Madhya\ Pradesh",
"9174534", "Baran\,\ Rajasthan",
"9166824", "Attabira\,\ Odisha",
"917585", "Rehli\,\ Madhya\ Pradesh",
"9177064", "Gariaband\,\ Madhya\ Pradesh",
"916214", "Muzaffarpur\,\ Bihar",
"9161856", "Bikramganj\,\ Bihar",
"912164", "Karad\,\ Maharashtra",
"912691", "Kapad\ Wanj\,\ Gujarat",
"9162437", "Begusarai\,\ Bihar",
"9165576", "Bagodar\,\ Bihar",
"9171552", "Seloo\,\ Maharashtra",
"9173242", "Mhow\,\ Madhya\ Pradesh",
"9182895", "Athani\,\ Karnataka",
"914543", "Batlagundu\,\ Tamil\ Nadu",
"9164626", "Dhamdaha\,\ Bihar",
"9164322", "Deoghar\,\ Bihar",
"9167645", "Anugul\,\ Odisha",
"9165663", "Japla\,\ Bihar",
"9164762", "Madhepura\,\ Bihar",
"912351", "Langa\,\ Maharashtra",
"913482", "Berhampur\,\ West\ Bengal",
"9164677", "Banmankhi\,\ Bihar",
"9166247", "Rajgangpur\,\ Odisha",
"9176350", "Lanji\,\ Madhya\ Pradesh",
"9162464", "Jainagar\,\ Bihar",
"913581", "Dinhata\,\ West\ Bengal",
"9167536", "Nayagarh\,\ Odisha",
"912367", "Kankavali\,\ Maharashtra",
"9176284", "Karpa\,\ Madhya\ Pradesh",
"917360", "Shujalpur\,\ Madhya\ Pradesh",
"9164517", "Barsoi\,\ Bihar",
"9176368", "Baihar\,\ Madhya\ Pradesh",
"918703", "Warangal\,\ Andhra\ Pradesh",
"9177037", "Manpur\,\ Madhya\ Pradesh",
"911475", "Begun\/Rawatbhata\,\ Rajasthan",
"911704", "Paonta\,\ Himachal\ Pradesh",
"9166774", "Narlaroad\,\ Odisha",
"917694", "Keolari\,\ Madhya\ Pradesh",
"9171525", "Wardha\,\ Maharashtra",
"918456", "Narayankhed\,\ Andhra\ Pradesh",
"9174567", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"918283", "Salkani\,\ Karnataka",
"9165312", "Mandar\,\ Bihar",
"9165616", "Garhwa\,\ Bihar",
"9162235", "Motipur\,\ Bihar",
"9174623", "Sawaimadhopur\,\ Rajasthan",
"911284", "Bawal\,\ Haryana",
"9168624", "Gudari\,\ Odisha",
"9164355", "Pakur\,\ Bihar",
"914892", "Minicoy\,\ Lakshadweep",
"9176424", "Mandla\,\ Madhya\ Pradesh",
"915244", "Haidergarh\,\ Uttar\ Pradesh",
"915961", "Munsiari\,\ Uttar\ Pradesh",
"9171456", "Chicholi\,\ Madhya\ Pradesh",
"9165472", "Chavparan\,\ Bihar",
"9174300", "Khanpur\,\ Rajasthan",
"9165585", "Dumri\(Isribazar\)\,\ Bihar",
"918363", "Hubli\,\ Karnataka",
"911364", "Ukhimath\/Guptkashi\,\ Uttarakhand",
"9174269", "Sitamau\,\ Madhya\ Pradesh",
"9171853", "Pauni\,\ Maharashtra",
"911495", "Mandawar\,\ Rajasthan",
"9162592", "Pakridayal\,\ Bihar",
"917674", "Maihar\,\ Madhya\ Pradesh",
"917125", "Nagpur\,\ Maharashtra",
"911902", "Kullu\,\ Himachal\ Pradesh",
"9165256", "Simdega\,\ Bihar",
"917280", "Barwaha\,\ Madhya\ Pradesh",
"9175922", "Vidisha\,\ Madhya\ Pradesh",
"9162733", "Jhajharpur\,\ Bihar",
"9176333", "Waraseoni\,\ Madhya\ Pradesh",
"912953", "Nathdwara\,\ Rajasthan",
"9168606", "Boriguma\,\ Odisha",
"9176406", "Shahpur\,\ Madhya\ Pradesh",
"9164757", "S\.Bakhtiarpur\,\ Bihar",
"9161122", "Biharsharif\,\ Bihar",
"9166835", "Padmapur\,\ Odisha",
"911624", "Jagraon\,\ Punjab",
"918623", "Sullurpet\,\ Andhra\ Pradesh",
"917769", "Bagicha\,\ Madhya\ Pradesh",
"91477", "Alappuzha\,\ Kerala",
"9161517", "Sidhawalia\,\ Bihar",
"9173939", "Jobat\,\ Madhya\ Pradesh",
"9171623", "Chhindwara\,\ Madhya\ Pradesh",
"913880", "Sadarhills\/Kangpokai\,\ Manipur",
"9171567", "Talegaokarangal\,\ Maharashtra",
"9174525", "Chhabra\,\ Rajasthan",
"918156", "Chikkaballapur\,\ Karnataka",
"9172884", "Bhikangaon\,\ Madhya\ Pradesh",
"9166707", "Bhawanipatna\,\ Odisha",
"91261", "Surat\,\ Gujarat",
"918230", "Krishnarajapet\,\ Karnataka",
"918515", "Banaganapalle\,\ Andhra\ Pradesh",
"914327", "Thuraiyur\,\ Tamil\ Nadu",
"913522", "Balurghat\,\ West\ Bengal",
"9176296", "Pushprajgarh\,\ Madhya\ Pradesh",
"9161355", "Bikram\,\ Bihar",
"9164782", "Saharsa\,\ Bihar",
"9165683", "Balumath\,\ Bihar",
"9174853", "Udaipura\,\ Madhya\ Pradesh",
"91479", "Mavelikkara\,\ Kerala",
"91431", "Tiruchchirappalli\,\ Tamil\ Nadu",
"9176539", "Bandhavgarh\,\ Madhya\ Pradesh",
"9168546", "Jeypore\,\ Odisha",
"9174272", "Bhanpura\,\ Madhya\ Pradesh",
"912735", "Deodar\,\ Gujarat",
"917233", "Pusad\,\ Maharashtra",
"9167842", "Bhadrak\,\ Odisha",
"911803", "Panipat\,\ Haryana",
"915922", "Amroha\,\ Uttar\ Pradesh",
"9166442", "Rairakhol\,\ Odisha",
"9174915", "Narwar\,\ Madhya\ Pradesh",
"9168214", "Bhanjanagar\,\ Odisha",
"917789", "Bhairongarh\,\ Madhya\ Pradesh",
"9175952", "Nateran\,\ Madhya\ Pradesh",
"918578", "Srikalahasthi\,\ Andhra\ Pradesh",
"9174213", "Manasa\,\ Madhya\ Pradesh",
"9165226", "Muri\,\ Bihar",
"911905", "Mandi\,\ Himachal\ Pradesh",
"917122", "Nagpur\,\ Maharashtra",
"9164263", "Rajmahal\,\ Bihar",
"9174908", "Pohari\,\ Madhya\ Pradesh",
"913860", "Wokha\,\ Nagaland",
"9171823", "Gondia\,\ Maharashtra",
"911492", "Laxmangarh\/Kherli\,\ Rajasthan",
"9174630", "Gangapur\,\ Rajasthan",
"9174144", "Jaora\,\ Madhya\ Pradesh",
"912143", "Pen\,\ Maharashtra",
"9165486", "Ichak\,\ Bihar",
"9168143", "Digapahandi\,\ Odisha",
"915948", "Khatima\/Sitarganj\,\ Uttar\ Pradesh",
"91421", "Tirupur\,\ Tamil\ Nadu",
"9165277", "Kolebira\,\ Bihar",
"9171426", "Bhimpur\,\ Madhya\ Pradesh",
"9173943", "Alirajpur\,\ Madhya\ Pradesh",
"9165883", "Jagarnathpur\,\ Bihar",
"9176454", "Karanjia\,\ Madhya\ Pradesh",
"9164325", "Deoghar\,\ Bihar",
"9167264", "Jajapur\ Road\,\ Odisha",
"9168654", "Kashipur\,\ Odisha",
"914895", "Kalpeni\,\ Lakshadweep",
"9162507", "Dhaka\,\ Bihar",
"918330", "Saundatti\,\ Karnataka",
"9174653", "Sapotra\,\ Rajasthan",
"911436", "Uniayara\,\ Rajasthan",
"918598", "Kandukuru\,\ Andhra\ Pradesh",
"914564", "Paramakudi\,\ Tamil\ Nadu",
"9171555", "Seloo\,\ Maharashtra",
"9165944", "Baharagora\,\ Bihar",
"917577", "Harda\,\ Madhya\ Pradesh",
"9182892", "Athani\,\ Karnataka",
"9173245", "Mhow\,\ Madhya\ Pradesh",
"911472", "Chittorgarh\,\ Rajasthan",
"9174708", "Bundi\,\ Rajasthan",
"9171477", "Multai\,\ Madhya\ Pradesh",
"916417", "Bhagalpur\,\ Bihar",
"9168403", "Tumudibandha\,\ Odisha",
"9181529", "Kolar\,\ Karnatak",
"914638", "Vilathikulam\,\ Tamil\ Nadu",
"9167642", "Anugul\,\ Odisha",
"915724", "Khair\,\ Uttar\ Pradesh",
"9171317", "Sironcha\,\ Maharashtra",
"9164765", "Madhepura\,\ Bihar",
"918131", "Gubbi\,\ Karnataka",
"9176320", "Balaghat\,\ Madhya\ Pradesh",
"913561", "Jalpaiguri\,\ West\ Bengal",
"917254", "Malgaon\,\ Maharashtra",
"9166792", "Komana\,\ Odisha",
"9168445", "Kantamal\,\ Odisha",
"9176349", "Lamta\,\ Madhya\ Pradesh",
"9166533", "Dunguripali\,\ Odisha",
"9168632", "Bisam\ Cuttack\,\ Odisha",
"9176432", "Bijadandi\,\ Madhya\ Pradesh",
"9165494", "Bermo\,\ Bihar",
"915823", "Aonla\,\ Uttar\ Pradesh",
"915111", "Akbarpur\,\ Uttar\ Pradesh",
"912443", "Manjalegaon\,\ Maharashtra",
"9171144", "Ramtek\,\ Maharashtra",
"917448", "Ladpura\/Kota\,\ Rajasthan",
"9174823", "Raisen\,\ Madhya\ Pradesh",
"9127175", "Sanand\,\ Gujarat",
"911527", "Lunkaransar\/Rajasarb\,\ Rajasthan",
"918263", "Mudigere\,\ Karnataka",
"9165816", "Bhandaria\,\ Bihar",
"9175385", "Ambah\,\ Madhya\ Pradesh",
"913753", "Dhemaji\,\ Assam",
"9181738", "Sakleshpur\,\ Karnataka",
"9173203", "Pandhana\,\ Madhya\ Pradesh",
"912891", "Jamkalyanpur\,\ Gujarat",
"9164367", "Sahibganj\,\ Bihar",
"913525", "Dalkhola\,\ West\ Bengal",
"9162574", "Barachakia\,\ Bihar",
"9161325", "Barh\,\ Bihar",
"911250", "Charkhidadri\,\ Haryana",
"9171715", "Gond\ Pipri\,\ Maharashtra",
"918512", "Adoni\,\ Andhra\ Pradesh",
"9163235", "Dumraon\,\ Bihar",
"9165413", "Chatra\,\ Bihar",
"91151", "Bikaner\,\ Rajasthan",
"918739", "Jannaram\/Luxittipet\,\ Andhra\ Pradesh",
"9175934", "Kurwai\,\ Madhya\ Pradesh",
"918383", "Joida\,\ Karnataka",
"9181763", "Cannarayapatna\,\ Karnataka",
"9174248", "Malhargarh\,\ Madhya\ Pradesh",
"9174555", "Digod\/Sultanpur\,\ Rajasthan",
"9168105", "Khalikote\,\ Odisha",
"9164776", "Triveniganj\,\ Bihar",
"9171653", "Saunsar\,\ Madhya\ Pradesh",
"9163464", "Lakhisarai\,\ Bihar",
"917260", "Lonar\,\ Maharashtra",
"913809", "Sagalee\,\ Arunachal\ Pradesh",
"9181938", "Hiriyur\,\ Karnataka",
"9176505", "Beohari\,\ Madhya\ Pradesh",
"9161152", "Danapur\,\ Bihar",
"912524", "Murbad\,\ Maharashtra",
"9174317", "Aklera\,\ Rajasthan",
"912934", "Desuri\/Rani\,\ Rajasthan",
"912796", "Kunkawav\,\ Gujarat",
"9165562", "Tisri\,\ Bihar",
"912871", "Keshod\,\ Gujarat",
"9181939", "Hiriyur\,\ Karnataka",
"913658", "Williamnagar\,\ Meghalaya",
"9167956", "Udala\,\ Odisha",
"918665", "Vijayawada\,\ Andhra\ Pradesh",
"9171892", "Amagaon\,\ Maharashtra",
"9168457", "Phiringia\,\ Odisha",
"9162553", "Raxaul\,\ Bihar",
"9174607", "Sahabad\,\ Rajasthan",
"9168575", "Gunupur\,\ Odisha",
"9167583", "Nimapara\,\ Odisha",
"91389", "Aizawal\,\ Mizoram",
"9171674", "Amarwada\,\ Madhya\ Pradesh",
"9174249", "Malhargarh\,\ Madhya\ Pradesh",
"9165354", "Chainpur\,\ Bihar",
"917231", "Umarkhed\,\ Maharashtra",
"9181739", "Sakleshpur\,\ Karnataka",
"9189460", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"912951", "Bhim\,\ Rajasthan",
"9171036", "Butibori\,\ Maharashtra",
"918454", "Gajwel\,\ Andhra\ Pradesh",
"9174547", "Chhipaborad\,\ Rajasthan",
"91122", "Hapur\,\ Uttar\ Pradesh",
"9161537", "Maharajganj\,\ Bihar",
"918621", "Rapur\/Podalakur\,\ Andhra\ Pradesh",
"913215", "Bongoan\,\ West\ Bengal",
"9162786", "Dalsinghsarai\,\ Bihar",
"9168482", "Kotagarh\,\ Odisha",
"9166815", "Jujumura\,\ Odisha",
"918222", "Hunsur\,\ Karnataka",
"911569", "Sujangarh\/Lalgarh\,\ Rajasthan",
"9176386", "Damoh\,\ Madhya\ Pradesh",
"9168222", "Aska\,\ Odisha",
"9171097", "Kamptee\,\ Maharashtra",
"918248", "Mangalore\,\ Karnataka",
"9166267", "Banaigarh\,\ Odisha",
"914142", "Cuddalore\,\ Tamil\ Nadu",
"912468", "Hadgaon\,\ Maharashtra",
"9162444", "Khagaria\,\ Bihar",
"918745", "Yellandu\,\ Andhra\ Pradesh",
"9174810", "Gairatganj\,\ Madhya\ Pradesh",
"915862", "Sitapur\,\ Uttar\ Pradesh",
"915677", "Karhal\,\ Uttar\ Pradesh",
"9176348", "Lamta\,\ Madhya\ Pradesh",
"9161596", "Masrakh\,\ Bihar",
"913772", "Sibsagar\,\ Assam",
"9181528", "Kolar\,\ Karnatak",
"9168566", "Rayagada\,\ Odisha",
"9174709", "Bundi\,\ Rajasthan",
"917815", "Kathghora\,\ Madhya\ Pradesh",
"912995", "Pokhran\/Nachna\,\ Rajasthan",
"9167862", "Chandbali\,\ Odisha",
"91452", "Madurai\,\ Tamil\ Nadu",
"9171607", "Jamai\,\ Madhya\ Pradesh",
"9168673", "Jharigan\,\ Odisha",
"9166572", "Kantabhanji\,\ Odisha",
"9167685", "Parajang\,\ Odisha",
"9176473", "Ghughari\,\ Madhya\ Pradesh",
"9174674", "Bamanwas\,\ Rajasthan",
"9166723", "Dharamgarh\,\ Odisha",
"9162713", "Benipatti\,\ Bihar",
"913792", "Daporizo\,\ Arunachal\ Pradesh",
"918154", "Chintamani\,\ Karnataka",
"918325", "Goa",
"913583", "Mathabhanga\,\ West\ Bengal",
"914733", "Pathanamthitta\,\ Kerala",
"9174909", "Pohari\,\ Madhya\ Pradesh",
"9161584", "Sonepur\,\ Bihar",
"9165697", "Garu\,\ Bihar",
"912975", "Reodar\,\ Rajasthan",
"9174220", "Mandsaur\,\ Madhya\ Pradesh",
"9177017", "Pingeshwar\,\ Madhya\ Pradesh",
"9164537", "Araria\,\ Bihar",
"9166485", "Patnagarh\,\ Odisha",
"918682", "Nalgonda\,\ Andhra\ Pradesh",
"916715", "Cuttack\,\ Odisha",
"912168", "Mahabaleswar\,\ Maharashtra",
"9166225", "Sundargarh\,\ Odisha",
"9165332", "Basia\,\ Bihar",
"9165636", "Bhawanathpur\,\ Bihar",
"91207", "Pune\,\ Maharashtra",
"9162794", "Barauni\,\ Bihar",
"915963", "Bageshwar\,\ Uttar\ Pradesh",
"9164596", "Thakurganj\,\ Bihar",
"913831", "Champa\,\ Mizoram",
"91771", "Raipur\,\ Madhya\ Pradesh",
"9175914", "Sironj\,\ Madhya\ Pradesh",
"918381", "Ron\,\ Karnataka",
"9165433", "Barhi\,\ Bihar",
"9176538", "Bandhavgarh\,\ Madhya\ Pradesh",
"9171735", "Rajura\,\ Maharashtra",
"915865", "Misrikh\,\ Uttar\ Pradesh",
"918742", "Khammam\,\ Andhra\ Pradesh",
"9174692", "Hindaun\,\ Rajasthan",
"914145", "Gingee\,\ Tamil\ Nadu",
"9177000", "Nagri\,\ Madhya\ Pradesh",
"9167662", "Keonjhar\,\ Odisha",
"918225", "Cowdahalli\,\ Karnataka",
"912669", "Chhota\ Udaipur\,\ Gujarat",
"9167244", "Jagatsinghpur\,\ Odisha",
"913212", "Champadanga\,\ West\ Bengal",
"918728", "Peddapalli\,\ Andhra\ Pradesh",
"9171384", "Dhanora\,\ Maharashtra",
"9171807", "Salekasa\,\ Maharashtra",
"918180", "Basavapatna\,\ Karnataka",
"9167885", "Soro\,\ Odisha",
"914566", "Aruppukottai\,\ Tamil\ Nadu",
"9165964", "Noamundi\,\ Bihar",
"912873", "Visavadar\,\ Gujarat",
"9174874", "Begamganj\,\ Madhya\ Pradesh",
"918910", "Visakhapatnam\,\ Andhra\ Pradesh",
"911434", "Deoli\,\ Rajasthan",
"9174337", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9167977", "Jashipur\,\ Odisha",
"9165324", "Giridih\,\ Bihar",
"9168476", "G\.Udayagiri\,\ Odisha",
"9164243", "Banka\,\ Bihar",
"9162772", "Phulparas\,\ Bihar",
"914369", "Thiruthuraipoondi\,\ Tamil\ Nadu",
"9165897", "Jhinkpani\,\ Bihar",
"9181705", "Alur\,\ Karnataka",
"913563", "Birpara\,\ West\ Bengal",
"9176372", "Birsa\,\ Madhya\ Pradesh",
"9173938", "Jobat\,\ Madhya\ Pradesh",
"9175295", "Laher\,\ Madhya\ Pradesh",
"915821", "Pitamberpur\,\ Uttar\ Pradesh",
"9171002", "Kuhi\,\ Maharashtra",
"912749", "Danta\,\ Gujarat",
"9162523", "Motihari\,\ Bihar",
"9176412", "Niwas\,\ Madhya\ Pradesh",
"9166513", "Birmaharajpur\,\ Odisha",
"9168163", "Mohana\,\ Odisha",
"9168612", "Malkangiri\,\ Odisha",
"912188", "Mangalwedha\,\ Maharashtra",
"918261", "Tarikere\,\ Karnataka",
"9165836", "Kharsawa\,\ Bihar",
"913751", "Digboi\,\ Assam",
"9168427", "Phulbani\,\ Odisha",
"918662", "Vijayawada\,\ Andhra\ Pradesh",
"917727", "Balodabazar\,\ Madhya\ Pradesh",
"9166462", "Bargarh\,\ Odisha",
"918944", "Bobbili\,\ Andhra\ Pradesh",
"9167926", "Baripada\,\ Odisha",
"915113", "Bhognipur\/Pakhrayan\,\ Uttar\ Pradesh",
"912441", "Ashti\,\ Maharashtra",
"9176563", "Kannodi\,\ Madhya\ Pradesh",
"917913", "Ahmedabad\ Local\,\ Gujarat",
"912893", "Jodia\,\ Gujarat",
"912437", "Khultabad\,\ Maharashtra",
"912526", "Wada\,\ Maharashtra",
"9163444", "Monghyr\,\ Bihar",
"912794", "Rajula\,\ Gujarat",
"9165542", "Rajdhanwar\,\ Bihar",
"9166255", "Lahunipara\,\ Odisha",
"9171692", "Batkakhapa\,\ Madhya\ Pradesh",
"9171396", "Kurkheda\,\ Maharashtra",
"918685", "Bhongir\,\ Andhra\ Pradesh",
"912936", "Pali\/Rohat\,\ Rajasthan",
"916712", "Cuttack\,\ Odisha",
"911386", "Lansdowne\,\ Uttarakhand",
"9174807", "Goharganj\,\ Madhya\ Pradesh",
"9174384", "Keshoraipatan\/Patan\,\ Rajasthan",
"9164205", "Amarpur\,\ Bihar",
"9181743", "Arsikere\,\ Karnataka",
"9176490", "Kakaiya\,\ Madhya\ Pradesh",
"9164347", "Dumka\,\ Bihar",
"9174250", "Garoth\,\ Madhya\ Pradesh",
"912972", "Sirohi\,\ Rajasthan",
"9167415", "Bhubaneshwar\,\ Odisha",
"9171337", "Aheri\,\ Maharashtra",
"918133", "Chikkanayakanahalli\,\ Karnataka",
"91132", "Saharanpur\,\ Uttar\ Pradesh",
"918322", "Goa",
"9173227", "Depalpur\,\ Madhya\ Pradesh",
"9171874", "Goregaon\,\ Maharashtra",
"9174268", "Sitamau\,\ Madhya\ Pradesh",
"913795", "Basar\,\ Arunachal\ Pradesh",
"9166753", "T\.Rampur\,\ Odisha",
"9174935", "Karera\,\ Madhya\ Pradesh",
"911828", "Sultanpur\ Lodhi\,\ Punjab",
"9171164", "Umrer\,\ Maharashtra",
"912774", "Modasa\,\ Gujarat",
"911589", "Parbatsar\,\ Rajasthan",
"9174233", "Neemuch\,\ Madhya\ Pradesh",
"912141", "Alibagh\,\ Maharashtra",
"915413", "Chakia\,\ Uttar\ Pradesh",
"917256", "Murtizapur\,\ Maharashtra",
"912992", "Jaisalmer\,\ Rajasthan",
"915882", "Pilibhit\,\ Uttar\ Pradesh",
"9174610", "Mahuwa\,\ Rajasthan",
"917812", "Damoh\,\ Madhya\ Pradesh",
"912488", "Parner\,\ Maharashtra",
"9168465", "Baliguda\,\ Odisha",
"912137", "Nahavara\,\ Maharashtra",
"9176369", "Baihar\,\ Madhya\ Pradesh",
"913775", "Majuli\,\ Assam",
"9165602", "Patan\,\ Bihar",
"9165306", "Bundu\,\ Bihar",
"912329", "Shahuwadi\/Malakapur\,\ Maharashtra",
"9161114", "Hilsa\,\ Bihar",
"9168686", "Nandapur\,\ Odisha",
"9171045", "Hingua\,\ Maharashtra",
"9176486", "Mawai\,\ Madhya\ Pradesh",
"912957", "Vallabhnagar\,\ Rajasthan",
"9177004", "Nagri\,\ Madhya\ Pradesh",
"9162266", "Sitamarhi\,\ Bihar",
"9175910", "Sironj\,\ Madhya\ Pradesh",
"918627", "Atmakur\,\ Andhra\ Pradesh",
"917762", "Raigarh\,\ Madhya\ Pradesh",
"9176277", "Manpur\,\ Madhya\ Pradesh",
"913805", "Hayuliang\,\ Arunachal\ Pradesh",
"9181742", "Arsikere\,\ Karnataka",
"9167565", "Balugaon\,\ Odisha",
"9174870", "Begamganj\,\ Madhya\ Pradesh",
"9171693", "Batkakhapa\,\ Madhya\ Pradesh",
"9176448", "Dindori\,\ Madhya\ Pradesh",
"9174595", "Ramganj\ Mandi\,\ Rajasthan",
"911960", "Nowshera\,\ Jammu\ And\ Kashmir",
"914997", "Kanhangad\,\ Kerala",
"9165543", "Rajdhanwar\,\ Bihar",
"915671", "Jasrana\,\ Uttar\ Pradesh",
"91326", "Dhanbad\,\ Bihar",
"918735", "Bellampalli\,\ Andhra\ Pradesh",
"9166787", "Nowparatan\,\ Odisha",
"912804", "Kutiyana\,\ Gujarat",
"913193", "Andaman\ \&\ Nicobar\,\ Nicobar\ Islands",
"914323", "Kulithalai\,\ Tamil\ Nadu",
"911954", "Sopore\,\ Jammu\ And\ Kashmir",
"9165603", "Patan\,\ Bihar",
"912623", "Mandvi\,\ Gujarat",
"9176579", "Jaitpur\,\ Madhya\ Pradesh",
"9165454", "Mandu\,\ Bihar",
"9174232", "Neemuch\,\ Madhya\ Pradesh",
"917237", "Marigaon\,\ Maharashtra",
"915164", "Kalpi\,\ Uttar\ Pradesh",
"9171614", "Parasia\,\ Madhya\ Pradesh",
"915691", "Chhibramau\,\ Uttar\ Pradesh",
"911807", "Panipat\,\ Haryana",
"9166752", "T\.Rampur\,\ Odisha",
"9176816", "Jatara\,\ Madhya\ Pradesh",
"917368", "Ghatia\,\ Madhya\ Pradesh",
"9167576", "Daspalla\,\ Odisha",
"912363", "Sawantwadi\,\ Maharashtra",
"915450", "Kerakat\,\ Uttar\ Pradesh",
"918707", "Warangal\,\ Andhra\ Pradesh",
"913666", "Barpeta\ Road\,\ Assam",
"9177077", "Bagbahera\,\ Madhya\ Pradesh",
"9166734", "Jayapatna\,\ Odisha",
"9167663", "Keonjhar\,\ Odisha",
"9172877", "Gogaon\,\ Madhya\ Pradesh",
"9165645", "Nagarutari\,\ Bihar",
"913841", "Vdarbondh\,\ Assam",
"9162275", "Mahua\,\ Bihar",
"9167527", "Puri\,\ Odisha",
"9174693", "Hindaun\,\ Rajasthan",
"914899", "Chetlat\,\ Lakshadweep",
"9168694", "Papadhandi\,\ Odisha",
"9174380", "Keshoraipatan\/Patan\,\ Rajasthan",
"9176494", "Kakaiya\,\ Madhya\ Pradesh",
"9174254", "Garoth\,\ Madhya\ Pradesh",
"913837", "Kolasib\,\ Mizoram",
"9165432", "Barhi\,\ Bihar",
"9165505", "Hunterganj\,\ Bihar",
"918367", "Hubli\,\ Karnataka",
"9164664", "Kishanganj\,\ Bihar",
"9166463", "Bargarh\,\ Odisha",
"9176562", "Kannodi\,\ Madhya\ Pradesh",
"918216", "Mysore\,\ Karnataka",
"918852", "Peddapuram\,\ Andhra\ Pradesh",
"9176413", "Niwas\,\ Madhya\ Pradesh",
"912456", "Hingoli\,\ Maharashtra",
"91494", "Tirur\,\ Kerala",
"9162522", "Motihari\,\ Bihar",
"9168613", "Malkangiri\,\ Odisha",
"9166512", "Birmaharajpur\,\ Odisha",
"911909", "Udaipur\,\ Himachal\ Pradesh",
"9168162", "Mohana\,\ Odisha",
"9171003", "Kuhi\,\ Maharashtra",
"917785", "Makodi\,\ Madhya\ Pradesh",
"911698", "Ellenabad\,\ Haryana",
"913473", "Ranaghat\,\ West\ Bengal",
"9162773", "Phulparas\,\ Bihar",
"9164242", "Banka\,\ Bihar",
"9176373", "Birsa\,\ Madhya\ Pradesh",
"9174614", "Mahuwa\,\ Rajasthan",
"915464", "Maunathbhanjan\,\ Uttar\ Pradesh",
"9166722", "Dharamgarh\,\ Odisha",
"9162712", "Benipatti\,\ Bihar",
"9168416", "Boudh\,\ Odisha",
"912383", "Ausa\,\ Maharashtra",
"9167917", "Bangiriposi\,\ Odisha",
"912739", "Vadgam\,\ Gujarat",
"9166573", "Kantabhanji\,\ Odisha",
"9168672", "Jharigan\,\ Odisha",
"9176472", "Ghughari\,\ Madhya\ Pradesh",
"9165424", "Bokaro\,\ Bihar",
"9167863", "Chandbali\,\ Odisha",
"917440", "Ladpura\/Kota\,\ Rajasthan",
"912447", "Gevrai\,\ Maharashtra",
"91217", "Sholapur\,\ Maharashtra",
"9165284", "Khunti\,\ Bihar",
"917721", "Neora\,\ Madhya\ Pradesh",
"918524", "Srisailam\,\ Andhra\ Pradesh",
"918267", "Kadur\,\ Karnataka",
"911523", "Bikaner\/Poogal\,\ Rajasthan",
"9165845", "Bishrampur\,\ Bihar",
"918934", "Chodavaram\,\ Andhra\ Pradesh",
"912431", "Paithan\,\ Maharashtra",
"911933", "Pulwama\,\ Jammu\ And\ Kashmir",
"9174128", "Ratlam\,\ Madhya\ Pradesh",
"918316", "Belgaum\,\ Karnataka",
"9171746", "Mul\,\ Maharashtra",
"9162534", "Narkatiaganj\,\ Bihar",
"9176256", "Umariapan\,\ Madhya\ Pradesh",
"918519", "Allagadda\,\ Andhra\ Pradesh",
"911258", "Kalanaur\,\ Haryana",
"9163275", "Rafiganj\,\ Bihar",
"918732", "Adilabad\,\ Andhra\ Pradesh",
"915275", "Akbarpur\/Jalalpur\,\ Uttar\ Pradesh",
"916574", "Jamshedpur\,\ Bihar",
"918387", "Honnavar\,\ Karnataka",
"9168185", "Buguda\,\ Odisha",
"9189464", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9164736", "Supaul\,\ Bihar",
"9165333", "Basia\,\ Bihar",
"917268", "Mekhar\,\ Maharashtra",
"918443", "Shorapur\,\ Karnataka",
"917826", "Patan\,\ Madhya\ Pradesh",
"917765", "Pathalgaon\,\ Madhya\ Pradesh",
"913802", "Roing\/Arda\,\ Arunachal\ Pradesh",
"9171484", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9164797", "Udakishanganj\,\ Bihar",
"91581", "Bareilly\,\ Uttar\ Pradesh",
"918776", "Tirupathi\,\ Andhra\ Pradesh",
"91788", "Durg\,\ Madhya\ Pradesh",
"9174206", "Jawad\,\ Madhya\ Pradesh",
"9174814", "Gairatganj\,\ Madhya\ Pradesh",
"91370", "Kohima\,\ Nagaland",
"9174946", "Kolaras\,\ Madhya\ Pradesh",
"917782", "Jagdalpur\,\ Madhya\ Pradesh",
"912598", "Umrane\,\ Maharashtra",
"9167582", "Nimapara\,\ Odisha",
"9165296", "Itki\,\ Bihar",
"918570", "Kuppam\,\ Andhra\ Pradesh",
"9162552", "Raxaul\,\ Bihar",
"917202", "Ralegaon\,\ Maharashtra",
"918855", "Mandapeta\/Ravulapalem\,\ Andhra\ Pradesh",
"9176469", "Nainpur\,\ Madhya\ Pradesh",
"917601", "Patharia\,\ Madhya\ Pradesh",
"911499", "Sangaria\,\ Rajasthan",
"9174670", "Bamanwas\,\ Rajasthan",
"9165406", "Govindpur\,\ Bihar",
"9171893", "Amagaon\,\ Maharashtra",
"911980", "Nobra\,\ Jammu\ And\ Kashmir",
"912147", "Shrivardhan\,\ Maharashtra",
"9165237", "Ghaghra\,\ Bihar",
"9171496", "Tamia\,\ Madhya\ Pradesh",
"9161864", "Aurangabad\,\ Bihar",
"9174224", "Mandsaur\,\ Madhya\ Pradesh",
"9177056", "Kurud\,\ Madhya\ Pradesh",
"9167557", "Khurda\,\ Odisha",
"915251", "Kaisarganj\/Kaiserganj\,\ Uttar\ Pradesh",
"9168223", "Aska\,\ Odisha",
"918338", "Chikkodi\,\ Karnataka",
"9162587", "Areraj\,\ Bihar",
"917573", "Timarani\,\ Madhya\ Pradesh",
"9175907", "Lateri\,\ Madhya\ Pradesh",
"9173216", "Sanwer\,\ Madhya\ Pradesh",
"911896", "Churah\/Tissa\,\ Himachal\ Pradesh",
"9168483", "Kotagarh\,\ Odisha",
"911479", "Pratapgarh\/Arnod\,\ Rajasthan",
"916413", "Bhagalpur\,\ Bihar",
"9171437", "Bhainsdehi\,\ Madhya\ Pradesh",
"9163266", "Sherghati\,\ Bihar",
"9171814", "Lakhandur\,\ Maharashtra",
"9167315", "Anandapur\,\ Odisha",
"914630", "Srivaikundam\,\ Tamil\ Nadu",
"912325", "Kagal\/Murgud\,\ Maharashtra",
"913779", "Roing\/Mariso\,\ Arunachal\ Pradesh",
"9173202", "Pandhana\,\ Madhya\ Pradesh",
"9174822", "Raisen\,\ Madhya\ Pradesh",
"911508", "Suratgarh\/Goluwala\,\ Rajasthan",
"9167605", "Talcher\,\ Odisha",
"9171687", "Harrai\,\ Madhya\ Pradesh",
"911585", "Nagaur\/Khinwsar\,\ Rajasthan",
"9180", "Bangalore\,\ Karnataka",
"9168633", "Bisam\ Cuttack\,\ Odisha",
"9166532", "Dunguripali\,\ Odisha",
"9176433", "Bijadandi\,\ Madhya\ Pradesh",
"911956", "Uri\,\ Jammu\ And\ Kashmir",
"914262", "Gudalur\,\ Tamil\ Nadu",
"9174634", "Gangapur\,\ Rajasthan",
"9166793", "Komana\,\ Odisha",
"9174140", "Jaora\,\ Madhya\ Pradesh",
"913471", "Karimpur\,\ West\ Bengal",
"915545", "Bansi\,\ Uttar\ Pradesh",
"913799", "Tuting\,\ Arunachal\ Pradesh",
"9165563", "Tisri\,\ Bihar",
"9161504", "Hathua\,\ Bihar",
"9176468", "Nainpur\,\ Madhya\ Pradesh",
"9165627", "Daltonganj\,\ Bihar",
"912806", "Gogodar\,\ Gujarat",
"9161153", "Danapur\,\ Bihar",
"9166405", "Bagdihi\,\ Odisha",
"9164577", "Korha\,\ Bihar",
"9176450", "Karanjia\,\ Madhya\ Pradesh",
"913843", "Karimganj\,\ Assam",
"9162246", "Hajipur\,\ Bihar",
"918689", "Miryalguda\,\ Andhra\ Pradesh",
"9165676", "Barwadih\,\ Bihar",
"9171652", "Saunsar\,\ Madhya\ Pradesh",
"9171356", "Chamorshi\,\ Maharashtra",
"914174", "Vaniyambadi\,\ Tamil\ Nadu",
"9162724", "Darbhanga\,\ Bihar",
"918402", "Kanigiri\,\ Andhra\ Pradesh",
"9171065", "Bhiwapur\,\ Maharashtra",
"9176324", "Balaghat\,\ Madhya\ Pradesh",
"9166714", "Rajkhariar\,\ Odisha",
"912160", "Sakarwadi\,\ Maharashtra",
"915967", "Dharchula\,\ Uttar\ Pradesh",
"9164526", "Katihar\,\ Bihar",
"9165412", "Chatra\,\ Bihar",
"9181762", "Cannarayapatna\,\ Karnataka",
"912454", "Basmatnagar\,\ Maharashtra",
"9168142", "Digapahandi\,\ Odisha",
"915466", "Sagri\,\ Uttar\ Pradesh",
"913650", "Dadengiri\/Phulbari\,\ Meghalaya",
"9164262", "Rajmahal\,\ Bihar",
"912621", "Sayan\,\ Gujarat",
"9171822", "Gondia\,\ Maharashtra",
"91343", "Durgapur\,\ West\ Bengal",
"9175953", "Nateran\,\ Madhya\ Pradesh",
"9174212", "Manasa\,\ Madhya\ Pradesh",
"9168535", "Sunabeda\,\ Odisha",
"9174687", "Khandar\,\ Rajasthan",
"918468", "Kamareddy\,\ Andhra\ Pradesh",
"9182206", "Gundlupet\,\ Karnataka",
"918214", "Mysore\,\ Karnataka",
"914365", "Nagapattinam\,\ Tamil\ Nadu",
"9165857", "Ghatsila\,\ Bihar",
"9166443", "Rairakhol\,\ Odisha",
"9165665", "Japla\,\ Bihar",
"9167643", "Anugul\,\ Odisha",
"9168402", "Tumudibandha\,\ Odisha",
"9176306", "Katangi\,\ Madhya\ Pradesh",
"9174129", "Ratlam\,\ Madhya\ Pradesh",
"9161577", "Mairwa\,\ Bihar",
"914285", "Gobichettipalayam\,\ Tamil\ Nadu",
"911562", "Churu\,\ Rajasthan",
"9175930", "Kurwai\,\ Madhya\ Pradesh",
"912665", "Sankheda\,\ Gujarat",
"9166846", "Paikamal\,\ Odisha",
"918229", "Gundlupet\,\ Karnataka",
"912460", "Delhi\ Tanda\,\ Maharashtra",
"9171027", "Parseoni\,\ Maharashtra",
"9182893", "Athani\,\ Karnataka",
"9174652", "Sapotra\,\ Rajasthan",
"9174356", "Gangdhar\,\ Rajasthan",
"914149", "Ulundurpet\,\ Tamil\ Nadu",
"918240", "Mangalore\,\ Karnataka",
"913664", "Hajo\,\ Assam",
"9165882", "Jagarnathpur\,\ Bihar",
"9166554", "Titlagarh\,\ Odisha",
"915673", "Bhogaon\,\ Uttar\ Pradesh",
"9161526", "Chapra\,\ Bihar",
"9173942", "Alirajpur\,\ Madhya\ Pradesh",
"917824", "Bemetara\,\ Madhya\ Pradesh",
"91542", "Varansi\,\ Uttar\ Pradesh",
"9164556", "Forbesganj\,\ Bihar",
"917571", "Khirkiya\,\ Madhya\ Pradesh",
"918405", "Giddalur\,\ Andhra\ Pradesh",
"9173236", "Punasa\,\ Madhya\ Pradesh",
"918774", "Tirupathi\,\ Andhra\ Pradesh",
"9176354", "Lanji\,\ Madhya\ Pradesh",
"9162754", "Rosera\,\ Bihar",
"9171326", "Gadchiroli\,\ Maharashtra",
"9171622", "Chhindwara\,\ Madhya\ Pradesh",
"9176280", "Karpa\,\ Madhya\ Pradesh",
"915253", "Nanpara\,\ Uttar\ Pradesh",
"916576", "Jamshedpur\,\ Bihar",
"9176420", "Mandla\,\ Madhya\ Pradesh",
"9171417", "Betul\,\ Madhya\ Pradesh",
"9171766", "Warora\,\ Maharashtra",
"918488", "Sindagi\,\ Karnataka",
"9161123", "Biharsharif\,\ Bihar",
"912979", "Sanchore\,\ Rajasthan",
"9164285", "Nala\,\ Bihar",
"9174304", "Khanpur\,\ Rajasthan",
"9171377", "Desaiganj\,\ Maharashtra",
"9165657", "Latehar\,\ Bihar",
"918137", "Madugiri\,\ Karnataka",
"9173297", "Khakner\,\ Madhya\ Pradesh",
"9167335", "Ghatgaon\,\ Odisha",
"918329", "Goa",
"9171834", "Tumsar\,\ Maharashtra",
"9175267", "Ghatigaon\,\ Madhya\ Pradesh",
"915542", "Basti\,\ Uttar\ Pradesh",
"9174975", "Khaniadhana\,\ Madhya\ Pradesh",
"9165865", "Chainpur\,\ Bihar",
"9167843", "Bhadrak\,\ Odisha",
"9189461", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"918314", "Belgaum\,\ Karnataka",
"911582", "Nagaur\,\ Rajasthan",
"918936", "Araku\,\ Andhra\ Pradesh",
"9174273", "Bhanpura\,\ Madhya\ Pradesh",
"912999", "Jaisalmer\/Nehdai\,\ Rajasthan",
"917603", "Tendukheda\,\ Madhya\ Pradesh",
"9174852", "Udaipura\,\ Madhya\ Pradesh",
"917819", "Pandishankar\,\ Madhya\ Pradesh",
"9171966", "Arjuni\ Morgaon\,\ Maharashtra",
"9164783", "Saharsa\,\ Bihar",
"91480", "Irinjalakuda\,\ Kerala",
"912133", "Manchar\,\ Maharashtra",
"9165386", "Torpa\,\ Bihar",
"9165682", "Balumath\,\ Bihar",
"912322", "Shirol\/Jalsingpur\,\ Maharashtra",
"9161556", "Ekma\,\ Bihar",
"9165473", "Chavparan\,\ Bihar",
"9163246", "Nawada\,\ Bihar",
"9166524", "Balangir\,\ Odisha",
"91512", "Kanpur\,\ Uttar\ Pradesh",
"915334", "Meja\/Sirsa\,\ Uttar\ Pradesh",
"9162514", "Bagaha\,\ Bihar",
"9176578", "Jaitpur\,\ Madhya\ Pradesh",
"9171775", "Brahmapuri\,\ Maharashtra",
"918749", "Madhira\,\ Andhra\ Pradesh",
"9165313", "Mandar\,\ Bihar",
"9164716", "Birpur\,\ Bihar",
"9174326", "Jhalawar\,\ Rajasthan",
"9174622", "Sawaimadhopur\,\ Rajasthan",
"91792", "Ahmedabad\ Local\,\ Gujarat",
"9171057", "Narkhed\,\ Maharashtra",
"912662", "Padra\,\ Gujarat",
"918720", "Mahadevapur\,\ Andhra\ Pradesh",
"9172880", "Bhikangaon\,\ Madhya\ Pradesh",
"911565", "Sri\ Dungargarh\,\ Rajasthan",
"918188", "Honnali\,\ Karnataka",
"9161844", "Sasaram\,\ Bihar",
"914282", "Attur\,\ Tamil\ Nadu",
"918441", "Sedam\,\ Karnataka",
"912877", "Talala\,\ Gujarat",
"911894", "Palampur\,\ Himachal\ Pradesh",
"9163364", "Rajauli\,\ Bihar",
"918918", "Visakhapatnam\,\ Andhra\ Pradesh",
"9174377", "Nainwa\,\ Rajasthan",
"9167937", "Betanati\,\ Odisha",
"9165394", "Bolwa\,\ Bihar",
"912381", "Ahmedpur\,\ Maharashtra",
"9171975", "Mohadi\,\ Maharashtra",
"9162732", "Jhajharpur\,\ Bihar",
"9168436", "Puruna\ Katak\,\ Odisha",
"9176449", "Dindori\,\ Madhya\ Pradesh",
"914362", "Thanjavur\,\ Tamil\ Nadu",
"9165827", "Chaibasa\,\ Bihar",
"913224", "Haldia\,\ West\ Bengal",
"9176332", "Waraseoni\,\ Madhya\ Pradesh",
"9175225", "Datia\,\ Madhya\ Pradesh",
"9175923", "Vidisha\,\ Madhya\ Pradesh",
"912742", "Palanpur\,\ Gujarat",
"9162593", "Pakridayal\,\ Bihar",
"913452", "Guskara\,\ West\ Bengal",
"9165876", "Chakardharpur\,\ Bihar",
"9168497", "Daringbadi\,\ Odisha",
"911521", "Bikaner\/Jaimalsar\,\ Rajasthan",
"9174966", "Pichhore\,\ Madhya\ Pradesh",
"9171852", "Pauni\,\ Maharashtra",
"917723", "Mahasamund\,\ Madhya\ Pradesh",
"918669", "Vijayawada\,\ Andhra\ Pradesh",
"911874", "Gurdaspur\,\ Punjab",
"917917", "Ahmedabad\ Local\,\ Gujarat",
"912897", "Dhrol\,\ Gujarat",
"912433", "Gangapur\,\ Maharashtra",
"911931", "Kulgam\,\ Jammu\ And\ Kashmir",
"918253", "Hebri\,\ Karnataka",
"911254", "Bawanikhera\,\ Haryana",
"9164265", "Rajmahal\,\ Bihar",
"9167324", "Hindol\,\ Odisha",
"9171825", "Gondia\,\ Maharashtra",
"9174867", "Bareli\,\ Madhya\ Pradesh",
"9171786", "Sinderwahi\,\ Maharashtra",
"9165977", "Saraikela\/Adstyapur\,\ Bihar",
"9174208", "Jawad\,\ Madhya\ Pradesh",
"911422", "Viratnagar\/Shahpura\,\ Rajasthan",
"9168145", "Digapahandi\,\ Odisha",
"9174913", "Narwar\,\ Madhya\ Pradesh",
"912520", "Jawahar\,\ Maharashtra",
"917527", "Mehgaon\,\ Madhya\ Pradesh",
"917264", "Chikhali\,\ Maharashtra",
"9176258", "Umariapan\,\ Madhya\ Pradesh",
"912930", "Bilara\/Piparcity\,\ Rajasthan",
"9176260", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9174215", "Manasa\,\ Madhya\ Pradesh",
"9171444", "Atner\,\ Madhya\ Pradesh",
"9168532", "Sunabeda\,\ Odisha",
"9168405", "Tumudibandha\,\ Odisha",
"9171986", "Tirora\,\ Maharashtra",
"9165366", "Palkot\,\ Bihar",
"9165662", "Japla\,\ Bihar",
"91154", "Sriganganagar\,\ Rajasthan",
"9174126", "Ratlam\,\ Madhya\ Pradesh",
"9176309", "Katangi\,\ Madhya\ Pradesh",
"9164763", "Madhepura\,\ Bihar",
"918542", "Mahabubnagar\,\ Andhra\ Pradesh",
"9165885", "Jagarnathpur\,\ Bihar",
"912346", "Tasgaon\,\ Maharashtra",
"9164323", "Deoghar\,\ Bihar",
"9174359", "Gangdhar\,\ Rajasthan",
"9181727", "Hassan\,\ Karnataka",
"9165244", "Gumla\,\ Bihar",
"9173945", "Alirajpur\,\ Madhya\ Pradesh",
"9171553", "Seloo\,\ Maharashtra",
"9173243", "Mhow\,\ Madhya\ Pradesh",
"9174655", "Sapotra\,\ Rajasthan",
"918417", "Chevella\,\ Andhra\ Pradesh",
"918938", "Sileru\,\ Andhra\ Pradesh",
"9167964", "Karanjia\,\ Odisha",
"9171867", "Sakoli\,\ Maharashtra",
"9127173", "Sanand\,\ Gujarat",
"9174825", "Raisen\,\ Madhya\ Pradesh",
"918186", "Kargal\,\ Karnataka",
"9164227", "Godda\,\ Bihar",
"9175383", "Ambah\,\ Madhya\ Pradesh",
"9172860", "Khetia\,\ Madhya\ Pradesh",
"912821", "Jasdan\,\ Gujarat",
"9174530", "Baran\,\ Rajasthan",
"918334", "Mudalgi\,\ Karnataka",
"9162547", "Bettiah\,\ Bihar",
"9173205", "Pandhana\,\ Madhya\ Pradesh",
"918916", "Visakhapatnam\,\ Andhra\ Pradesh",
"91424", "Erode\,\ Tamil\ Nadu",
"9177058", "Kurud\,\ Madhya\ Pradesh",
"9168443", "Kantamal\,\ Odisha",
"911481", "Raipur\,\ Rajasthan",
"9164276", "Kathikund\,\ Bihar",
"912983", "Barmer\/Gudda\,\ Rajasthan",
"9167602", "Talcher\,\ Odisha",
"9161817", "Piro\,\ Bihar",
"9173218", "Sanwer\,\ Madhya\ Pradesh",
"912113", "Bhor\,\ Maharashtra",
"9177060", "Gariaband\,\ Madhya\ Pradesh",
"9166535", "Dunguripali\,\ Odisha",
"9171794", "Nagbhir\,\ Maharashtra",
"9176503", "Beohari\,\ Madhya\ Pradesh",
"9166402", "Bagdihi\,\ Odisha",
"916512", "Ranchi\,\ Bihar",
"911577", "Dantaramgarh\,\ Rajasthan",
"9171126", "Katol\,\ Maharashtra",
"91278", "Bhavnagar\,\ Gujarat",
"912594", "Trimbak\,\ Maharashtra",
"9165415", "Chatra\,\ Bihar",
"9163233", "Dumraon\,\ Bihar",
"9168554", "Laxmipur\,\ Odisha",
"9174948", "Kolaras\,\ Madhya\ Pradesh",
"917472", "Bundi\,\ Rajasthan",
"9181765", "Cannarayapatna\,\ Karnataka",
"915873", "Nighasan\/Tikunia\,\ Uttar\ Pradesh",
"9161323", "Barh\,\ Bihar",
"9171713", "Gond\ Pipri\,\ Maharashtra",
"9168103", "Khalikote\,\ Odisha",
"913595", "Gauzing\/Nayabazar\,\ West\ Bengal",
"918117", "Kanakapura\,\ Karnataka",
"914554", "Cumbum\,\ Tamil\ Nadu",
"9171655", "Saunsar\,\ Madhya\ Pradesh",
"9171994", "Deori\,\ Maharashtra",
"9171062", "Bhiwapur\,\ Maharashtra",
"9174553", "Digod\/Sultanpur\,\ Rajasthan",
"914822", "Palai\,\ Kerala",
"9171667", "Chaurai\,\ Madhya\ Pradesh",
"9162233", "Motipur\,\ Bihar",
"9174625", "Sawaimadhopur\,\ Rajasthan",
"91230", "Khadakwasala\,\ Maharashtra",
"911958", "Karnah\,\ Jammu\ And\ Kashmir",
"9171523", "Wardha\,\ Maharashtra",
"9174329", "Jhalawar\,\ Rajasthan",
"917624", "Sihora\,\ Madhya\ Pradesh",
"9181757", "Holenarasipur\,\ Karnataka",
"9164353", "Pakur\,\ Bihar",
"9171772", "Brahmapuri\,\ Maharashtra",
"918545", "Amangallu\,\ Andhra\ Pradesh",
"9168506", "Kalimela\,\ Odisha",
"911461", "Bansur\,\ Rajasthan",
"912963", "Gerhi\/Partapur\,\ Rajasthan",
"911506", "Anupgarh\/Gharsana\,\ Rajasthan",
"9187597", "Outsarangapalle\,\ Andhra\ Pradesh",
"917759", "Korba\,\ Madhya\ Pradesh",
"915168", "Jalaun\,\ Uttar\ Pradesh",
"9176446", "Dindori\,\ Madhya\ Pradesh",
"9168646", "Mathili\,\ Odisha",
"9171972", "Mohadi\,\ Maharashtra",
"9162735", "Jhajharpur\,\ Bihar",
"9175222", "Datia\,\ Madhya\ Pradesh",
"9176335", "Waraseoni\,\ Madhya\ Pradesh",
"9165583", "Dumri\(Isribazar\)\,\ Bihar",
"9174969", "Pichhore\,\ Madhya\ Pradesh",
"91460", "Taliparamba\,\ Kerala",
"91341", "Asansol\,\ West\ Bengal",
"911425", "Phulera\/Sambhar\,\ Rajasthan",
"9176488", "Mawai\,\ Madhya\ Pradesh",
"918234", "Nagamangala\,\ Karnataka",
"9171855", "Pauni\,\ Maharashtra",
"9167354", "Telkoi\,\ Odisha",
"912808", "Sumrasar\,\ Gujarat",
"911233", "Mawana\,\ Uttar\ Pradesh",
"917803", "Majholi\,\ Madhya\ Pradesh",
"9174523", "Chhabra\,\ Rajasthan",
"9167697", "Kamakhyanagar\,\ Odisha",
"9165516", "Barkagaon\,\ Bihar",
"913783", "Along\,\ Arunachal\ Pradesh",
"9171625", "Chhindwara\,\ Madhya\ Pradesh",
"918466", "Banswada\,\ Andhra\ Pradesh",
"911360", "Dehradun\ Chakrata\/Dakpattar\,\ Uttarakhand",
"9174667", "Bonli\,\ Rajasthan",
"913592", "Gangtok\,\ West\ Bengal",
"9173239", "Punasa\,\ Madhya\ Pradesh",
"9161353", "Bikram\,\ Bihar",
"918501", "Kollapur\,\ Andhra\ Pradesh",
"917475", "Bundi\,\ Rajasthan",
"914923", "Koduvayur\,\ Kerala",
"9168524", "Koraput\,\ Odisha",
"912357", "Malgund\,\ Maharashtra",
"918693", "Thungaturthy\,\ Andhra\ Pradesh",
"912677", "Limkheda\,\ Gujarat",
"917670", "Majhagwan\,\ Madhya\ Pradesh",
"9171156", "Mouda\,\ Maharashtra",
"917284", "Rajpur\,\ Madhya\ Pradesh",
"9167636", "Athmallik\,\ Odisha",
"9167332", "Ghatgaon\,\ Odisha",
"916515", "Ranchi\,\ Bihar",
"9166833", "Padmapur\,\ Odisha",
"9164617", "Raniganj\,\ Bihar",
"9164282", "Nala\,\ Bihar",
"917364", "Shajapur\,\ Madhya\ Pradesh",
"9165862", "Chainpur\,\ Bihar",
"9174972", "Khaniadhana\,\ Madhya\ Pradesh",
"9166436", "Barkot\,\ Odisha",
"912697", "Retlad\,\ Gujarat",
"917690", "Lakhnadon\,\ Madhya\ Pradesh",
"918673", "Tirivuru\,\ Andhra\ Pradesh",
"9165685", "Balumath\,\ Bihar",
"918353", "Jamkhandi\,\ Karnataka",
"9176818", "Jatara\,\ Madhya\ Pradesh",
"916804", "Berhampur\,\ Odisha",
"915240", "Fatehpur\,\ Uttar\ Pradesh",
"918869", "Pithapuram\,\ Andhra\ Pradesh",
"9166497", "Jamankira\,\ Odisha",
"9164257", "Katoria\,\ Bihar",
"9174340", "Pirawa\/Raipur\,\ Rajasthan",
"9174855", "Udaipura\,\ Madhya\ Pradesh",
"9165264", "Lohardaga\,\ Bihar",
"9176819", "Jatara\,\ Madhya\ Pradesh",
"916742", "Bhubaneshwar\,\ Odisha",
"9167883", "Soro\,\ Odisha",
"912344", "Jath\,\ Maharashtra",
"917777", "Pratappur\,\ Madhya\ Pradesh",
"912770", "Prantij\,\ Gujarat",
"9167944", "Rairangpur\,\ Odisha",
"918318", "Belgaum\,\ Karnataka",
"915871", "Nighasan\/Palia\ Kalan\,\ Uttar\ Pradesh",
"9171733", "Rajura\,\ Maharashtra",
"9165435", "Barhi\,\ Bihar",
"9175214", "Seondha\,\ Madhya\ Pradesh",
"915524", "Pharenda\/Anand\ Nagar\,\ Uttar\ Pradesh",
"9165642", "Nagarutari\,\ Bihar",
"9165346", "Jhumaritalaiya\,\ Bihar",
"9162272", "Mahua\,\ Bihar",
"917266", "Jalgaonjamod\,\ Maharashtra",
"912823", "Jetpur\,\ Gujarat",
"9176565", "Kannodi\,\ Madhya\ Pradesh",
"9174510", "Atru\,\ Rajasthan",
"9165502", "Hunterganj\,\ Bihar",
"9176240", "Sihora\,\ Madhya\ Pradesh",
"915732", "Bulandshahr\,\ Uttar\ Pradesh",
"9171464", "Ghorandogri\,\ Madhya\ Pradesh",
"9161896", "Bhabhua\,\ Bihar",
"9167226", "Pardip\,\ Odisha",
"918778", "Tirupathi\,\ Andhra\ Pradesh",
"911331", "Nakur\/Gangoh\,\ Uttar\ Pradesh",
"9164245", "Banka\,\ Bihar",
"9167486", "Bhubaneshwar\,\ Odisha",
"911483", "Hurda\/Gulabpura\,\ Rajasthan",
"912981", "Sheo\/Harsani\,\ Rajasthan",
"9181703", "Alur\,\ Karnataka",
"918484", "Bhalki\,\ Karnataka",
"9174847", "Silwani\,\ Madhya\ Pradesh",
"9175293", "Laher\,\ Madhya\ Pradesh",
"9162456", "Gogri\,\ Bihar",
"911607", "Kharar\,\ Punjab",
"9167277", "Kendrapara\,\ Odisha",
"9162525", "Motihari\,\ Bihar",
"9166515", "Birmaharajpur\,\ Odisha",
"9168165", "Mohana\,\ Odisha",
"915443", "Chunur\,\ Uttar\ Pradesh",
"912111", "Indapur\,\ Maharashtra",
"9161837", "Buxar\,\ Bihar",
"9173238", "Punasa\,\ Madhya\ Pradesh",
"918539", "Koppal\,\ Karnataka",
"9176489", "Mawai\,\ Madhya\ Pradesh",
"913228", "Tamluk\,\ West\ Bengal",
"91171", "Ambala\,\ Haryana",
"9167413", "Bhubaneshwar\,\ Odisha",
"918392", "Bellary\,\ Karnataka",
"9173927", "Jhabua\,\ Madhya\ Pradesh",
"9164203", "Amarpur\,\ Bihar",
"914115", "Madurantakam\,\ Tamil\ Nadu",
"9181745", "Arsikere\,\ Karnataka",
"9174968", "Pichhore\,\ Madhya\ Pradesh",
"914985", "Payyanur\,\ Kerala",
"9171042", "Hingua\,\ Maharashtra",
"9174950", "Badarwas\,\ Madhya\ Pradesh",
"913637", "Cherrapunjee\,\ Meghalaya",
"9166253", "Lahunipara\,\ Odisha",
"9167562", "Balugaon\,\ Odisha",
"912596", "Pachora\,\ Maharashtra",
"9174592", "Ramganj\ Mandi\,\ Rajasthan",
"913242", "Bankura\,\ West\ Bengal",
"915855", "Bilgram\/Sandi\,\ Uttar\ Pradesh",
"911635", "Kotkapura\,\ Punjab",
"9168463", "Baliguda\,\ Odisha",
"9163286", "Daudnagar\,\ Bihar",
"9176527", "Shahdol\,\ Madhya\ Pradesh",
"9163317", "Imamganj\,\ Bihar",
"918251", "Puttur\,\ Karnataka",
"918372", "Gadag\,\ Karnataka",
"9167494", "Bhubaneshwar\,\ Odisha",
"9168176", "R\.Udayigiri\,\ Odisha",
"912922", "Osian\,\ Rajasthan",
"9163477", "Chakai\,\ Bihar",
"9177040", "Deobhog\,\ Madhya\ Pradesh",
"9176576", "Jaitpur\,\ Madhya\ Pradesh",
"9167816", "Basta\,\ Odisha",
"9161884", "Rohtas\,\ Bihar",
"9171847", "Bhandara\,\ Maharashtra",
"918184", "Sorab\,\ Karnataka",
"9166755", "T\.Rampur\,\ Odisha",
"9174933", "Karera\,\ Madhya\ Pradesh",
"9163426", "H\.Kharagpur\,\ Bihar",
"918914", "Visakhapatnam\,\ Andhra\ Pradesh",
"915143", "Hasanganj\,\ Uttar\ Pradesh",
"9174235", "Neemuch\,\ Madhya\ Pradesh",
"9174328", "Jhalawar\,\ Rajasthan",
"9162567", "Ramnagar\,\ Bihar",
"918336", "Khanapur\,\ Karnataka",
"9164374", "Mahagama\,\ Bihar",
"911430", "Phagi\,\ Rajasthan",
"914259", "Pollachi\,\ Tamil\ Nadu",
"9168573", "Gunupur\,\ Odisha",
"918150", "Bagepalli\,\ Karnataka",
"9167585", "Nimapara\,\ Odisha",
"9174949", "Kolaras\,\ Madhya\ Pradesh",
"9162555", "Raxaul\,\ Bihar",
"9166416", "Deodgarh\,\ Odisha",
"9162426", "Benipur\,\ Bihar",
"918236", "Pandavpura\,\ Karnataka",
"9174574", "Mangrol\,\ Rajasthan",
"9166767", "M\.Rampur\,\ Odisha",
"9176466", "Nainpur\,\ Madhya\ Pradesh",
"9168666", "Umerkote\,\ Odisha",
"9167256", "Dhanmandal\,\ Odisha",
"918351", "Hungund\,\ Karnataka",
"915735", "Sikandrabad\,\ Uttar\ Pradesh",
"918272", "Madikeri\,\ Karnataka",
"9162286", "Pupri\,\ Bihar",
"918671", "Divi\/Challapalli\,\ Andhra\ Pradesh",
"9162477", "Singhwara\,\ Bihar",
"9165536", "Ramgarh\,\ Bihar",
"9177059", "Kurud\,\ Madhya\ Pradesh",
"911504", "Bhadra\,\ Rajasthan",
"918503", "Makthal\,\ Andhra\ Pradesh",
"9173219", "Sanwer\,\ Madhya\ Pradesh",
"9165597", "Simaria\,\ Bihar",
"91129", "Faridabad\,\ Haryana",
"9167312", "Anandapur\,\ Odisha",
"9167616", "Chhendipada\,\ Odisha",
"918691", "Devarakonda\,\ Andhra\ Pradesh",
"9171647", "Pandhurna\,\ Madhya\ Pradesh",
"9166813", "Jujumura\,\ Odisha",
"916745", "Bhubaneshwar\,\ Odisha",
"9168675", "Jharigan\,\ Odisha",
"916806", "Berhampur\,\ Odisha",
"9167683", "Parajang\,\ Odisha",
"9168157", "Parlakhemundi\,\ Odisha",
"9176475", "Ghughari\,\ Madhya\ Pradesh",
"9174358", "Gangdhar\,\ Rajasthan",
"918450", "Andole\/Jogipet\,\ Andhra\ Pradesh",
"9174507", "Sangod\,\ Rajasthan",
"911676", "Sunam\,\ Punjab",
"9163456", "Jamui\,\ Bihar",
"91202", "Pune\,\ Maharashtra",
"9174360", "Hindoli\,\ Rajasthan",
"9166725", "Dharamgarh\,\ Odisha",
"9171574", "Arvi\,\ Maharashtra",
"9162715", "Benipatti\,\ Bihar",
"9162294", "Bidupur\,\ Bihar",
"917366", "Khachrod\,\ Madhya\ Pradesh",
"914204", "Kodumudi\,\ Tamil\ Nadu",
"912925", "Phalodi\,\ Rajasthan",
"917801", "Deosar\,\ Madhya\ Pradesh",
"918375", "Haveri\,\ Karnataka",
"9176308", "Katangi\,\ Madhya\ Pradesh",
"913668", "Bijni\,\ Assam",
"9165842", "Bishrampur\,\ Bihar",
"911632", "Ferozepur\,\ Punjab",
"9168182", "Buguda\,\ Odisha",
"9176259", "Umariapan\,\ Madhya\ Pradesh",
"915852", "Hardoi\,\ Uttar\ Pradesh",
"911696", "Kalanwali\,\ Haryana",
"9166223", "Sundargarh\,\ Odisha",
"9184537", "Medak\,\ Andhra\ Pradesh",
"9163272", "Rafiganj\,\ Bihar",
"918464", "Madnur\,\ Andhra\ Pradesh",
"9174647", "Karauli\,\ Rajasthan",
"9174920", "Shivpuri\,\ Madhya\ Pradesh",
"911463", "Kishangarh\,\ Rajasthan",
"912961", "Ghatol\,\ Rajasthan",
"914982", "Taliparamba\,\ Kerala",
"914112", "Kancheepuram\,\ Tamil\ Nadu",
"911559", "Rajgarh\,\ Rajasthan",
"9166483", "Patnagarh\,\ Odisha",
"918395", "Sandur\,\ Karnataka",
"918715", "Mulug\,\ Andhra\ Pradesh",
"9173957", "Sondhwa\,\ Madhya\ Pradesh",
"9174209", "Jawad\,\ Madhya\ Pradesh",
"918218", "Mysore\,\ Karnataka",
"915563", "Captanganj\/Khadda\,\ Uttar\ Pradesh",
"9176294", "Pushprajgarh\,\ Madhya\ Pradesh",
"9172886", "Bhikangaon\,\ Madhya\ Pradesh",
"917362", "Agar\,\ Madhya\ Pradesh",
"9165232", "Ghaghra\,\ Bihar",
"911636", "Moga\,\ Punjab",
"9168453", "Phiringia\,\ Odisha",
"9177048", "Deobhog\,\ Madhya\ Pradesh",
"917857", "Bacheli\,\ Madhya\ Pradesh",
"9162475", "Singhwara\,\ Bihar",
"913821", "R\.K\.Pur\,\ Tripura",
"911672", "Sangrur\,\ Punjab",
"9167587", "Nimapara\,\ Odisha",
"916617", "Rourkela\,\ Odisha",
"9174603", "Sahabad\,\ Rajasthan",
"916802", "Berhampur\,\ Odisha",
"9162557", "Raxaul\,\ Bihar",
"918335", "Ramdurg\,\ Karnataka",
"914890", "Bitra\,\ Lakshadweep",
"9168604", "Boriguma\,\ Odisha",
"9176404", "Shahpur\,\ Madhya\ Pradesh",
"9166765", "M\.Rampur\,\ Odisha",
"9174320", "Jhalawar\,\ Rajasthan",
"9165595", "Simaria\,\ Bihar",
"9174543", "Chhipaborad\,\ Rajasthan",
"9174960", "Pichhore\,\ Madhya\ Pradesh",
"9171645", "Pandhurna\,\ Madhya\ Pradesh",
"9168544", "Jeypore\,\ Odisha",
"9171432", "Bhainsdehi\,\ Madhya\ Pradesh",
"9161533", "Maharajganj\,\ Bihar",
"9174958", "Badarwas\,\ Madhya\ Pradesh",
"913865", "Phek\,\ Nagaland",
"914116", "Tiruvallur\,\ Tamil\ Nadu",
"9167552", "Khurda\,\ Odisha",
"9166263", "Banaigarh\,\ Odisha",
"912595", "Dhadgaon\,\ Maharashtra",
"911692", "Tohana\,\ Haryana",
"911900", "Lahul\/Keylong\,\ Himachal\ Pradesh",
"915212", "Malihabad\,\ Uttar\ Pradesh",
"9171093", "Kamptee\,\ Maharashtra",
"9162582", "Areraj\,\ Bihar",
"9175902", "Lateri\,\ Madhya\ Pradesh",
"917282", "Khargone\,\ Madhya\ Pradesh",
"9174518", "Atru\,\ Rajasthan",
"918276", "Somwarpet\,\ Karnataka",
"9171454", "Chicholi\,\ Madhya\ Pradesh",
"9168626", "Gudari\,\ Odisha",
"914343", "Krishnagiri\,\ Tamil\ Nadu",
"9176426", "Mandla\,\ Madhya\ Pradesh",
"9165614", "Garhwa\,\ Bihar",
"9176248", "Sihora\,\ Madhya\ Pradesh",
"917265", "Nandura\,\ Maharashtra",
"912763", "Vijapur\,\ Gujarat",
"9166776", "Narlaroad\,\ Odisha",
"917768", "Saranggarh\,\ Madhya\ Pradesh",
"9168677", "Jharigan\,\ Odisha",
"9171603", "Jamai\,\ Madhya\ Pradesh",
"918647", "Narsaraopet\,\ Andhra\ Pradesh",
"9168155", "Parlakhemundi\,\ Odisha",
"9176477", "Ghughari\,\ Madhya\ Pradesh",
"9174505", "Sangod\,\ Rajasthan",
"9166727", "Dharamgarh\,\ Odisha",
"9162717", "Benipatti\,\ Bihar",
"9176286", "Karpa\,\ Madhya\ Pradesh",
"918232", "Mandya\,\ Karnataka",
"912551", "Sinnar\,\ Maharashtra",
"9173230", "Punasa\,\ Madhya\ Pradesh",
"9162466", "Jainagar\,\ Bihar",
"915278", "Faizabad\,\ Uttar\ Pradesh",
"9167912", "Bangiriposi\,\ Odisha",
"911255", "Siwani\,\ Haryana",
"9167534", "Nayagarh\,\ Odisha",
"9174645", "Karauli\,\ Rajasthan",
"9164792", "Udakishanganj\,\ Bihar",
"9165693", "Garu\,\ Bihar",
"9165254", "Simdega\,\ Bihar",
"9174349", "Pirawa\/Raipur\,\ Rajasthan",
"9164533", "Araria\,\ Bihar",
"917622", "Katni\,\ Madhya\ Pradesh",
"9173955", "Sondhwa\,\ Madhya\ Pradesh",
"917221", "Nandgaon\,\ Maharashtra",
"9177013", "Pingeshwar\,\ Madhya\ Pradesh",
"912643", "Valia\,\ Gujarat",
"9184535", "Medak\,\ Andhra\ Pradesh",
"915315", "Dalmau\/Lalganj\,\ Uttar\ Pradesh",
"9165437", "Barhi\,\ Bihar",
"917285", "Kasrawad\,\ Madhya\ Pradesh",
"9176269", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9165814", "Bhandaria\,\ Bihar",
"916514", "Ranchi\,\ Bihar",
"917788", "Luckwada\,\ Madhya\ Pradesh",
"918579", "Palmaneru\,\ Andhra\ Pradesh",
"912592", "Kalwan\,\ Maharashtra",
"9172872", "Gogaon\,\ Madhya\ Pradesh",
"9171146", "Ramtek\,\ Maharashtra",
"9167522", "Puri\,\ Odisha",
"917474", "Bundi\,\ Rajasthan",
"913862", "Dimapur\,\ Nagaland",
"9174928", "Shivpuri\,\ Madhya\ Pradesh",
"918716", "Jangaon\,\ Andhra\ Pradesh",
"9165496", "Bermo\,\ Bihar",
"9171803", "Salekasa\,\ Maharashtra",
"918396", "Siruguppa\,\ Karnataka",
"9177072", "Bagbahera\,\ Madhya\ Pradesh",
"915949", "Kichha\/Bazpur\,\ Uttar\ Pradesh",
"913677", "Baithalangshu\,\ Assam",
"914552", "Usilampatti\,\ Tamil\ Nadu",
"9174333", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9174350", "Gangdhar\,\ Rajasthan",
"9165893", "Jhinkpani\,\ Bihar",
"9164247", "Banka\,\ Bihar",
"9174845", "Silwani\,\ Madhya\ Pradesh",
"9167973", "Jashipur\,\ Odisha",
"916805", "Berhampur\,\ Odisha",
"9162527", "Motihari\,\ Bihar",
"9167275", "Kendrapara\,\ Odisha",
"918332", "Gokak\,\ Karnataka",
"9174368", "Hindoli\,\ Rajasthan",
"918787", "Karimnagar\,\ Andhra\ Pradesh",
"9168167", "Mohana\,\ Odisha",
"9166517", "Birmaharajpur\,\ Odisha",
"9161835", "Buxar\,\ Bihar",
"911675", "Malerkotla\,\ Punjab",
"918599", "Ulvapadu\,\ Andhra\ Pradesh",
"9163466", "Lakhisarai\,\ Bihar",
"9164774", "Triveniganj\,\ Bihar",
"918376", "Hirekerur\,\ Karnataka",
"911470", "Dungla\,\ Rajasthan",
"9176567", "Kannodi\,\ Madhya\ Pradesh",
"918811", "Polavaram\,\ Andhra\ Pradesh",
"918207", "Udupi\,\ Karnataka",
"918656", "Nuzvidu\,\ Andhra\ Pradesh",
"9168423", "Phulbani\,\ Odisha",
"917365", "Mahidpurcity\,\ Madhya\ Pradesh",
"9175936", "Kurwai\,\ Madhya\ Pradesh",
"912926", "Osian\/Mathania\,\ Rajasthan",
"9162576", "Barachakia\,\ Bihar",
"9176300", "Katangi\,\ Madhya\ Pradesh",
"914639", "Tiruchendur\,\ Tamil\ Nadu",
"917513", "Gwalior\,\ Madhya\ Pradesh",
"9166782", "Nowparatan\,\ Odisha",
"9174146", "Jaora\,\ Madhya\ Pradesh",
"912427", "Newasa\,\ Maharashtra",
"9165484", "Ichak\,\ Bihar",
"917741", "Kawardha\,\ Madhya\ Pradesh",
"9177069", "Gariaband\,\ Madhya\ Pradesh",
"9164343", "Dumka\,\ Bihar",
"9174539", "Baran\,\ Rajasthan",
"917449", "Ladpura\/Kota\,\ Rajasthan",
"9176272", "Manpur\,\ Madhya\ Pradesh",
"9173925", "Jhabua\,\ Madhya\ Pradesh",
"9174803", "Goharganj\,\ Madhya\ Pradesh",
"916746", "Bhubaneshwar\,\ Odisha",
"9165224", "Muri\,\ Bihar",
"9181747", "Arsikere\,\ Karnataka",
"9172869", "Khetia\,\ Madhya\ Pradesh",
"9173223", "Depalpur\,\ Madhya\ Pradesh",
"9168216", "Bhanjanagar\,\ Odisha",
"911887", "Nangal\,\ Punjab",
"915831", "Dataganj\,\ Uttar\ Pradesh",
"9171333", "Aheri\,\ Maharashtra",
"91364", "Shillong\,\ Meghalaya",
"911252", "Loharu\,\ Haryana",
"918738", "Sirpurkagaznagar\,\ Andhra\ Pradesh",
"911371", "Dunda\,\ Uttarakhand",
"911651", "Phulmandi\,\ Punjab",
"918510", "Koilkuntla\,\ Andhra\ Pradesh",
"9171845", "Bhandara\,\ Maharashtra",
"9166757", "T\.Rampur\,\ Odisha",
"91376", "Jorhat\,\ Assam",
"911424", "Phulera\/Renwal\,\ Rajasthan",
"9174237", "Neemuch\,\ Madhya\ Pradesh",
"917846", "Garpa\,\ Madhya\ Pradesh",
"9162565", "Ramnagar\,\ Bihar",
"9165946", "Baharagora\,\ Bihar",
"913808", "Changlang\,\ Arunachal\ Pradesh",
"9176525", "Shahdol\,\ Madhya\ Pradesh",
"917262", "Buldhana\,\ Maharashtra",
"917661", "Teonthar\,\ Madhya\ Pradesh",
"9163315", "Imamganj\,\ Bihar",
"9176456", "Karanjia\,\ Madhya\ Pradesh",
"9168656", "Kashipur\,\ Odisha",
"9167266", "Jajapur\ Road\,\ Odisha",
"91241", "Ahmednagar\,\ Maharashtra",
"9163475", "Chakai\,\ Bihar",
"9171424", "Bhimpur\,\ Madhya\ Pradesh",
"915736", "Siyana\,\ Uttar\ Pradesh",
"915854", "Sandila\,\ Uttar\ Pradesh",
"9166243", "Rajgangpur\,\ Odisha",
"9174676", "Bamanwas\,\ Rajasthan",
"9174372", "Nainwa\,\ Rajasthan",
"9177033", "Manpur\,\ Madhya\ Pradesh",
"914573", "Rameshwaram\,\ Tamil\ Nadu",
"9187595", "Outsarangapalle\,\ Andhra\ Pradesh",
"917223", "Achalpur\,\ Maharashtra",
"913659", "Resubelpara\/Mendipathar\,\ Meghalaya",
"9164513", "Barsoi\,\ Bihar",
"9174940", "Kolaras\,\ Madhya\ Pradesh",
"9174627", "Sawaimadhopur\,\ Rajasthan",
"918462", "Nizamabad\,\ Andhra\ Pradesh",
"9171665", "Chaurai\,\ Madhya\ Pradesh",
"9171052", "Narkhed\,\ Maharashtra",
"912641", "Amod\,\ Gujarat",
"9174563", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"918557", "Penukonda\,\ Andhra\ Pradesh",
"9168564", "Rayagada\,\ Odisha",
"9181755", "Holenarasipur\,\ Karnataka",
"914114", "Chengalpattu\,\ Tamil\ Nadu",
"912637", "Navsari\,\ Gujarat",
"9172868", "Khetia\,\ Madhya\ Pradesh",
"914341", "Uthangarai\,\ Tamil\ Nadu",
"9164594", "Thakurganj\,\ Bihar",
"918915", "Visakhapatnam\,\ Andhra\ Pradesh",
"9174538", "Baran\,\ Rajasthan",
"9162796", "Barauni\,\ Bihar",
"9168492", "Daringbadi\,\ Odisha",
"918185", "Hosanagara\,\ Karnataka",
"9171857", "Pauni\,\ Maharashtra",
"911568", "Sujangarh\,\ Rajasthan",
"912761", "Kheralu\,\ Gujarat",
"9165634", "Bhawanathpur\,\ Bihar",
"912469", "Kinwat\,\ Maharashtra",
"914202", "Mulanur\,\ Tamil\ Nadu",
"9177050", "Kurud\,\ Madhya\ Pradesh",
"918249", "Mangalore\,\ Karnataka",
"9167932", "Betanati\,\ Odisha",
"9177068", "Gariaband\,\ Madhya\ Pradesh",
"912553", "Igatpuri\,\ Maharashtra",
"9161586", "Sonepur\,\ Bihar",
"9173210", "Sanwer\,\ Madhya\ Pradesh",
"911634", "Abohar\,\ Punjab",
"9162737", "Jhajharpur\,\ Bihar",
"9165822", "Chaibasa\,\ Bihar",
"9176337", "Waraseoni\,\ Madhya\ Pradesh",
"918633", "Guntur\,\ Andhra\ Pradesh",
"9171372", "Desaiganj\,\ Maharashtra",
"9171676", "Amarwada\,\ Madhya\ Pradesh",
"9165356", "Chainpur\,\ Bihar",
"9165652", "Latehar\,\ Bihar",
"9164753", "S\.Bakhtiarpur\,\ Bihar",
"9173292", "Khakner\,\ Madhya\ Pradesh",
"915525", "Bansgaon\,\ Uttar\ Pradesh",
"9161513", "Sidhawalia\,\ Bihar",
"91595", "Rampur\,\ Uttar\ Pradesh",
"911502", "Nohar\/Jedasar\,\ Rajasthan",
"9171412", "Betul\,\ Madhya\ Pradesh",
"9164615", "Raniganj\,\ Bihar",
"915613", "Achhnera\,\ Uttar\ Pradesh",
"9167695", "Kamakhyanagar\,\ Odisha",
"9171563", "Talegaokarangal\,\ Maharashtra",
"914268", "Velur\,\ Tamil\ Nadu",
"917683", "Tikamgarh\,\ Madhya\ Pradesh",
"9174665", "Bonli\,\ Rajasthan",
"9171627", "Chhindwara\,\ Madhya\ Pradesh",
"9167954", "Udala\,\ Odisha",
"912345", "Shirala\,\ Maharashtra",
"9166703", "Bhawanipatna\,\ Odisha",
"9174369", "Hindoli\,\ Rajasthan",
"913790", "Tali\,\ Arunachal\ Pradesh",
"9161594", "Masrakh\,\ Bihar",
"9165687", "Balumath\,\ Bihar",
"915561", "Salempur\/Barhaj\,\ Uttar\ Pradesh",
"9174929", "Shivpuri\,\ Madhya\ Pradesh",
"913823", "Belonia\,\ Tripura",
"9162446", "Khagaria\,\ Bihar",
"9174200", "Jawad\,\ Madhya\ Pradesh",
"9166495", "Jamankira\,\ Odisha",
"9164255", "Katoria\,\ Bihar",
"9174857", "Udaipura\,\ Madhya\ Pradesh",
"918485", "Aurad\,\ Karnataka",
"9162784", "Dalsinghsarai\,\ Bihar",
"918680", "Nidamanur\/Hillcolony\,\ Andhra\ Pradesh",
"918408", "Donakonda\,\ Andhra\ Pradesh",
"9176384", "Damoh\,\ Madhya\ Pradesh",
"9176250", "Umariapan\,\ Madhya\ Pradesh",
"918274", "Virajpet\,\ Karnataka",
"912169", "Shirwal\,\ Maharashtra",
"9175262", "Ghatigaon\,\ Madhya\ Pradesh",
"9171034", "Butibori\,\ Maharashtra",
"9176268", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9171876", "Goregaon\,\ Maharashtra",
"9165852", "Ghatsila\,\ Bihar",
"918654", "Jaggayyapet\,\ Andhra\ Pradesh",
"911373", "Purola\,\ Uttarakhand",
"918740", "Aswaraopet\,\ Andhra\ Pradesh",
"9174217", "Manasa\,\ Madhya\ Pradesh",
"912924", "Phalodi\/Baroo\,\ Rajasthan",
"9174386", "Keshoraipatan\/Patan\,\ Rajasthan",
"9174682", "Khandar\,\ Rajasthan",
"918729", "Manthani\,\ Andhra\ Pradesh",
"9171394", "Kurkheda\,\ Maharashtra",
"914288", "Tiruchengode\,\ Tamil\ Nadu",
"917663", "Mauganj\,\ Madhya\ Pradesh",
"913210", "Kakdwip\,\ West\ Bengal",
"91794", "Ahmedabad\ Local\,\ Gujarat",
"912668", "Waghodia\,\ Gujarat",
"9164267", "Rajmahal\,\ Bihar",
"9165975", "Saraikela\/Adstyapur\,\ Bihar",
"918182", "Shimoga\,\ Karnataka",
"9176810", "Jatara\,\ Madhya\ Pradesh",
"9174865", "Bareli\,\ Madhya\ Pradesh",
"9171827", "Gondia\,\ Maharashtra",
"9165273", "Kolebira\,\ Bihar",
"918912", "Visakhapatnam\,\ Andhra\ Pradesh",
"9163446", "Monghyr\,\ Bihar",
"91191", "Jammu\,\ Jammu\ And\ Kashmir",
"9172691", "Deolgaonraja\,\ Maharashtra",
"9174348", "Pirawa\/Raipur\,\ Rajasthan",
"9168147", "Digapahandi\,\ Odisha",
"9165887", "Jagarnathpur\,\ Bihar",
"914368", "Karaikal\,\ Tamil\ Nadu",
"9165304", "Bundu\,\ Bihar",
"9161116", "Hilsa\,\ Bihar",
"911537", "Nohar\/Rawatsar\,\ Rajasthan",
"9181725", "Hassan\,\ Karnataka",
"917476", "Bundi\,\ Rajasthan",
"9173947", "Alirajpur\,\ Madhya\ Pradesh",
"918394", "Hospet\,\ Karnataka",
"9171022", "Parseoni\,\ Maharashtra",
"917743", "Chuikhadan\,\ Madhya\ Pradesh",
"9174657", "Sapotra\,\ Rajasthan",
"9162503", "Dhaka\,\ Bihar",
"918465", "Yellareddy\,\ Andhra\ Pradesh",
"912748", "Dhanera\,\ Gujarat",
"9168407", "Tumudibandha\,\ Odisha",
"913017", "Pokhran\/Madasar\,\ Rajasthan",
"9171473", "Multai\,\ Madhya\ Pradesh",
"9161572", "Mairwa\,\ Bihar",
"918660", "Vijayawada\,\ Andhra\ Pradesh",
"912189", "Mohol\,\ Maharashtra",
"9174519", "Atru\,\ Rajasthan",
"9171166", "Umrer\,\ Maharashtra",
"915833", "Sahaswan\,\ Uttar\ Pradesh",
"9171313", "Sironcha\,\ Maharashtra",
"915497", "Zamania\,\ Uttar\ Pradesh",
"913244", "Bishnupur\,\ West\ Bengal",
"9176249", "Sihora\,\ Madhya\ Pradesh",
"916516", "Ranchi\,\ Bihar",
"9174876", "Begamganj\,\ Madhya\ Pradesh",
"9165966", "Noamundi\,\ Bihar",
"9161815", "Piro\,\ Bihar",
"915734", "Debai\,\ Uttar\ Pradesh",
"9171386", "Dhanora\,\ Maharashtra",
"9171682", "Harrai\,\ Madhya\ Pradesh",
"9166537", "Dunguripali\,\ Odisha",
"9167246", "Jagatsinghpur\,\ Odisha",
"9174827", "Raisen\,\ Madhya\ Pradesh",
"918482", "Bidar\,\ Karnataka",
"9171865", "Sakoli\,\ Maharashtra",
"9164225", "Godda\,\ Bihar",
"918813", "Eluru\ Kovvur\/Nidadavolu\,\ Andhra\ Pradesh",
"9176480", "Mawai\,\ Madhya\ Pradesh",
"912970", "Sanchore\/Hadecha\,\ Rajasthan",
"917844", "Pakhanjur\,\ Madhya\ Pradesh",
"9174959", "Badarwas\,\ Madhya\ Pradesh",
"9162545", "Bettiah\,\ Bihar",
"911426", "Jamwa\ Ramgarh\/Achrol\,\ Rajasthan",
"9173207", "Pandhana\,\ Madhya\ Pradesh",
"9175916", "Sironj\,\ Madhya\ Pradesh",
"918320", "Goa",
"916744", "Bhubaneshwar\,\ Odisha",
"9165417", "Chatra\,\ Bihar",
"9181767", "Cannarayapatna\,\ Karnataka",
"915548", "Khalilabad\/Mehdawal\,\ Uttar\ Pradesh",
"9164363", "Sahibganj\,\ Bihar",
"912342", "Islampur\,\ Maharashtra",
"911588", "Parbatsar\/Makrana\,\ Rajasthan",
"9167924", "Baripada\,\ Odisha",
"9171657", "Saunsar\,\ Madhya\ Pradesh",
"9165834", "Kharsawa\,\ Bihar",
"912489", "Karjat\,\ Maharashtra",
"9164572", "Korha\,\ Bihar",
"915880", "Puranpur\,\ Uttar\ Pradesh",
"912990", "Bhinmal\/Jasawantpura\,\ Rajasthan",
"911505", "Padampur\,\ Rajasthan",
"917810", "Uproda\,\ Madhya\ Pradesh",
"9168474", "G\.Udayagiri\,\ Odisha",
"915522", "Pharenda\/Compierganj\,\ Uttar\ Pradesh",
"918546", "Gadwal\,\ Andhra\ Pradesh",
"912328", "Panhala\,\ Maharashtra",
"9177049", "Deobhog\,\ Madhya\ Pradesh",
"9174313", "Aklera\,\ Rajasthan",
"9165326", "Giridih\,\ Bihar",
"9165622", "Daltonganj\,\ Bihar",
"9174244", "Malhargarh\,\ Madhya\ Pradesh",
"9171415", "Betul\,\ Madhya\ Pradesh",
"914286", "Namakkal\,\ Tamil\ Nadu",
"9164612", "Raniganj\,\ Bihar",
"9164316", "Jharmundi\,\ Bihar",
"9164287", "Nala\,\ Bihar",
"915740", "Aliganj\/Ganjdundwara\,\ Uttar\ Pradesh",
"912666", "Miyagam\,\ Gujarat",
"9165655", "Latehar\,\ Bihar",
"91422", "Coimbatore\,\ Tamil\ Nadu",
"9163324", "Nabinagar\,\ Bihar",
"9171375", "Desaiganj\,\ Maharashtra",
"9176514", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9175938", "Kurwai\,\ Madhya\ Pradesh",
"9167337", "Ghatgaon\,\ Odisha",
"9173295", "Khakner\,\ Madhya\ Pradesh",
"918477", "Aland\,\ Karnataka",
"911991", "Reasi\,\ Jammu\ And\ Kashmir",
"9168114", "Chhatrapur\,\ Odisha",
"912837", "Bhachav\,\ Gujarat",
"9167692", "Kamakhyanagar\,\ Odisha",
"915182", "Khaga\,\ Uttar\ Pradesh",
"912841", "Vallabhipur\,\ Gujarat",
"9174366", "Hindoli\,\ Rajasthan",
"9174662", "Bonli\,\ Rajasthan",
"9171704", "Chumur\,\ Maharashtra",
"915465", "Phulpur\/Atrawlia\,\ Uttar\ Pradesh",
"9166492", "Jamankira\,\ Odisha",
"9165913", "Chandil\,\ Bihar",
"9164252", "Katoria\,\ Bihar",
"9174926", "Shivpuri\,\ Madhya\ Pradesh",
"9171186", "Kalmeshwar\,\ Maharashtra",
"918581", "Punganur\,\ Andhra\ Pradesh",
"917784", "Parasgaon\,\ Madhya\ Pradesh",
"9175265", "Ghatigaon\,\ Madhya\ Pradesh",
"9165867", "Chainpur\,\ Bihar",
"914366", "Tiruvarur\,\ Tamil\ Nadu",
"9174977", "Khaniadhana\,\ Madhya\ Pradesh",
"912473", "Kallam\,\ Maharashtra",
"918497", "Kalyandurg\,\ Andhra\ Pradesh",
"918833", "Rajahmundri\,\ Andhra\ Pradesh",
"917478", "Bundi\,\ Rajasthan",
"9168193", "Surada\,\ Odisha",
"9181734", "Sakleshpur\,\ Karnataka",
"912746", "Radhanpur\,\ Gujarat",
"9175963", "Gyraspur\,\ Madhya\ Pradesh",
"914153", "Arakandanallur\,\ Tamil\ Nadu",
"9171726", "Chandrapur\,\ Maharashtra",
"9187592", "Outsarangapalle\,\ Andhra\ Pradesh",
"911733", "Kalka\,\ Haryana",
"9176460", "Nainpur\,\ Madhya\ Pradesh",
"916572", "Jamshedpur\,\ Bihar",
"917531", "Baroda\,\ Madhya\ Pradesh",
"9174679", "Bamanwas\,\ Rajasthan",
"918734", "Nirmal\,\ Andhra\ Pradesh",
"911389", "Joshimath\,\ Uttarakhand",
"9164234", "Maheshpur\ Raj\,\ Bihar",
"917547", "Chanderi\,\ Madhya\ Pradesh",
"9174375", "Nainwa\,\ Rajasthan",
"9176458", "Karanjia\,\ Madhya\ Pradesh",
"911428", "Dudu\,\ Rajasthan",
"9181752", "Holenarasipur\,\ Karnataka",
"91226", "Mumbai",
"912529", "Mokhada\,\ Maharashtra",
"913804", "Tezu\,\ Arunachal\ Pradesh",
"9171777", "Brahmapuri\,\ Maharashtra",
"918177", "Belur\,\ Karnataka",
"9174704", "Bundi\,\ Rajasthan",
"912939", "Jaitaran\,\ Rajasthan",
"9171662", "Chaurai\,\ Madhya\ Pradesh",
"9171366", "Etapalli\,\ Maharashtra",
"9171055", "Narkhed\,\ Maharashtra",
"9168495", "Daringbadi\,\ Odisha",
"913623", "Barama\,\ Assam",
"915165", "Konch\,\ Uttar\ Pradesh",
"916127", "Patna\,\ Bihar",
"912326", "Gaganbavada\,\ Maharashtra",
"918548", "Shadnagar\,\ Andhra\ Pradesh",
"9165444", "Gomia\,\ Bihar",
"9167935", "Betanati\,\ Odisha",
"9165825", "Chaibasa\,\ Bihar",
"9171977", "Mohadi\,\ Maharashtra",
"9164383", "Madhupur\,\ Bihar",
"915546", "Harraiya\,\ Uttar\ Pradesh",
"918522", "Peapalle\,\ Andhra\ Pradesh",
"9175227", "Datia\,\ Madhya\ Pradesh",
"9174904", "Pohari\,\ Madhya\ Pradesh",
"9161873", "Mohania\,\ Bihar",
"918932", "Narsipatnam\,\ Andhra\ Pradesh",
"911586", "Nawa\/Kuchamancity\,\ Rajasthan",
"9167233", "Athgarh\,\ Odisha",
"9174148", "Jaora\,\ Madhya\ Pradesh",
"911955", "Kupwara\,\ Jammu\ And\ Kashmir",
"9171685", "Harrai\,\ Madhya\ Pradesh",
"9167607", "Talcher\,\ Odisha",
"9161812", "Piro\,\ Bihar",
"9174583", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9174879", "Begamganj\,\ Madhya\ Pradesh",
"9168584", "Nowrangapur\,\ Odisha",
"918854", "Tuni\,\ Andhra\ Pradesh",
"911853", "Rayya\,\ Punjab",
"9162542", "Bettiah\,\ Bihar",
"9171862", "Sakoli\,\ Maharashtra",
"9174956", "Badarwas\,\ Madhya\ Pradesh",
"9164222", "Godda\,\ Bihar",
"917863", "Chingamut\,\ Madhya\ Pradesh",
"915462", "Azamgarh\,\ Uttar\ Pradesh",
"9175919", "Sironj\,\ Madhya\ Pradesh",
"9176570", "Jaitpur\,\ Madhya\ Pradesh",
"9171067", "Bhiwapur\,\ Maharashtra",
"9161566", "Gopalganj\,\ Bihar",
"9181521", "Kolar\,\ Karnatak",
"91474", "Kollam\,\ Kerala",
"9171516", "Samudrapur\,\ Maharashtra",
"912903", "Chohtan\/Gangasar\,\ Rajasthan",
"9172888", "Bhikangaon\,\ Madhya\ Pradesh",
"9165625", "Daltonganj\,\ Bihar",
"911566", "Sri\ Dungargarh\/Sudsar\,\ Rajasthan",
"9166407", "Bagdihi\,\ Odisha",
"9177046", "Deobhog\,\ Madhya\ Pradesh",
"9164575", "Korha\,\ Bihar",
"914266", "Kotagiri\,\ Tamil\ Nadu",
"911952", "Baramulla\,\ Jammu\ And\ Kashmir",
"9171583", "Deoli\,\ Maharashtra",
"918935", "Paderu\,\ Andhra\ Pradesh",
"914828", "Kanjirapally\,\ Kerala",
"9174685", "Khandar\,\ Rajasthan",
"9168537", "Sunabeda\,\ Odisha",
"918525", "Gudur\/Kodumur\,\ Andhra\ Pradesh",
"9167674", "Barbil\,\ Odisha",
"9165855", "Ghatsila\,\ Bihar",
"913512", "Malda\,\ West\ Bengal",
"9174389", "Keshoraipatan\/Patan\,\ Rajasthan",
"9168596", "Motu\,\ Odisha",
"9162433", "Begusarai\,\ Bihar",
"915162", "Orai\,\ Uttar\ Pradesh",
"912757", "Dasada\,\ Gujarat",
"917750", "Marwahi\,\ Madhya\ Pradesh",
"9174862", "Bareli\,\ Madhya\ Pradesh",
"9165972", "Saraikela\/Adstyapur\,\ Bihar",
"918613", "Nellore\,\ Andhra\ Pradesh",
"9176364", "Baihar\,\ Madhya\ Pradesh",
"9171025", "Parseoni\,\ Maharashtra",
"918406", "Cumbum\,\ Andhra\ Pradesh",
"9162764", "Madhubani\,\ Bihar",
"918561", "Rayachoti\,\ Andhra\ Pradesh",
"917764", "Kunkuri\,\ Madhya\ Pradesh",
"9176288", "Karpa\,\ Madhya\ Pradesh",
"9181722", "Hassan\,\ Karnataka",
"9165667", "Japla\,\ Bihar",
"9176428", "Mandla\,\ Madhya\ Pradesh",
"9166474", "Naktideul\,\ Odisha",
"9174516", "Atru\,\ Rajasthan",
"916575", "Jamshedpur\,\ Bihar",
"915274", "Tanda\/Baskhari\,\ Uttar\ Pradesh",
"9161575", "Mairwa\,\ Bihar",
"9171756", "Bhadrawati\,\ Maharashtra",
"915680", "Bharthana\,\ Uttar\ Pradesh",
"9164673", "Banmankhi\,\ Bihar",
"918753", "Outsarangapalle\,\ Andhra\ Pradesh",
"918398", "Harapanahalli\,\ Karnataka",
"918718", "Narasampet\,\ Andhra\ Pradesh",
"9166453", "Jharsuguda\,\ Odisha",
"913621", "Boko\,\ Assam",
"918215", "Mysore\,\ Karnataka",
"9176429", "Mandla\,\ Madhya\ Pradesh",
"914364", "Mayiladuthurai\,\ Tamil\ Nadu",
"9165847", "Bishrampur\,\ Bihar",
"9164293", "Kahalgaon\,\ Bihar",
"913222", "Kharagpur\,\ West\ Bengal",
"912744", "Deesa\,\ Gujarat",
"9175943", "Ganjbasoda\,\ Madhya\ Pradesh",
"913454", "Kalna\,\ West\ Bengal",
"911667", "Fatehabad\,\ Haryana",
"9167915", "Bangiriposi\,\ Odisha",
"912455", "Kalamnuri\,\ Maharashtra",
"9168152", "Parlakhemundi\,\ Odisha",
"9176289", "Karpa\,\ Madhya\ Pradesh",
"9167213", "Narsinghpur\,\ Odisha",
"911872", "Quadian\,\ Punjab",
"9174502", "Sangod\,\ Rajasthan",
"9181931", "Hiriyur\,\ Karnataka",
"917786", "Kondagaon\,\ Madhya\ Pradesh",
"9163226", "Wazirganj\,\ Bihar",
"917533", "Karhal\,\ Madhya\ Pradesh",
"911731", "Barara\,\ Haryana",
"918378", "Savanur\,\ Karnataka",
"9173952", "Sondhwa\,\ Madhya\ Pradesh",
"913665", "Tarabarihat\,\ Assam",
"914151", "Kallakurichi\,\ Tamil\ Nadu",
"915332", "Phoolpur\,\ Uttar\ Pradesh",
"9166544", "Sonapur\,\ Odisha",
"9167404", "Bhubaneshwar\,\ Odisha",
"912928", "Shergarh\/Deechu\,\ Rajasthan",
"9174346", "Pirawa\/Raipur\,\ Rajasthan",
"9174642", "Karauli\,\ Rajasthan",
"9164795", "Udakishanganj\,\ Bihar",
"9164214", "Naugachia\,\ Bihar",
"9167294", "Pattamundai\,\ Odisha",
"912191", "Poladpur\,\ Maharashtra",
"9166856", "Sohela\,\ Odisha",
"912664", "Pavijetpur\,\ Gujarat",
"9174264", "Sitamau\,\ Madhya\ Pradesh",
"9163277", "Rafiganj\,\ Bihar",
"9161824", "Arrah\,\ Bihar",
"9168187", "Buguda\,\ Odisha",
"911892", "Kangra\/Dharamsala\,\ Himachal\ Pradesh",
"9174388", "Keshoraipatan\/Patan\,\ Rajasthan",
"9167653", "Palla\ Hara\,\ Odisha",
"9163486", "Mallehpur\,\ Bihar",
"9171133", "Saoner\,\ Maharashtra",
"9184532", "Medak\,\ Andhra\ Pradesh",
"91734", "Ujjain\,\ Madhya\ Pradesh",
"915544", "Naugarh\/Tetribazar\,\ Uttar\ Pradesh",
"9165933", "Manoharpur\,\ Bihar",
"9172889", "Bhikangaon\,\ Madhya\ Pradesh",
"9163373", "Arwal\,\ Bihar",
"9162472", "Singhwara\,\ Bihar",
"9167823", "Balasore\,\ Odisha",
"912779", "Bayad\,\ Gujarat",
"918312", "Belgaum\,\ Karnataka",
"918583", "Sodam\,\ Andhra\ Pradesh",
"9173934", "Jobat\,\ Madhya\ Pradesh",
"91131", "Muzaffarnagar\,\ Uttar\ Pradesh",
"9163413", "Seikhpura\,\ Bihar",
"9165235", "Ghaghra\,\ Bihar",
"911584", "Nagaur\/Mundwa\ Marwar\,\ Rajasthan",
"912471", "Tuljapur\,\ Maharashtra",
"9166762", "M\.Rampur\,\ Odisha",
"918847", "Kakinada\,\ Andhra\ Pradesh",
"9165464", "Hazaribagh\,\ Bihar",
"9174701", "Bundi\,\ Rajasthan",
"912324", "Hatkangale\/Ichalkaranji\,\ Maharashtra",
"9164336", "Jamtara\,\ Bihar",
"913806", "Chowkhem\,\ Arunachal\ Pradesh",
"917822", "Sidhi\,\ Madhya\ Pradesh",
"9171435", "Bhainsdehi\,\ Madhya\ Pradesh",
"9163494", "Jhajha\,\ Bihar",
"914175", "Tiruvannamalai\,\ Tamil\ Nadu",
"9165592", "Simaria\,\ Bihar",
"9167286", "Jajapur\ Town\,\ Odisha",
"918772", "Tirupathi\,\ Andhra\ Pradesh",
"9161806", "Adhaura\,\ Bihar",
"9167317", "Anandapur\,\ Odisha",
"9175918", "Sironj\,\ Madhya\ Pradesh",
"9176534", "Bandhavgarh\,\ Madhya\ Pradesh",
"91177", "Shimla\,\ Himachal\ Pradesh",
"917580", "Bina\,\ Madhya\ Pradesh",
"912587", "Amalner\,\ Maharashtra",
"9171346", "Bhamregadh\,\ Maharashtra",
"9171642", "Pandhurna\,\ Madhya\ Pradesh",
"915738", "Khurja\,\ Uttar\ Pradesh",
"9176440", "Dindori\,\ Madhya\ Pradesh",
"9174878", "Begamganj\,\ Madhya\ Pradesh",
"918736", "Mancherial\,\ Andhra\ Pradesh",
"9161143", "Jahanabad\,\ Bihar",
"9167555", "Khurda\,\ Odisha",
"912843", "Gariadhar\,\ Gujarat",
"9174133", "Sailana\,\ Madhya\ Pradesh",
"9162585", "Areraj\,\ Bihar",
"9175905", "Lateri\,\ Madhya\ Pradesh",
"917848", "Keskal\,\ Madhya\ Pradesh",
"9167567", "Balugaon\,\ Odisha",
"9174597", "Ramganj\ Mandi\,\ Rajasthan",
"9167623", "Dhenkanal\,\ Odisha",
"911895", "Bharmour\,\ Himachal\ Pradesh",
"9161854", "Bikramganj\,\ Bihar",
"9174149", "Jaora\,\ Madhya\ Pradesh",
"9166826", "Attabira\,\ Odisha",
"911564", "Sardarshahar\,\ Rajasthan",
"9166785", "Nowparatan\,\ Odisha",
"918563", "Kamalapuram\/Yerraguntala\,\ Andhra\ Pradesh",
"9177066", "Gariaband\,\ Madhya\ Pradesh",
"91204", "Pune\,\ Maharashtra",
"9174536", "Baran\,\ Rajasthan",
"913877", "Tamenglong\,\ Manipur",
"9171047", "Hingua\,\ Maharashtra",
"9172866", "Khetia\,\ Madhya\ Pradesh",
"915335", "Soraon\,\ Uttar\ Pradesh",
"918751", "Boath\/Echoda\,\ Andhra\ Pradesh",
"91535", "Raibareli\,\ Uttar\ Pradesh",
"9176275", "Manpur\,\ Madhya\ Pradesh",
"913662", "Dhubri\,\ Assam",
"911638", "Fazilka\,\ Punjab",
"9161546", "Siwan\,\ Bihar",
"9173922", "Jhabua\,\ Madhya\ Pradesh",
"9163256", "Pakribarwan\,\ Bihar",
"911875", "Dinanagar\,\ Punjab",
"9162562", "Ramnagar\,\ Bihar",
"912452", "Parbhani\,\ Maharashtra",
"917560", "Ashta\,\ Madhya\ Pradesh",
"912567", "Taloda\,\ Maharashtra",
"9171842", "Bhandara\,\ Maharashtra",
"9174678", "Bamanwas\,\ Rajasthan",
"91724", "Akola\,\ Maharashtra",
"9164624", "Dhamdaha\,\ Bihar",
"9163472", "Chakai\,\ Bihar",
"913225", "Ghatal\,\ West\ Bengal",
"9165574", "Bagodar\,\ Bihar",
"9176459", "Karanjia\,\ Madhya\ Pradesh",
"918856", "Amalapuram\,\ Andhra\ Pradesh",
"918212", "Mysore\,\ Karnataka",
"914118", "Tiruttani\,\ Tamil\ Nadu",
"91121", "Meerut\,\ Uttar\ Pradesh",
"9176522", "Shahdol\,\ Madhya\ Pradesh",
"9163312", "Imamganj\,\ Bihar",
"9166423", "Kuchinda\,\ Odisha",
"918159", "Mulbagal\,\ Karnataka",
"9172875", "Gogaon\,\ Madhya\ Pradesh",
"9165647", "Nagarutari\,\ Bihar",
"91451", "Dindigul\,\ Tamil\ Nadu",
"9162277", "Mahua\,\ Bihar",
"9167525", "Puri\,\ Odisha",
"9176266", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9166216", "Hemgiri\,\ Odisha",
"9162226", "Sheohar\,\ Bihar",
"9176344", "Lamta\,\ Madhya\ Pradesh",
"918775", "Tirupathi\,\ Andhra\ Pradesh",
"918404", "Marturu\,\ Andhra\ Pradesh",
"917297", "Kukshi\,\ Madhya\ Pradesh",
"9171536", "Hinganghat\,\ Maharashtra",
"9162744", "Samastipur\,\ Bihar",
"914172", "Ranipet\,\ Tamil\ Nadu",
"912901", "Siwana\,\ Rajasthan",
"9164546", "Purnea\,\ Bihar",
"9177075", "Bagbahera\,\ Madhya\ Pradesh",
"915647", "Bari\,\ Rajasthan",
"917766", "Dharamjaigarh\,\ Madhya\ Pradesh",
"917825", "Berla\,\ Madhya\ Pradesh",
"9167272", "Kendrapara\,\ Odisha",
"9161832", "Buxar\,\ Bihar",
"911851", "Patti\,\ Punjab",
"9174842", "Silwani\,\ Madhya\ Pradesh",
"9165507", "Hunterganj\,\ Bihar",
"916637", "Sambalpur\,\ Odisha",
"918315", "Belgaum\,\ Karnataka",
"9175939", "Kurwai\,\ Madhya\ Pradesh",
"917861", "Netanar\,\ Madhya\ Pradesh",
"9174120", "Ratlam\,\ Madhya\ Pradesh",
"918514", "Nandyal\,\ Andhra\ Pradesh",
"912976", "Sheoganj\/Posaliyan\,\ Rajasthan",
"917391", "Petlawad\,\ Madhya\ Pradesh",
"9171796", "Nagbhir\,\ Maharashtra",
"9167887", "Soro\,\ Odisha",
"911382", "Lansdowne\/Kotdwara\,\ Uttarakhand",
"9174639", "Gangapur\,\ Rajasthan",
"9171805", "Salekasa\,\ Maharashtra",
"9174228", "Mandsaur\,\ Madhya\ Pradesh",
"911420", "Baswa\/Bandikui\,\ Rajasthan",
"9164274", "Kathikund\,\ Bihar",
"915342", "Pratapgarh\,\ Uttar\ Pradesh",
"918326", "Goa",
"917543", "Ashoknagar\,\ Madhya\ Pradesh",
"9174335", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"911741", "Pehowa\,\ Haryana",
"91361", "Guwahati\,\ Assam",
"912522", "Bhiwandi\,\ Maharashtra",
"9171737", "Rajura\,\ Maharashtra",
"916716", "Cuttack\,\ Odisha",
"912932", "Pali\,\ Rajasthan",
"9168425", "Phulbani\,\ Odisha",
"9181520", "Kolar\,\ Karnatak",
"9171996", "Deori\,\ Maharashtra",
"917816", "Pali\,\ Madhya\ Pradesh",
"912996", "Pokhran\/Loharki\,\ Rajasthan",
"917371", "Sarangpur\,\ Madhya\ Pradesh",
"917252", "Washim\,\ Maharashtra",
"912734", "Chanasma\,\ Gujarat",
"916123", "Patna\,\ Bihar",
"9176329", "Balaghat\,\ Madhya\ Pradesh",
"9168556", "Laxmipur\,\ Odisha",
"918540", "Nagarkurnool\,\ Andhra\ Pradesh",
"9171124", "Katol\,\ Maharashtra",
"9167975", "Jashipur\,\ Odisha",
"9181707", "Alur\,\ Karnataka",
"918193", "Hiriyur\,\ Karnataka",
"9165895", "Jhinkpani\,\ Bihar",
"911262", "Rohtak\,\ Haryana",
"9175297", "Laher\,\ Madhya\ Pradesh",
"9174843", "Silwani\,\ Madhya\ Pradesh",
"9161833", "Buxar\,\ Bihar",
"9167273", "Kendrapara\,\ Odisha",
"9173923", "Jhabua\,\ Madhya\ Pradesh",
"9174805", "Goharganj\,\ Madhya\ Pradesh",
"9164207", "Amarpur\,\ Bihar",
"9171446", "Atner\,\ Madhya\ Pradesh",
"913216", "Habra\,\ West\ Bengal",
"9164345", "Dumka\,\ Bihar",
"9167417", "Bhubaneshwar\,\ Odisha",
"9171335", "Aheri\,\ Maharashtra",
"911285", "Mohindergarh\,\ Haryana",
"9173225", "Depalpur\,\ Madhya\ Pradesh",
"914562", "Virudhunagar\,\ Tamil\ Nadu",
"917695", "Gopalganj\,\ Madhya\ Pradesh",
"918473", "Yadgiri\,\ Karnataka",
"911474", "Begun\,\ Rajasthan",
"9174818", "Gairatganj\,\ Madhya\ Pradesh",
"912833", "Khambhalia\,\ Gujarat",
"9167326", "Hindol\,\ Odisha",
"9167622", "Dhenkanal\,\ Odisha",
"9171784", "Sinderwahi\,\ Maharashtra",
"9176340", "Lamta\,\ Madhya\ Pradesh",
"9166257", "Lahunipara\,\ Odisha",
"918746", "Bhooragamphad\/Manuguru\,\ Andhra\ Pradesh",
"915722", "Hathras\,\ Uttar\ Pradesh",
"9176523", "Shahdol\,\ Madhya\ Pradesh",
"9167966", "Karanjia\,\ Odisha",
"9163313", "Imamganj\,\ Bihar",
"915924", "Hasanpur\,\ Uttar\ Pradesh",
"9166422", "Kuchinda\,\ Odisha",
"918666", "Vijayawada\,\ Andhra\ Pradesh",
"9168467", "Baliguda\,\ Odisha",
"9163473", "Chakai\,\ Bihar",
"9165246", "Gumla\,\ Bihar",
"917124", "Nagpur\,\ Maharashtra",
"917675", "Amarpatan\,\ Madhya\ Pradesh",
"91733", "Khandwa\,\ Madhya\ Pradesh",
"911494", "Behror\,\ Rajasthan",
"9171843", "Bhandara\,\ Maharashtra",
"912477", "Paranda\,\ Maharashtra",
"9174937", "Karera\,\ Madhya\ Pradesh",
"918493", "Madakasira\,\ Andhra\ Pradesh",
"9165364", "Palkot\,\ Bihar",
"918837", "Rajahmundri\,\ Andhra\ Pradesh",
"9174124", "Ratlam\,\ Madhya\ Pradesh",
"9171984", "Tirora\,\ Maharashtra",
"9162563", "Ramnagar\,\ Bihar",
"9174605", "Sahabad\,\ Rajasthan",
"9168577", "Gunupur\,\ Odisha",
"9167634", "Athmallik\,\ Odisha",
"912561", "Pimpalner\,\ Maharashtra",
"9166763", "M\.Rampur\,\ Odisha",
"9174309", "Khanpur\,\ Rajasthan",
"9171154", "Mouda\,\ Maharashtra",
"91497", "Kannur\,\ Kerala",
"9168526", "Koraput\,\ Odisha",
"9163412", "Seikhpura\,\ Bihar",
"913776", "Bokakhat\,\ Assam",
"9176359", "Lanji\,\ Madhya\ Pradesh",
"9174618", "Mahuwa\,\ Rajasthan",
"917758", "Dabhara\,\ Madhya\ Pradesh",
"9163372", "Arwal\,\ Bihar",
"9167822", "Balasore\,\ Odisha",
"9162473", "Singhwara\,\ Bihar",
"917255", "Barshi\ Takli\,\ Maharashtra",
"912753", "Limbdi\,\ Gujarat",
"9165514", "Barkagaon\,\ Bihar",
"9168455", "Phiringia\,\ Odisha",
"9165932", "Manoharpur\,\ Bihar",
"918617", "Nellore\,\ Andhra\ Pradesh",
"9171095", "Kamptee\,\ Maharashtra",
"9166265", "Banaigarh\,\ Odisha",
"912935", "Marwar\ Junction\,\ Rajasthan",
"9174132", "Sailana\,\ Madhya\ Pradesh",
"912525", "Palghar\,\ Maharashtra",
"9161142", "Jahanabad\,\ Bihar",
"9176498", "Kakaiya\,\ Madhya\ Pradesh",
"9166434", "Barkot\,\ Odisha",
"9171643", "Pandhurna\,\ Madhya\ Pradesh",
"9165593", "Simaria\,\ Bihar",
"913871", "Mao\/Korang\,\ Manipur",
"9174545", "Chhipaborad\,\ Rajasthan",
"9174258", "Garoth\,\ Madhya\ Pradesh",
"9161535", "Maharajganj\,\ Bihar",
"915688", "Etawah\,\ Uttar\ Pradesh",
"9174260", "Sitamau\,\ Madhya\ Pradesh",
"913524", "Harirampur\,\ West\ Bengal",
"91203", "Pune\,\ Maharashtra",
"9166817", "Jujumura\,\ Odisha",
"9174503", "Sangod\,\ Rajasthan",
"9167687", "Parajang\,\ Odisha",
"9173930", "Jobat\,\ Madhya\ Pradesh",
"9171605", "Jamai\,\ Madhya\ Pradesh",
"9167212", "Narsinghpur\,\ Odisha",
"9168153", "Parlakhemundi\,\ Odisha",
"9168504", "Kalimela\,\ Odisha",
"917271", "Bagli\,\ Madhya\ Pradesh",
"911904", "Nirmand\,\ Himachal\ Pradesh",
"917672", "Satna\,\ Madhya\ Pradesh",
"9175942", "Ganjbasoda\,\ Madhya\ Pradesh",
"9164292", "Kahalgaon\,\ Bihar",
"917867", "Bokaband\,\ Madhya\ Pradesh",
"9166452", "Jharsuguda\,\ Odisha",
"914931", "Nilambur\,\ Kerala",
"9171132", "Saoner\,\ Maharashtra",
"914146", "Villupuram\,\ Tamil\ Nadu",
"9184533", "Medak\,\ Andhra\ Pradesh",
"9166227", "Sundargarh\,\ Odisha",
"9176530", "Bandhavgarh\,\ Madhya\ Pradesh",
"9167652", "Palla\ Hara\,\ Odisha",
"9167356", "Telkoi\,\ Odisha",
"911702", "Nahan\,\ Himachal\ Pradesh",
"9177008", "Nagri\,\ Madhya\ Pradesh",
"912907", "Kherwara\,\ Rajasthan",
"917692", "Seoni\,\ Madhya\ Pradesh",
"914565", "Karaikudi\,\ Tamil\ Nadu",
"917291", "Manawar\,\ Madhya\ Pradesh",
"9174643", "Karauli\,\ Rajasthan",
"911282", "Narnaul\,\ Haryana",
"911681", "Jind\,\ Haryana",
"9165695", "Garu\,\ Bihar",
"9176444", "Dindori\,\ Madhya\ Pradesh",
"918226", "Chamrajnagar\,\ Karnataka",
"914894", "Agathy\,\ Lakshadweep",
"9177015", "Pingeshwar\,\ Madhya\ Pradesh",
"9168644", "Mathili\,\ Odisha",
"915641", "Deeg\,\ Rajasthan",
"918868", "Yeleswaram\,\ Andhra\ Pradesh",
"9164535", "Araria\,\ Bihar",
"9173953", "Sondhwa\,\ Madhya\ Pradesh",
"9166487", "Patnagarh\,\ Odisha",
"9165973", "Saraikela\/Adstyapur\,\ Bihar",
"9174863", "Bareli\,\ Madhya\ Pradesh",
"9162432", "Begusarai\,\ Bihar",
"912772", "Himatnagar\,\ Gujarat",
"918319", "Belgaum\,\ Karnataka",
"918587", "Venkatgirikota\,\ Andhra\ Pradesh",
"9165275", "Kolebira\,\ Bihar",
"9174917", "Narwar\,\ Madhya\ Pradesh",
"918491", "Kanaganapalle\,\ Andhra\ Pradesh",
"912994", "Pokhran\,\ Rajasthan",
"918843", "Kakinada\,\ Andhra\ Pradesh",
"9177009", "Nagri\,\ Madhya\ Pradesh",
"9171582", "Deoli\,\ Maharashtra",
"9164376", "Mahagama\,\ Bihar",
"9164672", "Banmankhi\,\ Bihar",
"9163424", "H\.Kharagpur\,\ Bihar",
"9171475", "Multai\,\ Madhya\ Pradesh",
"918779", "Tirupathi\,\ Andhra\ Pradesh",
"912792", "Amreli\,\ Gujarat",
"916714", "Cuttack\,\ Odisha",
"9176574", "Jaitpur\,\ Madhya\ Pradesh",
"9167814", "Basta\,\ Odisha",
"912583", "Edalabad\,\ Maharashtra",
"9164767", "Madhepura\,\ Bihar",
"9161886", "Rohtas\,\ Bihar",
"9171315", "Sironcha\,\ Maharashtra",
"9181723", "Hassan\,\ Karnataka",
"912831", "Nalia\,\ Gujarat",
"918516", "Dronachalam\,\ Andhra\ Pradesh",
"9167496", "Bhubaneshwar\,\ Odisha",
"9168174", "R\.Udayigiri\,\ Odisha",
"912974", "Abu\ Road\,\ Rajasthan",
"918471", "Mashal\,\ Karnataka",
"9164327", "Deoghar\,\ Bihar",
"911997", "Bedarwah\,\ Jammu\ And\ Kashmir",
"9163284", "Daudnagar\,\ Bihar",
"9162505", "Dhaka\,\ Bihar",
"917840", "Koyelibeda\,\ Madhya\ Pradesh",
"912847", "Gadhada\,\ Gujarat",
"918155", "Gowribidanur\,\ Karnataka",
"9171557", "Seloo\,\ Maharashtra",
"9173247", "Mhow\,\ Madhya\ Pradesh",
"918324", "Goa",
"9165344", "Jhumaritalaiya\,\ Bihar",
"912378", "Medha\,\ Maharashtra",
"9174259", "Garoth\,\ Madhya\ Pradesh",
"911496", "Sarwar\,\ Rajasthan",
"9175216", "Seondha\,\ Madhya\ Pradesh",
"9127177", "Sanand\,\ Gujarat",
"918710", "Cherial\,\ Andhra\ Pradesh",
"9171863", "Sakoli\,\ Maharashtra",
"9175387", "Ambah\,\ Madhya\ Pradesh",
"9176499", "Kakaiya\,\ Madhya\ Pradesh",
"918538", "Manvi\,\ Karnataka",
"9164223", "Godda\,\ Bihar",
"913229", "Dantan\,\ West\ Bengal",
"91485", "Muvattupuzha\,\ Kerala",
"9162543", "Bettiah\,\ Bihar",
"91194", "Srinagar\,\ Jammu\ And\ Kashmir",
"918664", "Vijayawada\,\ Andhra\ Pradesh",
"911663", "Hansi\,\ Haryana",
"9168447", "Kantamal\,\ Odisha",
"918191", "Holalkere\,\ Karnataka",
"9167946", "Rairangpur\,\ Odisha",
"918942", "Srikakulam\,\ Andhra\ Pradesh",
"917126", "Nagpur\,\ Maharashtra",
"9174582", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9161813", "Piro\,\ Bihar",
"9165266", "Lohardaga\,\ Bihar",
"917537", "Jora\,\ Madhya\ Pradesh",
"9174619", "Mahuwa\,\ Rajasthan",
"9176358", "Lanji\,\ Madhya\ Pradesh",
"912718", "Bareja\,\ Gujarat",
"9176507", "Beohari\,\ Madhya\ Pradesh",
"918370", "Kalghatagi\,\ Karnataka",
"911476", "Kapasan\,\ Rajasthan",
"9176360", "Baihar\,\ Madhya\ Pradesh",
"9174315", "Aklera\,\ Rajasthan",
"9162454", "Gogri\,\ Bihar",
"911743", "Cheeka\,\ Haryana",
"918744", "Kothagudem\,\ Andhra\ Pradesh",
"917541", "Isagarh\,\ Madhya\ Pradesh",
"912920", "Bilara\/Bhopalgarh\,\ Rajasthan",
"9167484", "Bhubaneshwar\,\ Odisha",
"9171717", "Gond\ Pipri\,\ Maharashtra",
"9161327", "Barh\,\ Bihar",
"913214", "Jagatballavpur\,\ West\ Bengal",
"9167224", "Pardip\,\ Odisha",
"9164365", "Sahibganj\,\ Bihar",
"9163237", "Dumraon\,\ Bihar",
"9171466", "Ghorandogri\,\ Madhya\ Pradesh",
"9161894", "Bhabhua\,\ Bihar",
"911899", "Chamba\,\ Himachal\ Pradesh",
"9174557", "Digod\/Sultanpur\,\ Rajasthan",
"918455", "Sangareddy\,\ Andhra\ Pradesh",
"9174308", "Khanpur\,\ Rajasthan",
"9168107", "Khalikote\,\ Odisha",
"911432", "Tonk\,\ Rajasthan",
"918152", "Kolar\,\ Karnataka",
"913794", "Tawang\,\ Arunachal\ Pradesh",
"9176510", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9174565", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9171527", "Wardha\,\ Maharashtra",
"914258", "Dharampuram\,\ Tamil\ Nadu",
"9162237", "Motipur\,\ Bihar",
"9171663", "Chaurai\,\ Madhya\ Pradesh",
"9174240", "Malhargarh\,\ Madhya\ Pradesh",
"913526", "Islampur\,\ West\ Bengal",
"9164357", "Pakur\,\ Bihar",
"9181753", "Holenarasipur\,\ Karnataka",
"911683", "Julana\,\ Haryana",
"9166245", "Rajgangpur\,\ Odisha",
"918684", "Suryapet\,\ Andhra\ Pradesh",
"9162296", "Bidupur\,\ Bihar",
"912795", "Kodinar\,\ Gujarat",
"9171576", "Arvi\,\ Maharashtra",
"914179", "Tirupattur\,\ Tamil\ Nadu",
"9181930", "Hiriyur\,\ Karnataka",
"9187593", "Outsarangapalle\,\ Andhra\ Pradesh",
"9163454", "Jamui\,\ Bihar",
"9164515", "Barsoi\,\ Bihar",
"9177035", "Manpur\,\ Madhya\ Pradesh",
"915643", "Nadbai\,\ Rajasthan",
"9167232", "Athgarh\,\ Odisha",
"913774", "Golaghat\,\ Assam",
"9174819", "Gairatganj\,\ Madhya\ Pradesh",
"9161872", "Mohania\,\ Bihar",
"9164382", "Madhupur\,\ Bihar",
"9181730", "Sakleshpur\,\ Karnataka",
"916633", "Sambalpur\,\ Odisha",
"9165587", "Dumri\(Isribazar\)\,\ Bihar",
"917273", "Kannod\,\ Madhya\ Pradesh",
"912775", "Khedbrahma\,\ Gujarat",
"914933", "Perinthalmanna\,\ Kerala",
"9174663", "Bonli\,\ Rajasthan",
"911435", "Tonk\/Piploo\,\ Rajasthan",
"91145", "Ajmer\,\ Rajasthan",
"9167693", "Kamakhyanagar\,\ Odisha",
"9174527", "Chhabra\,\ Rajasthan",
"918452", "Medak\,\ Andhra\ Pradesh",
"9171565", "Talegaokarangal\,\ Maharashtra",
"9166705", "Bhawanipatna\,\ Odisha",
"9162284", "Pupri\,\ Bihar",
"918224", "Kollegal\,\ Karnataka",
"9176464", "Nainpur\,\ Madhya\ Pradesh",
"914896", "Kavaratti\,\ Lakshadweep",
"9161357", "Bikram\,\ Bihar",
"918567", "Lakkireddipalli\,\ Andhra\ Pradesh",
"9168664", "Umerkote\,\ Odisha",
"9167254", "Dhanmandal\,\ Odisha",
"9174576", "Mangrol\,\ Rajasthan",
"9174700", "Bundi\,\ Rajasthan",
"913873", "Thinghat\,\ Manipur",
"9166414", "Deodgarh\,\ Odisha",
"915864", "Sidhauli\/Mahmodabad\,\ Uttar\ Pradesh",
"914144", "Chidambaram\,\ Tamil\ Nadu",
"9162424", "Benipur\,\ Bihar",
"9164755", "S\.Bakhtiarpur\,\ Bihar",
"9164613", "Raniganj\,\ Bihar",
"9166837", "Padmapur\,\ Odisha",
"913669", "Abhayapuri\,\ Assam",
"9161515", "Sidhawalia\,\ Bihar",
"9176328", "Balaghat\,\ Madhya\ Pradesh",
"915850", "Hardoi\/Baghavli\,\ Uttar\ Pradesh",
"9175962", "Gyraspur\,\ Madhya\ Pradesh",
"9168192", "Surada\,\ Odisha",
"911906", "Spiti\/Kaza\,\ Himachal\ Pradesh",
"918945", "Tekkali\/Palasa\,\ Andhra\ Pradesh",
"912563", "Shirpur\,\ Maharashtra",
"9167614", "Chhendipada\,\ Odisha",
"9174638", "Gangapur\,\ Rajasthan",
"9174900", "Pohari\,\ Madhya\ Pradesh",
"9165534", "Ramgarh\,\ Bihar",
"9165912", "Chandil\,\ Bihar",
"9164253", "Katoria\,\ Bihar",
"918219", "Mysore\,\ Karnataka",
"912751", "Chotila\,\ Gujarat",
"9166493", "Jamankira\,\ Odisha",
"9174229", "Mandsaur\,\ Madhya\ Pradesh",
"9174256", "Garoth\,\ Madhya\ Pradesh",
"9175219", "Seondha\,\ Madhya\ Pradesh",
"914347", "Denkanikota\,\ Tamil\ Nadu",
"9168696", "Papadhandi\,\ Odisha",
"9176496", "Kakaiya\,\ Madhya\ Pradesh",
"912767", "Sidhpur\,\ Gujarat",
"9166736", "Jayapatna\,\ Odisha",
"914331", "Jayamkondan\,\ Tamil\ Nadu",
"9174585", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9168637", "Bisam\ Cuttack\,\ Odisha",
"918643", "Bapatla\,\ Andhra\ Pradesh",
"9176437", "Bijadandi\,\ Madhya\ Pradesh",
"9171683", "Harrai\,\ Madhya\ Pradesh",
"914256", "Bhavani\,\ Tamil\ Nadu",
"911962", "Rajouri\,\ Jammu\ And\ Kashmir",
"9166797", "Komana\,\ Odisha",
"915270", "Bikapur\,\ Uttar\ Pradesh",
"9176814", "Jatara\,\ Madhya\ Pradesh",
"9167574", "Daspalla\,\ Odisha",
"9174616", "Mahuwa\,\ Rajasthan",
"9174312", "Aklera\,\ Rajasthan",
"9165623", "Daltonganj\,\ Bihar",
"91342", "Burdwan\,\ West\ Bengal",
"9165567", "Tisri\,\ Bihar",
"913253", "Manbazar\,\ West\ Bengal",
"9164573", "Korha\,\ Bihar",
"911764", "Samana\,\ Punjab",
"917445", "Ladpura\/Kota\,\ Rajasthan",
"9161157", "Danapur\,\ Bihar",
"9164362", "Sahibganj\,\ Bihar",
"9164666", "Kishanganj\,\ Bihar",
"912631", "Ahwa\,\ Gujarat",
"918551", "Garladinne\,\ Andhra\ Pradesh",
"917754", "Pandaria\,\ Madhya\ Pradesh",
"914635", "Nanguneri\,\ Tamil\ Nadu",
"915567", "Captanganj\,\ Uttar\ Pradesh",
"917369", "Tarana\,\ Madhya\ Pradesh",
"9165272", "Kolebira\,\ Bihar",
"915452", "Jaunpur\,\ Uttar\ Pradesh",
"917853", "Bijapur\,\ Madhya\ Pradesh",
"9162435", "Begusarai\,\ Bihar",
"911679", "Barnala\,\ Punjab",
"9175957", "Nateran\,\ Madhya\ Pradesh",
"9174683", "Khandar\,\ Rajasthan",
"916613", "Rourkela\,\ Odisha",
"9171585", "Deoli\,\ Maharashtra",
"914183", "Vandavasi\,\ Tamil\ Nadu",
"9166447", "Rairakhol\,\ Odisha",
"9162264", "Sitamarhi\,\ Bihar",
"9177006", "Nagri\,\ Madhya\ Pradesh",
"918864", "Rampachodavaram\,\ Andhra\ Pradesh",
"9168684", "Nandapur\,\ Odisha",
"914898", "Kiltan\,\ Lakshadweep",
"9176484", "Mawai\,\ Madhya\ Pradesh",
"9165853", "Ghatsila\,\ Bihar",
"91471", "Thiruvananthapuram\,\ Kerala",
"9167647", "Anugul\,\ Odisha",
"915945", "Haldwani\/Chorgalian\,\ Uttar\ Pradesh",
"9171312", "Sironcha\,\ Maharashtra",
"9171616", "Parasia\,\ Madhya\ Pradesh",
"911985", "Kargil\,\ Jammu\ And\ Kashmir",
"9164675", "Banmankhi\,\ Bihar",
"9165456", "Mandu\,\ Bihar",
"9171472", "Multai\,\ Madhya\ Pradesh",
"9161573", "Mairwa\,\ Bihar",
"9162502", "Dhaka\,\ Bihar",
"9171023", "Parseoni\,\ Maharashtra",
"917289", "Zhirnia\,\ Madhya\ Pradesh",
"911908", "Jogindernagar\,\ Himachal\ Pradesh",
"9182897", "Athani\,\ Karnataka",
"917517", "Gwalior\,\ Madhya\ Pradesh",
"9166702", "Bhawanipatna\,\ Odisha",
"912738", "Santalpur\,\ Gujarat",
"91225", "Mumbai",
"911531", "Nokha\,\ Rajasthan",
"917733", "Pawai\,\ Madhya\ Pradesh",
"911921", "Basholi\,\ Jammu\ And\ Kashmir",
"912423", "Koparagon\,\ Maharashtra",
"9171562", "Talegaokarangal\,\ Maharashtra",
"9165404", "Govindpur\,\ Bihar",
"9175111", "Gwalior\,\ Madhya\ Pradesh",
"9161127", "Biharsharif\,\ Bihar",
"917442", "Ladpura\/Kota\,\ Rajasthan",
"9174579", "Mangrol\,\ Rajasthan",
"9161512", "Sidhawalia\,\ Bihar",
"913011", "Jaisalmer\/Pasewar\,\ Rajasthan",
"9171413", "Betul\,\ Madhya\ Pradesh",
"915843", "Jalalabad\,\ Uttar\ Pradesh",
"9165294", "Itki\,\ Bihar",
"9174944", "Kolaras\,\ Madhya\ Pradesh",
"9173293", "Khakner\,\ Madhya\ Pradesh",
"915491", "Rasara\,\ Uttar\ Pradesh",
"911883", "Dasua\,\ Punjab",
"9165653", "Latehar\,\ Bihar",
"9171373", "Desaiganj\,\ Maharashtra",
"9164752", "S\.Bakhtiarpur\,\ Bihar",
"9167847", "Bhadrak\,\ Odisha",
"911259", "Kosli\,\ Haryana",
"9171816", "Lakhandur\,\ Maharashtra",
"918730", "Khanapur\,\ Andhra\ Pradesh",
"9175263", "Ghatigaon\,\ Madhya\ Pradesh",
"918518", "Kurnool\,\ Andhra\ Pradesh",
"9175965", "Gyraspur\,\ Madhya\ Pradesh",
"911965", "Poonch\,\ Jammu\ And\ Kashmir",
"9174277", "Bhanpura\,\ Madhya\ Pradesh",
"9163264", "Sherghati\,\ Bihar",
"9168195", "Surada\,\ Odisha",
"9165915", "Chandil\,\ Bihar",
"9173214", "Sanwer\,\ Madhya\ Pradesh",
"91427", "Salem\,\ Tamil\ Nadu",
"913800", "Jairampur\,\ Arunachal\ Pradesh",
"917269", "Sindkhedaraja\,\ Maharashtra",
"917586", "Deori\,\ Madhya\ Pradesh",
"9177054", "Kurud\,\ Madhya\ Pradesh",
"9161866", "Aurangabad\,\ Bihar",
"9164787", "Saharsa\,\ Bihar",
"9171494", "Tamia\,\ Madhya\ Pradesh",
"91793", "Ahmedabad\ Local\,\ Gujarat",
"9174226", "Mandsaur\,\ Madhya\ Pradesh",
"9165477", "Chavparan\,\ Bihar",
"9174562", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9171053", "Narkhed\,\ Maharashtra",
"9165317", "Mandar\,\ Bihar",
"918572", "Chittoor\,\ Andhra\ Pradesh",
"912599", "Bhudargad\/Gargoti\,\ Maharashtra",
"9165286", "Khunti\,\ Bihar",
"913869", "Mon\,\ Nagaland",
"9165426", "Bokaro\,\ Bihar",
"9164512", "Barsoi\,\ Bihar",
"918536", "Kustagi\,\ Karnataka",
"9177032", "Manpur\,\ Madhya\ Pradesh",
"911982", "Leh\,\ Jammu\ And\ Kashmir",
"911498", "Anupgarh\,\ Rajasthan",
"9166242", "Rajgangpur\,\ Odisha",
"915942", "Nainital\,\ Uttar\ Pradesh",
"913673", "Haflong\,\ Assam",
"9174373", "Nainwa\,\ Rajasthan",
"915191", "Naraini\/Attarra\,\ Uttar\ Pradesh",
"9168414", "Boudh\,\ Odisha",
"915664", "Mant\/Vrindavan\,\ Uttar\ Pradesh",
"9165823", "Chaibasa\,\ Bihar",
"9174204", "Jawad\,\ Madhya\ Pradesh",
"9164385", "Madhupur\,\ Bihar",
"9174816", "Gairatganj\,\ Madhya\ Pradesh",
"9171486", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"915744", "Kasganj\,\ Uttar\ Pradesh",
"9167933", "Betanati\,\ Odisha",
"918339", "Ainapur\,\ Karnataka",
"9162597", "Pakridayal\,\ Bihar",
"9167235", "Athgarh\,\ Odisha",
"918783", "Karimnagar\,\ Andhra\ Pradesh",
"9161875", "Mohania\,\ Bihar",
"918592", "Ongole\,\ Andhra\ Pradesh",
"9175927", "Vidisha\,\ Madhya\ Pradesh",
"9164734", "Supaul\,\ Bihar",
"912716", "Dehgam\,\ Gujarat",
"918203", "Udupi\,\ Karnataka",
"911478", "Pratapgarh\,\ Rajasthan",
"9168493", "Daringbadi\,\ Odisha",
"917834", "Sitapur\,\ Madhya\ Pradesh",
"9189466", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9176380", "Damoh\,\ Madhya\ Pradesh",
"9176254", "Umariapan\,\ Madhya\ Pradesh",
"9171744", "Mul\,\ Maharashtra",
"9162536", "Narkatiaganj\,\ Bihar",
"915171", "Garauth\,\ Uttar\ Pradesh",
"914632", "Kovilpatti\,\ Tamil\ Nadu",
"9171332", "Aheri\,\ Maharashtra",
"9182204", "Gundlupet\,\ Karnataka",
"9173222", "Depalpur\,\ Madhya\ Pradesh",
"913778", "Pakkekesang\,\ Arunachal\ Pradesh",
"9174802", "Goharganj\,\ Madhya\ Pradesh",
"911509", "Suratgarh\,\ Rajasthan",
"917756", "Lormi\,\ Madhya\ Pradesh",
"9164342", "Dumka\,\ Bihar",
"912485", "Bhokardan\,\ Maharashtra",
"9176273", "Manpur\,\ Madhya\ Pradesh",
"9167625", "Dhenkanal\,\ Odisha",
"9165547", "Rajdhanwar\,\ Bihar",
"917687", "Laundi\,\ Madhya\ Pradesh",
"9171697", "Batkakhapa\,\ Madhya\ Pradesh",
"9166783", "Nowparatan\,\ Odisha",
"913484", "Kandi\,\ West\ Bengal",
"91381", "Agartala\,\ Tripura",
"9161524", "Chapra\,\ Bihar",
"91562", "Agra\,\ Uttar\ Pradesh",
"914254", "Mettupalayam\,\ Tamil\ Nadu",
"913798", "Mariyang\,\ Arunachal\ Pradesh",
"9166556", "Titlagarh\,\ Odisha",
"9165607", "Patan\,\ Bihar",
"9174354", "Gangdhar\,\ Rajasthan",
"9166425", "Kuchinda\,\ Odisha",
"917851", "Bhopalpatnam\,\ Madhya\ Pradesh",
"91250", "Bassein\,\ Maharashtra",
"916212", "Muzaffarpur\,\ Bihar",
"914181", "Polur\,\ Tamil\ Nadu",
"9166844", "Paikamal\,\ Odisha",
"912162", "Satara\,\ Maharashtra",
"9176304", "Katangi\,\ Madhya\ Pradesh",
"9174332", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9174636", "Gangapur\,\ Rajasthan",
"9177073", "Bagbahera\,\ Madhya\ Pradesh",
"912185", "Malsuras\,\ Maharashtra",
"914577", "Tirupathur\,\ Tamil\ Nadu",
"913652", "Jowai\,\ Meghalaya",
"917227", "Chandurbazar\,\ Maharashtra",
"913251", "Adra\,\ West\ Bengal",
"9171802", "Salekasa\,\ Maharashtra",
"917564", "Budhni\,\ Madhya\ Pradesh",
"918761", "Sathupalli\,\ Andhra\ Pradesh",
"9172873", "Gogaon\,\ Madhya\ Pradesh",
"9167523", "Puri\,\ Odisha",
"9174697", "Hindaun\,\ Rajasthan",
"9167667", "Keonjhar\,\ Odisha",
"912633", "Dharampur\,\ Gujarat",
"9164524", "Katihar\,\ Bihar",
"9174578", "Mangrol\,\ Rajasthan",
"918301", "Mundagod\,\ Karnataka",
"914333", "Ponnamaravathi\,\ Tamil\ Nadu",
"9162726", "Darbhanga\,\ Bihar",
"9168422", "Phulbani\,\ Odisha",
"918228", "H\.D\.Kote\,\ Karnataka",
"9166716", "Rajkhariar\,\ Odisha",
"9176326", "Balaghat\,\ Madhya\ Pradesh",
"913712", "Tezpur\,\ Assam",
"9166467", "Bargarh\,\ Odisha",
"9162244", "Hajipur\,\ Bihar",
"9165674", "Barwadih\,\ Bihar",
"9171354", "Chamorshi\,\ Maharashtra",
"918725", "Metpalli\,\ Andhra\ Pradesh",
"911560", "Sujangarh\/Bidasar\,\ Rajasthan",
"91124", "Gurgaon\,\ Haryana",
"9171007", "Kuhi\,\ Maharashtra",
"912462", "Nanded\,\ Maharashtra",
"918641", "Sattenapalli\,\ Andhra\ Pradesh",
"9176417", "Niwas\,\ Madhya\ Pradesh",
"918242", "Mangalore\,\ Karnataka",
"9168617", "Malkangiri\,\ Odisha",
"9167972", "Jashipur\,\ Odisha",
"912557", "Dindori\,\ Maharashtra",
"916315", "Gaya\,\ Bihar",
"9165892", "Jhinkpani\,\ Bihar",
"9162777", "Phulparas\,\ Bihar",
"9176377", "Birsa\,\ Madhya\ Pradesh",
"9161506", "Hathua\,\ Bihar",
"91721", "Amravati\,\ Maharashtra",
"918637", "Guntur\,\ Andhra\ Pradesh",
"9163366", "Rajauli\,\ Bihar",
"9167913", "Bangiriposi\,\ Odisha",
"912165", "Dhiwadi\,\ Maharashtra",
"9161846", "Sasaram\,\ Bihar",
"9176290", "Pushprajgarh\,\ Madhya\ Pradesh",
"9171602", "Jamai\,\ Madhya\ Pradesh",
"917584", "Rahatgarh\,\ Madhya\ Pradesh",
"9166577", "Kantabhanji\,\ Odisha",
"91731", "Indore\,\ Madhya\ Pradesh",
"916215", "Muzaffarpur\,\ Bihar",
"9167215", "Narsinghpur\,\ Odisha",
"912978", "Ahore\,\ Rajasthan",
"9164295", "Kahalgaon\,\ Bihar",
"9176400", "Shahpur\,\ Madhya\ Pradesh",
"9166455", "Jharsuguda\,\ Odisha",
"9167867", "Chandbali\,\ Odisha",
"9174324", "Jhalawar\,\ Rajasthan",
"9164714", "Birpur\,\ Bihar",
"918328", "Goa",
"9166526", "Balangir\,\ Odisha",
"9162516", "Bagaha\,\ Bihar",
"9161554", "Ekma\,\ Bihar",
"9175945", "Ganjbasoda\,\ Madhya\ Pradesh",
"9163244", "Nawada\,\ Bihar",
"911822", "Kapurthala\,\ Punjab",
"9171135", "Saoner\,\ Maharashtra",
"9165337", "Basia\,\ Bihar",
"9174964", "Pichhore\,\ Madhya\ Pradesh",
"9165874", "Chakardharpur\,\ Bihar",
"911580", "Deedwana\,\ Rajasthan",
"9167655", "Palla\ Hara\,\ Odisha",
"912998", "Jaisalmer\/Khuiyals\,\ Rajasthan",
"917818", "Chandipara\,\ Madhya\ Pradesh",
"9177012", "Pingeshwar\,\ Madhya\ Pradesh",
"912482", "Jalna\,\ Maharashtra",
"9164532", "Araria\,\ Bihar",
"9168434", "Puruna\ Katak\,\ Odisha",
"9164793", "Udakishanganj\,\ Bihar",
"9165692", "Garu\,\ Bihar",
"9165396", "Bolwa\,\ Bihar",
"917327", "Harsud\,\ Madhya\ Pradesh",
"912320", "Chandgad\,\ Maharashtra",
"913671", "Diphu\,\ Assam",
"917836", "Baikunthpur\,\ Madhya\ Pradesh",
"916312", "Gaya\,\ Bihar",
"9171836", "Tumsar\,\ Maharashtra",
"912714", "Dholka\,\ Gujarat",
"911377", "Bhatwari\/Gangotri\,\ Uttarakhand",
"9171764", "Warora\,\ Maharashtra",
"918245", "Mangalore\,\ Karnataka",
"9174602", "Sahabad\,\ Rajasthan",
"9174306", "Khanpur\,\ Rajasthan",
"918748", "V\.R\.Puram\,\ Andhra\ Pradesh",
"912465", "Billoli\,\ Maharashtra",
"9163375", "Arwal\,\ Bihar",
"9171324", "Gadchiroli\,\ Maharashtra",
"913715", "Gohpur\,\ Assam",
"9167825", "Balasore\,\ Odisha",
"9173234", "Punasa\,\ Madhya\ Pradesh",
"9176356", "Lanji\,\ Madhya\ Pradesh",
"91172", "Chandigarh\,\ Punjab",
"9165935", "Manoharpur\,\ Bihar",
"9171897", "Amagaon\,\ Maharashtra",
"9168452", "Phiringia\,\ Odisha",
"918189", "Channagiri\,\ Karnataka",
"913218", "Canning\,\ West\ Bengal",
"9162756", "Rosera\,\ Bihar",
"9163415", "Seikhpura\,\ Bihar",
"9165233", "Ghaghra\,\ Bihar",
"918919", "Visakhapatnam\,\ Andhra\ Pradesh",
"9164554", "Forbesganj\,\ Bihar",
"911786", "Kalpa\,\ Himachal\ Pradesh",
"918534", "Yelburga\,\ Karnataka",
"917731", "Gunnore\,\ Madhya\ Pradesh",
"9161145", "Jahanabad\,\ Bihar",
"911533", "Kolayat\/Goddo\,\ Rajasthan",
"9165384", "Torpa\,\ Bihar",
"9162583", "Areraj\,\ Bihar",
"9168227", "Aska\,\ Odisha",
"9171092", "Kamptee\,\ Maharashtra",
"912740", "Vav\,\ Gujarat",
"917747", "Mohla\,\ Madhya\ Pradesh",
"9171964", "Arjuni\ Morgaon\,\ Maharashtra",
"9175903", "Lateri\,\ Madhya\ Pradesh",
"918924", "Anakapalle\,\ Andhra\ Pradesh",
"9166262", "Banaigarh\,\ Odisha",
"9167553", "Khurda\,\ Odisha",
"9174135", "Sailana\,\ Madhya\ Pradesh",
"911923", "Samba\,\ Jammu\ And\ Kashmir",
"912421", "Jamkhed\,\ Maharashtra",
"9171433", "Bhainsdehi\,\ Madhya\ Pradesh",
"913013", "Jaisalmer\/Dhanaua\,\ Rajasthan",
"915841", "Tilhar\,\ Uttar\ Pradesh",
"913655", "Khliehriat\,\ Meghalaya",
"9175218", "Seondha\,\ Madhya\ Pradesh",
"9161532", "Maharajganj\,\ Bihar",
"912182", "Karmala\,\ Maharashtra",
"9168487", "Kotagarh\,\ Odisha",
"918668", "Vijayawada\,\ Andhra\ Pradesh",
"911881", "Ropar\,\ Punjab",
"915493", "Mohamdabad\,\ Uttar\ Pradesh",
"9174542", "Chhipaborad\,\ Rajasthan",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+91|\D)//g;
      my $self = bless({ country_code => '91', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '91', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;