# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230113181718;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"492643", "Altenahr",
"492676", "Ulmen",
"4938848", "Vellahn",
"496226", "Meckesheim",
"4938224", "Gresenhorst",
"496868", "Mettlach\-Tünsdorf",
"495495", "Vörden\ Kreis\ Vechta",
"4935387", "Seyda",
"498022", "Tegernsee",
"495073", "Neustadt\-Esperke",
"497229", "Iffezheim",
"499375", "Freudenberg\ Baden",
"499655", "Tännesberg",
"497385", "Gomadingen",
"493346", "Seelow",
"496157", "Pfungstadt",
"495364", "Velpke",
"4933361", "Joachimsthal",
"49391", "Magdeburg",
"4936379", "Holzengel",
"4938725", "Gross\ Godems",
"497240", "Pfinztal",
"4936209", "Klettbach",
"498296", "Villenbach",
"492247", "Neunkirchen\-Seelscheid",
"494824", "Krempe",
"499962", "Schwarzach\ Niederbayern",
"4938788", "Gross\ Warnow",
"492303", "Unna",
"4939396", "Neukirchen\ Altmark",
"499644", "Pressath",
"497308", "Nersingen",
"498467", "Kinding",
"493606", "Heiligenstadt\ Heilbad",
"495902", "Freren",
"492632", "Andernach",
"4939427", "Ströbeck",
"497622", "Schopfheim",
"492065", "Duisburg\-Rheinhausen",
"4938484", "Ventschow",
"497221", "Baden\-Baden",
"496092", "Heimbuchenthal",
"4936920", "Grossenlupnitz",
"498552", "Grafenau\ Niederbayern",
"4939000", "Beetzendorf",
"4936647", "Saalburg\ Thüringen",
"494487", "Grossenkneten\-Huntlosen",
"499464", "Walderbach",
"497951", "Crailsheim",
"496036", "Wölfersheim",
"496508", "Hetzerath\ Mosel",
"492696", "Nohn\ Eifel",
"4938483", "Brüel",
"495475", "Bohmte\-Hunteburg",
"495704", "Petershagen\-Friedewalde",
"493541", "Calau",
"494603", "Havetoft",
"4939401", "Neuwegersleben",
"494123", "Barmstedt",
"498631", "Mühldorf\ am\ Inn",
"495404", "Westerkappeln",
"4935471", "Birkenhainchen",
"499395", "Triefenstein",
"495775", "Diepenau",
"498232", "Schwabmünchen",
"492551", "Steinfurt\-Burgsteinfurt",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"494332", "Hamdorf\ bei\ Rendsburg",
"495278", "Höxter\-Ovenhausen",
"495151", "Hameln",
"493537", "Jessen\ Elster",
"499764", "Höchheim",
"498276", "Baar\ Schwaben",
"498243", "Fuchstal",
"497959", "Frankenhardt",
"492463", "Titz",
"4933921", "Zechlinerhütte",
"494343", "Laboe",
"494207", "Oyten",
"497031", "Böblingen",
"4933835", "Golzow\ bei\ Brandenburg",
"492763", "Drolshagen\-Bleche",
"498639", "Neumarkt\-Sankt\ Veit",
"497265", "Angelbachtal",
"495159", "Coppenbrügge\-Bisperode",
"496585", "Ralingen",
"495284", "Schwalenberg",
"4939291", "Calbe\ Saale",
"4938223", "Saal\ Vorpom",
"4939268", "Egeln",
"496562", "Speicher",
"495195", "Neuenkirchen\ bei\ Soltau",
"4933974", "Dessow",
"492595", "Olfen",
"4935877", "Cunewalde",
"496757", "Becherbach\ bei\ Kirn",
"499351", "Gemünden\ am\ Main",
"497681", "Waldkirch\ Breisgau",
"499272", "Fichtelberg",
"499671", "Oberviechtach",
"494544", "Berkenthin",
"492864", "Reken",
"496457", "Burgwald\ Eder",
"4939384", "Arendsee\ Altmark",
"4938327", "Elmenhorst\ Vorpom",
"4934781", "Greifenhagen",
"497402", "Fluorn\-Winzeln",
"498167", "Zolling",
"498081", "Dorfen\ Stadt",
"493594", "Bischofswerda",
"4935728", "Uhyst\ Spree",
"499359", "Karlstadt\-Wiesenfeld",
"4935826", "Königshain\ bei\ Görlitz",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"495803", "Rosche",
"4938376", "Zirchow",
"498858", "Kochel\-Walchensee",
"4938206", "Graal\-Müritz\ Seeheilbad",
"499236", "Nagel",
"493865", "Holthusen",
"493726", "Flöha",
"497702", "Blumberg\ Baden",
"494723", "Cuxhaven\-Altenwalde",
"492575", "Greven\-Reckenfeld",
"494235", "Langwedel\-Etelsen",
"497904", "Ilshofen",
"495624", "Bad\ Emstal",
"495175", "Lehrte\-Arpke",
"493588", "Niesky",
"496802", "Völklingen\-Lauterbach",
"495751", "Rinteln",
"499292", "Konradsreuth",
"494187", "Holm\-Seppensen",
"499164", "Langenfeld\ Mittelfranken",
"498335", "Fellheim",
"4933478", "Gross\ Neuendorf",
"495451", "Ibbenbüren",
"499556", "Geiselwind",
"4936949", "Obermassfeld\-Grimmenthal",
"497975", "Untergröningen",
"492504", "Telgte",
"494423", "Fedderwarden",
"4936922", "Gerstungen",
"4938301", "Putbus",
"4933398", "Werneuchen",
"4939821", "Carpin",
"495563", "Kreiensen",
"4939002", "Oebisfelde",
"499908", "Schöfweg",
"492163", "Schwalmtal\ Niederrhein",
"4939383", "Sandau\ Elbe",
"493574", "Lauchhammer",
"497362", "Bopfingen",
"499503", "Oberhaid\ Oberfranken",
"495459", "Hörstel",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"492850", "Rees\-Haldern",
"493821", "Ribnitz\-Damgarten",
"4934466", "Janisroda",
"4933609", "Brieskow\-Finkenheerd",
"499531", "Ebern",
"4936734", "Leutenberg",
"496582", "Freudenburg",
"4936464", "Wormstedt",
"495436", "Nortrup",
"49271", "Siegen",
"4939482", "Gatersleben",
"497194", "Spiegelberg",
"497262", "Eppingen",
"496841", "Homburg\ Saar",
"497661", "Kirchzarten",
"496004", "Lich\-Eberstadt",
"499547", "Zapfendorf",
"49241", "Aachen",
"499921", "Regen",
"4939607", "Kotelow",
"496837", "Wallerfangen",
"494966", "Neubörger",
"494335", "Hohn\ bei\ Rendsburg",
"499392", "Faulbach\ Unterfranken",
"498723", "Arnstorf",
"4935322", "Doberlug\-Kirchhain",
"499198", "Heiligenstadt\ in\ Oberfranken",
"495772", "Espelkamp",
"497669", "St\ Märgen",
"498061", "Bad\ Aibling",
"496849", "Kirkel",
"4939222", "Möser",
"4938872", "Rehna",
"4969", "Frankfurt\ am\ Main",
"495472", "Bad\ Essen",
"498423", "Titting",
"499929", "Ruhmannsfelden",
"496666", "Freiensteinau",
"497449", "Baiersbronn\-Obertal",
"498555", "Perlesreut",
"496773", "Kamp\-Bornhofen",
"499184", "Deining\ Oberpfalz",
"496746", "Pfalzfeld",
"494167", "Apensen",
"496095", "Bessenbach",
"4939457", "Benneckenstein\ Harz",
"492635", "Rheinbrohl",
"495905", "Beesten",
"497625", "Zell\ im\ Wiesental",
"497174", "Mögglingen",
"4936968", "Rossdorf\ Rhön",
"496446", "Hohenahr",
"4934242", "Hohenpriessnitz",
"496473", "Leun",
"495831", "Wittingen",
"499965", "Sankt\ Englmar",
"4938755", "Eldena",
"499336", "Bütthard",
"494858", "Sankt\ Margarethen\ Holstein",
"493963", "Woldegk",
"493634", "Sömmerda",
"492183", "Rommerskirchen",
"495583", "Braunlage\-Hohegeiss",
"497441", "Freudenstadt",
"499652", "Waidhaus",
"497382", "Römerstein",
"499178", "Abenberg\ Mittelfranken",
"499251", "Münchberg",
"497720", "Schwenningen\ am\ Neckar",
"498025", "Miesbach",
"499372", "Klingenberg\ am\ Main",
"49906", "Donauwörth",
"497420", "Deisslingen",
"495492", "Steinfeld\ Oldenburg",
"492427", "Nideggen",
"4936463", "Gebstedt",
"4936733", "Kaulsdorf",
"497741", "Tiengen\ Hochrhein",
"498544", "Eging\ am\ See",
"4934638", "Zöschen",
"495839", "Wittingen\-Ohrdorf",
"498376", "Sulzberg\ Allgäu",
"498343", "Aitrang",
"498656", "Anger",
"498207", "Affing",
"495136", "Burgdorf\ Kreis\ Hannover",
"494307", "Raisdorf",
"496888", "Lebach\-Steinbach",
"492536", "Münster\-Albachten",
"494276", "Borstel\ bei\ Sulingen",
"494243", "Twistringen",
"4935604", "Krieschow",
"497365", "Essingen\ Württemberg",
"496051", "Gelnhausen",
"495250", "Delbrück\ Westfalen",
"497936", "Schrozberg\-Bartenstein",
"49211", "Düsseldorf",
"498591", "Obernzell",
"49551", "Göttingen",
"495384", "Seesen\-Gross\ Rhüden",
"494639", "Schafflund",
"4939851", "Göritz\ bei\ Prenzlau",
"499827", "Lichtenau\ Mittelfranken",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"499498", "Laaber",
"497056", "Gechingen",
"497972", "Gschwend\ bei\ Gaildorf",
"496874", "Wadern\-Nunkirchen",
"4938232", "Zingst\ Ostseebad",
"499295", "Töpen",
"498138", "Schwabhausen\ bei\ Dachau",
"496805", "Kleinblittersdorf",
"498332", "Ottobeuren",
"496059", "Jossgrund",
"4935453", "Drahnsdorf",
"4936875", "Straufhain\-Streufdorf",
"498123", "Moosinning",
"4936847", "Steinbach\-Hallenberg",
"495378", "Sassenburg\-Platendorf",
"495172", "Ilsede",
"494631", "Glücksburg\ Ostsee",
"492572", "Emsdetten",
"495658", "Wehretal",
"494232", "Langwedel\ Kreis\ Verden",
"497474", "Haigerloch",
"497705", "Wolterdingen\ Schwarzw",
"492203", "Cologne\-Porz",
"494467", "Wittmund\-Funnix",
"499484", "Brennberg",
"49981", "Ansbach",
"4936042", "Tonna",
"497340", "Neenstetten",
"4935454", "Uckro",
"494296", "Schwanewede\-Aschwarden",
"498824", "Oberau\ Loisach",
"492331", "Hagen\ Westfalen",
"497321", "Heidenheim\ an\ der\ Brenz",
"493677", "Ilmenau\ Thüringen",
"494552", "Leezen",
"496173", "Kronberg\ im\ Taunus",
"494767", "Bremervörde\-Bevern",
"496146", "Hochheim\ am\ Main",
"498571", "Simbach\ am\ Inn",
"497774", "Eigeltingen",
"496326", "Deidesheim",
"495937", "Geeste\-Gross\ Hesepe",
"492256", "Mechernich\-Satzvey",
"492607", "Kobern\-Gondorf",
"4935603", "Burg\ Spreewald",
"497141", "Ludwigsburg\ Württemberg",
"496894", "St\ Ingbert",
"499204", "Plankenfels",
"4936029", "Menteroda",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"492339", "Sprockhövel\-Hasslinghausen",
"499275", "Speichersdorf",
"495941", "Neuenhaus\ Dinkel",
"497329", "Steinheim\ am\ Albuch",
"492592", "Selm",
"495527", "Duderstadt",
"4939036", "Binde",
"495192", "Munster",
"499778", "Fladungen",
"496565", "Dudeldorf",
"495264", "Kalletal",
"495753", "Auetal\-Bernsen",
"493695", "Bad\ Salzungen",
"492360", "Haltern\-Lippramsdorf",
"497367", "Aalen\-Ebnat",
"4938221", "Marlow",
"4933338", "Stolpe\/Oder",
"4939293", "Dreileben",
"498274", "Buttenwiesen",
"494721", "Cuxhaven",
"497852", "Willstätt",
"498205", "Dasing",
"4939995", "Nossendorf",
"495286", "Ottenstein\ Niedersachsen",
"494421", "Wilhelmshaven",
"4935022", "Bad\ Schandau",
"493981", "Neustrelitz",
"494740", "Loxstedt\-Dedesdorf",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"498708", "Weihmichl\-Unterneuhausen",
"4936085", "Reinholterode",
"494305", "Westensee",
"4933923", "Flecken\ Zechlin",
"495453", "Recke",
"4936028", "Kammerforst\ Thüringen",
"498785", "Rottenburg\-Oberroning",
"4937467", "Klingenthal\ Sachsen",
"4935473", "Neu\ Lübbenau",
"495706", "Porta\ Westfalica",
"494182", "Tostedt",
"499070", "Tapfheim",
"499466", "Stamsried",
"492161", "Mönchengladbach",
"496034", "Wöllstadt",
"492694", "Wershofen",
"495561", "Einbeck",
"4938481", "Witzin",
"499825", "Herrieden",
"499766", "Grosswenkheim",
"493838", "Bergen\ auf\ Rügen",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"4934467", "Eckartsberga",
"495406", "Belm",
"499646", "Freihung",
"499673", "Tiefenbach\ Oberpfalz",
"495055", "Fassberg",
"493675", "Sonneberg\ Thüringen",
"499353", "Karlstadt",
"497683", "Simonswald",
"494394", "Bokhorst",
"4935876", "Weissenberg\ Sachsen",
"494268", "Bötersen",
"498294", "Horgau",
"4939404", "Ausleben",
"498368", "Halblech",
"494826", "Hohenlockstedt",
"494765", "Ebersdorf\ bei\ Bremervörde",
"492688", "Kroppach",
"4935474", "Schönwalde\ bei\ Lübben",
"499869", "Wettringen\ Mittelfranken",
"494465", "Friedeburg\ Ostfriesland",
"497707", "Bräunlingen",
"4938326", "Grimmen",
"499277", "Warmensteinach",
"499090", "Rain\ Lech",
"496752", "Kirn\ Nahe",
"498083", "Isen",
"499306", "Kist",
"497135", "Brackenheim",
"4933363", "Altenhof\ Kreis\ Barnim",
"496567", "Oberkail",
"492674", "Bad\ Bertrich",
"4935827", "Nieder\-Seifersdorf",
"496224", "Sandhausen\ Baden",
"492354", "Meinerzhagen",
"4933924", "Rägelin",
"495525", "Walkenried",
"495366", "Jembke",
"4938377", "Zinnowitz",
"495935", "Twist\-Schöninghsdorf",
"492605", "Löf",
"4938207", "Stäbelow",
"499861", "Rothenburg\ ob\ der\ Tauber",
"495044", "Springe\-Eldagsen",
"4939294", "Gross\ Rosenburg",
"496452", "Battenberg\ Eder",
"4938850", "Gammelin",
"493344", "Bad\ Freienwalde",
"4933971", "Kyritz\ Brandenburg",
"499545", "Buttenheim",
"494349", "Dänischenhagen",
"492958", "Büren\-Harth",
"494202", "Achim\ bei\ Bremen",
"493576", "Weisswasser",
"494140", "Estorf\ Kreis\ Stade",
"498302", "Görisried",
"496835", "Beckingen",
"497042", "Vaihingen\ an\ der\ Enz",
"497953", "Blaufelden",
"498249", "Ettringen\ Wertach",
"495153", "Salzhemmendorf",
"4934639", "Wallendorf\ Luppe",
"4934446", "Grosskorbetha",
"4939823", "Rechlin",
"492553", "Ochtrup",
"498628", "Kienberg\ Oberbayern",
"4938303", "Sellin\ Ostseebad",
"494121", "Elmshorn",
"497558", "Illmensee",
"493391", "Neuruppin",
"498633", "Tüssling",
"492461", "Jülich",
"494609", "Eggebek",
"499166", "Münchsteinach",
"4938852", "Wittenburg",
"498241", "Buchloe",
"494482", "Hatten",
"497906", "Braunsbach",
"498642", "Übersee",
"495626", "Bad\ Zwesten",
"496698", "Schrecksbach",
"4934425", "Droyssig",
"494337", "Jevenstedt",
"494320", "Heidmühlen",
"492506", "Münster\-Wolbeck",
"494129", "Haseldorf",
"492761", "Olpe\ Biggesee",
"49761", "Freiburg\ im\ Breisgau",
"497033", "Weil\ Der\ Stadt",
"498237", "Aindling",
"499554", "Untersteinbach\ Unterfranken",
"4936969", "Merkers",
"493596", "Neustadt\ in\ Sachsen",
"498462", "Berching",
"492242", "Hennef\ Sieg",
"4935020", "Struppen",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"492309", "Waltrop",
"499234", "Neusorg",
"496684", "Hofbieber\-Schwarzbach",
"498557", "Mauth",
"4935386", "Prettin",
"499560", "Grub\ am\ Forst",
"493724", "Burgstädt",
"4934783", "Gerbstedt",
"495845", "Bergen\ Dumme",
"492620", "Neuhäusel\ Westerwald",
"493371", "Luckenwalde",
"4936625", "Langenwetzendorf",
"498762", "Wartenberg\ Oberbayern",
"497627", "Steinen\ Kreis\ Lörrach",
"492637", "Weissenthurm",
"495907", "Geeste",
"494165", "Hollenstedt\ Nordheide",
"495071", "Schwarmstedt",
"4938304", "Garz\ Rügen",
"495854", "Bleckede\-Barskamp",
"492425", "Nideggen\-Embken",
"4939824", "Hohenzieritz",
"497435", "Albstadt\-Laufen",
"4939248", "Dobritz",
"4939397", "Geestgottberg",
"492301", "Holzwickede",
"4939426", "Hessen",
"496358", "Kriegsfeld",
"492228", "Remagen\-Rolandseck",
"496152", "Gross\-Gerau",
"496678", "Wildeck\-Hönebach",
"492233", "Hürth\ Rheinland",
"497735", "Öhningen",
"492725", "Lennestadt\-Oedingen",
"498027", "Dietramszell",
"492866", "Dorsten\-Rhade",
"497223", "Bühl\ Baden",
"494546", "Mustin\ Lauenburg",
"4936646", "Tanna\ bei\ Schleiz",
"493379", "Mahlow",
"496455", "Frankenau\ Hessen",
"4936731", "Unterloquitz",
"4936461", "Bad\ Sulza",
"495932", "Haren\ Ems",
"492602", "Montabaur",
"493636", "Greussen",
"4933608", "Jacobsdorf\ Mark",
"498573", "Ering",
"498546", "Windorf\-Otterskirchen",
"492597", "Senden\ Westfalen",
"495522", "Osterode\ am\ Harz",
"497132", "Neckarsulm",
"496171", "Oberursel\ Taunus",
"496258", "Gernsheim",
"495197", "Soltau\-Frielingen",
"4935200", "Arnsdorf\ bei\ Dresden",
"492333", "Ennepetal",
"497323", "Gerstetten",
"496755", "Odernheim\ am\ Glan",
"499186", "Lauterhofen\ Oberpfalz",
"496744", "Oberwesel",
"4938356", "Behrenhoff",
"494950", "Holtland",
"497143", "Besigheim",
"497176", "Spraitbach",
"493867", "Lübstorf",
"494462", "Wittmund",
"494762", "Kutenholz",
"498165", "Neufahrn\ bei\ Freising",
"499334", "Giebelstadt",
"495976", "Salzbergen",
"493672", "Rudolstadt",
"495052", "Hermannsburg",
"494557", "Blunk",
"4936948", "Römhild",
"495943", "Emlichheim",
"4939037", "Pretzier",
"496650", "Hosenfeld",
"496444", "Bischoffen",
"4933479", "Küstrin\-Kietz",
"4934262", "Falkenhain\ bei\ Wurzen",
"494241", "Bassum",
"4939832", "Wesenberg",
"4933458", "Falkenberg\ Mark",
"4938292", "Kröpelin",
"494642", "Kappeln\ Schlei",
"494964", "Rhede\ Ems",
"499822", "Bechhofen\ an\ der\ Heide",
"497977", "Oberrot\ bei\ Gaildorf",
"498341", "Kaufbeuren",
"495177", "Edemissen\-Abbensen",
"497844", "Rheinau",
"496664", "Sinntal\-Sterbfritz",
"494237", "Bendingbostel",
"497570", "Sigmaringen\-Gutenstein",
"498593", "Untergriesbach",
"498337", "Altenstadt\ Iller",
"494185", "Marxen\ Auetal",
"496053", "Wächtersbach",
"498320", "Missen\-Wilhams",
"498782", "Pfeffenhausen",
"494302", "Kirchbarkau",
"494108", "Rosengarten\ Kreis\ Harburg",
"494249", "Bassum\-Nordwohlde",
"498349", "Stötten\ am\ Auerberg",
"498202", "Althegnenberg",
"4935052", "Kipsdorf\ Kurort",
"495434", "Essen\ Oldenburg",
"496523", "Holsthum",
"495734", "Bergkirchen\ Westfalen",
"499848", "Simmershofen",
"498121", "Markt\ Schwaben",
"494633", "Satrup",
"4936846", "Suhl\-Dietzhausen",
"497387", "Hohenstein\ Württemberg",
"499206", "Mistelgau\-Obernsees",
"499657", "Waldthurn",
"499377", "Freudenberg\-Boxtal",
"497732", "Radolfzell\ am\ Bodensee",
"496771", "St\ Goarshausen",
"4937605", "Hartenstein\ Sachsen",
"492722", "Attendorn",
"492254", "Weilerswist",
"496324", "Hassloch",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"4939456", "Altenbrak",
"496155", "Griesheim\ Hessen",
"493961", "Altentreptow",
"495833", "Brome",
"4935601", "Peitz",
"495266", "Lemgo\-Kirchheide",
"4934605", "Gröbers",
"492422", "Kreuzau",
"497432", "Albstadt\-Tailfingen",
"496471", "Weilburg",
"4939854", "Kleptow",
"495828", "Himbergen",
"499253", "Weissenstadt",
"492448", "Hellenthal\-Rescheid",
"4939084", "Lindstedt",
"494162", "Jork",
"494294", "Riede\ Kreis\ Verden",
"498765", "Bruckberg\ Niederbayern",
"495842", "Schnega",
"497476", "Bisingen",
"497443", "Dornstetten",
"492181", "Grevenbroich",
"498268", "Tussenhausen",
"498394", "Lautrach",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"492245", "Much",
"497743", "Ühlingen\-Birkendorf",
"493969", "Siedenbollentin",
"498465", "Kipfenberg",
"496479", "Waldbrunn\ Westerwald",
"495777", "Diepenau\-Essern",
"4935202", "Klingenberg\ Sachsen",
"497663", "Eichstetten",
"499397", "Wertheim\-Dertingen",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"4935451", "Dahme\ Brandenburg",
"494288", "Horstedt\ Kreis\ Rotenburg",
"496876", "Weiskirchen\ Saar",
"499528", "Donnersdorf",
"496843", "Gersheim",
"493535", "Herzberg\ Elster",
"4938789", "Wolfshagen\ bei\ Perleberg",
"497054", "Wildberg\ Württemberg",
"4936208", "Ermstedt",
"499533", "Untermerzbach",
"4933932", "Fehrbellin",
"4936378", "Ostramondra",
"498388", "Hergensweiler",
"49355", "Cottbus",
"493925", "Stassfurt",
"4939083", "Messdorf",
"499923", "Teisnach",
"494485", "Elsfleth\-Huntorf",
"4939606", "Glienke",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"499938", "Moos\ Niederbayern",
"497267", "Gemmingen",
"498063", "Feldkirchen\-Westerham",
"498721", "Eggenfelden",
"494274", "Varrel\ bei\ Sulingen",
"492534", "Münster\-Roxel",
"497524", "Bad\ Waldsee",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498374", "Dietmannsried",
"494408", "Hude\ Oldenburg",
"496587", "Zerf",
"498654", "Freilassing",
"497045", "Oberderdingen",
"494708", "Ringstedt",
"496832", "Beckingen\-Reimsbach",
"494205", "Ottersberg",
"498421", "Eichstätt\ Bayern",
"499542", "Schesslitz",
"492924", "Möhnesee",
"497934", "Weikersheim",
"493564", "Schwarze\ Pumpe",
"499720", "Üchtelhausen",
"497251", "Bruchsal",
"496331", "Pirmasens",
"499737", "Wartmannsroth",
"499188", "Postbauer\-Heng",
"497652", "Hinterzarten",
"499382", "Gerolzhofen",
"492173", "Langenfeld\ Rheinland",
"499441", "Kelheim",
"495546", "Scheden",
"495573", "Uslar\-Volpriehausen",
"496203", "Ladenburg",
"494854", "Friedrichskoog",
"4934636", "Schafstädt",
"499741", "Bad\ Brückenau",
"496347", "Hochstadt\ Pfalz",
"495978", "Hörstel\-Dreierwalde",
"499420", "Feldkirchen\ Niederbayern",
"496783", "Baumholder",
"499174", "Hilpoltstein",
"499625", "Kastl\ bei\ Amberg",
"4934422", "Osterfeld",
"493623", "Friedrichroda",
"497259", "Östringen\-Odenheim",
"4936481", "Neustadt\ an\ der\ Orla",
"498052", "Aschau\ im\ Chiemgau",
"497184", "Kaisersbach",
"496339", "Grosssteinhausen",
"495165", "Rethem\ Aller",
"496592", "Daun",
"496130", "Schwabenheim\ an\ der\ Selz",
"4933674", "Trebatsch",
"496127", "Niedernhausen\ Taunus",
"494845", "Ostenfeld\ Husum",
"492565", "Gronau\-Epe",
"497336", "Lonsee",
"499749", "Oberbach\ Unterfranken",
"496256", "Lampertheim\-Hüttenfeld",
"4938855", "Lübtheen",
"497965", "Ellwangen\-Röhlingen",
"498548", "Vilshofen\-Sandbach",
"4937422", "Markneukirchen",
"4936966", "Kaltennordheim",
"499105", "Grosshabersdorf",
"496483", "Selters\ Taunus",
"492051", "Velbert",
"497392", "Laupheim",
"494106", "Quickborn\ Kreis\ Pinneberg",
"495320", "Torfhaus",
"495337", "Kissenbrück",
"495593", "Bovenden\-Lenglern",
"492529", "Oelde\-Stromberg",
"4936622", "Triebes",
"49611", "Wiesbaden",
"492193", "Dabringhausen",
"495129", "Söhlde",
"498177", "Münsing\ Starnberger\ See",
"495341", "Salzgitter",
"4935389", "Holzdorf\ Elster",
"495609", "Ahnatal",
"499846", "Ipsheim",
"499873", "Abenberg\-Wassermungenau",
"494626", "Treia",
"495482", "Tecklenburg",
"4933673", "Weichensdorf",
"496008", "Echzell",
"496536", "Kleinich",
"492947", "Anröchte",
"497940", "Künzelsau",
"4936377", "Rastenberg",
"499661", "Sulzbach\-Rosenberg",
"4936207", "Plaue\ Thüringen",
"496085", "Waldsolms",
"499194", "Ebermannstadt",
"499262", "Wallenfels",
"494153", "Lauenburg\ Elbe",
"495121", "Hildesheim",
"497531", "Konstanz",
"496572", "Manderscheid\ Eifel",
"498734", "Reisbach\ Niederbayern",
"492521", "Beckum",
"498434", "Rennertshofen",
"495202", "Oerlinghausen",
"492931", "Arnsberg",
"495601", "Schauenburg",
"4936766", "Schalkau",
"4936649", "Gefell\ bei\ Schleiz",
"492874", "Isselburg",
"4935025", "Liebstadt",
"494935", "Juist",
"4939992", "Görmin",
"499141", "Weissenburg\ in\ Bayern",
"492473", "Simmerath",
"494366", "Grömitz\-Cismar",
"497204", "Malsch\-Völkersbach",
"492446", "Heimbach\ Eifel",
"4936082", "Ershausen",
"498266", "Kirchheim\ in\ Schwaben",
"497478", "Hirrlingen",
"499120", "Leinburg",
"4939038", "Henningen",
"4936947", "Jüchsen",
"494525", "Ahrensbök",
"492773", "Haiger",
"497275", "Kandel",
"496062", "Erbach\ Odenwald",
"499285", "Kirchenlamitz",
"496635", "Kirtorf",
"496427", "Cölbe\-Schönstadt",
"499149", "Weissenburg\-Suffersheim",
"496430", "Hahnstätten",
"496898", "Völklingen",
"499208", "Bindlach",
"495465", "Neuenkirchen\ bei\ Bramsche",
"49781", "Offenburg",
"497484", "Simmersfeld",
"499340", "Königheim\-Brehmen",
"499474", "Schmidmühlen",
"4939951", "Faulenrost",
"499405", "Bad\ Abbach",
"496183", "Erlensee",
"499774", "Oberelsbach",
"498581", "Waldkirchen\ Niederbayern",
"4935756", "Hosena",
"495826", "Suderburg",
"495765", "Raddestorf",
"496727", "Gensingen",
"4933607", "Briesen\ Mark",
"499321", "Kitzingen",
"495429", "Melle\-Wellingholzhausen",
"49641", "Giessen",
"499972", "Waldmünchen",
"494406", "Berne",
"495645", "Borgentreich\-Borgholz",
"492837", "Weeze",
"495182", "Gronau\ Leine",
"494706", "Schiffdorf",
"492582", "Everswinkel",
"494561", "Neustadt\ in\ Holstein",
"492841", "Moers",
"49671", "Bad\ Kreuznach",
"499526", "Riedbach",
"494286", "Gyhum",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"498386", "Oberstaufen",
"494453", "Zetel",
"4933457", "Altreetz",
"495305", "Sickte",
"492666", "Freilingen\ Westerwald",
"495654", "Herleshausen",
"495374", "Isenbüttel",
"4939751", "Penkun",
"494753", "Balje",
"499936", "Wallerfing",
"495721", "Stadthagen",
"498134", "Odelzhausen",
"495063", "Bad\ Salzdetfurth",
"499365", "Rimpar",
"498453", "Reichertshofen\ Oberbayern",
"4936691", "Eisenberg\ Thüringen",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"4939459", "Hasselfelde",
"496504", "Thalfang",
"499468", "Zell\ Oberpfalz",
"495205", "Bielefeld\-Sennestadt",
"496575", "Landscheid",
"495274", "Nieheim",
"4937602", "Kirchberg\ Sachsen",
"4938731", "Lübz",
"4938461", "Bützow",
"494134", "Embsen\ Kreis\ Lüneburg",
"4939773", "Altwarp",
"496082", "Niederreifenberg",
"499265", "Pressig",
"498753", "Elsendorf\ Niederbayern",
"492802", "Alpen",
"493836", "Wolgast",
"495485", "Ladbergen",
"498406", "Böhmfeld",
"494477", "Lastrup\-Hemmelte",
"497464", "Talheim\ Kreis\ Tuttlingen",
"499951", "Landau\ an\ der\ Isar",
"498561", "Pfarrkirchen\ Niederbayern",
"497764", "Herrischried",
"4933234", "Wustermark",
"496163", "Höchst\ im\ Odenwald",
"494777", "Cadenberge",
"4936652", "Wurzbach",
"497395", "Ehingen\-Dächingen",
"498706", "Vilsheim",
"496864", "Mettlach",
"493431", "Döbeln",
"499102", "Wilhermsdorf",
"497644", "Kenzingen",
"4939247", "Güterglück",
"4939398", "Gross\ Garz",
"4933233", "Ketzin",
"497962", "Fichtenau",
"4938825", "Klütz",
"4939973", "Altkalen",
"492562", "Gronau\ Westfalen",
"494842", "Nordstrand",
"4935205", "Ottendorf\-Okrilla",
"495368", "Parsau",
"495294", "Hövelhof\-Espeln",
"495162", "Fallingbostel",
"496595", "Dockweiler",
"493447", "Altenburg\ Thüringen",
"498809", "Wessobrunn",
"499221", "Kulmbach",
"498055", "Halfing",
"499622", "Hirschau\ Oberpfalz",
"493731", "Freiberg\ Sachsen",
"494266", "Brockel",
"494833", "Wesselburen",
"497304", "Blaustein\ Württemberg",
"4939774", "Mönkebude",
"499648", "Neustadt\ am\ Kulm",
"492686", "Weyerbusch",
"494828", "Lägerdorf",
"498366", "Oy\-Mittelberg",
"4934491", "Schmölln\ Thüringen",
"494497", "Barssel\-Harkebrügge",
"497655", "Feldberg\-Altglashütten",
"495083", "Hohne\ bei\ Celle",
"499385", "Kolitzheim",
"498801", "Seeshaupt",
"497375", "Obermarchtal",
"499229", "Mainleus",
"495633", "Diemelsee",
"492903", "Meschede\-Freienohl",
"496029", "Mömbris",
"49331", "Potsdam",
"498091", "Kirchseeon",
"494734", "Stadland\-Seefeld",
"4939721", "Liepen\ bei\ Anklam",
"496551", "Prüm",
"4938793", "Dergenthin",
"4937468", "Treuen\ Vogtland",
"498153", "Wessling",
"4933396", "Klosterfelde",
"492508", "Drensteinfurt",
"498860", "Bernbeuren",
"497026", "Lenningen",
"495108", "Gehrden\ Han",
"499857", "Schopfloch\ Mittelfranken",
"495302", "Vechelde",
"496696", "Gilserberg",
"494434", "Colnrade",
"497503", "Wilhelmsdorf\ Württemberg",
"4936076", "Niederorschel",
"4937434", "Bobenneukirchen",
"496021", "Aschaffenburg",
"493578", "Kamenz",
"495237", "Augustdorf",
"497164", "Boll\ Kreis\ Göppingen",
"496763", "Kirchberg\ Hunsrück",
"4933337", "Altkünkendorf",
"4939343", "Jerichow",
"494177", "Drage\ Elbe",
"499904", "Lalling",
"4933874", "Stechow\ Brandenburg",
"492585", "Warendorf\-Hoetmar",
"498106", "Vaterstetten",
"496559", "Leidenborn",
"495185", "Duingen",
"4937324", "Reinsberg\ Sachsen",
"4936027", "Lengenfeld\ Unterm\ Stein",
"495642", "Warburg\-Scherfede",
"493946", "Quedlinburg",
"4934324", "Ostrau\ Sachsen",
"493973", "Pasewalk",
"499975", "Waldmünchen\-Geigant",
"495241", "Gütersloh",
"4939361", "Lüderitz",
"497556", "Uhldingen\-Mühlhofen",
"4933476", "Neuhardenberg",
"495964", "Lähden",
"4935243", "Weinböhla",
"498071", "Wasserburg\ am\ Inn",
"4935828", "Reichenbach\ OL",
"496239", "Bobenheim\-Roxheim",
"49228", "Bonn",
"4935726", "Gross\ Särchen",
"498845", "Bad\ Kohlgrub",
"497150", "Korntal\-Münchingen",
"492157", "Nettetal\-Kaldenkirchen",
"4937600", "Neumark\ Sachsen",
"499402", "Regenstauf",
"4939921", "Ankershagen",
"494943", "Grossefehn",
"4935244", "Krögis",
"494976", "Spiekeroog",
"496676", "Hohenroda\ Hessen",
"496643", "Herbstein",
"4934600", "Ostrau\ Saalkreis",
"497236", "Keltern",
"4938295", "Satow\ bei\ Bad\ Doberan",
"4939344", "Güsen",
"496356", "Carlsberg\ Pfalz",
"492226", "Rheinbach",
"4938208", "Kavelstorf",
"495462", "Ankum",
"4933873", "Grosswudicke",
"4938378", "Heringsdorf\ Seebad",
"4937323", "Lichtenberg\ Erzgebirge",
"497671", "Todtnau",
"499282", "Naila",
"493327", "Werder\ Havel",
"497351", "Biberach\ an\ der\ Riss",
"495027", "Linsburg",
"494522", "Plön",
"497272", "Rülzheim",
"496231", "Hochdorf\-Assenheim",
"499681", "Windischeschenbach",
"4937433", "Gutenfürst",
"4934741", "Frose",
"4939266", "Förderstedt",
"496247", "Worms\-Pfeddersheim",
"496303", "Enkenbach\-Alsenborn",
"4938794", "Cumlosen",
"4936849", "Kleinschmalkalden",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"494932", "Norderney",
"499855", "Dentlein\ am\ Forst",
"494968", "Neulehe",
"4933084", "Gutengermendorf",
"499196", "Wiesenttal",
"494563", "Scharbeutz\-Haffkrug",
"492843", "Rheinberg",
"4936848", "Wernshausen",
"495069", "Nordstemmen",
"496668", "Birstein\-Lichenroth",
"4935842", "Oderwitz",
"4936484", "Knau\ bei\ Pössneck",
"495438", "Bakum\-Lüsche",
"499977", "Arnschwang",
"492832", "Kevelaer",
"494451", "Varel\ Jadebusen",
"497822", "Ettenheim",
"495423", "Versmold",
"4933671", "Lieberose",
"4933456", "Wriezen",
"494104", "Aumühle\ bei\ Hamburg",
"4935829", "Gersdorf\ bei\ Görlitz",
"494624", "Kropp",
"494175", "Egestorf\ Nordheide",
"493361", "Fürstenwalde\ Spree",
"498772", "Mallersdorf\-Pfaffenberg",
"4938379", "Benz\ Usedom",
"495235", "Blomberg\ Lippe",
"496534", "Mülheim\ Mosel",
"4938209", "Sanitz\ bei\ Rostock",
"495723", "Bad\ Nenndorf",
"495187", "Delligsen",
"4933830", "Ziesar",
"494751", "Otterndorf",
"492587", "Ennigerloh\-Westkirchen",
"499844", "Obernzenn",
"49760", "Oberried\ Breisgau",
"499143", "Pappenheim\ Mittelfranken",
"492471", "Roetgen\ Eifel",
"496422", "Kirchhain",
"499176", "Allersberg",
"498847", "Obersöchering",
"493682", "Zella\-Mehlis",
"4936483", "Ziegenrück",
"496722", "Rüdesheim\ am\ Rhein",
"492771", "Dillenburg",
"4936946", "Erbenhausen\ Thüringen",
"497334", "Deggingen",
"495555", "Moringen\-Fredelsloh",
"494803", "Pahlen",
"496254", "Lautertal\ Odenwald",
"492324", "Hattingen\ Ruhr",
"495544", "Reinhardshagen",
"496245", "Biblis",
"4938720", "Grebbin",
"4939932", "Malchow\ bei\ Waren",
"4939005", "Kusey",
"495025", "Estorf\ Weser",
"4936925", "Marksuhl",
"499323", "Iphofen",
"492779", "Greifenstein\-Beilstein",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"494195", "Hartenholm",
"498583", "Neureichenau",
"499132", "Herzogenaurach",
"494856", "Kronprinzenkoog",
"499338", "Röttingen\ Unterfranken",
"496181", "Hanau",
"4933606", "Müllrose",
"4939753", "Strasburg",
"492191", "Remscheid",
"498384", "Röthenbach\ Allgäu",
"4939061", "Weferlingen",
"49851", "Passau",
"492664", "Rennerod",
"498250", "Hilgertshausen\-Tandern",
"492053", "Velbert\-Neviges",
"492942", "Geseke",
"499524", "Zeil\ am\ Main",
"494284", "Selsingen",
"499267", "Nordhalben",
"494159", "Basthorst",
"497542", "Tettnang",
"498136", "Markt\ Indersdorf",
"495656", "Waldkappel",
"495207", "Schloss\ Holte\-Stukenbrock",
"499871", "Windsbach",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"4936376", "Straussfurt",
"497533", "Allensbach",
"494775", "Grossenwörden",
"4936206", "Grossfahner",
"494404", "Elsfleth",
"492523", "Wadersloh",
"498378", "Buchenberg\ bei\ Kempten",
"495123", "Schellerten",
"497528", "Neukirch\ bei\ Tettnang",
"4939399", "Kleinau",
"494151", "Schwarzenbek",
"492538", "Drensteinfurt\-Rinkerode",
"495332", "Schöppenstedt",
"495138", "Sehnde",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"497938", "Mulfingen\ Jagst",
"4938722", "Raduhn",
"492928", "Soest\-Ostönnen",
"4939954", "Stavenhagen\ Reuterstadt",
"4939608", "Staven",
"495603", "Gudensberg",
"492933", "Sundern\ Sauerland",
"494704", "Drangstedt",
"494475", "Molbergen",
"497486", "Horb\-Altheim",
"496597", "Jünkerath",
"493445", "Naumburg\ Saale",
"495571", "Uslar",
"496122", "Hofheim\-Wallau",
"496328", "Elmstein",
"499443", "Abensberg",
"4939953", "Schwinkendorf",
"492171", "Leverkusen\-Opladen",
"494902", "Jemgum\-Ditzum",
"496789", "Heimbach\ Nahe",
"498057", "Aschau\-Sachrang",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497253", "Bad\ Schönborn",
"493629", "Stadtilm",
"496333", "Waldfischbach\-Burgalben",
"495824", "Bad\ Bodenteich",
"492455", "Waldfeucht",
"4934637", "Frankleben",
"499776", "Mellrichstadt",
"496201", "Weinheim\ Bergstr",
"493745", "Falkenstein\ Vogtland",
"4933832", "Rogäsen",
"498192", "Schondorf\ am\ Ammersee",
"4939458", "Heudeber",
"494795", "Garlstedt",
"493621", "Gotha\ Thüringen",
"499732", "Hammelburg",
"494364", "Dahme\ Kreis\ Ostholstein",
"494298", "Lilienthal",
"496781", "Idar\-Oberstein",
"492444", "Schleiden\-Gemünd",
"497657", "Eisenbach\ Hochschwarzwald",
"492744", "Herdorf",
"4939754", "Löcknitz\ Vorpom",
"494495", "Friesoythe\-Thüle",
"496209", "Mörlenbach",
"496342", "Schweigen\-Rechtenbach",
"4936967", "Geisa",
"494941", "Aurich",
"4936694", "Schkölen\ Thüringen",
"492684", "Puderbach\ Westerwald",
"499135", "Hessdorf\ Mittelfranken",
"498364", "Seeg",
"4935727", "Burghammer",
"499287", "Selb",
"496637", "Feldatal",
"494264", "Sottrum\ Kreis\ Rotenburg",
"493322", "Falkensee",
"494192", "Bad\ Bramstedt",
"497306", "Vöhringen\ Iller",
"496620", "Philippsthal\ Werra",
"497277", "Wörth\-Büchelberg",
"498073", "Gars\ am\ Inn",
"498046", "Bad\ Heilbrunn",
"495022", "Wietzen",
"494527", "Bosau",
"4938464", "Bernitt",
"494920", "Wirdum",
"4938750", "Malliss",
"4936253", "Georgenthal\ Thüringer\ Wald",
"496242", "Osthofen",
"4934493", "Gössnitz\ Thüringen",
"496641", "Lauterbach\ Hessen",
"492152", "Kempen",
"492358", "Meinerzhagen\-Valbert",
"496228", "Schönau\ Odenwald",
"495552", "Katlenburg",
"492678", "Büchel\ bei\ Cochem",
"4939971", "Gnoien",
"499407", "Wenzenbach",
"497353", "Schwendi",
"496725", "Gau\-Algesheim",
"496866", "Perl\-Nennig",
"4934203", "Zwenkau",
"496233", "Frankenthal\ Pfalz",
"499683", "Friedenfels",
"493685", "Hildburghausen",
"495767", "Warmsen",
"497646", "Weisweil\ Breisgau",
"497673", "Schönau\ im\ Schwarzwald",
"4939267", "Schneidlingen",
"4938328", "Miltzow",
"4933231", "Pausin",
"495467", "Voltlage",
"4934905", "Wörlitz",
"4937203", "Gersdorf\ bei\ Chemnitz",
"496425", "Rauschenberg\ Hessen",
"493991", "Waren\ Müritz",
"496301", "Otterbach\ Pfalz",
"498151", "Starnberg",
"497466", "Beuron",
"496553", "Schönecken",
"4937204", "Lichtenstein\ Sachsen",
"495232", "Lage\ Lippe",
"498093", "Glonn\ Kreis\ Ebersberg",
"498404", "Oberdolling",
"499080", "Harburg\ Schwaben",
"494172", "Salzhausen",
"495631", "Korbach",
"4933397", "Wandlitz",
"498704", "Altdorf\-Pfettrach",
"4934204", "Schkeuditz",
"492835", "Issum",
"497825", "Kippenheim",
"4936077", "Grossbodungen",
"495647", "Lichtenau\-Kleinenberg",
"4939771", "Ueckermünde",
"4938733", "Karbow\-Vietlübbe",
"498284", "Ziemetshausen",
"496506", "Welschbillig",
"4936254", "Friedrichswerth",
"4933336", "Passow\ Kreis\ Uckermark",
"4933632", "Hangelsberg",
"494384", "Selent",
"499367", "Unterpleichfeld",
"4934494", "Ehrenhain",
"496761", "Simmern\ Hunsrück",
"498670", "Reischach\ Kreis\ Altötting",
"49451", "Lübeck",
"496023", "Alzenau\ in\ Unterfranken",
"4936026", "Struth\ bei\ Mühlhausen",
"4936693", "Crossen\ an\ der\ Elster",
"493834", "Greifswald",
"496461", "Biedenkopf",
"495276", "Marienmünster",
"4939039", "Bonese",
"495307", "Braunschweig\-Wenden",
"499852", "Feuchtwangen",
"4933477", "Trebnitz\ bei\ Müncheberg",
"494136", "Scharnebeck",
"493971", "Anklam",
"496345", "Albersweiler",
"494492", "Saterland",
"4939246", "Lindau\ Anh",
"4938787", "Glöwen",
"499435", "Schwarzenfeld",
"4935435", "Gollmitz\ bei\ Calau",
"494839", "Wöhrden\ Dithmarschen",
"493433", "Borna\ Stadt",
"4939724", "Klein\ Bünzow",
"498856", "Penzberg",
"493733", "Annaberg\-Buchholz",
"4936648", "Dittersdorf\ bei\ Schleiz",
"499735", "Massbach",
"499223", "Rugendorf",
"496400", "Mücke",
"4934743", "Ermsleben",
"4939485", "Gernrode\ Harz",
"4937431", "Mehltheuer\ Vogtland",
"494792", "Worpswede",
"499238", "Röslau",
"4939428", "Pabstorf",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"497967", "Jagstzell",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4939225", "Altengrabow",
"4935264", "Strehla",
"494974", "Neuharlingersiel",
"499107", "Trautskirchen",
"495858", "Hitzacker\-Wietzetze",
"4937321", "Frankenstein\ Sachsen",
"4938847", "Boizenburg\ Elbe",
"492452", "Heinsberg\ Rheinland",
"498803", "Peissenberg",
"493381", "Brandenburg\ an\ der\ Havel",
"492752", "Bad\ Laasphe",
"499627", "Freudenberg\ Oberpfalz",
"4934321", "Leisnig",
"496674", "Friedewald\ Hessen",
"492567", "Ahaus\-Alstätte",
"494847", "Oster\-Ohrstedt",
"4933654", "Fünfeichen",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4939923", "Priborn",
"495167", "Walsrode\-Westenholz",
"4939364", "Dolle",
"497234", "Tiefenbronn",
"492224", "Bad\ Honnef",
"4935388", "Klöden",
"499906", "Mariaposching",
"494472", "Lastrup",
"498104", "Sauerlach",
"493877", "Wittenberge",
"4939924", "Stuer",
"4935241", "Lommatzsch",
"497166", "Adelberg",
"4933653", "Ziltendorf",
"492954", "Rüthen\-Oestereiden",
"4939363", "Angern",
"4938752", "Zierzow\ bei\ Ludwigslust",
"495335", "Schladen",
"497554", "Heiligenberg\ Baden",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4939341", "Redekin",
"498751", "Mainburg",
"495966", "Meppen\-Apeldorn",
"4935263", "Gröditz\ bei\ Riesa",
"493944", "Blankenburg\ Harz",
"498624", "Obing",
"494772", "Oberndorf\ Oste",
"499953", "Pilsting",
"498459", "Manching",
"497545", "Immenstaad\ am\ Bodensee",
"493586", "Neugersdorf\ Sachsen",
"494736", "Butjadingen\-Tossens",
"496087", "Waldems",
"492945", "Lippstadt\-Benninghausen",
"496161", "Brensbach",
"497024", "Wendlingen\ am\ Neckar",
"4933708", "Rangsdorf",
"4938791", "Bad\ Wilsnack",
"4939723", "Krien",
"498563", "Bad\ Birnbach\ Rottal",
"4936870", "Masserberg",
"496694", "Neukirchen\ Knüll",
"4939922", "Dambeck\ bei\ Röbel",
"499480", "Sünching",
"497344", "Blaubeuren",
"49214", "Leverkusen",
"499608", "Kohlberg\ Oberpfalz",
"4938754", "Leussow\ bei\ Ludwigslust",
"497066", "Bad\ Rappenau\-Bonfeld",
"498582", "Röhrnbach",
"499133", "Baiersdorf\ Mittelfranken",
"4938458", "Zehna",
"499128", "Feucht",
"492777", "Breitscheid\ Hessen",
"498075", "Amerang",
"498841", "Murnau\ am\ Staffelsee",
"496423", "Wetter\ Hessen",
"499348", "Werbach\-Gamburg",
"4934742", "Sylda",
"499142", "Treuchtlingen",
"495924", "Bad\ Bentheim\-Gildehaus",
"4989", "Munich",
"496438", "Hünfelden",
"498666", "Teisendorf",
"496187", "Schöneck",
"494802", "Wrohm",
"497675", "Bernau\ Baden",
"4937369", "Wolkenstein",
"497124", "Trochtelfingen\ Hohenz",
"496061", "Michelstadt",
"493683", "Schmalkalden",
"496235", "Schifferstadt",
"495534", "Eschershausen\ an\ der\ Lenne",
"497355", "Hochdorf\ Riss",
"496723", "Oestrich\-Winkel",
"495422", "Melle",
"498446", "Pörnbach",
"497838", "Nordrach",
"4939722", "Sarnow\ bei\ Anklam",
"492828", "Emmerich\-Elten",
"497823", "Seelbach\ Schutter",
"492266", "Lindlar",
"492833", "Kerken",
"496555", "Bleialf",
"4934929", "Straach",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4939889", "Boitzenburg",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"495722", "Bückeburg",
"498095", "Aying",
"4936465", "Oberndorf\ bei\ Apolda",
"4936735", "Probstzella",
"498773", "Neufahrn\ in\ Niederbayern",
"499834", "Theilenhofen",
"496544", "Rhaunen",
"4939059", "Wegenstedt",
"495245", "Herzebrock\-Clarholz",
"499971", "Cham",
"4939749", "Grambow\ bei\ Pasewalk",
"492581", "Warendorf",
"4933652", "Neuzelle",
"4938753", "Wöbbelin",
"4939362", "Grieben\ bei\ Tangerhütte",
"495181", "Alfeld\ Leine",
"494757", "Wanna",
"495448", "Barver",
"492842", "Kamp\-Lintfort",
"494562", "Grömitz",
"495067", "Bockenem",
"49375", "Zwickau",
"499225", "Stadtsteinach",
"498051", "Prien\ am\ Chiemsee",
"499733", "Münnerstadt",
"493735", "Marienberg\ Sachsen",
"498193", "Geltendorf",
"499728", "Wülfershausen\ Unterfranken",
"496591", "Gerolstein",
"499180", "Pyrbaum",
"494956", "Uplengen",
"4937202", "Claussnitz\ bei\ Chemnitz",
"496656", "Ebersburg",
"496207", "Wald\-Michelbach",
"4934202", "Delitzsch",
"496343", "Bad\ Bergzabern",
"499428", "Kirchroth",
"493435", "Oschatz",
"4935455", "Walddrehna",
"499433", "Nabburg",
"49345", "Halle\ Saale",
"4936873", "Themar",
"496787", "Niederbrombach",
"499381", "Volkach",
"4934492", "Lucka",
"497651", "Titisee\-Neustadt",
"497371", "Riedlingen\ Württemberg",
"496332", "Zweibrücken",
"497252", "Bretten",
"498805", "Hohenpeissenberg",
"496138", "Mommenheim",
"496599", "Weidenbach\ bei\ Gerolstein",
"497724", "St\ Georgen\ im\ Schwarzwald",
"492734", "Freudenberg\ Westfalen",
"499442", "Riedenburg",
"4936252", "Tambach\-Dietharz",
"494903", "Wymeer",
"496123", "Eltville\ am\ Rhein",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"499742", "Kalbach\ Rhön",
"492434", "Wegberg",
"497424", "Spaichingen",
"494508", "Krummesse",
"4933849", "Wiesenburg\ Mark",
"499261", "Kronach",
"49361", "Erfurt",
"4939209", "Wanzleben",
"4935698", "Hornow",
"499662", "Vilseck",
"495333", "Dettum",
"4934601", "Teutschenthal",
"492522", "Oelde",
"4936692", "Bürgel",
"4935605", "Komptendorf",
"499944", "Miltach",
"496571", "Wittlich",
"497532", "Meersburg",
"498146", "Moorenweis",
"495328", "Altenau\ Harz",
"492932", "Neheim\-Hüsten",
"495602", "Hessisch\ Lichtenau",
"496396", "Hinterweidenthal",
"4936427", "Dornburg\ Saale",
"495201", "Halle\ Westfalen",
"4937601", "Mülsen\ Skt\ Jacob",
"4938732", "Gallin\ bei\ Lübz",
"4938462", "Baumgarten",
"496824", "Ottweiler",
"4933633", "Spreenhagen",
"4933989", "Sadenbeck",
"4936337", "Schiedungen",
"492943", "Erwitte",
"497391", "Ehingen\ Donau",
"492052", "Velbert\-Langenberg",
"499269", "Tettau\ Kreis\ Kronach",
"497948", "Öhringen\-Ohrnberg",
"498565", "Dietersburg\-Baumgarten",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"495209", "Gütersloh\-Friedrichsdorf",
"492548", "Dülmen\-Rorup",
"499955", "Mamming",
"495148", "Steinhorst\ Niedersachsen",
"498326", "Fischen\ im\ Allgäu",
"497576", "Krauchenwies",
"497543", "Kressbronn\ am\ Bodensee",
"495481", "Lengerich\ Westfalen",
"4936651", "Lobenstein",
"499369", "Uettingen",
"492845", "Neukirchen\-Vluyn",
"496022", "Obernburg\ am\ Main",
"4938723", "Kladrum",
"498157", "Feldafing",
"495242", "Rheda\-Wiedenbrück",
"498226", "Bibertal",
"495309", "Lehre\-Wendhausen",
"495641", "Warburg",
"499853", "Wilburgstetten",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"498868", "Schwabsoien",
"494326", "Wankendorf",
"498092", "Grafing\ bei\ München",
"495725", "Lindhorst\ bei\ Stadthagen",
"495233", "Steinheim\ Westfalen",
"494146", "Stade\-Bützfleth",
"4933207", "Gross\ Kreutz",
"494173", "Wulfsen",
"4935937", "Prischwitz",
"495228", "Vlotho\-Exter",
"4933834", "Pritzerbe",
"493844", "Schwaan",
"496552", "Olzheim",
"495301", "Lehre\-Essenrode",
"496296", "Ahorn\ Baden",
"496467", "Hatzfeld\ Eder",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4933436", "Prötzel",
"496048", "Büdingen\-Eckartshausen",
"4933766", "Teupitz",
"495425", "Borgholzhausen",
"496232", "Speyer",
"499682", "Erbendorf",
"497158", "Neuhausen\ auf\ den\ Fildern",
"497271", "Wörth\ am\ Rhein",
"494521", "Eutin",
"497352", "Ochsenhausen",
"496631", "Alsfeld",
"499281", "Hof\ Saale",
"495769", "Steyerberg\-Voigtei",
"4936081", "Arenshausen",
"497672", "St\ Blasien",
"4935796", "Panschwitz\-Kuckau",
"492153", "Nettetal\-Lobberich",
"494947", "Aurich\-Ogenbargen",
"499409", "Pielenhofen",
"495553", "Kalefeld",
"4939991", "Daberkow",
"494805", "Schafstedt",
"494874", "Todenbüttel",
"496647", "Herbstein\-Stockhausen",
"498036", "Stephanskirchen\ Simssee",
"4938225", "Trinwillershagen",
"4934978", "Radegast\ Kreis\ Köthen",
"4933833", "Wollin\ bei\ Brandenburg",
"494931", "Norden",
"499145", "Solnhofen",
"494193", "Henstedt\-Ulzburg",
"499289", "Schwarzenbach\ am\ Wald",
"496639", "Ottrau",
"495761", "Stolzenau",
"499154", "Pommelsbrunn",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"499325", "Kleinlangheim",
"498072", "Haag\ in\ Oberbayern",
"494529", "Süsel\-Bujendorf",
"4938428", "Hohenkirchen\ bei\ Wismar",
"493338", "Bernau\ Brandenburg",
"499401", "Neutraubling",
"495506", "Adelebsen",
"4938485", "Dabel",
"498585", "Grainet",
"496243", "Monsheim",
"496276", "Hesseneck",
"496307", "Schopp",
"492626", "Selters\ Westferwald",
"499701", "Sandberg\ Unterfranken",
"497636", "Münstertal\ Schwarzwald",
"499566", "Meeder",
"4933966", "Dranse",
"4938724", "Siggelkow",
"4939952", "Grammentin",
"494939", "Baltrum",
"495461", "Bramsche\ Hase",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"498457", "Vohburg\ an\ der\ Donau",
"4936621", "Elsterberg\ bei\ Plauen",
"499952", "Eichendorf",
"499076", "Wittislingen",
"495345", "Baddeckenstedt",
"493871", "Parchim",
"493496", "Köthen\ Anhalt",
"498562", "Triftern",
"4933747", "Marzahna",
"49203", "Duisburg",
"4934297", "Liebertwolkwitz",
"4935843", "Hirschfelde\ bei\ Zittau",
"4934348", "Frohburg",
"496858", "Ottweiler\-Fürth",
"4939934", "Gross\ Plasten",
"492366", "Herten\ Westfalen",
"494473", "Emstek",
"494446", "Bakum\ Kreis\ Vechta",
"495605", "Kaufungen\ Hessen",
"492935", "Sundern\-Hachen",
"498686", "Petting",
"495674", "Grebenstein",
"494746", "Hagen\ bei\ Bremerhaven",
"496167", "Modautal",
"492525", "Beckum\-Neubeckum",
"495354", "Jerxheim",
"494773", "Lamstedt",
"492801", "Xanten",
"499665", "Königstein\ Oberpfalz",
"4937348", "Oberwiesenthal\ Kurort",
"496081", "Usingen",
"4937297", "Thum\ Sachsen",
"493663", "Schleiz",
"494666", "Ladelund",
"492453", "Heinsberg\-Randerath",
"4939328", "Rochau",
"4933082", "Menz\ Kreis\ Oberhavel",
"499745", "Wildflecken",
"497458", "Ebhausen",
"499445", "Neustadt\ an\ der\ Donau",
"4939933", "Vollrathsruhe",
"494849", "Hooge",
"4935844", "Oybin\ Kurort",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"496335", "Trulben",
"492753", "Erndtebrück",
"497255", "Graben\-Neudorf",
"498802", "Huglfing",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"494837", "Neuenkirchen\ Dithmarschen",
"499101", "Langenzenn",
"492406", "Herzogenrath",
"497244", "Weingarten\ Baden",
"4936482", "Triptis",
"499454", "Aufhausen\ Oberpfalz",
"497961", "Ellwangen\ Jagst",
"494493", "Friesoythe\-Gehlenberg",
"494793", "Hambergen",
"4937421", "Oelsnitz\ Vogtland",
"495161", "Walsrode",
"494841", "Husum\ Nordsee",
"492561", "Ahaus",
"495694", "Diemelstadt",
"4936607", "Niederpöllnitz",
"499621", "Amberg\ Oberpfalz",
"499222", "Presseck",
"498171", "Wolfratshausen",
"498258", "Sielenbach",
"4938751", "Picher",
"4935242", "Nossen",
"496573", "Gillenfeld",
"495331", "Wolfenbüttel",
"494152", "Geesthacht",
"499263", "Ludwigsstadt",
"494358", "Loose\ bei\ Eckernförde",
"499836", "Gunzenhausen\-Cronheim",
"4936426", "Ottendorf\ bei\ Stadtroda",
"495203", "Werther\ Westfalen",
"4939342", "Gladau",
"495347", "Burgdorf\ bei\ Salzgitter",
"4936336", "Klettenberg",
"492527", "Lippetal\-Lippborg",
"496165", "Breuberg",
"497520", "Bodnegg",
"495592", "Gleichen\-Bremke",
"492264", "Marienheide",
"4933230", "Börnicke\ Kreis\ Havelland",
"495130", "Wedemark",
"495127", "Harsum",
"492192", "Hückeswagen",
"498179", "Eurasburg\ an\ der\ Loisach",
"498650", "Marktschellenberg",
"498444", "Schweitenkirchen",
"4939329", "Möringen",
"498370", "Wiggensbach",
"492941", "Lippstadt",
"497393", "Munderkingen",
"494684", "Langeness\ Hallig",
"495339", "Gielde",
"4938792", "Lenzen\ \(Elbe\)",
"498744", "Gerzen",
"497541", "Friedrichshafen",
"495483", "Lienen",
"492937", "Arnsberg\-Oeventrop",
"495607", "Fuldatal",
"497930", "Boxberg\ Baden",
"499872", "Heilsbronn",
"496593", "Hillesheim\ Eifel",
"49511", "Hannover",
"498664", "Chieming",
"498191", "Landsberg\ am\ Lech",
"492384", "Welver",
"496129", "Schlangenbad",
"49251", "Münster",
"499447", "Essing",
"496782", "Birkenfeld\ Nahe",
"497257", "Bruchsal\-Untergrombach",
"498053", "Bad\ Endorf",
"496337", "Grossbundenbach",
"493622", "Waltershausen\ Thüringen",
"495926", "Engden",
"497126", "Burladingen\-Melchingen",
"499431", "Schwandorf",
"4937349", "Scheibenberg",
"496482", "Runkel",
"4937432", "Pausa\ Vogtland",
"495536", "Holzminden\-Neuhaus",
"496341", "Landau\ in\ der\ Pfalz",
"499747", "Geroda\ Bayern",
"49791", "Schwäbisch\ Hall",
"4933872", "Hohennauen",
"492378", "Fröndenberg\-Langschede",
"495572", "Bodenfelde",
"4937322", "Brand\-Erbisdorf",
"497373", "Zwiefalten",
"493385", "Rathenow",
"497346", "Illerkirchberg",
"495085", "Burgdorf\-Ehlershausen",
"499383", "Wiesentheid",
"497653", "Lenzkirch",
"498538", "Pocking\-Hartkirchen",
"494835", "Albersdorf\ Holstein",
"499439", "Neunburg\-Kemnath",
"4934322", "Rosswein",
"496202", "Schwetzingen",
"496349", "Billigheim\-Ingenheim",
"497821", "Lahr\ Schwarzwald",
"494452", "Zetel\-Neuenburg",
"492831", "Geldern",
"4938429", "Glasin",
"492974", "Schmallenberg\-Fredeburg",
"4936653", "Lehesten\ Thüringer\ Wald",
"497505", "Fronreute",
"4937430", "Eichigt",
"497574", "Gammertingen",
"496660", "Steinau\-Marjoss",
"498771", "Ergoldsbach",
"493362", "Erkner",
"494224", "Gross\ Ippener",
"495062", "Holle\ bei\ Hildesheim",
"495635", "Vöhl",
"492905", "Bestwig\-Ramsbeck",
"49931", "Würzburg",
"4930", "Berlin",
"494752", "Neuhaus\ Oste",
"498324", "Hindelang",
"499946", "Hohenwarth\ bei\ Kötzing",
"499973", "Furth\ im\ Wald",
"498144", "Grafrath",
"492839", "Straelen\-Herongen",
"495427", "Melle\-Buer",
"4933631", "Bad\ Saarow\-Pieskow",
"4939772", "Rothemühl",
"496465", "Breidenbach\ bei\ Biedenkopf",
"4937603", "Wildenfels",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"496826", "Bexbach",
"496765", "Gemünden\ Hunsrück",
"496394", "Bundenthal",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"496268", "Hüffenhardt",
"493904", "Haldensleben",
"495183", "Lamspringe",
"4933870", "Zollchow\ bei\ Rathenow",
"492583", "Sassenberg",
"4937320", "Mulda\ Sachsen",
"4939855", "Parmen\-Weggun",
"497726", "Bad\ Dürrheim",
"492736", "Burbach\ Siegerl",
"4934604", "Niemberg",
"496645", "Ulrichstein",
"496429", "Schweinsberg\ Hessen",
"499147", "Nennslingen",
"492994", "Marsberg\-Westheim",
"49541", "Osnabrück",
"49571", "Minden\ Westfalen",
"496182", "Seligenstadt",
"494945", "Grossefehn\-Timmel",
"4935240", "Tauscha\ bei\ Grossenhain",
"492436", "Wegberg\-Rödgen",
"4937604", "Mosel",
"497426", "Gosheim",
"499131", "Erlangen",
"496305", "Hochspeyer",
"494954", "Moormerland",
"4936871", "Bad\ Colberg\-Heldburg",
"4939972", "Walkendorf",
"496421", "Marburg",
"492472", "Monschau",
"492772", "Herborn\ Hessen",
"496721", "Bingen\ am\ Rhein",
"496063", "Bad\ König",
"493681", "Suhl",
"496440", "Kölschhausen",
"496654", "Gersfeld\ Rhön",
"4939085", "Zichtau",
"4933232", "Brieselang",
"496374", "Weilerbach",
"4934779", "Abberode",
"492104", "Mettmann",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"493741", "Plauen",
"495504", "Friedland\ Kreis\ Göttingen",
"494499", "Barssel",
"496205", "Hockenheim",
"492451", "Geilenkirchen",
"494832", "Meldorf",
"4935475", "Straupitz",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"493437", "Grimma",
"499564", "Bad\ Rodach",
"4939405", "Hötensleben",
"495082", "Langlingen",
"496408", "Buseck",
"493737", "Rochlitz",
"492751", "Bad\ Berleburg",
"499227", "Neuenmarkt",
"493382", "Lehnin",
"493441", "Zeitz",
"496274", "Waldbrunn\ Odenwald",
"492175", "Leichlingen\ Rheinland",
"492624", "Höhr\-Grenzhausen",
"497634", "Sulzburg",
"495850", "Neetze",
"4939295", "Zuchau",
"497963", "Adelmannsfelden",
"494491", "Friesoythe",
"496485", "Nentershausen\ Westerwald",
"499103", "Cadolzburg",
"4939208", "Loitsche",
"4933831", "Weseram",
"498807", "Diessen\ am\ Ammersee",
"497568", "Bad\ Wurzach\-Hauerz",
"492759", "Bad\ Berleburg\-Aue",
"4936083", "Uder",
"4933925", "Wustrau\-Altfriesack",
"496785", "Herrstein",
"4936606", "Kraftsdorf",
"494843", "Viöl",
"492563", "Stadtlohn",
"4939993", "Hohenmocker",
"494876", "Reher\ Holstein",
"499638", "Neualbenreuth",
"495163", "Fallingbostel\-Dorfmark",
"498034", "Brannenburg",
"494791", "Osterholz\-Scharmbeck",
"4936084", "Heuthen",
"494479", "Molbergen\-Peheim",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"499875", "Wolframs\-Eschenbach",
"495864", "Jameln",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"4939994", "Metschow",
"494144", "Himmelpforten",
"4939062", "Bebertal",
"4933848", "Raben",
"492856", "Hamminkeln\-Brünen",
"4933746", "Werbig\ bei\ Jüterbog",
"492195", "Radevormwald",
"499804", "Aurach",
"496294", "Krautheim\ Jagst",
"496162", "Reinheim\ Odenwald",
"494779", "Freiburg\ Elbe",
"4934296", "Groitzsch\ bei\ Pegau",
"494471", "Cloppenburg",
"498452", "Geisenfeld",
"494155", "Büchen",
"49921", "Bayreuth",
"493661", "Greiz",
"496083", "Weilrod",
"492803", "Wesel\-Büderich",
"498752", "Au\ in\ der\ Hallertau",
"494324", "Brokstedt",
"498224", "Offingen\ Donau",
"494771", "Hemmoor",
"4938721", "Ziegendorf",
"4937296", "Stollberg\ Erzgebirge",
"497808", "Hohberg\ bei\ Offenburg",
"496628", "Oberaula",
"4936624", "Teichwolframsdorf",
"495551", "Northeim",
"4939058", "Uthmöden",
"4937423", "Adorf\ Vogtland",
"492151", "Krefeld",
"4935797", "Schwepnitz",
"496633", "Homberg\ Ohm",
"499283", "Rehau",
"493329", "Stahnsdorf",
"492775", "Driedorf",
"497273", "Hagenbach\ Pfalz",
"497246", "Malsch\ Kreis\ Karlsruhe",
"494523", "Malente",
"492404", "Alsdorf\ Rheinland",
"494933", "Dornum\ Ostfriesland",
"496249", "Guntersblum",
"4934423", "Heuckewalde",
"496108", "Mühlheim\ am\ Main",
"494928", "Ihlow\-Riepe",
"496302", "Winnweiler",
"4939748", "Viereck",
"495696", "Bad\ Arolsen\-Landau",
"493774", "Schwarzenberg",
"492159", "Meerbusch\-Osterath",
"494942", "Südbrookmerland",
"499403", "Donaustauf",
"499094", "Tagmersheim",
"496185", "Hammersbach\ Hessen",
"4939931", "Röbel\ Müritz",
"495021", "Nienburg\ Weser",
"496220", "Wilhelmsfeld",
"497357", "Attenweiler",
"496237", "Maxdorf",
"494664", "Neukirchen\ bei\ Niebüll",
"495763", "Uchte",
"494191", "Kaltenkirchen\ Holstein",
"493321", "Nauen\ Brandenburg",
"496642", "Schlitz",
"4933967", "Freyenstein",
"4939888", "Lychen",
"496241", "Worms",
"4934928", "Seegrehna",
"4939825", "Wokuhl",
"4938305", "Gingst",
"492364", "Haltern\ Westfalen",
"494444", "Goldenstedt",
"496557", "Hallschlag",
"499088", "Mönchsdeggingen",
"498684", "Fridolfing",
"494179", "Winsen\-Tönnhausen",
"496762", "Kastellaun",
"496462", "Gladenbach",
"4935841", "Grossschönau\ Sachsen",
"4937368", "Deutschneudorf",
"495676", "Liebenau\ Hessen",
"495643", "Borgentreich",
"499851", "Dinkelsbühl",
"494744", "Loxstedt",
"495356", "Helmstedt\-Barmke",
"494755", "Ihlienworth",
"499074", "Höchstädt\ an\ der\ Donau",
"498678", "Marktl",
"497084", "Schömberg\ bei\ Neuenbürg",
"4933206", "Fichtenwalde",
"498152", "Herrsching\ am\ Ammersee",
"4933672", "Pfaffendorfb\ Beeskow",
"495065", "Sibbesse",
"4935936", "Sohland\ Spree",
"499363", "Arnstein\ Unterfranken",
"495632", "Willingen\ Upland",
"494258", "Schwarme",
"492902", "Warstein",
"4934424", "Reuden\ bei\ Zeitz",
"494171", "Winsen\ Luhe",
"496027", "Stockstadt\ am\ Main",
"495231", "Detmold",
"497502", "Wolpertswende",
"4936623", "Berga\ Elster",
"495247", "Harsewinkel",
"4938459", "Laage",
"493494", "Wolfen",
"4933437", "Reichenberg\ bei\ Strausberg",
"495303", "Wendeburg",
"494455", "Jade\-Schweiburg",
"4933767", "Friedersdorf\ bei\ Berlin",
"4934785", "Sandersleben",
"496569", "Bickendorf",
"4938426", "Neuburg\-Steinhausen",
"4935204", "Wilsdruff",
"497325", "Sontheim\ an\ der\ Brenz",
"496753", "Meisenheim",
"499279", "Mistelgau",
"4936041", "Bad\ Tennstedt",
"492335", "Wetter\ Ruhr",
"498082", "Schwindegg",
"497154", "Kornwestheim",
"495954", "Lorup",
"4934927", "Globig\-Bleddin",
"4938824", "Mallentin",
"497566", "Argenbühl",
"4939887", "Gerswalde",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"496453", "Gemünden\ Wohra",
"496286", "Walldürn\-Rippberg",
"499636", "Plössberg",
"498504", "Tittling",
"495034", "Neustadt\-Hagen",
"493334", "Eberswalde",
"49471", "Bremerhaven",
"496561", "Bitburg",
"499672", "Neunburg\ vorm\ Wald",
"496706", "Wallhausen\ Nahe",
"499271", "Thurnau\-Alladorf",
"499158", "Offenhausen\ Mittelfranken",
"495945", "Wilsum",
"497682", "Elzach",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"499352", "Lohr\ am\ Main",
"495807", "Altenmedingen",
"4939747", "Züsedom",
"4933733", "Stülpe",
"497145", "Markgröningen",
"496406", "Lollar",
"4934976", "Gröbzig",
"499867", "Geslau",
"494884", "Schwabstedt",
"49441", "Oldenburg",
"497709", "Wutach",
"4939775", "Ahlbeck\ bei\ Torgelow",
"4933734", "Felgentreu",
"497361", "Aalen",
"496055", "Freigericht",
"496809", "Grossrosseln",
"494183", "Jesteburg",
"4933768", "Prieros",
"4939852", "Schönermark\ bei\ Prenzlau",
"4933438", "Altlandsberg",
"497806", "Bad\ Peterstal\-Griesbach",
"493987", "Templin",
"494635", "Sörup",
"4938823", "Selmsdorf",
"4938231", "Barth",
"495224", "Enger\ Westfalen",
"49465", "Sylt",
"496525", "Irrel",
"4939082", "Mieste",
"495752", "Auetal\-Hattendorf",
"4934901", "Rosslau\ Elbe",
"4933235", "Friesack",
"496044", "Schotten\ Hessen",
"492858", "Hünxe",
"495452", "Mettingen\ Westfalen",
"4933933", "Lindow\ Mark",
"4935032", "Langenhennersdorf",
"4937367", "Lengefeld\ Erzgebirge",
"4939975", "Thürkow",
"497853", "Kehl\-Bodersweier",
"4935203", "Tharandt",
"4934776", "Rothenschirmbach",
"492647", "Kesseling",
"497454", "Sulz\ am\ Neckar",
"495835", "Wahrenholz",
"499961", "Mitterfels",
"4939207", "Colbitz",
"4934263", "Hohburg",
"499244", "Betzenstein",
"4938294", "Neubukow",
"4939345", "Parchen",
"497222", "Rastatt",
"498029", "Kreuth\ bei\ Tegernsee",
"492232", "Brühl\ Rheinland",
"497621", "Lörrach",
"493377", "Zossen\ Brandenburg",
"4935245", "Burkhardswalde\-Munzig",
"492631", "Neuwied",
"495901", "Fürstenau\ bei\ Bramsche",
"4934241", "Jesewitz",
"498551", "Freyung",
"497754", "Görwihl",
"494536", "Steinhorst\ Lauenburg",
"492243", "Eitorf",
"497745", "Jestetten",
"4935054", "Lauenstein\ Sachsen",
"497300", "Roggenburg",
"496626", "Wildeck\-Obersuhl",
"492307", "Kamen",
"497248", "Marxzell",
"498463", "Greding",
"4939080", "Kalbe\ Milde",
"497629", "Tegernau\ Baden",
"492639", "Anhausen\ Kreis\ Neuwied",
"495909", "Wettrup",
"499255", "Marktleugast",
"498021", "Waakirchen",
"494926", "Krummhörn\-Greetsiel",
"496106", "Rodgau",
"497445", "Pfalzgrafenweiler",
"494483", "Ovelgönne\-Grossenmeer",
"499925", "Bayerisch\ Eisenstein",
"493923", "Zerbst",
"4937435", "Reuth\ bei\ Plauen",
"4939481", "Hedersleben\ bei\ Aschersleben",
"496500", "Waldrach",
"494607", "Janneby",
"494256", "Hilgermissen",
"4934346", "Narsdorf",
"494127", "Westerhorn",
"4937346", "Geyer",
"493528", "Radeberg",
"497665", "March\ Breisgau",
"498239", "Langenneufnach",
"4935053", "Glashütte\ Sachsen",
"496071", "Dieburg",
"497032", "Herrenberg",
"495684", "Frielendorf",
"494339", "Christiansholm",
"499535", "Pfarrweisach",
"493533", "Elsterwerda",
"499086", "Fremdingen",
"498303", "Waltenhofen",
"493881", "Grevesmühlen",
"497952", "Gerabronn",
"497043", "Maulbronn",
"492296", "Reichshof\-Brüchermühle",
"498247", "Bad\ Wörishofen",
"4934325", "Mochau\-Lüttewitz",
"494347", "Flintbek",
"496854", "Oberthal\ Saar",
"493542", "Lübbenau\ Spreewald",
"494203", "Weyhe\ bei\ Bremen",
"498231", "Königsbrunn\ bei\ Augsburg",
"4933875", "Rhinow",
"4937325", "Niederbobritzsch",
"498065", "Tuntenhausen\-Schönau",
"495358", "Bahrdorf\-Mackendorf",
"495152", "Hessisch\ Oldendorf",
"4938871", "Mühlen\ Eichsen",
"4939221", "Möckern\ bei\ Magdeburg",
"494331", "Rendsburg",
"4938293", "Kühlungsborn\ Ostseebad",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4933847", "Görzke",
"492552", "Steinfurt\-Borghorst",
"498347", "Friesenried",
"497971", "Gaildorf",
"498203", "Grossaitingen",
"492824", "Kalkar",
"495455", "Tecklenburg\-Brochterbeck",
"497834", "Wolfach",
"494303", "Schlesen",
"494247", "Affinghausen",
"493693", "Meiningen",
"498331", "Memmingen",
"495755", "Kalletal\-Varenholz",
"494231", "Verden\ Aller",
"492571", "Greven\ Westfalen",
"496522", "Mettendorf",
"4938853", "Drönnewitz\ bei\ Hagenow",
"494632", "Steinbergkirche",
"495258", "Salzkotten",
"495171", "Peine",
"499823", "Leutershausen",
"494356", "Gross\ Wittensee",
"495744", "Hüllhorst",
"493501", "Pirna",
"4936921", "Wutha\-Farnroda",
"4938302", "Sagard",
"494643", "Gelting\ Angeln",
"4939822", "Kratzeburg",
"4939001", "Apenburg",
"496052", "Bad\ Orb",
"495650", "Cornberg",
"495444", "Wagenfeld",
"498783", "Rohr\ in\ Niederbayern",
"4937757", "Rittersgrün",
"493466", "Artern\ Unstrut",
"498592", "Wegscheid\ Niederbayern",
"494239", "Dörverden\-Westen",
"492207", "Kürten\-Dürscheid",
"492656", "Virneburg",
"493869", "Dümmer",
"494463", "Wangerland",
"498536", "Kösslarn",
"499604", "Wernberg\-Köblitz",
"497348", "Beimerstetten",
"497142", "Bietigheim\-Bissingen",
"497685", "Gutach\-Bleibach",
"494559", "Wensin",
"495942", "Uelsen",
"495053", "Fassberg\-Müden",
"499355", "Frammersbach",
"499675", "Altendorf\ am\ Nabburg",
"4939400", "Wefensleben",
"495191", "Soltau",
"494763", "Gnarrenburg",
"495664", "Morschen",
"49811", "Hallbergmoos",
"492591", "Lüdinghausen",
"495933", "Lathen",
"492603", "Bad\ Ems",
"4933209", "Caputh",
"493861", "Plate",
"496434", "Bad\ Camberg",
"4935939", "Hochkirch",
"4934782", "Mansfeld\ Südharz",
"4938854", "Redefin",
"499344", "Gerchsheim",
"498085", "Sankt\ Wolfgang",
"494551", "Bad\ Segeberg",
"4933675", "Tauche",
"497322", "Giengen\ an\ der\ Brenz",
"492332", "Gevelsberg",
"493306", "Gransee",
"497128", "Sonnenbühl",
"495523", "Bad\ Sachsa",
"4938456", "Langhagen\ bei\ Güstrow",
"496734", "Flonheim",
"492599", "Ascheberg\-Herbern",
"498572", "Tann\ Niederbayern",
"495199", "Schneverdingen\-Heber",
"497133", "Lauffen\ am\ Neckar",
"4933920", "Walsleben\ bei\ Neuruppin",
"495324", "Vienenburg",
"4939402", "Völpke",
"492555", "Schöppingen",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"499948", "Eschlkam",
"495155", "Emmerthal",
"496589", "Kell\ am\ See",
"497269", "Sulzfeld\ Baden",
"498635", "Pleiskirchen",
"498062", "Bruckmühl\ Mangfall",
"495771", "Rahden\ Westfalen",
"499391", "Marktheidenfeld",
"497586", "Herbertingen",
"495471", "Bohmte",
"499576", "Lichtenfels\-Isling",
"499543", "Hirschaid",
"4935472", "Schlepzig",
"497955", "Wallhausen\ Württemberg",
"496833", "Rehlingen\-Siersburg",
"496266", "Hassmersheim",
"499190", "Heroldsbach",
"496581", "Saarburg",
"497944", "Kupferzell",
"499532", "Maroldsweisach",
"4933922", "Karwesee",
"4935023", "Bad\ Gottleuba",
"498727", "Falkenberg\ Niederbayern",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"4935696", "Briesnig",
"497261", "Sinsheim",
"496842", "Blieskastel",
"4939292", "Biederitz",
"498427", "Wellheim",
"495144", "Wathlingen",
"494864", "Oldenswort",
"499922", "Zwiesel",
"497442", "Baiersbronn",
"499724", "Stadtlauringen",
"499371", "Miltenberg",
"499252", "Helmbrechts",
"494163", "Horneburg\ Niederelbe",
"497381", "Münsingen",
"49871", "Landshut",
"495843", "Wustrow\ Wendland",
"499651", "Vohenstrauss",
"4933362", "Liepe\ Kreis\ Barnim",
"49841", "Ingolstadt\ Donau",
"495491", "Damme\ Dümmer",
"496477", "Greifenstein\-Nenderoth",
"499424", "Strasskirchen",
"4935024", "Stadt\ Wehlen",
"497742", "Klettgau",
"493967", "Oertzenhof\ bei\ Strasburg",
"4934299", "Gaschwitz",
"492738", "Netphen",
"499170", "Schwanstetten",
"497728", "Niedereschach",
"496134", "Mainz\-Kastel",
"497389", "Heroldstatt",
"499659", "Leuchtenberg",
"492723", "Kirchhundem",
"4936459", "Blankenhain\ Thüringen",
"497225", "Gaggenau",
"492235", "Erftstadt",
"497733", "Engen\ Hegau",
"497433", "Balingen",
"492423", "Langerwehe",
"494504", "Ratekau",
"4938300", "Insel\ Hiddensee",
"4939820", "Triepkendorf",
"497428", "Rosenfeld",
"495832", "Hankensbüttel",
"496386", "Altenkirchen\ Pfalz",
"4933931", "Rheinsberg\ Mark",
"494342", "Preetz\ Kreis\ Plön",
"4934205", "Markranstädt",
"494148", "Drochtersen\-Assel",
"4936458", "Bad\ Berka",
"492462", "Linnich",
"494209", "Schwanewede",
"493921", "Burg\ bei\ Magdeburg",
"498641", "Grassau\ Kreis\ Traunstein",
"495226", "Bruchmühlen\ Westfalen",
"4935201", "Langebrück",
"494481", "Hatten\-Sandkrug",
"4934298", "Taucha\ bei\ Leipzig",
"497957", "Kressberg",
"4934347", "Oelzschau\ bei\ Borna",
"4935452", "Golssen",
"493531", "Finsterwalde",
"495157", "Emmerthal\-Börry",
"4937298", "Oelsnitz\ Erzgebirge",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"496364", "Nussbach\ Pfalz",
"496298", "Möckmühl",
"4936730", "Sitzendorf",
"492557", "Wettringen\ Kreis\ Steinfurt",
"4938233", "Prerow\ Ostseebad",
"4938821", "Lüdersdorf",
"496046", "Ortenberg\ Hessen",
"4934903", "Coswig\ Anhalt",
"496073", "Babenhausen\ Hessen",
"492762", "Wenden\ Südsauerland",
"498637", "Lohkirchen",
"49721", "Karlsruhe",
"494602", "Freienwill",
"494489", "Apen",
"497041", "Mühlacker",
"498649", "Schleching",
"493883", "Hagenow",
"494333", "Erfde",
"497804", "Oppenau",
"4934495", "Dobitschen",
"494328", "Rickling",
"4933748", "Treuenbrietzen",
"494122", "Uetersen",
"498233", "Kissing",
"4936255", "Goldbach\ bei\ Gotha",
"498725", "Wurmannsquick",
"4933846", "Dippmannsdorf",
"496475", "Weilmünster\-Wolfenhausen",
"496704", "Langenlonsheim",
"4939206", "Eichenbarleben",
"498469", "Freystadt\-Burggriesbach",
"4933731", "Trebbin",
"493965", "Burow\ bei\ Altentreptow",
"4938735", "Plau\ am\ See",
"495036", "Neustadt\-Schneeren",
"495508", "Gleichen\-Rittmarshausen",
"492302", "Witten",
"499963", "Konzell",
"498553", "Spiegelau",
"492628", "Rhens",
"496151", "Darmstadt",
"4936608", "Seelingstädt\ bei\ Gera",
"497623", "Rheinfelden\ Baden",
"4935602", "Drebkau",
"495903", "Emsbüren",
"4936695", "Söllmnitz",
"49201", "Essen",
"492633", "Brohl\-Lützing",
"496093", "Laufach",
"496404", "Lich\ Hessen",
"496775", "Strüth\ Taunus",
"499568", "Neustadt\ bei\ Coburg",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"498461", "Beilngries",
"497156", "Ditzingen",
"4938234", "Born\ Darss",
"492964", "Brilon\-Alme",
"4934904", "Oranienbaum",
"492642", "Remagen",
"4934658", "Hayn\ Harz",
"4939327", "Klietz",
"492241", "Siegburg",
"496159", "Messel",
"495585", "Herzberg\-Sieber",
"499634", "Wiesau",
"496284", "Mudau",
"498506", "Bad\ Höhenstadt",
"498038", "Vogtareuth",
"492237", "Kerpen\ Rheinland\-Türnich",
"495956", "Rastdorf",
"495072", "Neustadt\-Mandelsloh",
"497227", "Lichtenau\ Baden",
"498023", "Bayrischzell",
"497564", "Bad\ Wurzach",
"4936043", "Kirchheilingen",
"496670", "Ludwigsau\ Hessen",
"498761", "Moosburg\ an\ der\ Isar",
"493372", "Jüterbog",
"494181", "Buchholz\ in\ der\ Nordheide",
"4935600", "Döbern\ NL",
"497363", "Lauchheim",
"496856", "St\ Wendel\-Niederkirchen",
"4935938", "Grosspostwitz\ OL",
"496195", "Kelkheim\ Taunus",
"499084", "Bissingen\ Schwaben",
"4939831", "Feldberg",
"495562", "Dassel\-Markoldendorf",
"4933208", "Fahrland",
"4938873", "Carlow",
"4939223", "Theessen",
"492162", "Viersen",
"492294", "Morsbach\ Sieg",
"492368", "Oer\-Erkenschwick",
"4939925", "Wredenhagen",
"4935323", "Sonnewalde",
"494748", "Stubben\ bei\ Bremerhaven",
"498345", "Stöttwang",
"494245", "Neuenkirchen\ bei\ Bassum",
"4934244", "Mockrehna",
"499502", "Frensdorf",
"495457", "Hopsten\-Schale",
"4935433", "Vetschau",
"494254", "Eystrup",
"499293", "Berg\ Oberfranken",
"494189", "Undeloh",
"496803", "Mandelbachtal\-Ommersheim",
"494722", "Cuxhaven\-Altenbruch",
"499078", "Mertingen",
"4934745", "Winningen\ Sachsen\-Anhalt",
"495686", "Schwarzenborn\ Knüll",
"4939483", "Ballenstedt",
"494422", "Sande\ Kreis\ Friesl",
"497851", "Kehl",
"4937366", "Rübenau",
"4939484", "Harzgerode",
"492408", "Aachen\-Kornelimünster",
"499677", "Oberviechtach\-Pullenried",
"499357", "Gräfendorf\ Bayern",
"495802", "Wrestedt",
"496751", "Bad\ Sobernheim",
"4938427", "Blowatz",
"492680", "Mündersbach",
"494534", "Steinburg\ Kreis\ Storman",
"492274", "Elsdorf\ Rheinland",
"497403", "Dunningen",
"494260", "Visselhövede\-Wittorf",
"4936732", "Könitz",
"496624", "Heringen\ Werra",
"4936462", "Ossmannstedt",
"496175", "Friedrichsdorf\ Taunus",
"494924", "Moormerland\-Oldersum",
"4935434", "Altdöbern",
"496104", "Heusenstamm",
"4934926", "Pretzsch\ Elbe",
"49381", "Rostock",
"497703", "Bonndorf\ im\ Schwarzwald",
"492205", "Rösrath",
"4939886", "Milmersdorf",
"496451", "Frankenberg\ Eder",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"4935324", "Crinitz",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"499246", "Pegnitz\-Trockau",
"494668", "Klanxbüll",
"4939365", "Bellingen\ bei\ Stendal",
"497456", "Haiterbach",
"496563", "Kyllburg",
"4939056", "Klüden",
"498161", "Freising",
"4934243", "Bad\ Düben",
"4939746", "Krackow",
"4934261", "Kühren\ bei\ Wurzen",
"4938874", "Lützow",
"4934977", "Quellendorf",
"4939224", "Büden",
"492485", "Schleiden\-Dreiborn",
"4935265", "Glaubitz",
"497383", "Münsingen\-Buttenhausen",
"493375", "Königs\ Wusterhausen",
"495841", "Lüchow\ Wendland",
"499653", "Eslarn",
"499373", "Amorbach",
"497739", "Hilzingen",
"499346", "Grünsfeld",
"494161", "Buxtehude",
"492182", "Grevenbroich\-Kapellen",
"492388", "Hamm\-Uentrop",
"495582", "Sankt\ Andreasberg",
"496436", "Dornburg\ Hessen",
"496736", "Bechenheim",
"495837", "Sprakensehl",
"495820", "Suhlendorf",
"492645", "Vettelschoss",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"492429", "Hürtgenwald",
"4938220", "Wustrow\ Ostseebad",
"493304", "Velten",
"492721", "Lennestadt",
"499257", "Zell\ Oberfranken",
"499606", "Pfreimd",
"498534", "Tettenweis",
"496772", "Nastätten",
"494169", "Sauensiek",
"497731", "Singen\ Hohentwiel",
"495849", "Waddeweitz",
"4936924", "Mihla",
"497447", "Baiersbronn\-Schwarzenberg",
"492440", "Nettersheim\-Tondorf",
"492654", "Polch",
"4939004", "Köckte\ bei\ Gardelegen",
"492374", "Iserlohn\-Letmathe",
"492305", "Castrop\-Rauxel",
"49991", "Deggendorf",
"497747", "Berau",
"493962", "Penzlin\ bei\ Waren",
"493644", "Apolda",
"496472", "Weilmünster",
"499126", "Eckental",
"497431", "Albstadt\-Ebingen",
"492421", "Düren",
"494354", "Fleckeby",
"495773", "Stemwede\-Wehdem",
"495746", "Rödinghausen",
"499393", "Rothenfels\ Unterfranken",
"498722", "Gangkofen",
"497667", "Breisach\ am\ Rhein",
"493395", "Pritzwalk",
"498380", "Achberg",
"494674", "Ockholm",
"494125", "Seestermühe",
"498254", "Altomünster",
"4933972", "Breddin",
"4936338", "Bleicherode",
"493764", "Meerane",
"496831", "Saarlouis",
"493464", "Sangerhausen",
"4939382", "Kamern",
"499927", "Kirchberg\ Wald",
"4939003", "Jübar",
"4936923", "Treffurt",
"494605", "Medelby",
"495446", "Rehden",
"498422", "Dollnstein",
"4933085", "Seilershof",
"495473", "Ostercappeln",
"498067", "Tuntenhausen",
"492826", "Kranenburg\ Niederrhein",
"497263", "Waibstadt",
"497836", "Schiltach",
"492268", "Kürten",
"4938851", "Zarrentin",
"4935697", "Bagenz",
"492394", "Neuenrade\-Affeln",
"496583", "Palzem",
"498245", "Türkheim\ Wertach",
"4936428", "Stadtroda",
"499549", "Lisberg",
"492465", "Inden",
"496136", "Nieder\-Olm",
"492482", "Hellenthal",
"494461", "Jever",
"495939", "Sustrum",
"495529", "Rhumspringe",
"492593", "Ascheberg\ Westfalen",
"49651", "Trier",
"492129", "Haan\ Rheinland",
"4933970", "Neustadt\ Dosse",
"496384", "Konken",
"497139", "Neuenstadt\ am\ Kocher",
"494761", "Bremervörde",
"495193", "Schneverdingen",
"494506", "Stockelsdorf\-Krumbeck",
"492337", "Hagen\-Dahl",
"495051", "Bergen\ Kreis\ Celle",
"493671", "Saalfeld\ Saale",
"497327", "Dischingen",
"497147", "Sachsenheim\ Württemberg",
"495874", "Soltendieck",
"494958", "Jemgum",
"492202", "Bergisch\ Gladbach",
"493863", "Crivitz",
"495931", "Meppen",
"492601", "Nauort",
"494469", "Wangerooge",
"499726", "Euerbach",
"499865", "Adelshofen\ Mittelfranken",
"4934956", "Zörbig",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"494769", "Bremervörde\-Iselersheim",
"497131", "Heilbronn\ Neckar",
"499426", "Oberschneiding",
"495521", "Herzberg\ am\ Harz",
"496658", "Poppenhausen\ Wasserkuppe",
"4938457", "Krakow\ am\ See",
"494553", "Geschendorf",
"495805", "Oetzen",
"493679", "Neuhaus\ am\ Rennweg",
"495947", "Laar\ Vechte",
"4933439", "Fredersdorf\-Vogelsdorf",
"4933769", "Töpchin",
"4938222", "Semlow",
"499829", "Flachslanden",
"494425", "Wangerland\-Hooksiel",
"497946", "Bretzfeld",
"497973", "Obersontheim",
"498328", "Balderschwang",
"495173", "Uetze",
"495146", "Wietze",
"498122", "Erding",
"492573", "Nordwalde",
"494233", "Blender",
"492546", "Coesfeld\-Lette",
"494725", "Helgoland",
"493691", "Eisenach\ Thüringen",
"498333", "Babenhausen\ Schwaben",
"496057", "Flörsbachtal",
"497578", "Wald\ Hohenz",
"4935021", "Königstein\ Sächsische\ Schweiz",
"494641", "Süderbrarup",
"499505", "Litzendorf",
"492984", "Hallenberg",
"494242", "Syke",
"498342", "Marktoberdorf",
"495326", "Langelsheim",
"4939955", "Jürgenstorf",
"492165", "Jüchen",
"496527", "Oberweis",
"496192", "Hofheim\ am\ Taunus",
"495565", "Einbeck\-Wenzen",
"496398", "Vorderweidenthal",
"4937756", "Breitenbrunn\ Erzgebirge",
"494637", "Sterup",
"496264", "Neudenau",
"497584", "Altshausen",
"4933969", "Stepenitz",
"49731", "Ulm\ Donau",
"498781", "Rottenburg\ an\ der\ Laaber",
"4938482", "Warin",
"499574", "Marktzeuln",
"4935754", "Klettwitz",
"492377", "Wickede\ Ruhr",
"498393", "Holzgünz",
"499722", "Werneck",
"493631", "Nordhausen\ Thüringen",
"497444", "Alpirsbach",
"492206", "Overath",
"492657", "Uersfeld",
"498537", "Bad\ Füssing\-Aigen",
"499254", "Gefrees",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4937292", "Oederan",
"494293", "Ottersberg\-Fischerhude",
"4934292", "Brandis\ bei\ Wurzen",
"493647", "Pössneck",
"497744", "Stühlingen",
"498541", "Vilshofen\ Niederbayern",
"4936452", "Berlstedt",
"499422", "Bogen\ Niederbayern",
"4936371", "Schlossvippach",
"4936201", "Walschleben",
"4933369", "Oderberg",
"497755", "Weilheim\ Kreis\ Waldshut",
"499448", "Hausen\ Niederbayern",
"492253", "Bad\ Münstereifel",
"496323", "Edenkoben",
"4933742", "Oehna\ Brandenburg",
"492486", "Nettersheim",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"496338", "Hornbach\ Pfalz",
"497258", "Oberderdingen\-Flehingen",
"497171", "Schwäbisch\ Gmünd",
"496132", "Ingelheim\ am\ Rhein",
"499245", "Obertrubach",
"495971", "Rheine",
"493307", "Zehdenick",
"4935953", "Burkau",
"494502", "Lübeck\-Travemünde",
"495834", "Wittingen\-Knesebeck",
"497455", "Dornhan",
"499748", "Motten",
"4933052", "Leegebruch",
"498549", "Vilshofen\-Pleinting",
"492528", "Ennigerloh\-Enniger",
"4935930", "Seitschen",
"498373", "Altusried",
"495128", "Hohenhameln",
"4935608", "Gross\ Ossnig",
"4935954", "Grossharthau",
"495322", "Bad\ Harzburg",
"4934691", "Könnern",
"498346", "Pforzen",
"494273", "Kirchdorf\ bei\ Sulingen",
"4935695", "Simmersdorf",
"492533", "Münster\-Nienberge",
"4936602", "Ronneburg\ Thüringen",
"494246", "Twistringen\-Heiligenloh",
"498064", "Au\ bei\ Bad\ Aibling",
"4933200", "Bergholz\-Rehbrücke",
"492923", "Lippetal\-Herzfeld",
"497933", "Creglingen",
"4933929", "Gühlen\-Glienicke",
"496855", "Freisen",
"495608", "Söhrewald",
"492938", "Ense",
"496196", "Bad\ Soden\ am\ Taunus",
"499534", "Burgpreppach",
"498257", "Inchenhofen",
"497053", "Bad\ Teinach\-Zavelstein",
"497942", "Neuenstein\ Württemberg",
"495685", "Knüllwald",
"499260", "Wilhelmsthal\ Oberfranken",
"497191", "Backnang",
"492058", "Wülfrath",
"496844", "Blieskastel\-Altheim",
"494357", "Sehestedt\ Eider",
"497664", "Freiburg\-Tiengen",
"4939409", "Eilsleben",
"4935753", "Grossräschen",
"4934652", "Allstedt",
"499924", "Bodenmais",
"494862", "Garding",
"492542", "Gescher",
"495142", "Eschede",
"4933087", "Bredereiche",
"494885", "Bergenhusen",
"4936964", "Dermbach\ Rhön",
"497144", "Marbach\ am\ Neckar",
"49234", "Bochum",
"499201", "Gesees",
"496776", "Dachsenhausen",
"496743", "Bacharach",
"499602", "Neustadt\ an\ der\ Waldnaab",
"496443", "Ehringshausen\ Dill",
"499122", "Schwabach",
"496476", "Mengerskirchen",
"4933202", "Töplitz",
"4933451", "Heckelberg",
"4933676", "Friedland\ bei\ Beeskow",
"495944", "Hoogstede",
"499333", "Sommerhausen",
"4935932", "Guttau",
"495035", "Gross\ Munzel",
"493966", "Cölpin",
"495662", "Felsberg\ Hessen",
"49335", "Frankfurt\ \(Oder\)",
"4938455", "Plaaz",
"495261", "Lemgo",
"493335", "Finowfurt",
"497471", "Hechingen",
"496432", "Diez",
"498505", "Hutthurm",
"495586", "Wieda",
"499481", "Pfatter",
"499342", "Wertheim",
"495955", "Esterwegen",
"499148", "Ettenstatt",
"498821", "Garmisch\-Partenkirchen",
"4936741", "Bad\ Blankenburg",
"499209", "Emtmannsberg",
"492334", "Hagen\-Hohenlimburg",
"49212", "Solingen",
"497324", "Herbrechtingen",
"496387", "Sankt\ Julian",
"498574", "Wittibreut",
"497771", "Stockach",
"496732", "Wörrstadt",
"4936764", "Neuhaus\-Schierschnitz",
"495433", "Badbergen",
"4933601", "Podelzig",
"4936450", "Kranichfeld",
"495428", "Melle\-Neuenkirchen",
"496045", "Gedern",
"497832", "Haslach\ im\ Kinzigtal",
"4939957", "Gielow",
"496871", "Wadern",
"492822", "Emmerich",
"4936738", "Königsee",
"497587", "Hosskirch",
"4934633", "Braunsbedra",
"496267", "Fahrenbach\ Baden",
"494634", "Husby",
"495733", "Vlotho",
"4938309", "Trent",
"496524", "Rodershausen",
"495225", "Spenge",
"4939829", "Blankenförde",
"494963", "Dörpen",
"4936941", "Wasungen",
"498726", "Schönau\ Niederbayern",
"495742", "Preussisch\ Oldendorf",
"498426", "Walting\ Kreis\ Eichstätt",
"495442", "Barnstorf\ Kreis\ Diepholz",
"4936963", "Dorndorf\ Rhön",
"496054", "Birstein",
"496663", "Steinau\ an\ der\ Strasse",
"497843", "Renchen",
"495381", "Seesen",
"495145", "Beedenbostel",
"499469", "Roding\-Neubäu",
"492545", "Rosendahl\-Darfeld",
"494865", "Osterhever",
"4933474", "Neutrebbin",
"4935723", "Bernsdorf\ OL",
"499553", "Ebrach\ Oberfranken",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4934497", "Langenleuba\-Niederhain",
"497034", "Ehningen",
"4933876", "Buschow",
"4937326", "Frauenstein\ Sachsen",
"495281", "Bad\ Pyrmont",
"494426", "Wangerland\-Horumersiel",
"497807", "Neuried\ Ortenaukreis",
"4936257", "Luisenthal\ Thüringen",
"495682", "Borken\ Hessen",
"497945", "Wüstenrot",
"499461", "Roding",
"4934207", "Zwochau",
"4936074", "Worbis",
"492166", "Mönchengladbach\-Rheydt",
"4935341", "Bad\ Liebenwerda",
"497954", "Kirchberg\ an\ der\ Jagst",
"4939263", "Unseburg",
"4937436", "Weischlitz",
"496852", "Nohfelden",
"493544", "Luckau\ Brandenburg",
"4934345", "Bad\ Lausick",
"498634", "Garching\ an\ der\ Alz",
"495401", "Georgsmarienhütte",
"4933394", "Blumberg\ Kreis\ Barnim",
"492554", "Laer\ Kreis\ Steinfurt",
"4939241", "Leitzkau",
"495325", "Goslar\-Hahnenklee",
"4935363", "Fermerswalde",
"495154", "Aerzen",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"4937207", "Hainichen\ Sachsen",
"4938796", "Viesecke",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"494821", "Itzehoe",
"497452", "Nagold",
"494505", "Stockelsdorf\-Curau",
"499641", "Grafenwöhr",
"4939325", "Vinzelberg",
"495853", "Neu\ Darchau",
"4939388", "Goldbeck\ Altm",
"499242", "Gössweinstein",
"4935364", "Lebusa",
"497567", "Leutkirch\-Friesenhofen",
"4936332", "Ellrich",
"496135", "Bodenheim\ Rhein",
"498808", "Pähl",
"4933978", "Segeletz",
"492234", "Frechen",
"497224", "Gernsbach",
"4939264", "Kroppenstedt",
"4934221", "Schildau\ Gneisenaustadt",
"499637", "Falkenberg\ Oberpfalz",
"496287", "Limbach\ Baden",
"494829", "Wewelsfleth",
"4936422", "Reinstädt\ Thüringen",
"493423", "Eilenburg",
"4938737", "Ganzlin",
"495806", "Barum\ bei\ Bad\ Bevensen",
"4939346", "Tucheim",
"496707", "Windesheim",
"496407", "Rabenau\ Hessen",
"4935246", "Ziegenhain\ Sachsen",
"499228", "Thurnau",
"4933473", "Zechin",
"493723", "Hohenstein\-Ernstthal",
"495361", "Wolfsburg",
"499233", "Arzberg\ Oberfranken",
"496683", "Ehrenberg\ Rhön",
"4935724", "Lohsa",
"499725", "Poppenhausen\ Unterfranken",
"492693", "Antweiler",
"4938783", "Dallmin",
"499360", "Thüngen",
"498677", "Burghausen\ Salzach",
"496033", "Butzbach",
"49661", "Fulda",
"4936330", "Grossberndten",
"494606", "Wanderup",
"494257", "Schweringen",
"493571", "Hoyerswerda",
"495445", "Drebber",
"496028", "Sulzbach\ am\ Main",
"495745", "Stemwede\-Levern",
"498862", "Steingaden\ Oberbayern",
"4935771", "Bad\ Muskau",
"495300", "Salzgitter\-Üfingen",
"494126", "Horst\ Holstein",
"4939089", "Bismark\ Altmark",
"49491", "Leer\ Ostfriesland",
"492509", "Nottuln\-Appelhülsen",
"495248", "Langenberg\ Kreis\ Gütersloh",
"4939976", "Gross\ Bützin",
"4934775", "Wippra",
"495109", "Ronnenberg",
"498273", "Nordendorf",
"492297", "Wildbergerhütte",
"498246", "Waal",
"4939859", "Fürstenwerder",
"495222", "Bad\ Salzuflen",
"496558", "Büdesheim\ Eifel",
"499087", "Marktoffingen",
"4938843", "Bennin",
"495621", "Bad\ Wildungen",
"495754", "Extertal\-Bremke",
"494346", "Gettorf",
"499161", "Neustadt\ an\ der\ Aisch",
"4939927", "Nossentiner\ Hütte",
"497835", "Zell\ am\ Harmersbach",
"492825", "Uedem",
"495454", "Hörstel\-Riesenbeck",
"496042", "Büdingen\ Hessen",
"495101", "Pattensen",
"492501", "Münster\-Hiltrup",
"496223", "Neckargemünd",
"492353", "Halver",
"4933657", "Steinsdorf\ Brandenburg",
"496735", "Eppelsheim",
"492646", "Königsfeld\ Eifel",
"492673", "Ellenz\-Poltersdorf",
"496238", "Dirmstein",
"498084", "Taufkirchen\ Vils",
"497152", "Leonberg\ Württemberg",
"497358", "Eberhardzell\-Füramoos",
"493591", "Bautzen",
"4935895", "Klitten",
"4936021", "Schlotheim",
"4938844", "Gülze",
"499345", "Külsheim\ Baden",
"495043", "Lauenau",
"4935971", "Sebnitz",
"495952", "Sögel",
"4933331", "Casekow",
"4934975", "Görzig\ Kreis\ Köthen",
"4938228", "Dettmannsdorf\-Kölzow",
"498502", "Fürstenzell",
"496435", "Wallmerod",
"4935267", "Diesbar\-Seusslitz",
"4939776", "Hintersee",
"499280", "Selbitz\ Oberfranken",
"496630", "Schwalmtal\-Storndorf",
"492306", "Lünen",
"496627", "Nentershausen\ Hessen",
"4938488", "Demen",
"493332", "Schwedt\/Oder",
"494537", "Sülfeld\ Holstein",
"495032", "Neustadt\ am\ Rübenberge",
"4938425", "Kirchdorf\ Poel",
"498293", "Welden\ bei\ Augsburg",
"495665", "Guxhagen",
"499354", "Rieneck",
"494393", "Boostedt",
"497684", "Glottertal",
"499674", "Schönsee",
"4938784", "Kleinow\ Kreis\ Prignitz",
"492861", "Borken\ Westfalen",
"499605", "Weiherhammer",
"494541", "Ratzeburg",
"493603", "Bad\ Langensalza",
"4939727", "Spantekow",
"494927", "Krummhörn\-Loquard",
"494882", "Lunden",
"496107", "Kelsterbach",
"496873", "Nonnweiler",
"4935751", "Welzow",
"497666", "Denzlingen",
"499536", "Kirchlauter",
"4933962", "Heiligengrabe",
"494458", "Wiefelstede\-Spohle",
"4939956", "Neukalen",
"4933094", "Löwenberg",
"495431", "Quakenbrück",
"496669", "Neuhof\-Hauswurz",
"495731", "Bad\ Oeynhausen",
"499926", "Frauenau",
"494758", "Nordleda",
"4937755", "Schönheide\ Erzgebirge",
"498124", "Forstern\ Oberbayern",
"4936374", "Weissensee",
"495447", "Lembruch",
"4936204", "Stotternheim",
"49911", "Nuremberg",
"495068", "Elze\ Leine",
"494255", "Martfeld",
"494244", "Harpstedt",
"498066", "Bad\ Feilnbach",
"492827", "Goch\-Hassum",
"492982", "Medebach",
"497837", "Oberharmersbach",
"495439", "Bersenbrück",
"494961", "Papenburg",
"498344", "Westendorf\ bei\ Kaufbeuren",
"497841", "Achern",
"496262", "Aglasterhausen",
"499085", "Alerheim",
"495383", "Lutter\ am\ Barenberge",
"4938229", "Bad\ Sülze",
"496661", "Schlüchtern",
"492295", "Ruppichteroth",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"4935792", "Ossling",
"499572", "Burgkunstadt",
"497582", "Bad\ Buchau",
"49281", "Wesel",
"492484", "Mechernich\-Eiserfey",
"4935951", "Neukirch\ Lausitz",
"496741", "St\ Goar",
"499347", "Wittighausen",
"499203", "Neudrossenfeld",
"496893", "Saarbrücken\-Ensheim",
"496420", "Lahntal",
"4939858", "Bietikow",
"4934955", "Gossa",
"4933432", "Müncheberg",
"4933762", "Zeuthen",
"496382", "Lauterecken",
"495836", "Wittingen\-Radenbeck",
"495263", "Barntrup",
"496188", "Kahl\ am\ Main",
"499331", "Ochsenfurt",
"496737", "Köngernheim",
"4933677", "Glienicke\ bei\ Beeskow",
"496441", "Wetzlar",
"498823", "Mittenwald",
"495872", "Stoetze",
"499256", "Stammbach",
"499607", "Luhe\-Wildenau",
"4936203", "Vieselbach",
"496105", "Mörfelden\-Walldorf",
"4936373", "Buttstädt",
"494925", "Hinte",
"497473", "Mössingen",
"492204", "Bensberg",
"497446", "Lossburg",
"497746", "Wutöschingen",
"499339", "Ippesheim",
"497773", "Bodman\-Ludwigshafen",
"494535", "Nahe",
"492275", "Kerpen\-Buir",
"496174", "Königstein\ im\ Taunus",
"496625", "Niederaula",
"4939088", "Letzlingen",
"499127", "Rosstal\ Mittelfranken",
"496449", "Ehringshausen\-Katzenfurt",
"492778", "Siegbach",
"4933093", "Fürstenberg\ Havel",
"495131", "Garbsen",
"494672", "Langenhorn",
"4939862", "Schmölln\ bei\ Prenzlau",
"4936961", "Bad\ Liebenstein",
"494271", "Sulingen",
"494158", "Roseburg",
"498724", "Massing",
"494352", "Damp",
"497947", "Forchtenberg",
"493762", "Crimmitschau",
"498252", "Schrobenhausen",
"497805", "Appenweier",
"49971", "Bad\ Kissingen",
"498651", "Bad\ Reichenhall",
"4933454", "Wölsickendorf\/Wollenberg",
"49941", "Regensburg",
"492547", "Rosendahl\-Osterwick",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"493462", "Bad\ Dürrenberg",
"495147", "Uetze\-Hänigsen",
"498424", "Nassenfels",
"492921", "Soest",
"4936943", "Bettenhausen\ Thüringen",
"496056", "Bad\ Soden\-Salmünster",
"497931", "Bad\ Mergentheim",
"497529", "Waldburg\ Württemberg",
"4939389", "Schollene",
"497193", "Sulzbach\ an\ der\ Murr",
"495139", "Burgwedel",
"498170", "Strasslach\-Dingharting",
"4936744", "Remda",
"495327", "Bad\ Grund\ Harz",
"497051", "Calw",
"498379", "Waltenhofen\-Oberdorf",
"492392", "Werdohl",
"494636", "Langballig",
"4933603", "Falkenhagen\ bei\ Seelow",
"496526", "Bollendorf",
"497939", "Schrozberg\-Spielbach",
"4933979", "Wusterhausen\ Dosse",
"496003", "Rosbach\ von\ der\ Höhe",
"4933086", "Grieben\ Kreis\ Oberhavel",
"496788", "Sien",
"4936761", "Heubisch",
"496120", "Aarbergen",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"493628", "Arnstadt",
"4933604", "Lebus",
"499635", "Bärnau",
"496285", "Walldürn\-Altheim",
"49531", "Braunschweig",
"495584", "Hattorf\ am\ Harz",
"496329", "Weidenthal\ Pfalz",
"498543", "Aidenbach",
"492336", "Schwelm",
"493302", "Hennigsdorf",
"497326", "Neresheim",
"4936743", "Teichel",
"497146", "Remseck\ am\ Neckar",
"497173", "Heubach",
"496774", "Kaub",
"499183", "Burgthann",
"496405", "Laubach\ Hessen",
"498532", "Griesbach\ im\ Rottal",
"499727", "Schonungen\-Marktsteinach",
"492251", "Euskirchen",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"492372", "Hemer",
"492652", "Mendig",
"4936944", "Rentwertshausen",
"4937382", "Geringswalde",
"4934382", "Nerchau",
"493964", "Bredenfelde\ bei\ Strasburg",
"499427", "Leiblfing",
"496474", "Villmar\-Aumenau",
"496340", "Wörth\-Schaidt",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"495946", "Georgsdorf",
"4933656", "Bahro",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4939366", "Kehnert",
"493337", "Biesenthal\ Brandenburg",
"496622", "Bebra",
"492671", "Cochem",
"496221", "Heidelberg",
"492351", "Lüdenscheid",
"495037", "Bad\ Rehburg",
"492272", "Bedburg\ Erft",
"494532", "Bargteheide",
"4939055", "Hörsingen",
"4939745", "Hetzdorf\ bei\ Strasburg",
"496102", "Neu\-Isenburg",
"496308", "Olsbrücken",
"494922", "Borkum",
"493998", "Demmin",
"495041", "Springe\ Deister",
"4939777", "Borkenfriede",
"4935266", "Heyda\ bei\ Riesa",
"495875", "Emmendorf",
"493341", "Strausberg",
"492150", "Meerbusch\-Lank",
"497157", "Waldenbuch",
"4936071", "Teistungen",
"496229", "Neckarsteinach",
"492359", "Kierspe",
"4934223", "Dommitzsch",
"498291", "Zusmarshausen",
"49521", "Bielefeld",
"496385", "Reichenbach\-Steegen",
"494948", "Wiesmoor\-Marcardsmoor",
"496648", "Bad\ Salzschlirf",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"4934925", "Bad\ Schmiedeberg",
"4938308", "Göhren\ Rügen",
"4939885", "Jakobshagen",
"498507", "Neuburg\ am\ Inn",
"4939726", "Ducherow",
"493601", "Mühlhausen\ Thüringen",
"492236", "Wesseling\ Rheinland",
"495957", "Lindern\ Oldenburg",
"4936739", "Rottenbach",
"4939244", "Steutz",
"492863", "Velen",
"494543", "Nusse",
"497226", "Bühl\-Sand",
"493573", "Senftenberg",
"493546", "Lübben\ Spreewald",
"497585", "Ostrach",
"499575", "Weismain",
"492292", "Windeck\ Sieg",
"497072", "Gomaringen",
"496031", "Friedberg\ Hessen",
"4935361", "Schlieben",
"492164", "Jüchen\-Otzenrath",
"496265", "Billigheim\ Baden",
"492691", "Adenau",
"4939243", "Nedlitz\ bei\ Zerbst",
"4933237", "Paulinenaue",
"499082", "Oettingen\ in\ Bayern",
"495564", "Dassel",
"492556", "Metelen",
"4934746", "Giersleben",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"495156", "Coppenbrügge",
"496468", "Dautphetal\-Mornshausen",
"492985", "Winterberg\-Niedersfeld",
"4934224", "Belgern\ Sachsen",
"4939977", "Jördenstorf",
"499504", "Stadelhofen",
"4937365", "Sayda",
"498636", "Ampfing",
"496047", "Altenstadt\ Hessen",
"494371", "Burg\ auf\ Fehmarn",
"499163", "Dachsbach",
"494252", "Bruchhausen\-Vilsen",
"497903", "Mainhardt",
"495623", "Edertal",
"494724", "Cuxhaven\-Lüdingworth",
"498271", "Meitingen",
"498158", "Tutzing",
"496039", "Karben",
"49208", "Oberhausen\ Rheinland",
"4939926", "Grabowhöfe",
"493984", "Prenzlau",
"495103", "Wennigsen\ Deister",
"498867", "Rottenbuch\ Oberbayern",
"4938797", "Karstädt\ Kreis\ Prignitz",
"499356", "Burgsinn",
"494838", "Tellingstedt",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"495851", "Dahlenburg",
"499676", "Winklarn",
"4935478", "Goyatz",
"494823", "Wilster",
"492304", "Schwerte",
"492655", "Weibern",
"492375", "Balve",
"4935774", "Boxberg\ Sachsen",
"496402", "Hungen",
"498535", "Haarbach",
"4939408", "Hadmersleben",
"495859", "Thomasburg",
"4939205", "Langenweddingen",
"498086", "Buchbach\ Oberbayern",
"492962", "Olsberg",
"4935973", "Stolpen",
"499303", "Eibelstadt",
"4938736", "Goldberg",
"4935609", "Drachhausen",
"493421", "Torgau",
"4938466", "Jürgenshagen",
"492644", "Linz\ am\ Rhein",
"4933333", "Tantow",
"497457", "Rottenburg\-Ergenzingen",
"4939347", "Kade",
"4939298", "Barby\ Elbe",
"499231", "Marktredwitz",
"496681", "Hilders",
"492750", "Diedenshausen",
"493721", "Meinersdorf",
"4935247", "Zehren\ Sachsen",
"499632", "Waldsassen",
"496282", "Walldürn",
"495363", "Wolfsburg\-Vorsfelde",
"4933928", "Wildberg\ Brandenburg",
"497562", "Isny\ im\ Allgäu",
"4936023", "Horsmar",
"495074", "Rodewald",
"496857", "Namborn",
"492464", "Aldenhoven\ bei\ Jülich",
"494344", "Schönberg\ Holstein",
"4936024", "Diedorf\ bei\ Mühlhausen",
"4934327", "Waldheim\ Sachsen",
"4933368", "Hohensaaten",
"4938841", "Neuhaus\ Elbe",
"4934496", "Nöbdenitz",
"492395", "Finnentrop\-Rönkhausen",
"4935974", "Hinterhermsdorf",
"4933877", "Nitzahn",
"496362", "Alsenz",
"495283", "Lügde\-Rischenau",
"4937327", "Rechenberg\-Bienenmühle",
"492764", "Welschen\ Ennest",
"495456", "Westerkappeln\-Velpe",
"4936256", "Wechmar",
"499551", "Burgwindheim",
"4933845", "Borkheide",
"4933334", "Greiffenberg",
"494770", "Wischhafen",
"4934206", "Rötha",
"494604", "Grossenwiehe",
"4934672", "Rossleben",
"498458", "Gaimersheim",
"4935773", "Schleife",
"4937437", "Bad\ Elster",
"495703", "Hille",
"499463", "Wald\ Oberpfalz",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"493765", "Reichenbach\ Vogtland",
"4938781", "Mellen",
"497802", "Oberkirch\ Baden",
"495403", "Bad\ Iburg",
"494355", "Rieseby",
"494124", "Glückstadt",
"4937206", "Frankenberg\ Sachsen",
"493394", "Wittstock\ Dosse",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4939348", "Klitsche",
"496869", "Merzig\-Silwingen",
"498041", "Bad\ Tölz",
"494946", "Grossefehn\-Bagband",
"494973", "Wittmund\-Burhafe",
"497425", "Trossingen",
"4938374", "Lassan\ bei\ Wolgast",
"492435", "Erkelenz\-Lövenich",
"4938204", "Broderstorf",
"497233", "Niefern\-Öschelbronn",
"492735", "Neunkirchen\ Siegerl",
"497725", "Königsfeld\ im\ Schwarzwald",
"498020", "Weyarn",
"492223", "Königswinter",
"496353", "Freinsheim",
"496673", "Haunetal",
"496646", "Grebenau",
"4933927", "Linum",
"497228", "Forbach",
"4935248", "Schönfeld\ bei\ Grossenhain",
"492238", "Pulheim",
"496861", "Merzig",
"497242", "Rheinstetten",
"4939386", "Seehausen\ Altmark",
"497641", "Emmendingen",
"497309", "Weissenhorn",
"4935477", "Rietzneuendorf\-Friedrichshof",
"4934441", "Hohenmölsen",
"495507", "Ebergötzen",
"4937463", "Bergen\ Vogtland",
"499452", "Langquaid",
"4933701", "Grossbeeren",
"497620", "Schopfheim\-Gersbach",
"493996", "Teterow",
"495692", "Wolfhagen",
"496306", "Trippstadt",
"492627", "Braubach",
"4939407", "Seehausen\ Börde",
"49821", "Augsburg",
"492630", "Mülheim\-Kärlich",
"4934463", "Bad\ Kösen",
"498550", "Philippsreut",
"499567", "Sesslach\-Gemünda",
"4933976", "Wutike",
"4933089", "Himmelpfort",
"49431", "Kiel",
"495636", "Lichtenfels\-Goddelsheim",
"4934464", "Freyburg\ Unstrut",
"496509", "Büdlich",
"4937438", "Bad\ Brambach",
"497461", "Tuttlingen",
"4939421", "Osterwieck",
"499954", "Simbach\ Niederbayern",
"498564", "Johanniskirchen",
"497761", "Bad\ Säckingen",
"494139", "Hohnstorf\ Elbe",
"496693", "Neuental",
"498230", "Gablingen",
"49261", "Koblenz\ am\ Rhein",
"497023", "Weilheim\ an\ der\ Teck",
"494330", "Emkendorf",
"4937464", "Schöneck\ Vogtland",
"494327", "Grossenaspe",
"493522", "Grossenhain\ Sachsen",
"497506", "Wangen\-Leupolz",
"496766", "Kisselbach",
"496825", "Illingen\ Saar",
"4934385", "Mutzschen",
"4933367", "Friedrichswalde\ Brandenburg",
"492953", "Wünnenberg",
"4935823", "Ostritz",
"4934328", "Hartha\ bei\ Döbeln",
"496501", "Konz",
"497958", "Rot\ Am\ See\-Brettheim",
"495352", "Schöningen",
"496297", "Ravenstein\ Baden",
"495271", "Höxter",
"499945", "Arnbruck",
"495158", "Hemeringen",
"498623", "Kirchweidach",
"493943", "Wernigerode",
"492558", "Horstmar",
"495672", "Bad\ Karlshafen",
"494131", "Lüneburg",
"493976", "Torgelow\ bei\ Ueckermünde",
"4937328", "Grossschirma",
"498638", "Waldkraiburg",
"4938203", "Bad\ Doberan",
"497553", "Salem\ Baden",
"4933878", "Nennhausen",
"4938373", "Katzow",
"496466", "Dautphetal\-Friedensdorf",
"497125", "Bad\ Urach",
"497674", "Todtmoos",
"495535", "Polle",
"497354", "Erolzheim",
"496234", "Mutterstadt",
"494667", "Dagebüll",
"4937752", "Eibenstock",
"499270", "Creussen",
"499097", "Marxheim",
"4938486", "Gustävel",
"4939959", "Dargun",
"4939394", "Hohenberg\-Krusemark",
"494872", "Hanerau\-Hademarschen",
"4933965", "Herzsprung\ bei\ Wittstock",
"498851", "Kochel\ am\ See",
"4938307", "Poseritz",
"495925", "Wietmarschen",
"4939827", "Schwarz\ bei\ Neustrelitz",
"498074", "Schnaitsee",
"492407", "Herzogenrath\-Kohlscheid",
"4935795", "Königsbrück",
"499152", "Hartenstein\ Mittelfranken",
"494263", "Scheessel",
"4936702", "Lauscha",
"499358", "Gössenheim",
"494836", "Hennstedt\ Dithmarschen",
"498363", "Pfronten",
"492683", "Asbach\ Westerwald",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"4938226", "Dierhagen\ Ostseebad",
"493386", "Premnitz",
"497345", "Langenau\ Württemberg",
"495086", "Celle\-Scheuen",
"496024", "Schöllkrippen",
"497161", "Göppingen",
"498456", "Lenting",
"494383", "Grebin",
"499901", "Hengersberg\ Bayern",
"498283", "Neuburg\ an\ der\ Kammel",
"499077", "Bachhagel",
"494892", "Schenefeld\ Mittelholstein",
"495244", "Rietberg",
"496545", "Blankenrath",
"498756", "Nandlstadt",
"499835", "Ehingen\ Mittelfranken",
"4933765", "Märkisch\ Buchholz",
"495961", "Haselünne",
"4933435", "Rehfelde",
"4933238", "Senzke",
"4939393", "Werben\ Elbe",
"4938321", "Martensdorf\ bei\ Stralsund",
"493581", "Görlitz",
"498403", "Pförring",
"498094", "Steinhöring",
"494731", "Nordenham",
"495255", "Altenbeken",
"498687", "Taching\-Tengling",
"496554", "Waxweiler",
"492367", "Henrichenburg",
"494447", "Vechta\-Langförden",
"494747", "Beverstedt",
"496166", "Fischbachtal",
"4939978", "Gross\ Roge",
"494431", "Wildeshausen",
"498703", "Essenbach",
"492852", "Hamminkeln",
"495458", "Hopsten",
"499664", "Hahnbach",
"499191", "Forchheim\ Oberfranken",
"496580", "Zemmer",
"492267", "Wipperfürth",
"497260", "Sinsheim\-Hilsbach",
"495675", "Trendelburg",
"497534", "Reichenau\ Baden",
"495355", "Frellstedt",
"492524", "Ennigerloh",
"494403", "Bad\ Zwischenahn",
"499942", "Viechtach",
"498731", "Dingolfing",
"4937360", "Olbernhau",
"498431", "Neuburg\ an\ der\ Donau",
"494703", "Loxstedt\-Donnern",
"492934", "Sundern\-Altenhellefeld",
"495604", "Grossalmerode",
"492045", "Bottrop\-Kirchhellen",
"492871", "Bocholt",
"499199", "Kunreuth",
"494283", "Tarmstedt",
"497668", "Ihringen",
"493525", "Riesa",
"492054", "Essen\-Kettwig",
"496848", "Homburg\-Einöd",
"499523", "Hofheim\ in\ Unterfranken",
"492663", "Westerburg\ Westerwald",
"4935606", "Briesen\ bei\ Cottbus",
"498383", "Grünenbach\ Allgäu",
"494456", "Varel\-Altjührden",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4939033", "Wallstawe",
"4939451", "Wasserleben",
"495344", "Lengede",
"4939202", "Gross\ Ammensleben",
"494756", "Odisheim",
"499928", "Kirchdorf\ im\ Wald",
"493935", "Tangerhütte",
"495066", "Sarstedt",
"493366", "Beeskow",
"49395", "Neubrandenburg",
"499933", "Wallersdorf",
"494363", "Lensahn",
"4939034", "Fleetmark",
"499171", "Roth\ Mittelfranken",
"492443", "Mechernich",
"4939050", "Bartensleben",
"497181", "Schorndorf\ Württemberg",
"497448", "Seewald",
"498263", "Breitenbrunn\ Schwaben",
"495695", "Twistetal",
"497748", "Grafenhausen\ Hochschwarzwald",
"494859", "Windbergen",
"4939740", "Nechlin",
"497245", "Durmersheim",
"4936259", "Tabarz\ Thüringer\ Wald",
"492743", "Daaden",
"492776", "Bad\ Endbach\-Hartenrod",
"497254", "Waghäusel",
"493561", "Guben",
"496334", "Thaleischweiler\-Fröschen",
"4939601", "Friedland",
"499179", "Freystadt",
"492387", "Drensteinfurt\-Walstedde",
"499444", "Siegenburg",
"492732", "Kreuztal",
"498667", "Seeon\-Seebruck",
"497722", "Triberg\ im\ Schwarzwald",
"497422", "Schramberg",
"492432", "Wassenberg",
"494851", "Marne",
"499744", "Zeitlofs\-Detter",
"496186", "Grosskrotzenburg",
"495838", "Gross\ Oesingen",
"4934920", "Kropstädt",
"4935456", "Terpt",
"495823", "Bienenbüttel",
"4937209", "Einsiedel\ bei\ Chemnitz",
"4939742", "Brüssow\ bei\ Pasewalk",
"494103", "Wedel",
"495424", "Bad\ Rothenfelde",
"492855", "Voerde\ Niederrhein",
"492196", "Wermelskirchen",
"499491", "Hemau",
"499843", "Burgbernheim",
"495651", "Eschwege",
"499876", "Rohr\ Mittelfranken",
"496397", "Leimen\ Pfalz",
"494638", "Tarp",
"495252", "Bad\ Lippspringe",
"493907", "Gardelegen",
"495371", "Gifhorn",
"495724", "Obernkirchen",
"496533", "Morbach\ Hunsrück",
"494623", "Böklund",
"4939052", "Erxleben\ bei\ Haldensleben",
"4938351", "Mesekenhagen",
"498131", "Dachau",
"499832", "Wassertrüdingen",
"4934922", "Mühlanger",
"494156", "Talkau",
"496881", "Lebach",
"4939882", "Gollin",
"492977", "Schmallenberg\-Bödefeld",
"496542", "Bullay",
"4938392", "Sassnitz",
"499499", "Painten",
"498330", "Legau",
"495379", "Sassenburg\-Grussendorf",
"498327", "Rettenberg",
"495659", "Ringgau",
"492844", "Rheinberg\-Orsoy",
"494564", "Schashagen",
"496058", "Gründau",
"498139", "Röhrmoos",
"4936736", "Arnsgereuth",
"497577", "Veringenstadt",
"494230", "Verden\-Walle",
"493860", "Raben\ Steinfeld",
"4936841", "Schleusingen",
"497148", "Grossbottwar",
"4937362", "Seiffen\ Erzgebirge",
"495543", "Staufenberg\ Niedersachsen",
"494957", "Detern",
"499471", "Burglengenfeld",
"494550", "Bühnsdorf",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"498584", "Breitenberg\ Niederbayern",
"496657", "Hofbieber",
"496206", "Lampertheim",
"49831", "Kempten\ Allgäu",
"4934362", "Mügeln\ bei\ Oschatz",
"4939087", "Jerchel\ Altmark",
"499155", "Simmelsdorf",
"495948", "Itterbeck",
"49421", "Bremen",
"499324", "Dettelbach",
"495922", "Bad\ Bentheim",
"4936781", "Grossbreitenbach",
"4939857", "Drense",
"4934722", "Preusslitz",
"496786", "Kempfeld",
"499144", "Pleinfeld",
"494875", "Stafstedt",
"4939200", "Gommern",
"4939929", "Jabel\ bei\ Waren",
"494804", "Nordhastedt",
"497333", "Laichingen",
"492323", "Herne",
"499779", "Nordheim\ von\ der\ Rhön",
"496253", "Fürth\ Odenwald",
"495532", "Stadtoldendorf",
"4933678", "Storkow\ Mark",
"492590", "Dülmen\-Buldern",
"496486", "Katzenelnbogen",
"492132", "Meerbusch\-Büderich",
"497328", "Königsbronn",
"492338", "Breckerfeld",
"497122", "St\ Johann\ Württemberg",
"495190", "Soltau\-Emmingen",
"493847", "Sternberg",
"498682", "Laufen\ Salzach",
"496395", "Münchweiler\ an\ der\ Rodalb",
"499903", "Schöllnach",
"498281", "Thannhausen\ Schwaben",
"494442", "Lohne\ Oldenburg",
"4933205", "Michendorf",
"492362", "Dorsten",
"4938452", "Lalendorf",
"496764", "Rheinböllen",
"4938371", "Karlshagen",
"494381", "Lütjenburg",
"4938201", "Gelbensande",
"4935935", "Kleinwelka",
"497163", "Ebersbach\ an\ der\ Fils",
"498709", "Eching\ Niederbayern",
"495963", "Bawinkel",
"492857", "Rees\-Mehr",
"4933679", "Wendisch\ Rietz",
"496464", "Angelburg",
"493831", "Stralsund",
"4935383", "Elster\ Elbe",
"494742", "Dorum",
"498145", "Mammendorf",
"4939928", "Möllenhagen",
"497082", "Neuenbürg\ Württemberg",
"498325", "Oberstaufen\-Thalkirchdorf",
"499956", "Eichendorf\-Aufhausen",
"499072", "Lauingen\ Donau",
"494180", "Königsmoor",
"493583", "Zittau",
"494733", "Butjadingen\-Burhave",
"4933704", "Baruth\ Mark",
"497575", "Messkirch",
"495634", "Waldeck\-Sachsenhausen",
"4934444", "Lützen",
"492904", "Bestwig",
"492975", "Schmallenberg\-Oberkirchen",
"494433", "Dötlingen",
"497504", "Horgenzell",
"4936643", "Thimmendorf",
"4939423", "Wegeleben",
"4934461", "Nebra\ Unstrut",
"498369", "Rückholz",
"49209", "Gelsenkirchen",
"496655", "Neuhof\ Kreis\ Fulda",
"4936644", "Hirschberg\ Saale",
"496375", "Wallhalben",
"492689", "Dierdorf",
"492402", "Stolberg\ Rheinland",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"495808", "Gerdau",
"494269", "Ahausen\-Kirchwalsede",
"499157", "Alfeld\ Mittelfranken",
"499868", "Schillingsfürst",
"496304", "Wolfstein\ Pfalz",
"4933703", "Sperenberg",
"493994", "Malchin",
"4939728", "Medow\ bei\ Anklam",
"494955", "Westoverledingen",
"4938306", "Samtens",
"4934443", "Teuchern",
"4939826", "Blankensee\ bei\ Neustrelitz",
"494944", "Wiesmoor",
"499092", "Wemding",
"492681", "Altenkirchen\ Westerwald",
"498361", "Nesselwang",
"493772", "Schneeberg\ Erzgebirge",
"4935384", "Steinsdorf\ bei\ Jessen",
"494261", "Rotenburg\ Wümme",
"494662", "Leck",
"4935268", "Stauchitz",
"498806", "Utting\ am\ Ammersee",
"4938227", "Lüdershagen\ bei\ Barth",
"494877", "Hennstedt\ bei\ Itzehoe",
"496644", "Grebenhain",
"497463", "Mühlheim\ an\ der\ Donau",
"496556", "Pronsfeld",
"4934295", "Krensitz",
"498248", "Lamerdingen",
"494348", "Schönkirchen",
"494142", "Steinkirchen\ Kreis\ Stade",
"4935873", "Herrnhut",
"4934208", "Löbnitz\ bei\ Delitzsch",
"495862", "Hitzacker\ Elbe",
"498745", "Bodenkirchen",
"4937208", "Auerswalde",
"498445", "Gerolsbach",
"4938323", "Prohn",
"4939391", "Lückstedt",
"496164", "Reichelsheim\ Odenwald",
"495357", "Grasleben",
"499802", "Ansbach\-Katterbach",
"496292", "Seckach",
"497021", "Kirchheim\ unter\ Teck",
"493949", "Oschersleben\ Bode",
"495677", "Calden\-Westuffeln",
"498629", "Palling",
"4937295", "Lugau\ Erzgebirge",
"497763", "Murg",
"496691", "Schwalmstadt",
"492265", "Reichshof\-Eckenhagen",
"496503", "Hermeskeil",
"4933366", "Chorin",
"4933055", "Kremmen",
"496026", "Grossostheim",
"494480", "Ovelgönne\-Strückhausen",
"492951", "Büren",
"498640", "Reit\ Im\ Winkl",
"498454", "Karlshuld",
"494608", "Handewitt",
"493937", "Osterburg\ Altmark",
"494322", "Bordesholm",
"497551", "Überlingen\ Bodensee",
"494128", "Kollmar",
"4936258", "Friemar",
"498754", "Volkenschwand",
"4933745", "Petkus",
"498621", "Trostberg",
"493941", "Halberstadt",
"494133", "Wittorf\ Kreis\ Lüneburg",
"498222", "Burgau\ Schwaben",
"495246", "Verl",
"4934498", "Rositz",
"495273", "Beverungen",
"4939296", "Welsleben",
"495502", "Dransfeld",
"498460", "Berching\-Holnstein",
"492308", "Unna\-Hemmerde",
"4938738", "Karow\ bei\ Lübz",
"492102", "Ratingen",
"494971", "Esens",
"498076", "Pfaffing",
"498043", "Jachenau",
"497247", "Linkenheim\-Hochstetten",
"497303", "Illertissen",
"494834", "Büsum",
"4938450", "Tarnow\ bei\ Bützow",
"49351", "Dresden",
"499562", "Sonnefeld",
"495084", "Hambühren",
"4933926", "Herzberg\ Mark",
"497632", "Badenweiler",
"4936605", "Bad\ Köstritz",
"4935692", "Kerkwitz",
"492622", "Bendorf\ am\ Rhein",
"497231", "Pforzheim",
"496272", "Hirschhorn\ Neckar",
"496351", "Eisenberg\ Pfalz",
"4939387", "Havelberg",
"4938324", "Velgast",
"497643", "Herbolzheim\ Breisgau",
"4935476", "Wittmannsdorf\-Bückchen",
"497676", "Feldberg\ Schwarzwald",
"497356", "Schemmerhofen",
"496236", "Neuhofen\ Pfalz",
"496150", "Weiterstadt",
"4939406", "Harbke",
"493378", "Ludwigsfelde",
"495293", "Paderborn\-Dahl",
"498665", "Inzell",
"496359", "Grünstadt",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"4933977", "Gumtow",
"492385", "Hamm\-Rhynern",
"4935874", "Bernstadt\ an\ der\ Eigen",
"499473", "Kallmünz",
"499446", "Altmannstein",
"4939320", "Schinne",
"497483", "Horb\-Mühringen",
"495541", "Hann\.\ Münden",
"493475", "Lutherstadt\ Eisleben",
"497256", "Philippsburg",
"496336", "Dellfeld",
"495882", "Gorleben",
"492992", "Marsberg",
"4933239", "Gross\ Behnitz",
"4934772", "Helbra",
"495520", "Braunlage",
"494665", "Emmelsbüll\-Horsbüll",
"4939603", "Burg\ Stargard",
"497127", "Neckartenzlingen",
"492137", "Neuss\-Norf",
"497130", "Löwenstein\ Württemberg",
"4939086", "Jävenitz",
"496184", "Langenselbold",
"499746", "Zeitlofs",
"499773", "Unsleben",
"494952", "Rhauderfehn",
"492208", "Niederkassel",
"4939856", "Beenz\ bei\ Prenzlau",
"492474", "Nideggen\-Schmidt",
"497203", "Walzbachtal",
"497347", "Dietenheim",
"4939454", "Elbingerode\ Harz",
"492405", "Würselen",
"492774", "Dietzhölztal",
"496372", "Bruchmühlbach\-Miesau",
"497331", "Geislingen\ an\ der\ Steige",
"496251", "Bensheim",
"496652", "Hünfeld",
"4938332", "Gross\ Bisdorf",
"494454", "Jade",
"499493", "Beratzhausen",
"4939031", "Dähre",
"4939453", "Derenburg",
"499820", "Lehrberg",
"499837", "Haundorf",
"494101", "Pinneberg",
"492056", "Heiligenhaus",
"492972", "Schmallenberg",
"494621", "Schleswig",
"495064", "Gross\ Düngen",
"498133", "Haimhausen\ Oberbayern",
"494222", "Ganderkesee",
"493364", "Eisenhüttenstadt",
"497572", "Mengen\ Württemberg",
"496531", "Bernkastel\-Kues",
"495346", "Liebenburg",
"498322", "Oberstdorf",
"499075", "Glött",
"494754", "Bülkau",
"495373", "Hillerse\ Kreis\ Gifhorn",
"4939779", "Eggesin",
"499841", "Bad\ Windsheim",
"495653", "Sontra",
"497085", "Enzklösterle",
"4935892", "Horka\ OL",
"498348", "Bidingen",
"4939604", "Wildberg\ bei\ Altentreptow",
"498142", "Olching",
"495126", "Algermissen",
"494745", "Bad\ Bederkesa",
"492526", "Sendenhorst",
"494109", "Tangstedt\ Bz\ Hamburg",
"499666", "Illschwang",
"494248", "Bassum\-Neubruchhausen",
"49591", "Lingen\ \(Ems\)",
"49711", "Stuttgart",
"4938422", "Neukloster",
"494445", "Visbek\ Kreis\ Vechta",
"492365", "Marl",
"496198", "Eppstein",
"498685", "Kirchanschöring",
"4936737", "Drognitz",
"496392", "Hauenstein\ Pfalz",
"495606", "Zierenberg",
"493902", "Diesdorf\ Altm",
"495257", "Hövelhof",
"498261", "Mindelheim",
"492382", "Ahlen\ Westfalen",
"497727", "Vöhrenbach",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"498035", "Raubling",
"492737", "Netphen\-Deuz",
"493624", "Ohrdruf",
"497183", "Rudersberg\ Württemberg",
"496784", "Weierbach",
"499146", "Markt\ Berolzheim",
"494361", "Oldenburg\ in\ Holstein",
"499173", "Thalmässing",
"492441", "Kall",
"492741", "Betzdorf",
"496484", "Beselich",
"49681", "Saarbrücken",
"4936783", "Gehren\ Thüringen",
"495829", "Wriedel",
"4937329", "Grosshartmannsdorf",
"4938354", "Wusterhusen",
"497427", "Schömberg\ bei\ Balingen",
"494806", "Sarzbüttel",
"496275", "Rothenberg\ Odenwald",
"4937342", "Cranzahl",
"495574", "Oberweser",
"498269", "Unteregg\ bei\ Mindelheim",
"497635", "Schliengen",
"497062", "Beilstein\ Württemberg",
"492625", "Ochtendung",
"495840", "Schnackenburg",
"4937439", "Jocketa",
"492174", "Burscheid\ Rheinland",
"499565", "Untersiemau",
"492449", "Blankenheim\ Ahr",
"493563", "Spremberg",
"495821", "Bad\ Bevensen",
"4936843", "Benshausen",
"496478", "Greifenstein\-Ulm",
"499326", "Markt\ Einersheim",
"498586", "Hauzenberg",
"493968", "Schönbeck",
"496204", "Viernheim",
"495505", "Hardegsen",
"494853", "Sankt\ Michaelisdonn",
"4934342", "Neukieritzsch",
"4936844", "Rohr\ Thüringen",
"498225", "Jettingen\-Scheppach",
"494401", "Brake\ Unterweser",
"498733", "Mengkofen",
"4936335", "Grosswechsungen",
"498389", "Weissensberg",
"494289", "Kirchtimke",
"499193", "Höchstadt\ an\ der\ Aisch",
"494154", "Trittau",
"498728", "Geratskirchen",
"499529", "Oberaurach",
"4933088", "Falkenthal",
"492873", "Isselburg\-Werth",
"4939322", "Tangermünde",
"498433", "Königsmoos",
"49771", "Donaueschingen",
"498381", "Lindenberg\ im\ Allgäu",
"492262", "Wiehl",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"495594", "Bovenden\-Reyershausen",
"496295", "Rosenberg\ Baden",
"494409", "Westerstede\-Ocholt",
"4936784", "Stützerbach",
"492661", "Bad\ Marienberg\ Westerwald",
"499805", "Burgoberbach",
"494682", "Amrum",
"4938353", "Gützkow\ bei\ Greifswald",
"4935607", "Jänschwalde",
"499521", "Hassfurt",
"494281", "Zeven",
"498442", "Wolnzach",
"495426", "Glandorf",
"4939349", "Parey\ Elbe",
"499931", "Plattling",
"4936425", "Isserstedt",
"498742", "Velden\ Vils",
"495865", "Gusborn",
"495726", "Wiedensahl",
"4935249", "Basslitz",
"496827", "Eppelborn",
"499874", "Neuendettelsau",
"49741", "Rottweil",
"492456", "Selfkant",
"495764", "Steyerberg",
"499278", "Weidenberg",
"499151", "Hersbruck",
"4934343", "Regis\-Breitingen",
"4937361", "Neuhausen\ Erzgebirge",
"494663", "Süderlügum",
"4936842", "Oberhof\ Thüringen",
"496568", "Wolsfeld",
"499775", "Schönau\ an\ der\ Brend",
"499093", "Polsingen",
"499404", "Nittendorf",
"4939265", "Löderburg",
"493773", "Johanngeorgenstadt",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4934907", "Jeber\-Bergfrieden",
"497485", "Empfingen",
"4939324", "Kläden\ bei\ Stendal",
"4935365", "Falkenberg\ Elster",
"499704", "Euerdorf",
"4934361", "Dahlen\ Sachsen",
"4937343", "Jöhstadt",
"495464", "Alfhausen",
"4935056", "Altenberg\ Sachsen",
"497274", "Germersheim",
"492403", "Eschweiler\ Rheinland",
"494524", "Scharbeutz\-Pönitz",
"499284", "Schwarzenbach\ an\ der\ Saale",
"496634", "Gemünden\ Felda",
"494267", "Lauenbrück",
"4935725", "Wittichenau",
"4934721", "Nienburg\ Saale",
"498367", "Rosshaupten\ Forggensee",
"494496", "Friesoythe\-Markhausen",
"499350", "Eussenheim\-Hundsbach",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"492687", "Horhausen\ Westerwald",
"494871", "Hohenwestedt",
"494796", "Teufelsmoor",
"4938296", "Rerik\ Ostseebad",
"497708", "Geisingen\-Leipferdingen",
"494934", "Marienhafe",
"494732", "Stadland\-Rodenkirchen",
"499364", "Zellingen",
"498135", "Sulzemoos",
"497083", "Bad\ Herrenalb",
"495655", "Wanfried",
"499073", "Gundelfingen\ an\ der\ Donau",
"4939741", "Jatznick",
"495375", "Müden\ Aller",
"493841", "Wismar",
"495304", "Meine",
"499495", "Breitenbrunn\ Oberpfalz",
"4939051", "Calvörde",
"4938352", "Kemnitz\ bei\ Greifswald",
"493493", "Bitterfeld",
"4933475", "Letschin",
"492851", "Rees",
"494432", "Dötlingen\-Brettorf",
"4939323", "Schönhausen\ Elbe",
"4938391", "Altenkirchen\ Rügen",
"497162", "Süssen",
"498407", "Grossmehring",
"4937344", "Crottendorf\ Sachsen",
"4939881", "Ringenwalde\ bei\ Templin",
"498683", "Tittmoning",
"4933395", "Zerpenschleuse",
"492363", "Datteln",
"4934921", "Kemberg",
"494443", "Dinklage",
"4939600", "Zwiedorf",
"494743", "Langen\ bei\ Bremerhaven",
"494776", "Osten\-Altendorf",
"4934344", "Kohren\-Sahlis",
"495644", "Willebadessen\-Peckelsheim",
"498707", "Adlkofen",
"4936075", "Dingelstädt\ Eichsfeld",
"495962", "Herzlake",
"492859", "Wesel\-Bislich",
"4933841", "Belzig",
"497642", "Endingen\ Kaiserstuhl",
"499104", "Emskirchen",
"495556", "Lindau\ Harz",
"494977", "Blomberg\ Ostfriesland",
"4938334", "Grammendorf",
"499451", "Schierling",
"492156", "Willich\-Anrath",
"4938845", "Kaarssen",
"497964", "Stödtlen",
"49861", "Traunstein",
"498033", "Oberaudorf",
"495164", "Hodenhagen",
"497237", "Neulingen\ Enzkreis",
"492227", "Bornheim\-Merten",
"496357", "Standenbühl",
"497220", "Forbach\-Hundsbach",
"495292", "Lichtenau\-Atteln",
"496677", "Neuenstein\ Hessen",
"492564", "Vreden",
"494844", "Pellworm",
"495691", "Bad\ Arolsen",
"4935894", "Hähnichen",
"499624", "Ensdorf\ Oberpfalz",
"4935327", "Priessen",
"498028", "Fischbachau",
"499175", "Spalt",
"495026", "Steimbke",
"498042", "Lenggries",
"497249", "Stutensee",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"495503", "Nörten\-Hardenberg",
"494855", "Eddelak",
"4938785", "Berge\ bei\ Perleberg",
"4939602", "Kleeth",
"4938826", "Dassow",
"492103", "Hilden",
"4938728", "Domsühl",
"492623", "Ransbach\-Baumbach",
"4935206", "Kreischa\ bei\ Dresden",
"498558", "Hohenau\ Niederbayern",
"497633", "Staufen\ im\ Breisgau",
"496246", "Eich\ Rheinhessen",
"4934773", "Schwittersdorf",
"495908", "Wietmarschen\-Lohne",
"492638", "Waldbreitbach",
"4939487", "Friedrichsbrunn",
"497628", "Efringen\-Kirchen",
"499563", "Rödental",
"4938424", "Bobitz",
"492041", "Bottrop",
"4934774", "Röblingen\ am\ See",
"496502", "Schweich",
"498435", "Ehekirchen",
"4938423", "Bad\ Kleinen",
"4936840", "Trusetal",
"495671", "Hofgeismar",
"494132", "Amelinghausen",
"496697", "Willingshausen",
"494338", "Alt\ Duvenstedt",
"499856", "Dürrwangen",
"495272", "Brakel\ Westfalen",
"498735", "Gangkofen\-Kollbach",
"498223", "Ichenhausen",
"495351", "Helmstedt",
"492804", "Xanten\-Marienbaum",
"494323", "Bornhöved",
"493529", "Heidenau\ Sachsen",
"499195", "Adelsdorf\ Mittelfranken",
"496084", "Schmitten\ Taunus",
"498238", "Gessertshausen",
"494143", "Drochtersen",
"4933981", "Putlitz",
"493931", "Stendal",
"494176", "Marschacht",
"4935893", "Mücka",
"495863", "Zernien",
"4937609", "Wolkenburg\ Mulde",
"497950", "Schnelldorf",
"495236", "Blomberg\-Grossenmarpe",
"492957", "Wünnenberg\-Haaren",
"497462", "Immendingen",
"493874", "Ludwigslust",
"496293", "Schefflenz",
"499803", "Colmberg",
"4934973", "Osternienburg",
"493947", "Thale",
"497762", "Wehr\ Baden",
"49221", "Cologne",
"498630", "Oberneukirchen",
"496078", "Gross\-Umstadt",
"4934609", "Salzmünde",
"493521", "Meissen",
"497557", "Herdwangen\-Schönach",
"4933838", "Päwesin",
"4939452", "Ilsenburg",
"4938333", "Horst\ bei\ Grimmen",
"4939201", "Wolmirstedt",
"494107", "Siek\ Kreis\ Stormarn",
"495336", "Semmenstedt",
"499831", "Gunzenhausen",
"495965", "Klein\ Berssen",
"498143", "Inning\ am\ Ammersee",
"498176", "Egling\ bei\ Wolfratshausen",
"496541", "Traben\-Trarbach",
"499974", "Traitsching",
"492584", "Warendorf\-Milte",
"499847", "Ergersheim",
"49231", "Dortmund",
"499905", "Bernried\ Niederbayern",
"4935694", "Gosda\ bei\ Klinge",
"495184", "Freden\ Leine",
"496393", "Fischbach\ bei\ Dahn",
"495259", "Bad\ Driburg\-Neuenheerse",
"497165", "Göppingen\-Hohenstaufen",
"494627", "Dörpstedt",
"4935955", "Pulsnitz",
"494630", "Barderup",
"494435", "Grossenkneten",
"492973", "Eslohe\ Sauerland",
"499492", "Parsberg",
"4938322", "Richtenberg",
"495372", "Meinersen",
"495251", "Paderborn",
"498323", "Immenstadt\ im\ Allgäu",
"496050", "Biebergemünd",
"494238", "Neddenaverbergen",
"495652", "Bad\ Sooden\-Allendorf",
"4935872", "Neusalza\-Spremberg",
"498338", "Böhen",
"4936878", "Oberland",
"494735", "Butjadingen\-Stollhamm",
"497573", "Stetten\ am\ kalten\ Markt",
"497546", "Oberteuringen",
"494223", "Ganderkesee\-Bookholzberg",
"493585", "Löbau",
"497202", "Karlsbad",
"499736", "Oberthulba",
"495921", "Nordhorn",
"493868", "Rastow",
"494953", "Bunde",
"498196", "Pürgen",
"4936927", "Unterellen",
"496346", "Annweiler\ am\ Trifels",
"496373", "Schönenberg\-Kübelberg",
"4939007", "Tangeln",
"4936640", "Remptendorf",
"496653", "Burghaun",
"499436", "Nittenau",
"497121", "Reutlingen",
"494558", "Todesfelde",
"4935755", "Ortrand",
"492131", "Neuss",
"495531", "Holzminden",
"4935693", "Lauschütz",
"492993", "Marsberg\-Canstein",
"495883", "Lemgow",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"4936701", "Lichte",
"499472", "Hohenfels\ Oberpfalz",
"496126", "Idstein",
"497482", "Horb\-Dettingen",
"492598", "Senden\-Ottmarsbocholt",
"4939999", "Tutow",
"497337", "Nellingen\ Alb",
"499772", "Bischofsheim\ an\ der\ Rhön",
"495198", "Schneverdingen\-Wintermoor",
"492330", "Herdecke",
"492327", "Bochum\-Wattenscheid",
"496257", "Seeheim\-Jugenheim",
"4933638", "Rüdersdorf\ bei\ Berlin",
"49340", "Dessau\ Anh",
"49461", "Flensburg",
"497129", "Lichtenstein\ Württemberg",
"4939422", "Badersleben",
"497268", "Bad\ Rappenau\-Obergimpern",
"494683", "Oldsum",
"497394", "Schelklingen",
"498443", "Hohenwart\ Paar",
"497765", "Rickenbach\ Hotzenwald",
"497826", "Schuttertal",
"492263", "Engelskirchen",
"492836", "Wachtendonk",
"4936642", "Harra",
"496588", "Pluwig",
"494407", "Wardenburg",
"494707", "Langen\-Neuenwalde",
"497465", "Emmingen\-Liptingen",
"498743", "Geisenhausen",
"495484", "Lienen\-Kattenvenne",
"49581", "Uelzen",
"499398", "Birkenfeld\ bei\ Würzburg",
"499264", "Küps",
"494287", "Heeslingen\-Boitzen",
"499192", "Gräfenberg",
"499527", "Knetzgau",
"495275", "Höxter\-Ottbergen",
"499941", "Kötzting",
"498732", "Frontenhausen",
"497660", "St\ Peter\ Schwarzwald",
"496574", "Hasborn",
"492667", "Stein\-Neukirch",
"494135", "Kirchgellersen",
"498387", "Weiler\-Simmerberg",
"4938453", "Mistorf",
"495204", "Steinhagen\ Westfalen",
"498432", "Burgheim",
"496505", "Kordel",
"492872", "Rhede\ Westfalen",
"496821", "Neunkirchen\ Saar",
"499920", "Bischofsmais",
"499937", "Oberpöring",
"499384", "Schwanfeld",
"4938454", "Kritzkow",
"494367", "Grossenbrode",
"49951", "Bamberg",
"492447", "Dahlem\ bei\ Kall",
"497654", "Löffingen",
"497440", "Bad\ Rippoldsau",
"497374", "Uttenweiler",
"493562", "Forst\ Lausitz",
"497721", "Villingen\ im\ Schwarzwald",
"498267", "Dirlewang",
"497063", "Bad\ Wimpfen",
"4938758", "Dömitz",
"494852", "Brunsbüttel",
"492431", "Erkelenz",
"4938856", "Pritzier\ bei\ Hagenow",
"497305", "Erbach\ Donau",
"492747", "Molzhain",
"498045", "Lenggries\-Fall",
"4936965", "Stadtlengsfeld",
"499658", "Georgenberg",
"498054", "Breitbrunn\ am\ Chiemsee",
"497182", "Welzheim",
"497388", "Pfronstetten",
"4933702", "Wünsdorf",
"499172", "Georgensgmünd",
"496426", "Fronhausen",
"499378", "Eichenbühl\-Riedern",
"492383", "Bönen",
"497729", "Tennenbronn",
"496594", "Birresborn",
"495295", "Lichtenau\ Westfalen",
"498663", "Ruhpolding",
"492739", "Wilnsdorf",
"4934635", "Bad\ Lauchstädt",
"497429", "Egesheim",
"4938320", "Tribsees",
"496726", "Lorch\ Rheingau",
"496865", "Mettlach\-Orscholz",
"495827", "Unterlüss",
"493686", "Eisfeld",
"497645", "Freiamt",
"4937364", "Reitzenhain\ Erzgebirge",
"497467", "Neuhausen\ ob\ Eck",
"494340", "Achterwehr",
"498102", "Höhenkirchen\-Siegertsbrunn",
"494474", "Garrel",
"494705", "Wremen",
"494149", "Fredenbeck",
"494208", "Grasberg",
"492952", "Rüthen",
"492043", "Gladbeck",
"4938393", "Binz\ Ostseebad",
"497552", "Pfullendorf",
"494321", "Neumünster",
"4939321", "Arneburg",
"4934923", "Cobbelsdorf",
"494405", "Edewecht",
"494774", "Hechthausen",
"495353", "Königslutter\ am\ Elm",
"498221", "Günzburg",
"495673", "Immenhausen\ Hessen",
"4939883", "Gross\ Dölln",
"4934364", "Wermsdorf",
"495646", "Willebadessen",
"498622", "Tacherting\-Peterskirchen",
"496507", "Neumagen\-Dhron",
"494488", "Westerstede",
"4939053", "Süplingen",
"493928", "Schönebeck\ Elbe",
"499935", "Stephansposching",
"495861", "Dannenberg\ Elbe",
"494141", "Stade",
"499366", "Geroldshausen\ Unterfranken",
"493933", "Genthin",
"499525", "Königsberg\ in\ Bayern",
"494329", "Langwedel\ Holstein",
"494285", "Rhade\ bei\ Zeven",
"493523", "Coswig\ bei\ Dresden",
"496692", "Neustadt\ Hessen",
"495306", "Cremlingen",
"494120", "Ellerhoop",
"498385", "Hergatz",
"494137", "Barendorf",
"4939743", "Zerrenthin",
"497022", "Nürtingen",
"496291", "Adelsheim",
"495277", "Höxter\-Fürstenau",
"4938759", "Tewswoos",
"499453", "Thalmassing",
"495509", "Rosdorf\ Kreis\ Göttingen",
"4939226", "Hohenziatz",
"492248", "Hennef\-Uckerath",
"4938876", "Roggendorf",
"494494", "Bösel\ Oldenburg",
"4939744", "Rothenklempenow",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"494526", "Ascheberg\ Holstein",
"497243", "Ettlingen",
"492745", "Brachbach\ Sieg",
"499286", "Oberkotzau",
"496636", "Romrod",
"497307", "Senden\ Iller",
"498468", "Altmannstein\-Pondorf",
"4939030", "Brunau",
"494936", "Grossheide",
"499569", "Sesslach",
"4939054", "Flechtingen",
"4936628", "Zeulenroda",
"492445", "Schleiden\ Eifel",
"494365", "Heringsdorf\ Holstein",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"495693", "Volkmarsen",
"498265", "Pfaffenhausen\ Schwaben",
"494794", "Worpswede\-Ostersode",
"498031", "Rosenheim\ Oberbayern",
"494972", "Langeoog",
"499406", "Mintraching",
"493744", "Auerbach\ Vogtland",
"4939245", "Loburg",
"4935436", "Laasow\ bei\ Calau",
"495825", "Wieren",
"492454", "Gangelt",
"495766", "Rehburg\-Loccum",
"4934924", "Zahna",
"4938827", "Kalkhorst",
"496867", "Perl",
"4937341", "Ehrenfriedersdorf",
"4934363", "Cavertitz",
"4939884", "Hassleben\ bei\ Prenzlau",
"4935207", "Moritzburg",
"499561", "Coburg",
"4937363", "Zöblitz",
"4934341", "Geithain",
"495466", "Merzen",
"492754", "Bad\ Laasphe\-Feudingen",
"496352", "Kirchheimbolanden",
"492222", "Bornheim\ Rheinland",
"498039", "Rott\ am\ Inn",
"496271", "Eberbach\ Baden",
"496158", "Riedstadt",
"497232", "Königsbach\-Stein",
"492621", "Lahnstein",
"496672", "Eiterfeld",
"497631", "Müllheim\ Baden",
"499071", "Dillingen\ an\ der\ Donau",
"493843", "Güstrow",
"493876", "Perleberg",
"499907", "Zenting",
"4933335", "Pinnow\ Kreis\ Uckermark",
"497081", "Bad\ Wildbad",
"492369", "Dorsten\-Wulfen",
"4933844", "Brück\ Brandenburg",
"499845", "Oberdachstetten",
"4938331", "Rakow\ Vorpom",
"4939203", "Barleben",
"4935975", "Hohnstein",
"494174", "Stelle\ Kreis\ Harburg",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"494625", "Jübek",
"496535", "Osann\-Monzel",
"498402", "Münchsmünster",
"495234", "Horn\-Bad\ Meinberg",
"492853", "Schermbeck",
"498702", "Wörth\ an\ der\ Isar",
"4935891", "Rothenburg\ OL",
"4936025", "Körner",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"494105", "Seevetal",
"494749", "Schiffdorf\-Geestenseth",
"493491", "Lutherstadt\ Wittenberg",
"4939998", "Loitz\ bei\ Demmin",
"492361", "Recklinghausen",
"494441", "Vechta",
"498282", "Krumbach\ Schwaben",
"498681", "Waging\ am\ See",
"494737", "Stadland\-Schwei",
"494188", "Welle\ Nordheide",
"494382", "Wangels",
"496086", "Grävenwiesbach",
"494893", "Hohenaspe",
"499854", "Wittelshofen",
"494741", "Nordholz\ bei\ Bremerhaven",
"498168", "Attenkirchen",
"493771", "Aue\ Sachsen",
"4934771", "Querfurt",
"498362", "Füssen",
"492682", "Hamm\ Sieg",
"499091", "Monheim\ Schwaben",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"494661", "Niebüll",
"492409", "Stolberg\-Gressenich",
"494194", "Sievershütten",
"4935775", "Pechern",
"499153", "Schnaittach",
"494262", "Visselhövede",
"4934906", "Raguhn",
"498857", "Benediktbeuern",
"496244", "Westhofen\ Rheinhessenen",
"493471", "Bernburg\ Saale",
"4935057", "Hermsdorf\ Erzgebirge",
"495545", "Hedemünden",
"492325", "Wanne\-Eickel",
"496255", "Lindenfels",
"499099", "Kaisheim",
"495554", "Moringen",
"497335", "Wiesensteig",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"497966", "Unterschneidheim",
"492154", "Willich",
"496758", "Waldböckelheim",
"499106", "Markt\ Erlbach",
"492401", "Baesweiler",
"499626", "Hohenburg",
"496458", "Rosenthal\ Hessen",
"4933843", "Niemegk",
"4938297", "Moitin",
"495166", "Walsrode\-Kirchboitzen",
"4939204", "Niederndodeleben",
"494846", "Hattstedt",
"492566", "Legden",
"494873", "Aukrug",
"492389", "Werne",
"496124", "Bad\ Schwalbach",
"496675", "Breitenbach\ am\ Herzberg",
"497723", "Furtwangen\ im\ Schwarzwald",
"4935820", "Zodel",
"496355", "Albisheim\ Pfrimm",
"492225", "Meckenheim\ Rheinland",
"497235", "Unterreichenbach\ Kreis\ Calw",
"498669", "Traunreut",
"492733", "Hilchenbach",
"4937608", "Waldenburg\ Sachsen",
"497738", "Steisslingen",
"499177", "Heideck",
"492428", "Niederzier",
"4933839", "Wusterwitz",
"495822", "Ebstorf",
"498846", "Uffing\ am\ Staffelsee",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"4935691", "Bärenklau\ NL",
"492433", "Hückelhoven",
"497423", "Oberndorf\ am\ Neckar",
"4938370", "Kröslin",
"494975", "Westerholt\ Ostfriesland",
"4936703", "Gräfenthal",
"4940", "Hamburg",
"498661", "Grabenstätt\ Chiemsee",
"492381", "Hamm\ Westfalen",
"498194", "Vilgertshofen",
"498262", "Mittelneufnach",
"494168", "Neu\ Wulmstorf\-Elstorf",
"494362", "Heiligenhafen",
"495848", "Trebel",
"499734", "Burkardroth",
"499434", "Bodenwöhr",
"496066", "Michelstadt\-Vielbrunn",
"492742", "Wissen",
"496344", "Schwegenheim",
"494857", "Barlt",
"4936205", "Gräfenroda",
"492662", "Hachenburg",
"497025", "Neuffen",
"4936375", "Kindelbrück",
"4938729", "Marnitz",
"492261", "Gummersbach",
"496695", "Jesberg",
"498382", "Lindau\ Bodensee",
"499197", "Egloffstein",
"494282", "Sittensen",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"492944", "Rietberg\-Mastholte",
"499522", "Eltmann",
"494681", "Wyk\ auf\ Föhr",
"4937754", "Zwönitz",
"498741", "Vilsbiburg",
"499932", "Osterhofen",
"497544", "Markdorf",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"492269", "Kierspe\-Rönsahl",
"499943", "Lam\ Oberpfalz",
"4934953", "Gräfenhainichen",
"494402", "Rastede",
"499976", "Rötz",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"497555", "Deggenhausertal",
"4936704", "Steinheid",
"492955", "Büren\-Wewelsburg",
"499548", "Mühlhausen\ Mittelfranken",
"492586", "Beelen",
"494702", "Sandstedt",
"495186", "Salzhemmendorf\-Wallensen",
"498105", "Gilching",
"496838", "Saarwellingen",
"4939390", "Iden",
"492608", "Welschneudorf",
"496596", "Üdersdorf",
"494951", "Weener",
"498056", "Eggstätt",
"495923", "Schüttorf",
"496424", "Ebsdorfergrund",
"4934462", "Laucha\ Unstrut",
"4936926", "Creuzburg",
"4937462", "Rothenkirchen\ Vogtland",
"496724", "Stromberg\ Hunsrück",
"4939006", "Miesterhorst",
"495533", "Bodenwerder",
"497123", "Metzingen\ Württemberg",
"492133", "Dormagen",
"496651", "Rasdorf",
"495528", "Gieboldehausen",
"4933605", "Boossen",
"497138", "Schwaigern",
"496252", "Heppenheim\ Bergstrasse",
"497332", "Lauterstein",
"499777", "Ostheim\ von\ der\ Rhön",
"496371", "Landstuhl",
"494959", "Dollart",
"495542", "Witzenhausen",
"4935027", "Weesenstein",
"494468", "Friedeburg\-Reepsholt",
"499386", "Prosselsheim",
"497656", "Schluchsee",
"492991", "Marsberg\-Bredelar",
"497376", "Langenenslingen",
"497343", "Buch\ bei\ Illertissen",
"494265", "Fintel",
"4936945", "Henneberg",
"492685", "Flammersfeld",
"494768", "Hipstedt",
"496659", "Eichenzell",
"498365", "Wertach",
"499134", "Neunkirchen\ am\ Brand",
"496543", "Büchenbeuren",
"499828", "Rügland",
"4938451", "Hoppenrade\ bei\ Güstrow",
"498141", "Fürstenfeldbruck",
"4938372", "Usedom",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"4938202", "Volkenshagen",
"499266", "Mitwitz",
"49385", "Schwerin",
"499833", "Heidenheim\ Mittelfranken",
"498137", "Petershausen",
"494385", "Hohenfelde\ bei\ Kiel",
"497579", "Schwenningen\ Baden",
"493901", "Salzwedel",
"496391", "Dahn",
"495377", "Ehra\-Lessien",
"495206", "Bielefeld\-Jöllenbeck",
"495657", "Meissner",
"4935822", "Hagenwerder",
"498285", "Burtenbach",
"497824", "Schwanau",
"492834", "Straelen",
"498208", "Eurasburg\ bei\ Augsburg",
"494240", "Syke\-Heiligenfelde",
"494308", "Schwedeneck",
"496887", "Schmelz\ Saar",
"494102", "Ahrensburg",
"492971", "Schmallenberg\-Dorlar",
"498340", "Baisweil",
"498705", "Altfraunhofen",
"498405", "Stammham\ bei\ Ingolstadt",
"496532", "Zeltingen\-Rachtig",
"497571", "Sigmaringen",
"494221", "Delmenhorst",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"494622", "Taarstedt",
"496190", "Hattersheim\ am\ Main",
"499842", "Uffenheim",
"493909", "Klötze\ Altmark",
"498321", "Sonthofen",
"495253", "Bad\ Driburg",
"4936022", "Grossengottern",
"499482", "Wörth\ an\ der\ Donau",
"496431", "Limburg\ an\ der\ Lahn",
"497472", "Rottenburg\ am\ Neckar",
"495873", "Eimke",
"495846", "Gartow\ Niedersachsen",
"498822", "Oberammergau",
"4935028", "Krippen",
"499341", "Tauberbischofsheim",
"496747", "Emmelshausen",
"494166", "Ahlerstedt",
"499129", "Wendelstein",
"496447", "Langgöns\-Niederkleen",
"496068", "Beerfelden",
"494554", "Wahlstedt",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"4933332", "Gartz\ Oder",
"496731", "Alzey",
"4939035", "Kuhfelde",
"499337", "Gaukönigshofen",
"496439", "Holzappel",
"492865", "Raesfeld",
"494545", "Seedorf\ Lauenburg",
"499349", "Werbach\-Wenkheim",
"497736", "Tengen",
"499202", "Waischenfeld",
"497436", "Messstetten\-Oberdigisheim",
"492426", "Nörvenich",
"495262", "Extertal",
"495194", "Bispingen",
"496383", "Glan\-Münchweiler",
"495661", "Melsungen",
"492594", "Dülmen",
"499978", "Schönthal\ Oberpfalz",
"495437", "Menslage",
"495741", "Lübbecke",
"493504", "Dippoldiswalde",
"497839", "Schapbach",
"492983", "Winterberg\-Siedlinghausen",
"499573", "Staffelstein\ Oberfranken",
"4934909", "Aken\ Elbe",
"499546", "Burgebrach",
"495441", "Diepholz",
"497583", "Bad\ Schussenried",
"495382", "Bad\ Gandersheim",
"496836", "Überherrn",
"4934673", "Heldrungen",
"496263", "Neckargerach",
"492588", "Harsewinkel\-Greffen",
"4935772", "Rietschen",
"495105", "Barsinghausen",
"497974", "Bühlerzell",
"492505", "Altenberge\ Westfalen",
"494967", "Rhauderfehn\-Burlage",
"492821", "Kleve\ Niederrhein",
"496872", "Losheim\ am\ See",
"497831", "Hausach",
"498334", "Bad\ Grönenbach",
"499165", "Sugenheim",
"496667", "Steinau\-Ulmbach",
"494234", "Dörverden",
"492574", "Saerbeck",
"495174", "Lahstedt",
"495625", "Naumburg\ Hessen",
"497905", "Langenburg",
"492373", "Menden\ Sauerland",
"499729", "Grettstadt",
"494466", "Wittmund\-Ardorf",
"492653", "Kaisersesch",
"496131", "Mainz",
"492064", "Dinslaken",
"497172", "Lorch\ Württemberg",
"498533", "Rotthalmünster",
"499182", "Velburg",
"494297", "Ottersberg\-Posthausen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"4934222", "Arzberg\ bei\ Torgau",
"494501", "Kastorf\ Holstein",
"493643", "Weimar\ Thüringen",
"495056", "Winsen\-Meissendorf",
"4936331", "Ilfeld",
"499429", "Rain\ Niederbayern",
"496147", "Trebur",
"494766", "Basdahl",
"494825", "Burg\ Dithmarschen",
"495365", "Wolfsburg\-Neindorf",
"496327", "Neustadt\-Lachen",
"495936", "Twist",
"492257", "Reckerscheid",
"492606", "Winningen\ Mosel",
"493632", "Sondershausen",
"4937607", "Ebersbrunn\ Sachsen",
"499721", "Schweinfurt",
"497250", "Kraichtal",
"499374", "Eschau",
"496139", "Budenheim",
"497384", "Schelklingen\-Hütten",
"4936421", "Camburg",
"499654", "Pleystein",
"49751", "Ravensburg",
"493303", "Birkenwerder",
"495494", "Holdorf\ Niedersachsen",
"49291", "Meschede",
"499305", "Estenfeld",
"494509", "Gross\ Grönau",
"4938858", "Lassahn",
"4934607", "Wettin",
"499421", "Straubing",
"497136", "Bad\ Friedrichshall",
"498542", "Ortenburg",
"4938756", "Grabow",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"49631", "Kaiserslautern",
"498657", "Ramsau\ bei\ Berchtesgaden",
"498206", "Egling\ an\ der\ Paar",
"496584", "Wellen\ Mosel",
"495329", "Schulenberg\ im\ Oberharz",
"498377", "Unterthingau",
"497941", "Öhringen",
"492393", "Sundern\-Allendorf",
"494277", "Schwaförden",
"497527", "Wolfegg",
"492520", "Wadersloh\-Diestedde",
"497264", "Bad\ Rappenau",
"495137", "Seelze",
"497192", "Murrhardt",
"492927", "Neuengeseke",
"497937", "Dörzbach",
"496002", "Ober\-Mörlen",
"4935329", "Dollenchen",
"4936020", "Ebeleben",
"495141", "Celle",
"492541", "Coesfeld",
"494861", "Tönning",
"497949", "Pfedelbach\-Untersteinbach",
"495321", "Goslar",
"498253", "Pöttmes",
"493763", "Glauchau",
"499826", "Weidenbach\ Mittelfranken",
"499765", "Trappstadt",
"496578", "Salmtal",
"494646", "Mohrkirch",
"4935439", "Zinnitz",
"494673", "Joldelund",
"495774", "Wagenfeld\-Ströhen",
"494353", "Ascheffel",
"4935342", "Mühlberg\ Elbe",
"499394", "Esselbach",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"499268", "Teuschnitz",
"495705", "Petershagen\-Windheim",
"495474", "Stemwede\-Dielingen",
"4939242", "Prödel",
"4939489", "Strassberg\ Harz",
"499465", "Neukirchen\-Balbini",
"495208", "Leopoldshöhe",
"495149", "Wienhausen",
"495622", "Fritzlar",
"4937465", "Tannenbergsthal\ Vogtland",
"492697", "Blankenheim\-Ahrhütte",
"496020", "Heigenbrücken",
"495221", "Herford",
"494486", "Edewecht\-Friedrichsfehn",
"4936370", "Grossenehrich",
"499162", "Scheinfeld",
"494253", "Asendorf\ Kreis\ Diepholz",
"4936200", "Elxleben\ bei\ Arnstadt",
"496804", "Mandelbachtal",
"499294", "Regnitzlosau",
"4933602", "Alt\ Zeschdorf",
"4936929", "Ruhla",
"496041", "Glauburg",
"4939009", "Badel",
"498869", "Kinsau",
"496875", "Nonnweiler\-Primstal",
"492502", "Nottuln",
"495102", "Laatzen",
"495308", "Lehre",
"4934465", "Bad\ Bibra",
"497073", "Ammerbuch",
"497046", "Zaberfeld",
"492293", "Nümbrecht",
"49621", "Mannheim",
"499083", "Möttingen",
"498306", "Ronsberg",
"4937384", "Wechselburg",
"497364", "Oberkochen",
"494206", "Stuhr\-Heiligenrode",
"496550", "Irrhausen",
"4939997", "Jarmen",
"496049", "Kefenrod",
"498861", "Schongau",
"4936087", "Wüstheuterode",
"495648", "Brakel\-Gehrden",
"4934384", "Grossbothen",
"4939863", "Seehausen\ bei\ Prenzlau",
"492357", "Herscheid\ Westfalen",
"496227", "Walldorf\ Baden",
"495031", "Wunstorf",
"499408", "Altenthann",
"495265", "Dörentrup",
"493331", "Angermünde",
"492677", "Lutzerath",
"496564", "Neuerburg\ Eifel",
"4934383", "Trebsen\ Mulde",
"497159", "Renningen",
"499274", "Hollfeld",
"495768", "Petershagen\-Heimsen",
"4935825", "Kodersdorf",
"499205", "Vorbach",
"495468", "Bramsche\-Engter",
"4935931", "Königswartha",
"494542", "Mölln\ Lauenburg",
"4938205", "Tessin\ bei\ Rostock",
"4937383", "Lunzenau",
"492862", "Südlohn",
"4938375", "Koserow",
"4933201", "Gross\ Glienicke",
"499708", "Bad\ Bocklet",
"4933452", "Neulewin",
"494881", "Friedrichstadt",
"498509", "Ruderting",
"4936742", "Uhlstädt",
"496623", "Rotenburg\ an\ der\ Fulda",
"497775", "Mühlingen",
"494533", "Reinfeld\ Holstein",
"492273", "Kerpen\-Horrem",
"492246", "Lohmar\ Rheinland",
"497404", "Epfendorf",
"498466", "Denkendorf\ Oberbayern",
"496638", "Schwalmtal\-Renzendorf",
"499288", "Bad\ Steben",
"493592", "Kirschau",
"494528", "Schönwalde\ am\ Bungsberg",
"497151", "Waiblingen",
"4935058", "Pretzschendorf",
"495951", "Werlte",
"494938", "Hagermarsch",
"498825", "Krün",
"498766", "Gammelsdorf",
"497704", "Geisingen\ Baden",
"497475", "Burladingen",
"498501", "Thyrnau",
"494923", "Krummhörn\-Pewsum",
"496103", "Langen\ Hessen",
"49341", "Leipzig",
"4933434", "Herzfelde\ bei\ Strausberg",
"4936601", "Hermsdorf\ Thüringen",
"499462", "Falkenstein\ Oberpfalz",
"4933764", "Mittenwalde\ Mark",
"4934692", "Alsleben\ Saale",
"494186", "Buchholz\-Trelde",
"495702", "Petershagen\-Lahde",
"4935793", "Elstra",
"496851", "St\ Wendel",
"498234", "Bobingen",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"4933836", "Butzow\ bei\ Brandenburg",
"499762", "Saal\ an\ der\ Saale",
"497803", "Gengenbach",
"49371", "Chemnitz\ Sachsen",
"494334", "Bredenbek\ bei\ Rendsburg",
"497195", "Winnenden",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"496074", "Rödermark",
"495681", "Homberg\ Efze",
"4934651", "Rossla",
"495282", "Schieder\-Schwalenberg",
"496363", "Niederkirchen",
"498545", "Hofkirchen\ Bayern",
"4933964", "Fretzdorf",
"4937291", "Augustusburg",
"4938726", "Spornitz",
"497459", "Nagold\-Hochdorf",
"4938828", "Schönberg",
"499302", "Rottendorf\ Unterfranken",
"495857", "Bleckede\-Brackede",
"492963", "Brilon\-Messinghausen",
"4939395", "Wanzer",
"496756", "Winterbach\ Soonwald",
"4936451", "Buttelstedt",
"4936372", "Kleinneuhausen",
"497563", "Kisslegg",
"496456", "Haina\ Kloster",
"4936202", "Neudietendorf",
"498024", "Holzkirchen",
"499628", "Ursensollen",
"493635", "Kölleda",
"492568", "Heek",
"494848", "Rantrum",
"495362", "Wolfsburg\-Fallersleben",
"49365", "Gera",
"4934291", "Borsdorf",
"499633", "Mitterteich",
"495168", "Walsrode\-Stellichte",
"496283", "Hardheim\ Odenwald",
"4935208", "Radeburg",
"497451", "Horb\ am\ Neckar",
"494822", "Kellinghusen",
"499964", "Stallwang",
"498166", "Allershausen\ Oberbayern",
"4933741", "Niedergörsdorf",
"495975", "Rheine\-Mesum",
"499241", "Pegnitz",
"499642", "Kemnath\ Stadt",
"496703", "Wöllstein\ Rheinhessen",
"496403", "Linden\ Hessen",
"499185", "Mühlhausen\ Oberpfalz",
"496094", "Weibersbrunn",
"4933763", "Bestensee",
"497175", "Leinzell",
"497624", "Grenzach\-Wyhlen",
"495904", "Lengerich\ Emsl",
"492634", "Rengsdorf",
"4933433", "Buckow\ Märkische\ Schweiz",
"4933051", "Nassenheide",
"493727", "Mittweida",
"498554", "Schönberg\ Niederbayern",
"497751", "Waldshut",
"499220", "Kasendorf\-Azendorf",
"4936940", "Oepfershausen",
"492948", "Lippstadt\-Rebbeke",
"499555", "Schlüsselfeld\-Aschbach",
"498259", "Schiltberg",
"497943", "Schöntal\ Jagst",
"497976", "Sulzbach\-Laufen",
"492391", "Plettenberg",
"497052", "Bad\ Liebenzell",
"494236", "Kirchlinteln",
"492543", "Billerbeck\ Westfalen",
"494863", "Sankt\ Peter\-Ording",
"4933470", "Lietzen",
"495176", "Edemissen",
"495143", "Winsen\ Aller",
"4938842", "Lüttenmark",
"498336", "Erkheim",
"497522", "Wangen\ im\ Allgäu",
"494351", "Eckernförde",
"494272", "Siedenburg",
"492532", "Ostbevern",
"494671", "Bredstedt",
"495132", "Lehrte",
"498652", "Berchtesgaden",
"498178", "Icking",
"498251", "Aichach",
"495323", "Clausthal\-Zellerfeld",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"493761", "Werdau\ Sachsen",
"498372", "Obergünzburg",
"493461", "Merseburg\ Saale",
"4935209", "Mohorn",
"496834", "Bous",
"497932", "Niederstetten\ Württemberg",
"4939605", "Gross\ Nemerow",
"499544", "Baunach",
"4938782", "Reetz\ bei\ Perleberg",
"492922", "Werl",
"496007", "Rosbach\-Rodheim",
"498531", "Pocking",
"492724", "Finnentrop\-Serkenrode",
"497734", "Gailingen",
"496133", "Oppenheim",
"492651", "Mayen",
"496128", "Taunusstein",
"492371", "Iserlohn",
"496322", "Bad\ Dürkheim",
"492252", "Zülpich",
"495196", "Wietzendorf",
"498547", "Osterhofen\-Gergweis",
"492596", "Nordkirchen",
"493641", "Jena",
"497434", "Winterlingen",
"494503", "Timmendorfer\ Strand",
"492424", "Vettweiss",
"495855", "Nahrendorf",
"499738", "Rottershausen",
"495844", "Clenze",
"4937606", "Lengenfeld\ Vogtland",
"494292", "Ritterhude",
"494164", "Harsefeld",
"499187", "Altdorf\ bei\ Nürnberg",
"492379", "Menden\-Asbeck",
"499723", "Röthlein",
"498392", "Markt\ Rettenbach",
"499235", "Thierstein",
"493725", "Zschopau",
"493866", "Cambs",
"4939455", "Schierke",
"493425", "Wurzen",
"496142", "Rüsselsheim",
"499423", "Geiselhöring",
"496348", "Offenbach\ an\ der\ Queich",
"4934606", "Teicha\ Sachsen\-Anhalt",
"494556", "Ahrensbök\-Gnissau",
"495977", "Spelle",
"493301", "Oranienburg",
"4938757", "Neustadt\-Glewe",
"499438", "Fensterbach",
"494644", "Karby",
"492981", "Winterberg\ Westfalen",
"49881", "Weilheim\ in\ Oberbayern",
"495776", "Preussisch\ Ströhen",
"495743", "Espelkamp\-Gestringen",
"4935362", "Schönewalde\ bei\ Herzberg",
"499396", "Urspringen\ bei\ Lohr",
"494962", "Papenburg\-Aschendorf",
"499824", "Dietenhofen",
"496035", "Reichelsheim\ Wetterau",
"497842", "Kappelrodeck",
"495060", "Bodenburg",
"496261", "Mosbach\ Baden",
"492695", "Insul",
"495443", "Lemförde",
"4936334", "Wolkramshausen",
"497581", "Saulgau",
"498784", "Hohenthann",
"4936845", "Gehlberg",
"495476", "Ostercappeln\-Venne",
"499571", "Lichtenfels\ Bayern",
"4939262", "Güsten\ Anh",
"492823", "Goch",
"497266", "Kirchardt",
"497833", "Hornberg\ Schwarzwaldbahn",
"495432", "Löningen",
"4936424", "Kahla\ Thüringen",
"496586", "Beuren\ Hochwald",
"498204", "Mickhausen",
"492838", "Sonsbeck",
"496269", "Gundelsheim\ Württemberg",
"4935722", "Lauta\ bei\ Hoyerswerda",
"495732", "Löhne",
"4936785", "Gräfinau\-Angstedt",
"4938355", "Züssow",
"499376", "Collenberg",
"496428", "Stadtallendorf",
"499343", "Lauda\-Königshofen",
"495045", "Springe\-Bennigsen",
"497386", "Hayingen",
"496897", "Sulzbach\ Saar",
"499207", "Königsfeld\ Oberfranken",
"499656", "Moosbach\ bei\ Vohenstrauss",
"496433", "Hadamar",
"495934", "Haren\-Rütenbrock",
"492604", "Nassau\ Lahn",
"4933472", "Golzow\ bei\ Seelow",
"492675", "Ediger\-Eller",
"497134", "Weinsberg",
"496733", "Gau\-Odernheim",
"495524", "Bad\ Lauterberg\ im\ Harz",
"492355", "Schalksmühle",
"4933637", "Beerfelde",
"4936423", "Orlamünde",
"496728", "Ober\-Hilbersheim",
"492066", "Duisburg\-Homberg",
"493605", "Leinefelde",
"4938780", "Lanz\ Brandenburg",
"496742", "Boppard",
"499603", "Floss",
"494464", "Wittmund\-Carolinensiel",
"4936072", "Weissenborn\-Lüderode",
"4936333", "Heringen\ Helme",
"497477", "Jungingen\ bei\ Hechingen",
"495663", "Spangenberg",
"498295", "Altenmünster\ Schwaben",
"492770", "Eschenburg",
"499332", "Marktbreit",
"497777", "Sauldorf",
"494764", "Gnarrenburg\-Klenkendorf",
"496381", "Kusel",
"499123", "Lauf\ an\ der\ Pegnitz",
"496442", "Braunfels",
"4939008", "Kunrau",
"495054", "Bergen\-Sülze",
"4936928", "Neuenhof\ Thüringen",
"498464", "Dietfurt\ an\ der\ Altmühl",
"4938727", "Mestlin",
"499647", "Kirchenthumbach",
"492961", "Brilon",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"494827", "Wacken",
"496145", "Flörsheim\ am\ Main",
"4936762", "Steinach\ Thüringen",
"494830", "Süderhastedt",
"494498", "Saterland\-Ramsloh",
"492244", "Königswinter\-Oberpleis",
"497706", "Oberbaldingen",
"499631", "Tirschenreuth",
"496281", "Buchen\ Odenwald",
"4939425", "Dingelstedt\ am\ Huy",
"493722", "Limbach\-Oberfrohna",
"498395", "Tannheim\ Württemberg",
"499232", "Wunsiedel",
"4939488", "Güntersberge",
"496682", "Tann\ Rhön",
"494295", "Emtinghausen",
"496409", "Biebertal",
"497561", "Leutkirch\ im\ Allgäu",
"498764", "Mauern\ Kreis\ Freising",
"4936645", "Mühltroff",
"495852", "Bleckede",
"499307", "Altertheim",
"496701", "Sprendlingen\ Rheinhessen",
"4937381", "Penig",
"4935933", "Neschwitz",
"499276", "Bischofsgrün",
"499243", "Pottenstein",
"497453", "Altensteig\ Württemberg",
"496566", "Körperich",
"4933203", "Kleinmachnow",
"497753", "Albbruck",
"496325", "Lambrecht\ Pfalz",
"492255", "Euskirchen\-Flamersheim",
"4935385", "Annaburg",
"493448", "Meuselwitz\ Thüringen",
"496154", "Ober\-Ramstadt",
"495367", "Rühen",
"499639", "Mähring",
"497569", "Isny\-Eisenbach",
"492758", "Bad\ Berleburg\-Girkhausen",
"4936626", "Auma",
"496401", "Grünberg\ Hessen",
"4934381", "Colditz",
"497366", "Abtsgmünd",
"496853", "Marpingen",
"494204", "Thedinghausen",
"497935", "Schrozberg",
"492925", "Warstein\-Allagen",
"494478", "Cappeln\ Oldenburg",
"497044", "Mönsheim",
"4939861", "Gramzow\ bei\ Prenzlau",
"4936962", "Vacha",
"498304", "Wildpoldsried",
"4935934", "Grossdubrau",
"498375", "Weitnau",
"4934426", "Kayna",
"4933837", "Brielow",
"494778", "Wingst",
"4938859", "Alt\ Zachun",
"495135", "Burgwedel\-Fuhrberg",
"497525", "Aulendorf",
"4933204", "Beelitz\ Mark",
"492535", "Sendenhorst\-Albersloh",
"494275", "Ehrenburg",
"4934632", "Mücheln\ Geiseltal",
"496806", "Heusweiler",
"495707", "Petershagen\ Weser",
"498450", "Ingolstadt\-Zuchering",
"499467", "Michelsneukirchen",
"494484", "Hude\-Wüsting",
"49481", "Heide\ Holstein",
"49202", "Wuppertal",
"496361", "Rockenhausen",
"495683", "Wabern\ Hessen",
"4934445", "Stössen",
"497055", "Neuweiler\ Kreis\ Calw",
"495407", "Wallenhorst",
"499552", "Burghaslach",
"494392", "Nortorf\ bei\ Neumünster",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"493328", "Teltow",
"4936604", "Münchenbernsdorf",
"496445", "Schöffengrund",
"495028", "Pennigsehl",
"496629", "Schenklengsfeld",
"499966", "Wiesenfelden",
"494539", "Westerau",
"498292", "Dinkelscherben",
"499335", "Aub\ Kreis\ Würzburg",
"4935952", "Grossröhrsdorf\ OL",
"495033", "Wunstorf\-Grossenheidorn",
"49561", "Kassel",
"494929", "Ihlow\ Kreis\ Aurich",
"498556", "Haidmühle",
"496109", "Frankfurt\-Bergen\-Enkheim",
"494883", "Süderstapel",
"496745", "Gondershausen",
"496096", "Wiesen\ Unterfranken",
"497626", "Kandern",
"4933743", "Blönsdorf",
"495906", "Lünne",
"492636", "Burgbrohl",
"497153", "Plochingen",
"496754", "Martinstein",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"4936453", "Mellingen",
"492158", "Grefrath\ bei\ Krefeld",
"494531", "Bad\ Oldesloe",
"492271", "Bergheim\ Erft",
"496222", "Wiesloch",
"492352", "Altena\ Westfalen",
"4934293", "Naunhof\ bei\ Grimma",
"492672", "Treis\-Karden",
"496621", "Bad\ Hersfeld",
"494921", "Emden\ Stadt",
"496101", "Bad\ Vilbel",
"4937293", "Eppendorf\ Sachsen",
"498503", "Neuhaus\ am\ Inn",
"493342", "Neuenhagen\ bei\ Berlin",
"496454", "Lichtenfels\-Sachsenberg",
"4938325", "Rolofshagen",
"495953", "Börger",
"4934654", "Stolberg\ Harz",
"494547", "Gudow\ Lauenburg",
"495042", "Bad\ Münder\ am\ Deister",
"498026", "Hausham",
"492867", "Heiden\ Kreis\ Borken",
"495238", "Nieheim\-Himmighausen",
"494251", "Hoya",
"494178", "Radbruch",
"494372", "Westfehmarn",
"4937294", "Grünhainichen",
"4935752", "Ruhland",
"495223", "Bünde",
"498272", "Wertingen",
"499089", "Bissingen\-Unterringingen",
"4934653", "Rottleberode",
"498671", "Altötting",
"495435", "Berge\ bei\ Quakenbrück",
"4936454", "Magdala",
"497854", "Kehl\-Goldscheuer",
"4934294", "Rackwitz",
"496043", "Nidda",
"499167", "Oberscheinfeld",
"494184", "Hanstedt\ Nordheide",
"499081", "Nördlingen",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"493886", "Gadebusch",
"498679", "Burgkirchen\ an\ der\ Alz",
"492692", "Kelberg",
"496032", "Bad\ Nauheim",
"497071", "Tübingen",
"4933744", "Hohenseefeld",
"496665", "Sinntal\-Altengronau",
"492291", "Waldbröl",
"494965", "Surwold",
"4936603", "Weida",
"492507", "Havixbeck",
"4933054", "Liebenwalde",
"4939996", "Törpin",
"494336", "Owschlag",
"498236", "Fischach",};
$areanames{de} = {"499567", "Seßlach\-Gemünda",
"4935248", "Schönfeld\ bei\ Großenhain",
"495064", "Groß\ Düngen",
"496663", "Steinau\ an\ der\ Straße",
"493647", "Pößneck",
"4935753", "Großräschen",
"4939976", "Groß\ Bützin",
"499242", "Gößweinstein",
"498170", "Straßlach\-Dingharting",
"496321", "Neustadt\ an\ der\ Weinstraße",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"49911", "Nürnberg",
"494509", "Groß\ Grönau",
"4936072", "Weißenborn\-Lüderode",
"499656", "Moosbach\ bei\ Vohenstrauß",
"4935952", "Großröhrsdorf\ OL",
"4934445", "Stößen",
"49221", "Köln",
"498367", "Roßhaupten\ Forggensee",
"497162", "Süßen",
"495827", "Unterlüß",
"4939883", "Groß\ Dölln",
"496252", "Heppenheim\ Bergstraße",
"499141", "Weißenburg\ in\ Bayern",
"497351", "Biberach\ an\ der\ Riß",
"4935726", "Groß\ Särchen",
"494497", "Barßel\-Harkebrügge",
"4936484", "Knau\ bei\ Pößneck",
"4934493", "Gößnitz\ Thüringen",
"4936949", "Obermaßfeld\-Grimmenthal",
"495384", "Seesen\-Groß\ Rhüden",
"492339", "Sprockhövel\-Haßlinghausen",
"492203", "Köln\-Porz",
"498633", "Tüßling",
"494483", "Ovelgönne\-Großenmeer",
"499636", "Plößberg",
"4934901", "Roßlau\ Elbe",
"498536", "Kößlarn",
"495053", "Faßberg\-Müden",
"4935938", "Großpostwitz\ OL",
"496364", "Nußbach\ Pfalz",
"4938234", "Born\ Darß",
"4989", "München",
"497355", "Hochdorf\ Riß",
"4939934", "Groß\ Plasten",
"4935240", "Tauscha\ bei\ Großenhain",
"494684", "Langeneß\ Hallig",
"4935841", "Großschönau\ Sachsen",
"498807", "Dießen\ am\ Ammersee",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;